/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.recognizer.remote.maus;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.api.RecognizerConfigurationException;
import mpi.eudico.client.annotator.recognizer.api.RecognizerHost;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.io.XmlTierIO;

public class MausWsClient
implements Recognizer {
    protected RecognizerHost host;
    private String name = "MAUS web service client";
    private String baseUrl = "http://clarin.phonetik.uni-muenchen.de/BASWebServices/services/";
    private String baseServiceId = "runMAUSBasic";
    private String textParamName = "TEXT";
    private String signalParamName = "SIGNAL";
    private String langParamName = "LANGUAGE";
    private String currentMediaFile = null;
    private String currentMediaName = null;
    private String currentTextFile = null;
    private String currentTextName = null;
    private Map<String, String> parameters;
    private float progress = 0.0f;
    private boolean isRunning = false;
    private boolean interrupted = false;
    private long startTime;
    private List<Segmentation> segmentations;
    private ArrayList<RSelection> tierSelectionObjects;
    private final String pipeLineService = "runPipeline";
    private String pipeParamName = "PIPE";
    private String pipeParamValue = "G2P_CHUNKER_MAUS";
    private final String eq = "=";
    private final String tierSpec = "IntervalTier";
    private final String nm = "name";
    private final String min = "xmin";
    private final String max = "xmax";
    private final String tx = "text";

    public boolean canCombineMultipleFiles() {
        return false;
    }

    public boolean canHandleMedia(String mediaFilePath) {
        if (mediaFilePath == null) {
            return false;
        }
        String lower = mediaFilePath.toLowerCase();
        return lower.endsWith(".wav") || lower.endsWith(".wave");
    }

    public void dispose() {
    }

    public JPanel getControlPanel() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Object getParameterValue(String param) {
        return null;
    }

    public int getRecognizerType() {
        return 0;
    }

    private void setMedia(String mediaFilePath) {
        if (mediaFilePath != null) {
            int slashIndex;
            this.currentMediaFile = mediaFilePath;
            if (this.currentMediaFile.startsWith("file:")) {
                this.currentMediaFile = this.currentMediaFile.substring(5);
            }
            if (this.currentMediaFile.startsWith("///")) {
                this.currentMediaFile = this.currentMediaFile.substring(2);
            }
            if ((slashIndex = this.currentMediaFile.lastIndexOf("/") + 1) > 0) {
                this.currentMediaName = this.currentMediaFile.substring(slashIndex);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void validateParameters() throws RecognizerConfigurationException {
        if ((this.tierSelectionObjects == null || this.tierSelectionObjects.size() == 0) && this.currentTextFile == null) {
            throw new RecognizerConfigurationException("Selections are required: either select an input file or tier or add selections to the list.");
        }
    }

    public void setParameterValue(String param, String value) {
        if (param == null || param.length() == 0 || value == null || value.length() == 0) {
            return;
        }
        if (param.equals("SignalUrl")) {
            this.setMedia(value);
        } else if (param.equals("base_url")) {
            this.baseUrl = value;
        } else if (param.equals("TextUrl")) {
            this.currentTextFile = value;
            String fwTextFile = this.currentTextFile.replace('\\', '/');
            int slashIndex = fwTextFile.lastIndexOf("/") + 1;
            if (slashIndex > 0) {
                this.currentTextName = fwTextFile.substring(slashIndex);
            }
        } else if (param.equals("TierUrl")) {
            File file = new File(value);
            if (file.exists() && file.canRead()) {
                List segm = null;
                XmlTierIO xio = new XmlTierIO(file);
                try {
                    segm = xio.parse();
                }
                catch (Exception exe) {
                    JOptionPane.showMessageDialog(null, exe.getMessage(), "Error", 0);
                }
                if (this.tierSelectionObjects == null) {
                    this.tierSelectionObjects = new ArrayList();
                } else {
                    this.tierSelectionObjects.clear();
                }
                for (Segmentation seg : segm) {
                    if (seg.getSegments() == null) continue;
                    this.tierSelectionObjects.addAll(seg.getSegments());
                }
            }
        } else if (param.equals("TextParamName")) {
            this.textParamName = value;
        } else if (param.equals("SignalParamName")) {
            this.signalParamName = value;
        } else if (param.equals("ServiceName")) {
            this.baseServiceId = value;
            if (value.equals("runPipeline")) {
                if (this.parameters == null) {
                    this.parameters = new HashMap<String, String>(2);
                }
                this.parameters.put(this.pipeParamName, this.pipeParamValue);
            }
        } else {
            if (this.parameters == null) {
                this.parameters = new HashMap<String, String>(2);
            }
            this.parameters.put(param, value);
        }
    }

    public void setParameterValue(String param, float value) {
    }

    public void setRecognizerHost(RecognizerHost host) {
        this.host = host;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        if (this.currentMediaFile == null) {
            this.host.errorOccurred("There is no audio file.");
            return;
        }
        this.interrupted = false;
        this.progress = 0.0f;
        this.startTime = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("d MMM yyyy HH:mm:ss");
        this.host.appendToReport("Starting process at " + df.format(new Date(this.startTime)) + "\n");
        this.host.appendToReport("Server url:\t" + this.baseUrl + this.baseServiceId + "\n");
        this.host.appendToReport("Media file:\t" + this.currentMediaFile + "\n");
        if (this.currentTextFile != null) {
            this.host.appendToReport("Text file:\t" + this.currentTextFile + "\n");
        }
        if (this.tierSelectionObjects != null && this.tierSelectionObjects.size() > 0) {
            this.host.appendToReport("Input text from tier, number of segments:\t" + this.tierSelectionObjects.size() + "\n");
        }
        this.host.setProgress(this.progress, "Retrieving project ID");
        this.progress = 0.05f;
        this.host.setProgress(this.progress, "Project exists or is created");
        if (this.interrupted) {
            this.host.setProgress(this.progress, "Process canceled.");
            this.host.appendToReport("The process has been canceled after: " + (float)(System.currentTimeMillis() - this.startTime) / 1000.0f + " sec\n");
            return;
        }
        int uploadStatus = this.uploadAllFiles();
        if (uploadStatus != 200) {
            this.host.errorOccurred("Processing files failed.");
            this.host.appendToReport("Unable to process the files: " + uploadStatus + "\n");
            return;
        }
        this.host.setProgress(this.progress, "Files processed");
        if (this.segmentations != null) {
            this.host.appendToReport("Number of tiers created: " + this.segmentations.size() + "\n");
            for (Segmentation s : this.segmentations) {
                this.host.addSegmentation(s);
            }
        } else {
            this.host.appendToReport("Number of tiers created: 0\n");
        }
        this.host.appendToReport("Process finished after: " + (float)(System.currentTimeMillis() - this.startTime) / 1000.0f + " sec\n");
        this.host.setProgress(1.0f, "Process finished.");
        this.currentMediaFile = null;
        this.currentTextFile = null;
        this.tierSelectionObjects = null;
    }

    public void stop() {
        this.interrupted = true;
    }

    public void updateLocale(Locale locale) {
    }

    public void updateLocaleBundle(ResourceBundle bundle) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int uploadAllFiles() {
        StringBuilder subFileString;
        File tf;
        byte[] inputText;
        long fileLength;
        File f;
        byte[] preBytes;
        StringBuilder preFileString;
        byte[] paramBytes;
        long totalLength;
        URL url;
        block33: {
            block34: {
                block32: {
                    if (this.currentMediaFile == null) {
                        this.host.appendToReport("There is no audio file url.\n");
                        return 400;
                    }
                    if ((this.tierSelectionObjects == null || this.tierSelectionObjects.size() == 0) && this.currentTextFile == null) {
                        this.host.appendToReport("There is no text input, neither from a selected tier nor from file url.\n");
                        return 400;
                    }
                    this.host.setProgress(this.progress, "Uploading wav and text file");
                    url = null;
                    try {
                        url = new URL(this.baseUrl + this.baseServiceId);
                    }
                    catch (MalformedURLException mue) {
                        this.host.appendToReport("Could not create the input service url: " + mue.getMessage() + "\n");
                        return 400;
                    }
                    if (url != null) {
                        this.host.appendToReport("Service url: " + url.toExternalForm() + "\n");
                    }
                    String boundary = "DaDa0x";
                    String nl = "\r\n";
                    totalLength = 0L;
                    paramBytes = null;
                    if (!this.parameters.isEmpty()) {
                        StringBuilder paramsString = new StringBuilder();
                        for (Map.Entry<String, String> paramEntry : this.parameters.entrySet()) {
                            paramsString.append("\r\n--DaDa0x\r\n");
                            paramsString.append(String.format("content-disposition: form-data; name=\"%s\"%s", paramEntry.getKey(), "\r\n"));
                            paramsString.append("\r\n");
                            paramsString.append(paramEntry.getValue());
                            paramsString.append("\r\n");
                        }
                        paramBytes = paramsString.toString().getBytes();
                        totalLength += (long)paramBytes.length;
                        this.host.appendToReport("Form data Parameters: " + paramsString + "\r\n");
                    }
                    this.currentMediaName = this.currentMediaName.replace(' ', '_');
                    preFileString = new StringBuilder("--DaDa0x\r\n");
                    preFileString.append("content-disposition: form-data; name=\"" + this.signalParamName + "\"; filename=\"" + this.currentMediaName + "\"" + "\r\n");
                    preFileString.append("\r\n");
                    preBytes = preFileString.toString().getBytes();
                    totalLength += (long)preBytes.length;
                    f = new File(this.currentMediaFile);
                    fileLength = 0L;
                    if (!f.exists() || f.isDirectory()) break block32;
                    fileLength = f.length();
                    totalLength += f.length();
                    inputText = null;
                    tf = null;
                    subFileString = null;
                    if (this.tierSelectionObjects == null) break block33;
                    break block34;
                }
                this.host.appendToReport("Error: the wav file does not exist\n");
                return 400;
            }
            if (this.tierSelectionObjects.size() > 0 && (inputText = this.convertToString(this.tierSelectionObjects)) != null) {
                totalLength += (long)inputText.length;
                fileLength += (long)inputText.length;
                subFileString = new StringBuilder("\r\n--DaDa0x\r\n");
                subFileString.append("content-disposition: form-data; name=\"" + this.textParamName + "\"; filename=\"tierText.txt\"" + "\r\n");
                subFileString.append("\r\n");
            }
        }
        if (inputText == null) {
            tf = new File(this.currentTextFile);
            if (tf.exists() && !tf.isDirectory()) {
                totalLength += tf.length();
                fileLength += tf.length();
                subFileString = new StringBuilder("\r\n--DaDa0x\r\n");
                this.currentTextName = this.currentTextName.replace(' ', '_');
                subFileString.append("content-disposition: form-data; name=\"" + this.textParamName + "\"; filename=\"" + this.currentTextName + "\"" + "\r\n");
                subFileString.append("\r\n");
            } else {
                this.host.appendToReport("Error: the text file does not exist\n");
                return 400;
            }
        }
        this.host.appendToReport("Form data SIGNAL: " + preFileString);
        this.host.appendToReport("Form data TEXT: " + subFileString);
        byte[] subBytes = subFileString.toString().getBytes();
        totalLength += (long)subBytes.length;
        byte[] postBytes = "\r\n--DaDa0x--\r\n".getBytes();
        totalLength += (long)postBytes.length;
        try {
            int totalBytesRead;
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setDefaultUseCaches(false);
            httpConn.setUseCaches(false);
            httpConn.setDoInput(true);
            httpConn.setDoOutput(true);
            httpConn.setRequestMethod("POST");
            httpConn.setInstanceFollowRedirects(false);
            httpConn.setFixedLengthStreamingMode((int)totalLength);
            httpConn.setRequestProperty("User-Agent", "ELAN");
            httpConn.setRequestProperty("Connection", "Keep-Alive");
            httpConn.setRequestProperty("Content-Type", "multipart/form-data;boundary=DaDa0x");
            FileInputStream fis = null;
            FileInputStream fis2 = null;
            DataOutputStream dos = null;
            float startProg = this.progress;
            float progPart = 0.5f;
            try {
                block37: {
                    int numBytesRead;
                    byte[] chunk;
                    block35: {
                        block36: {
                            fis = new FileInputStream(f);
                            dos = new DataOutputStream(httpConn.getOutputStream());
                            if (paramBytes != null) {
                                dos.write(paramBytes);
                            }
                            dos.write(preBytes);
                            totalBytesRead = 0;
                            chunk = new byte[0x100000];
                            while ((numBytesRead = fis.read(chunk, 0, chunk.length)) != -1 && !this.interrupted) {
                                dos.write(chunk, 0, numBytesRead);
                                dos.flush();
                                totalBytesRead += numBytesRead;
                                if (fileLength <= 0L) continue;
                                this.progress = startProg + progPart * ((float)totalBytesRead / (float)fileLength);
                                this.host.setProgress(this.progress);
                            }
                            if (this.interrupted) {
                                this.host.appendToReport("The process has been canceled, uploading has been stopped...\n");
                                int n = 400;
                                return n;
                            }
                            dos.write(subBytes);
                            if (inputText == null) break block35;
                            numBytesRead = 0;
                            if (inputText.length > chunk.length) break block36;
                            dos.write(inputText);
                            dos.flush();
                            totalBytesRead += inputText.length;
                            if (fileLength > 0L) {
                                this.progress = startProg + progPart * ((float)totalBytesRead / (float)fileLength);
                                this.host.setProgress(this.progress);
                            }
                            break block37;
                        }
                        int count = inputText.length / chunk.length;
                        for (int i = 0; i < count; ++i) {
                            dos.write(inputText, i * chunk.length, chunk.length);
                            dos.flush();
                            totalBytesRead += chunk.length;
                            numBytesRead += chunk.length;
                            if (fileLength <= 0L) continue;
                            this.progress = startProg + progPart * ((float)totalBytesRead / (float)fileLength);
                            this.host.setProgress(this.progress);
                        }
                        if (numBytesRead >= inputText.length) break block37;
                        dos.write(inputText, numBytesRead, inputText.length - numBytesRead);
                        dos.flush();
                        break block37;
                    }
                    fis2 = new FileInputStream(tf);
                    numBytesRead = 0;
                    while ((numBytesRead = fis2.read(chunk, 0, chunk.length)) != -1 && !this.interrupted) {
                        dos.write(chunk, 0, numBytesRead);
                        dos.flush();
                        totalBytesRead += numBytesRead;
                        if (fileLength <= 0L) continue;
                        this.progress = startProg + progPart * ((float)totalBytesRead / (float)fileLength);
                        this.host.setProgress(this.progress);
                    }
                }
                this.progress = startProg + progPart;
                this.host.setProgress(this.progress);
                dos.write(postBytes);
                dos.flush();
                this.host.setProgress(this.progress, "Files uploaded, waiting for server response.");
                this.host.appendToReport("Uploading of files took: " + (float)(System.currentTimeMillis() - this.startTime) / 1000.0f + " sec\n");
            }
            catch (IOException ioe) {
                this.host.appendToReport("An error occurred while uploading the audio file or text file: " + ioe.getMessage() + "\n");
                totalBytesRead = 400;
                return totalBytesRead;
            }
            finally {
                if (dos != null) {
                    dos.flush();
                    dos.close();
                }
                if (fis != null) {
                    fis.close();
                }
                if (fis2 != null) {
                    fis2.close();
                }
            }
            if (this.interrupted) {
                return 400;
            }
            this.host.setProgress(-1.0f, "Waiting for results...");
            int responseCode = httpConn.getResponseCode();
            if (responseCode != 200) {
                this.host.appendToReport("An error occurred while uploading the audio file or text file: " + responseCode + "\n");
                return responseCode;
            }
            BufferedReader procReader = new BufferedReader(new InputStreamReader(httpConn.getInputStream(), "UTF-8"));
            int parseCode = this.parseResults(procReader);
            if (parseCode == 200) return responseCode;
            return parseCode;
        }
        catch (ProtocolException pe) {
            this.host.appendToReport("Could not contact the server: " + pe.getMessage() + "\n");
            return 400;
        }
        catch (IOException ioe) {
            this.host.appendToReport("Could not contact the server: " + ioe.getMessage() + "\n");
        }
        return 400;
    }

    private byte[] convertToString(ArrayList<RSelection> tierSelectionObjects) {
        StringBuilder sb = new StringBuilder();
        String label = null;
        for (RSelection rsel : tierSelectionObjects) {
            if (!(rsel instanceof Segment) || (label = ((Segment)rsel).label) == null) continue;
            sb.append(label);
            sb.append(" ");
        }
        try {
            return sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            this.host.appendToReport("Unsupported text encoding: " + uee.getMessage() + "\n");
            return sb.toString().getBytes();
        }
        catch (Throwable t) {
            this.host.appendToReport("Error while getting the bytes from String: " + t.getMessage() + "\n");
            return sb.toString().getBytes();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int parseResults(BufferedReader reader) throws IOException {
        if (reader == null) {
            return 204;
        }
        this.host.appendToReport("Parsing results started after: " + (float)(System.currentTimeMillis() - this.startTime) / 1000.0f + " sec\n");
        this.host.setProgress(0.9f, "Parsing results");
        String respLine = null;
        ArrayList<String> responseXML = new ArrayList<String>();
        while ((respLine = reader.readLine()) != null) {
            responseXML.add(respLine.trim());
        }
        boolean success = false;
        String resultURL = null;
        String warningsText = null;
        Pattern sucPat = Pattern.compile("<success>([a-z]+)");
        Pattern downLinkPat = Pattern.compile("<downloadLink>([^<]+)");
        Pattern warnPat = Pattern.compile("<warnings>([^<]+)");
        Pattern outputPat = Pattern.compile("<output>([^<]+)");
        if (responseXML.size() == 1) {
            String s = (String)responseXML.get(0);
            Matcher m = sucPat.matcher(s);
            boolean sf = m.find();
            if (!sf) {
                this.host.appendToReport("No \"success\" element in response, cannot handle the response.\n");
                return 204;
            }
            if (m.groupCount() >= 1) {
                String suc = m.group(1);
                success = Boolean.valueOf(suc);
            }
            if (success) {
                m = downLinkPat.matcher(s);
                sf = m.find();
                if (!sf) {
                    this.host.appendToReport("No \"downloadLink\" element in response, cannot handle the response.\n");
                    return 204;
                }
                if (m.groupCount() < 1) {
                    this.host.appendToReport("An unknwon error occurred inside the service.\n");
                    return 204;
                }
                resultURL = m.group(1);
                if (resultURL == null || resultURL.length() == 0) {
                    this.host.appendToReport("No or empty \"downloadLink\" element in response, cannot handle the response.\n");
                    return 204;
                }
                this.host.appendToReport("The \"downloadLink\" is: " + resultURL + "\n");
                try {
                    URL tgUrl = new URL(resultURL);
                    HttpURLConnection tgConnection = (HttpURLConnection)tgUrl.openConnection();
                    BufferedReader tgReader = null;
                    try {
                        tgReader = new BufferedReader(new InputStreamReader(tgConnection.getInputStream(), "UTF-8"));
                        return this.parseTextGrid(tgReader);
                    }
                    catch (UnsupportedEncodingException uee) {
                        this.host.appendToReport("Reading results with default character set: " + uee.getMessage() + "\n");
                        tgReader = new BufferedReader(new InputStreamReader(tgConnection.getInputStream()));
                    }
                    return this.parseTextGrid(tgReader);
                }
                catch (MalformedURLException mue) {
                    this.host.appendToReport("The returned URL is not valid: " + mue.getMessage() + "\n");
                    return 204;
                }
            }
            m = warnPat.matcher(s);
            sf = m.find();
            if (sf && m.groupCount() >= 1) {
                warningsText = m.group(1);
            }
            if (warningsText != null && warningsText.length() > 0) {
                this.host.appendToReport("Running MAUS was unsuccessful. Error message: " + warningsText + "\n");
                return 204;
            }
            String output = null;
            m = outputPat.matcher(s);
            sf = m.find();
            if (sf && m.groupCount() >= 1) {
                output = m.group(1);
            }
            this.host.appendToReport("Running MAUS was unsuccessful. An unknown error occurred.\n");
            if (output == null) return 204;
            this.host.appendToReport("Output message: " + output + "\n");
            return 204;
        }
        boolean successTested = false;
        for (String s : responseXML) {
            Matcher wm;
            Matcher m;
            if (!successTested && (m = sucPat.matcher(s)).find()) {
                if (m.groupCount() < 1) continue;
                String suc = m.group(1);
                success = Boolean.valueOf(suc);
                continue;
            }
            if (success) {
                Matcher dm = downLinkPat.matcher(s);
                if (!dm.find()) continue;
                if (dm.groupCount() < 1) break;
                resultURL = dm.group(1);
                break;
            }
            if (!successTested || !(wm = warnPat.matcher(s)).find()) continue;
            if (wm.groupCount() < 1) break;
            warningsText = wm.group(0);
            break;
        }
        if (resultURL != null) {
            try {
                URL tgUrl = new URL(resultURL);
                HttpURLConnection tgConnection = (HttpURLConnection)tgUrl.openConnection();
                BufferedReader tgReader = null;
                try {
                    tgReader = new BufferedReader(new InputStreamReader(tgConnection.getInputStream(), "UTF-8"));
                    return this.parseTextGrid(tgReader);
                }
                catch (UnsupportedEncodingException uee) {
                    this.host.appendToReport("Reading results with default character set: " + uee.getMessage() + "\n");
                    tgReader = new BufferedReader(new InputStreamReader(tgConnection.getInputStream()));
                }
                return this.parseTextGrid(tgReader);
            }
            catch (MalformedURLException mue) {
                this.host.appendToReport("The returned URL is not valid: " + mue.getMessage() + "\n");
                return 204;
            }
        }
        this.host.appendToReport("An error occurred inside the service:");
        if (warnPat != null) {
            this.host.appendToReport(warningsText);
        }
        this.host.appendToReport("\n");
        return 204;
    }

    private int parseTextGrid(BufferedReader gridReader) throws IOException {
        this.segmentations = new ArrayList<Segmentation>(6);
        String line = null;
        boolean startNewTier = false;
        boolean inTier = false;
        long begin = -1L;
        long end = -1L;
        ArrayList<Segment> segments = null;
        Segmentation curSegmentation = null;
        while ((line = gridReader.readLine()) != null) {
            int eqIndex;
            int index = -1;
            if (line.indexOf("IntervalTier") > -1) {
                startNewTier = true;
                inTier = false;
                continue;
            }
            index = line.indexOf("name");
            if (startNewTier && index > -1) {
                eqIndex = line.indexOf("=");
                if (eqIndex > index && eqIndex + 1 < line.length()) {
                    String tier = this.removeQuotes(line.substring(eqIndex + 1).trim());
                    segments = new ArrayList<Segment>();
                    curSegmentation = new Segmentation(tier, segments, this.currentMediaFile);
                    this.segmentations.add(curSegmentation);
                    inTier = true;
                }
                startNewTier = false;
                continue;
            }
            if (!inTier) continue;
            index = line.indexOf("xmin");
            if (index > -1) {
                eqIndex = line.indexOf("=");
                if (eqIndex <= index || eqIndex + 1 >= line.length()) continue;
                begin = this.extractLong(line, eqIndex);
                continue;
            }
            index = line.indexOf("xmax");
            if (index > -1) {
                eqIndex = line.indexOf("=");
                if (eqIndex <= index || eqIndex + 1 >= line.length()) continue;
                end = this.extractLong(line, eqIndex);
                continue;
            }
            index = line.indexOf("text");
            if (index <= -1 || (eqIndex = line.indexOf("=")) <= index || eqIndex + 1 >= line.length()) continue;
            String label = this.removeQuotes(line.substring(eqIndex + 1).trim());
            if (begin <= -1L || end <= begin) continue;
            Segment seg = new Segment(begin, end, label);
            if (segments == null) continue;
            segments.add(seg);
        }
        return 200;
    }

    private long extractLong(String value, int eqPos) {
        if (value.length() > eqPos + 1) {
            String v = value.substring(eqPos + 1).trim();
            long l = -1L;
            try {
                Double d = new Double(v);
                l = Math.round(d * 1000.0);
            }
            catch (NumberFormatException nfe) {
                this.host.appendToReport("Not a valid numeric value: " + value + "\n");
            }
            return l;
        }
        return -1L;
    }

    private String removeQuotes(String value) {
        if (value.charAt(0) == '\"') {
            if (value.charAt(value.length() - 1) == '\"' && value.length() > 1) {
                return value.substring(1, value.length() - 1);
            }
            return value.substring(1);
        }
        if (value.charAt(value.length() - 1) == '\"') {
            return value.substring(0, value.length() - 1);
        }
        return value;
    }

    public boolean setMedia(List<String> mediaFiles) {
        return false;
    }
}

