/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexus.wsclient.extension;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import mpi.eudico.server.corpora.lexicon.LexicalEntryFieldIdentification;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class LexusEntryFieldsParser {
    private XMLReader reader;
    private ArrayList<LexicalEntryFieldIdentification> entryFields;

    public LexusEntryFieldsParser() {
        try {
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setFeature("http://xml.org/sax/features/validation", true);
            this.reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            this.reader.setContentHandler(new LexusDataCategoriesContentHandler());
            this.reader.setErrorHandler(new LexusDataCategoriesErrorHandler());
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    private void parse(String dataCategoryXML) {
        try {
            this.reader.parse(new InputSource(new StringReader(dataCategoryXML)));
        }
        catch (SAXException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ArrayList<LexicalEntryFieldIdentification> getEntryFields(String dataCategoryXML) {
        this.entryFields = new ArrayList();
        this.parse(dataCategoryXML);
        return this.entryFields;
    }

    class LexusDataCategoriesErrorHandler
    implements ErrorHandler {
        LexusDataCategoriesErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            System.out.println("Error: " + exception.getMessage());
            System.out.println("System id " + exception.getSystemId());
            System.out.println("Public id " + exception.getPublicId());
            System.out.println("Line: " + exception.getLineNumber());
            System.out.println("Column: " + exception.getColumnNumber());
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            System.out.println("FatalError: " + exception.getMessage());
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("Warning: " + exception.getMessage());
        }
    }

    class LexusDataCategoriesContentHandler
    implements ContentHandler {
        LexicalEntryFieldIdentification currentType;
        String content = "";

        LexusDataCategoriesContentHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int end) throws SAXException {
            this.content = this.content + new String(ch, start, end);
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            if (name.equals("datacategory")) {
                LexusEntryFieldsParser.this.entryFields.add(this.currentType);
                this.currentType = null;
            } else if (name.equals("name")) {
                this.currentType.setName(this.content);
            } else if (name.equals("description")) {
                this.currentType.setDescription(this.content);
            }
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator arg0) {
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            this.content = "";
            if (name.equals("datacategory")) {
                this.currentType = new LexicalEntryFieldIdentification(attributes.getValue("id"), "");
            }
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }
    }
}

