/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexus.wsclient.extension;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.tree.TreeModel;
import mpi.eudico.server.corpora.lexicon.LexicalEntryFieldIdentification;
import mpi.eudico.server.corpora.lexicon.Lexicon;
import mpi.eudico.server.corpora.lexicon.LexiconIdentification;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClient;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClientException;
import nl.mpi.lexus.wsclient.extension.LexusEntryFieldsParser;
import nl.mpi.lexus.wsclient.extension.LexusResourceListParser;
import nl.mpi.lexus.wsclient.extension.LexusSearchResultsParser;
import nl.mpi.lexus.wsclient.extension.LexusWebServiceClientFactory;
import nl.mpi.lexus.wsclient.extension.LexusWebServiceSoapBindingStub;
import nl.mpi.lexus.wsclient.extension.SecurityException;
import org.apache.axis.AxisFault;

public class LexusWebServiceClient
implements LexiconServiceClient {
    private String description;
    private boolean isLoggedIn;
    private String url;
    private String username;
    private String password;
    private LexusWebServiceSoapBindingStub stub;
    private LexusWebServiceClientFactory factory;

    public LexusWebServiceClient(LexusWebServiceClientFactory factory) {
        this.factory = factory;
        this.isLoggedIn = false;
    }

    private void connect() throws LexiconServiceClientException {
        try {
            this.stub = new LexusWebServiceSoapBindingStub(new URL(this.getUrl()), null);
            this.stub.setMaintainSession(true);
        }
        catch (AxisFault e) {
            throw new LexiconServiceClientException("Client malfunction", (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new LexiconServiceClientException("Malformed Url", (Throwable)e);
        }
    }

    private void login() throws LexiconServiceClientException {
        if (this.username == null || this.username.equals("") || this.password == null || this.password.equals("")) {
            throw new LexiconServiceClientException("No username or password");
        }
        if (this.stub == null) {
            this.connect();
        }
        try {
            this.stub.login(this.username, this.password);
        }
        catch (SecurityException e) {
            this.username = "";
            this.password = "";
            throw new LexiconServiceClientException("Incorrect username or password", (Throwable)((Object)e));
        }
        catch (RemoteException e) {
            throw new LexiconServiceClientException("CONNECTION_MALFUNCTION", (Throwable)e);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public ArrayList<LexicalEntryFieldIdentification> getLexicalEntryFieldIdentifications(LexiconIdentification lexId) throws LexiconServiceClientException {
        if (!this.isLoggedIn) {
            this.login();
        }
        try {
            String entryFieldXML = this.stub.getDataCategories(lexId.getId());
            LexusEntryFieldsParser parser = new LexusEntryFieldsParser();
            return parser.getEntryFields(entryFieldXML);
        }
        catch (SecurityException e) {
            throw new LexiconServiceClientException("Incorrect username or password", (Throwable)((Object)e));
        }
        catch (RemoteException e) {
            throw new LexiconServiceClientException("CONNECTION_MALFUNCTION", (Throwable)e);
        }
    }

    public TreeModel getLexicalEntryStructure(LexiconIdentification lexId) throws LexiconServiceClientException {
        return null;
    }

    public Lexicon getLexicon(LexiconIdentification lexId) throws LexiconServiceClientException {
        if (!this.isLoggedIn) {
            this.login();
        }
        try {
            String resources = this.stub.getResource(lexId.getId());
            return null;
        }
        catch (SecurityException e) {
            throw new LexiconServiceClientException("Incorrect username or password", (Throwable)((Object)e));
        }
        catch (RemoteException e) {
            throw new LexiconServiceClientException("CONNECTION_MALFUNCTION", (Throwable)e);
        }
    }

    public ArrayList<LexiconIdentification> getLexiconIdentifications() throws LexiconServiceClientException {
        if (!this.isLoggedIn) {
            this.login();
        }
        try {
            String resources = this.stub.getResources();
            LexusResourceListParser parser = new LexusResourceListParser();
            ArrayList<LexiconIdentification> lexica = parser.getLexica(resources);
            return lexica;
        }
        catch (SecurityException e) {
            throw new LexiconServiceClientException("Incorrect username or password", (Throwable)((Object)e));
        }
        catch (RemoteException e) {
            throw new LexiconServiceClientException("CONNECTION_MALFUNCTION", (Throwable)e);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public ArrayList<String> getSearchConstraints() {
        return this.factory.getSearchConstraints();
    }

    public String getType() {
        return this.factory.getType();
    }

    public String getUrl() {
        if (this.url == null || this.url.equals("")) {
            return this.factory.getDefaultUrl();
        }
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public static String escapeXml(String in) {
        return in.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public Lexicon search(LexiconIdentification lexId, LexicalEntryFieldIdentification fldId, String constraint, String searchString) throws LexiconServiceClientException {
        if (!this.isLoggedIn) {
            this.login();
        }
        Lexicon lexicon = new Lexicon();
        LexusSearchResultsParser parser = new LexusSearchResultsParser();
        String queryFull = "<query>\n\t<id/>\n\t<name/>\n\t<lexicon>\n\t\t<id>" + LexusWebServiceClient.escapeXml(lexId.getId());
        queryFull = queryFull + "</id>\n\t\t<name></name>\n\t\t<children>\n\t\t\t<parameter>\n\t\t\t\t<id>" + LexusWebServiceClient.escapeXml(fldId.getId());
        queryFull = queryFull + "</id>\n\t\t\t\t<name></name>\n\t\t\t\t<condition>" + constraint + "</condition>\n\t\t\t\t<negation>false</negation>";
        queryFull = queryFull + "\n\t\t\t\t<value>" + LexusWebServiceClient.escapeXml(searchString) + "</value>\n\t\t\t\t<children/>\n\t\t\t</parameter>\n\t\t</children>\n\t</lexicon>\n</query>";
        try {
            String searchResult = this.stub.search(queryFull, 0, 999999);
            lexicon = parser.parseToLexicon(searchResult, fldId.getName());
        }
        catch (SecurityException e) {
            throw new LexiconServiceClientException("Incorrect username or password", (Throwable)((Object)e));
        }
        catch (RemoteException e) {
            throw new LexiconServiceClientException("CONNECTION_MALFUNCTION", (Throwable)e);
        }
        return lexicon;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String lexiconWebserviceUrl) {
        this.url = lexiconWebserviceUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

