/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Set;
import nl.mpi.annot.search.lib.FrequencyInfo;
import nl.mpi.annot.search.lib.HitField;
import nl.mpi.annot.search.lib.SearchHit;
import nl.mpi.annot.search.lib.SearchStatistics;

public class CsvOutput {
    private static final String delimiter = ";";
    private StringBuilder resultString = new StringBuilder();
    private Set<String> fieldSet = null;

    public CsvOutput(Set<String> fieldSet) {
        this.fieldSet = fieldSet;
    }

    public static String getInfoAsTabDelimited(FrequencyInfo freqInfo, boolean includeHeader, SearchStatistics stats) {
        StringBuilder result = new StringBuilder("");
        if (includeHeader) {
            result.append("\"Annotation\"").append(delimiter).append("\"Percentage\"").append(delimiter).append("\"Count\"").append(delimiter).append("\"HitPositionInAnnotation\"").append(delimiter).append("\"HitLength\"\n");
        }
        float percentage = 100.0f * (float)freqInfo.numberOfHits / (float)stats.nAnnotationsWithHit;
        String fmt = "##0.00";
        DecimalFormat df = new DecimalFormat(fmt);
        String percentageString = df.format(percentage);
        result.append('\"').append(freqInfo.annotation.replaceAll("\"", "\"\"")).append('\"').append(delimiter);
        result.append(percentageString).append(delimiter);
        result.append(freqInfo.numberOfHits).append(delimiter);
        result.append(freqInfo.hitPositionInAnnotation).append(delimiter);
        result.append(freqInfo.hitLength).append("\n");
        return result.toString();
    }

    public static String getHitAsTabDelimited(SearchHit hit, boolean includeHeader, int contextSize, Set<String> fieldSet) {
        CsvOutput csvo = new CsvOutput(fieldSet);
        if (hit.isComplex()) {
            int n;
            int k;
            if (includeHeader) {
                k = 1;
                for (List<HitField> layerFields : hit.hitFields) {
                    n = 1;
                    for (HitField hitField : layerFields) {
                        if (hitField.annotation.length() > 0) {
                            csvo.addHeader("Annotation", "Annotation" + k + "-" + n);
                            csvo.addHeader("HitPositionInAnnotation", "Position");
                            csvo.addHeader("AnnotationBeginTime", "Begin Time");
                            csvo.addHeader("AnnotationEndTime", "End Time");
                        }
                        ++n;
                    }
                    ++k;
                }
                csvo.addHeader("TranscriptionName");
                csvo.addHeader("TranscriptionURL");
                csvo.addLastHeader("TranscriptionPID");
            }
            k = 1;
            for (List<HitField> layerFields : hit.hitFields) {
                n = 1;
                for (HitField hitField : layerFields) {
                    if (hitField.annotation.length() > 0) {
                        csvo.addField("Annotation", hitField.annotation);
                        csvo.addField("HitPositionInAnnotation", hitField.hitPositionInAnnotation + 1);
                        csvo.addField("AnnotationBeginTime", hitField.beginTime);
                        csvo.addField("AnnotationEndTime", hitField.endTime);
                    }
                    ++n;
                }
                ++k;
            }
            csvo.addField("TranscriptionName", hit.transcriptionName);
            csvo.addField("TranscriptionURL", hit.transcriptionURL);
            if (hit.transcriptionPID == null) {
                csvo.addField("TranscriptionPID", "", "\n");
            } else {
                csvo.addField("TranscriptionPID", hit.transcriptionPID, "\n");
            }
        } else {
            int k;
            if (includeHeader) {
                if (contextSize > 0) {
                    csvo.addHeader("LeftContext");
                }
                csvo.addHeader("Annotation");
                if (contextSize > 0) {
                    csvo.addHeader("RightContext");
                }
                csvo.addHeader("HitPositionInAnnotation");
                csvo.addHeader("HitLength");
                csvo.addHeader("HitNumberInAnnotation");
                csvo.addHeader("AnnotationBeginTime");
                csvo.addHeader("AnnotationEndTime");
                csvo.addHeader("HitPositionInTier");
                csvo.addHeader("TierName");
                csvo.addHeader("TierType");
                csvo.addHeader("TierParticipant");
                csvo.addHeader("TierAnnotator");
                csvo.addHeader("TranscriptionName");
                csvo.addHeader("TranscriptionURL");
                csvo.addLastHeader("TranscriptionPID");
            }
            HitField hitField = hit.getFirstField();
            if (contextSize > 0) {
                if (hit.leftContext.size() > 0) {
                    Object leftContext = hit.leftContext.get(0);
                    for (k = 1; k < hit.leftContext.size(); ++k) {
                        leftContext = hit.leftContext.get(k) + "  " + (String)leftContext;
                    }
                    csvo.addField("LeftContext", (String)leftContext);
                } else {
                    csvo.addField("LeftContext", "");
                }
            }
            csvo.addField("Annotation", hitField.annotation);
            if (contextSize > 0) {
                if (hit.rightContext.size() > 0) {
                    StringBuilder rightContext = new StringBuilder(hit.rightContext.get(0));
                    for (k = 1; k < hit.rightContext.size(); ++k) {
                        rightContext.append("  ");
                        rightContext.append(hit.rightContext.get(k));
                    }
                    csvo.addField("RightContext", rightContext.toString());
                } else {
                    csvo.addField("RightContext", "");
                }
            }
            csvo.addField("HitPositionInAnnotation", hitField.hitPositionInAnnotation + 1);
            csvo.addField("HitLength", hitField.hitLength);
            csvo.addField("HitNumberInAnnotation", hitField.hitNumberInAnnotation);
            csvo.addField("AnnotationBeginTime", hitField.beginTime);
            csvo.addField("AnnotationEndTime", hitField.endTime);
            csvo.addField("HitPositionInTier", hitField.positionInTier + 1);
            csvo.addField("TierName", hit.layerTiers.get((int)0).tierName);
            csvo.addField("TierType", hit.layerTiers.get((int)0).tierType);
            String participant = hit.layerTiers.get((int)0).participant;
            csvo.addField("TierParticipant", participant == null ? "" : participant);
            String annotator = hit.layerTiers.get((int)0).annotator;
            csvo.addField("TierAnnotator", annotator == null ? "" : annotator);
            csvo.addField("TranscriptionName", hit.transcriptionName);
            csvo.addField("TranscriptionURL", hit.transcriptionURL);
            if (hit.transcriptionPID == null) {
                csvo.addField("TranscriptionPID", "", "\n");
            } else {
                csvo.addField("TranscriptionPID", hit.transcriptionPID, "\n");
            }
        }
        return csvo.getResultString();
    }

    private void addHeader(String field) {
        this.addHeader(field, field, delimiter);
    }

    private void addLastHeader(String field) {
        this.addHeader(field, field, "\n");
    }

    private void addHeader(String canonicalField, String displayField) {
        this.addHeader(canonicalField, displayField, delimiter);
    }

    private void addHeader(String canonicalField, String displayField, String delim) {
        if (this.fieldSet == null || this.fieldSet.contains(canonicalField)) {
            this.resultString.append('\"').append(displayField).append('\"').append(delim);
        }
    }

    private void addField(String field, String value) {
        this.addField(field, value, delimiter);
    }

    private void addField(String field, String value, String delim) {
        if (this.fieldSet == null || this.fieldSet.contains(field)) {
            this.resultString.append('\"').append(value.replaceAll("\"", "\"\"")).append('\"').append(delim);
        }
    }

    private void addField(String field, long value) {
        this.addField(field, value, delimiter);
    }

    private void addField(String field, long value, String delim) {
        if (this.fieldSet == null || this.fieldSet.contains(field)) {
            this.resultString.append(value).append(delim);
        }
    }

    private String getResultString() {
        return this.resultString.toString();
    }
}

