/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import nl.mpi.annot.search.lib.HitField;
import nl.mpi.annot.search.lib.HitLayer;
import nl.mpi.annot.search.lib.SearchHSQLDB;
import nl.mpi.annot.search.lib.SearchHit;
import nl.mpi.annot.search.lib.SearchQuery;
import nl.mpi.annot.tools.data.AnnexTranscription;

public class HSQLDBQuery
extends SearchQuery {
    private static Logger _logger = Logger.getLogger(HSQLDBQuery.class.getName());
    private Connection queryCon;
    private Statement queryStatement;
    private Connection hitCon;
    private Statement hitStatement;
    private SearchHSQLDB _ingester;
    private int attrVC = 512;
    private int annVC = 4096;
    private final int _queryIdInt;

    public HSQLDBQuery(int queryIdInt) {
        super(queryIdInt);
        this._queryIdInt = queryIdInt;
        String createSchema = "CREATE SCHEMA search" + this._queryIdInt + " AUTHORIZATION DBA";
        String createTierTable = String.format("CREATE TABLE search%d.tiers (tier_id INTEGER, tier_name VARCHAR(%d), tier_type VARCHAR(%d), default_locale VARCHAR(%d), annotator VARCHAR(%d), participant VARCHAR(%d), n_annotations INTEGER, ref_tier_id INTEGER, transcription_type INTEGER, node_id VARCHAR(%d), aligned_annotations INTEGER )", queryIdInt, this.attrVC, this.attrVC, this.attrVC, this.attrVC, this.attrVC, this.attrVC);
        String createAnnotationTable = String.format("CREATE TABLE search%d.annotations (ann_id INTEGER, annotation VARCHAR(%d), ann_position INTEGER, begin_time BIGINT, end_time BIGINT, ann_tier_id INTEGER)", this._queryIdInt, this.annVC);
        try {
            Properties props = new Properties(System.getProperties());
            this.queryCon = DriverManager.getConnection(props.getProperty("nl.mpi.annot.search.jdbc.url", "jdbc:hsqldb:mem") + ":doQuery", props.getProperty("nl.mpi.annot.search.jdbc.user", "sa"), props.getProperty("nl.mpi.annot.search.jdbc.pass", ""));
            this.queryStatement = this.queryCon.createStatement();
            this.hitCon = DriverManager.getConnection(props.getProperty("nl.mpi.annot.search.jdbc.url", "jdbc:hsqldb:mem") + ":getHits", props.getProperty("nl.mpi.annot.search.jdbc.user", "sa"), props.getProperty("nl.mpi.annot.search.jdbc.pass", ""));
            this.hitStatement = this.hitCon.createStatement();
            this.queryStatement.executeUpdate(createSchema);
            this.queryStatement.executeUpdate(createTierTable);
            this.queryStatement.executeUpdate(createAnnotationTable);
            this.queryStatement.executeUpdate("CREATE INDEX ann_begin_time_index ON search" + this._queryIdInt + ".annotations( begin_time )");
            this.queryStatement.executeUpdate("CREATE INDEX ann_end_time_index ON search" + this._queryIdInt + ".annotations( end_time )");
            this.hitStatement.executeUpdate(createSchema);
            this.hitStatement.executeUpdate(createTierTable);
            this.hitStatement.executeUpdate(createAnnotationTable);
            this.hitStatement.executeUpdate("CREATE INDEX ann_begin_time_index ON search" + this._queryIdInt + ".annotations( begin_time )");
            this.hitStatement.executeUpdate("CREATE INDEX ann_end_time_index ON search" + this._queryIdInt + ".annotations( end_time )");
        }
        catch (SQLException e) {
            _logger.log(Level.SEVERE, "HSQLDBQuery create tables SQLException: " + e, e);
        }
        this._ingester = new SearchHSQLDB("search" + this._queryIdInt);
    }

    public void doQuery(String encodedQuery) {
        this.cancelQuery();
        this.statistics.reset();
        this.clearFrequencyStatistics();
        if (this._ingester.getDomain().size() == 0) {
            return;
        }
        this.createLayers(encodedQuery);
        this.keepExecuting = true;
        this.isExecuting = true;
        new Thread(new QueryExecutor()).start();
    }

    public void cancelQuery() {
        if (this.isExecuting) {
            this.keepExecuting = false;
            try {
                while (this.isExecuting) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.isExecuting = false;
    }

    @Override
    protected String createQueryPatternPart(String pattern, String[] queryModes, Pattern regexpPattern, boolean patternNOTMode) {
        Object queryPart = "";
        this.patternNeedsFullStatistics = false;
        if (queryModes[0].equals(" Annotation")) {
            if (queryModes[2].equals(" variable match")) {
                queryPart = "1 = 1";
            } else if (!(queryModes[2].equals(" exact match") || queryModes[2].equals(" substring match") || queryModes[2].equals(" regular expression"))) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "Mode (exact, substring, regexp, variable) not recognized: " + queryModes[2]);
                }
                queryPart = "42 = 43";
            } else if (queryModes[1].equals(" case sensitive")) {
                if (queryModes[2].equals(" exact match")) {
                    queryPart = patternNOTMode ? "annotation != '" + this.escapeQ(pattern) + "'" : "annotation = '" + this.escapeQ(pattern) + "'";
                } else if (queryModes[2].equals(" substring match")) {
                    if (patternNOTMode) {
                        queryPart = "annotation NOT LIKE '%" + this.escape(pattern) + "%' ESCAPE '~'";
                    } else {
                        queryPart = "annotation LIKE '%" + this.escape(pattern) + "%' ESCAPE '~'";
                        this.patternNeedsFullStatistics = true;
                    }
                } else if (queryModes[2].equals(" regular expression")) {
                    if (patternNOTMode) {
                        queryPart = "REGEXP_SUBSTRING(annotation, '" + this.escapeQ(pattern) + "') IS NULL";
                    } else {
                        queryPart = "REGEXP_SUBSTRING(annotation, '" + this.escapeQ(pattern) + "') IS NOT NULL";
                        this.patternNeedsFullStatistics = true;
                    }
                }
            } else if (queryModes[2].equals(" exact match")) {
                queryPart = patternNOTMode ? "LCASE(annotation) != '" + this.escapeQ(pattern.toLowerCase()) + "'" : "LCASE(annotation) = '" + this.escapeQ(pattern.toLowerCase()) + "'";
            } else if (queryModes[2].equals(" substring match")) {
                if (patternNOTMode) {
                    queryPart = "LCASE(annotation) NOT LIKE '%" + this.escape(pattern.toLowerCase()) + "%' ESCAPE '~'";
                } else {
                    queryPart = "LCASE(annotation) LIKE '%" + this.escape(pattern.toLowerCase()) + "%' ESCAPE '~'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (queryModes[2].equals(" regular expression")) {
                if (patternNOTMode) {
                    queryPart = "REGEXP_SUBSTRING(LCASE(annotation), '" + this.escapeQ(pattern.toLowerCase()) + "') IS NULL";
                } else {
                    queryPart = "REGEXP_SUBSTRING(LCASE(annotation), '" + this.escapeQ(pattern.toLowerCase()) + "') IS NOT NULL";
                    this.patternNeedsFullStatistics = true;
                }
            }
        } else if (queryModes[0].equals(" N-gram over annotations") || queryModes[0].equals(" N-gram within annotation")) {
            String nGramPart = HSQLDBQuery.getLongestNonWildcardPart(pattern);
            if (queryModes[2].equals(" variable match")) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "Variable match mode cannot be combined with N-Gram searches");
                }
                queryPart = "42 = 43";
            } else if (queryModes[2].equals(" regular expression")) {
                if (queryModes[0].equals(" N-gram within annotation")) {
                    if (nGramPart.startsWith("^")) {
                        nGramPart = nGramPart.substring(1);
                    }
                    if (nGramPart.endsWith("$")) {
                        nGramPart = nGramPart.substring(0, nGramPart.length() - 1);
                    }
                }
                if (queryModes[1].equals(" case sensitive")) {
                    if (patternNOTMode) {
                        queryPart = "REGEXP_SUBSTRING(annotation, '" + this.escapeQ(pattern) + "') IS NULL";
                    } else {
                        queryPart = "REGEXP_SUBSTRING(annotation, '" + this.escapeQ(pattern) + "') IS NOT NULL";
                        this.patternNeedsFullStatistics = true;
                    }
                } else if (patternNOTMode) {
                    queryPart = "REGEXP_SUBSTRING(LCASE(annotation), '" + this.escapeQ(pattern.toLowerCase()) + "') IS NULL";
                } else {
                    queryPart = "REGEXP_SUBSTRING(LCASE(annotation), '" + this.escapeQ(pattern.toLowerCase()) + "') IS NOT NULL";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (queryModes[1].equals(" case sensitive")) {
                if (patternNOTMode) {
                    queryPart = "annotation NOT LIKE '%" + this.escape(nGramPart) + "%' ESCAPE '~'";
                } else {
                    queryPart = "annotation LIKE '%" + this.escape(nGramPart) + "%' ESCAPE '~'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (patternNOTMode) {
                queryPart = "LCASE(annotation) NOT LIKE '%" + this.escape(nGramPart.toLowerCase()) + "%' ESCAPE '~'";
            } else {
                queryPart = "LCASE(annotation) LIKE '%" + this.escape(nGramPart.toLowerCase()) + "%' ESCAPE '~'";
                this.patternNeedsFullStatistics = true;
            }
        } else {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "Mode is neither ANNOTATIONS nor N_GRAMS_WITHIN_ANNOTATIONS nor N_GRAMS_OVER_ANNOTATIONS but: " + queryModes[0] + " (" + queryModes[1] + "/" + queryModes[2] + ")");
            }
            queryPart = "42 = 43";
        }
        return queryPart;
    }

    @Override
    protected String convertRegexpPatternsIfNeeded(String queryString) {
        return queryString;
    }

    public ArrayList<SearchHit> getHits(int fromIndex, int count, int contextSize) {
        ArrayList<SearchHit> hitList;
        block36: {
            hitList = new ArrayList<SearchHit>();
            if (this.firstNonEmptyLayerIndex < 0 || this.firstNonEmptyLayerIndex >= this.nLayers || this.firstNonEmptyPatternIndex < 0 || this.firstNonEmptyPatternIndex >= this.nPatternsPerLayer) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "Empty query? no results. FirstNonEmpty: " + this.firstNonEmptyPatternIndex + "/" + this.firstNonEmptyLayerIndex + " Matrix: " + this.nPatternsPerLayer + "*" + this.nLayers);
                }
                return hitList;
            }
            ResultSet rs = null;
            try {
                int prevFileId = -1;
                File file = null;
                ArrayList<Long> beginTimes = new ArrayList<Long>();
                int[][] hitAnnIds = new int[this.nLayers][this.nPatternsPerLayer];
                int[][] hitTierIds = new int[this.nLayers][this.nPatternsPerLayer];
                for (int i = fromIndex; i < this.statistics.nHits; ++i) {
                    SearchHit hit = new SearchHit();
                    int annId = this.searchLayers[this.firstNonEmptyLayerIndex].getHitAnnIdForPattern(this.firstNonEmptyPatternIndex, i);
                    int hitNumberInAnnotation = this.searchLayers[this.firstNonEmptyLayerIndex].getHitNumberForPattern(this.firstNonEmptyPatternIndex, i);
                    if (hitNumberInAnnotation == -1) {
                        if (count != 1 || !hitList.isEmpty()) {
                            if (count == 1) {
                                hitList.remove(hitList.size() - 1);
                            }
                            hit.setError("[END OF HIT LIST DUE TO MEMORY LIMITATIONS]");
                            hitList.add(hit);
                        }
                    } else {
                        int fileId = this.searchLayers[this.firstNonEmptyLayerIndex].getHitFileId(i);
                        if (fileId != prevFileId) {
                            file = this._ingester.getDomain().get(fileId);
                            AnnexTranscription transcription = new AnnexTranscription(file.getName(), 0, file);
                            this._ingester.ingestCounting(transcription, this.hitCon);
                            prevFileId = fileId;
                        }
                        rs = this.hitStatement.executeQuery("SELECT ann_position, annotation, begin_time, end_time, ann_tier_id FROM search" + this._queryIdInt + ".annotations WHERE ann_id = " + annId);
                        rs.next();
                        int positionInTier = rs.getInt(1);
                        if (this.isSimpleQuery) {
                            String annotation = rs.getString(2);
                            long beginTime = HSQLDBQuery.getValue(rs, 3);
                            long endTime = HSQLDBQuery.getValue(rs, 4);
                            int ann_tier_id = rs.getInt(5);
                            hit.hitFields.get(0).add(new HitField(annotation, beginTime, endTime, positionInTier, hitNumberInAnnotation, ann_tier_id));
                        } else {
                            for (int layer = 0; layer < this.nLayers; ++layer) {
                                for (int pattern = 0; pattern < this.nPatternsPerLayer; ++pattern) {
                                    hitAnnIds[layer][pattern] = this.searchLayers[layer].getHitAnnIdForPattern(pattern, i);
                                    hitTierIds[layer][pattern] = this.searchLayers[layer].getHitTierIdForPattern(pattern, i);
                                }
                            }
                            this.constructComplexHitResult(null, this.hitStatement, hitAnnIds, hitTierIds, hit);
                        }
                        rs.close();
                        rs = null;
                        boolean doneWithFileProperties = false;
                        for (List<HitField> hitFieldLayer : hit.hitFields) {
                            int ann_tier_id = -1;
                            for (HitField oneHitField : hitFieldLayer) {
                                if (oneHitField == null) continue;
                                ann_tier_id = oneHitField.tierId;
                                break;
                            }
                            if (ann_tier_id == -1) {
                                if (doneWithFileProperties) continue;
                                hit.layerTiers.add(new HitLayer("", "", "", "", false));
                                continue;
                            }
                            rs = this.hitStatement.executeQuery("SELECT node_id, tier_name, tier_type, participant, annotator, n_annotations, aligned_annotations FROM search" + this._queryIdInt + ".tiers WHERE tier_id = " + ann_tier_id);
                            rs.next();
                            if (!doneWithFileProperties) {
                                hit.transcriptionNodeId = rs.getString(1);
                                hit.transcriptionName = file.getAbsolutePath();
                                hit.transcriptionPID = null;
                                hit.transcriptionURL = file.toURI().toASCIIString();
                                doneWithFileProperties = true;
                            }
                            String tierName = rs.getString(2);
                            String tierType = rs.getString(3);
                            String participant = rs.getString(4);
                            String annotator = rs.getString(5);
                            int nAnnotationsInTier = rs.getInt(6);
                            int nAlignedAnnotationsInTier = rs.getInt(7);
                            rs.close();
                            rs = null;
                            boolean aligned = nAlignedAnnotationsInTier == nAnnotationsInTier;
                            hit.layerTiers.add(new HitLayer(tierName, tierType, participant, annotator, aligned));
                        }
                        String pattern = this.searchLayers[this.firstNonEmptyLayerIndex].getPattern(this.firstNonEmptyPatternIndex);
                        boolean patternNOTMode = this.searchLayers[this.firstNonEmptyLayerIndex].getPatternNOTMode(this.firstNonEmptyPatternIndex);
                        Pattern regExpPattern = this.searchLayers[this.firstNonEmptyLayerIndex].getRegExpPattern(this.firstNonEmptyPatternIndex);
                        String[] queryModes = this.searchLayers[this.firstNonEmptyLayerIndex].getMode(this.firstNonEmptyPatternIndex);
                        HitField firstField = hit.getFirstField();
                        int ann_tier_id = firstField.tierId;
                        firstField.setHighlightInfo(this.getHitPosition(firstField.annotation, firstField.hitNumberInAnnotation, queryModes, pattern, regExpPattern, patternNOTMode), this.getHitLength(firstField.annotation, firstField.hitNumberInAnnotation, queryModes, pattern, regExpPattern, patternNOTMode));
                        if (queryModes[0].equals(" N-gram over annotations")) {
                            int leftContextSize = contextSize + this.nGramSizeLeftFromHit;
                            StringBuilder annotation = new StringBuilder(firstField.annotation);
                            boolean incomplete = false;
                            hit.refreshTimes();
                            rs = this.hitStatement.executeQuery("SELECT annotation, ann_position, begin_time FROM search" + this._queryIdInt + ".annotations WHERE ann_tier_id = " + ann_tier_id + " AND ann_position < " + positionInTier + " AND ann_position >= " + (positionInTier - leftContextSize) + " ORDER BY ann_position DESC");
                            beginTimes.clear();
                            while (rs.next()) {
                                hit.leftContext.add(rs.getString(1));
                                beginTimes.add(HSQLDBQuery.getValue(rs, 3));
                            }
                            Object withLeftContext = annotation.toString();
                            for (int j = 0; j < this.nGramSizeLeftFromHit; ++j) {
                                if (hit.leftContext.size() <= 0) {
                                    if (_logger.isLoggable(Level.WARNING)) {
                                        _logger.log(Level.WARNING, "incomplete start of N-gram: Would need " + this.nGramSizeLeftFromHit + " elements before " + positionInTier);
                                    }
                                    incomplete = true;
                                    break;
                                }
                                String part = hit.leftContext.get(0);
                                withLeftContext = part + " " + (String)withLeftContext;
                                hit.beginTime = (Long)beginTimes.get(0);
                                hit.leftContext.remove(0);
                                beginTimes.remove(0);
                            }
                            annotation = new StringBuilder((String)withLeftContext);
                            rs.close();
                            rs = null;
                            int rightContextSize = contextSize + this.nGramSizeRightFromHit;
                            rs = this.hitStatement.executeQuery("SELECT annotation, ann_position, end_time FROM search" + this._queryIdInt + ".annotations WHERE ann_tier_id = " + ann_tier_id + " AND ann_position > " + positionInTier + " AND ann_position <= " + (positionInTier + rightContextSize) + " ORDER BY ann_position");
                            int n = 0;
                            while (rs.next()) {
                                if (n < this.nGramSizeRightFromHit) {
                                    annotation.append(' ');
                                    annotation.append(rs.getString(1));
                                    hit.endTime = HSQLDBQuery.getValue(rs, 3);
                                } else {
                                    hit.rightContext.add(rs.getString(1));
                                }
                                ++n;
                            }
                            rs.close();
                            rs = null;
                            if (n < this.nGramSizeRightFromHit) {
                                if (_logger.isLoggable(Level.WARNING)) {
                                    _logger.log(Level.WARNING, "incomplete end of N-gram: Would need " + this.nGramSizeRightFromHit + " elements after " + positionInTier + " but got only " + n);
                                }
                                incomplete = true;
                            }
                            hit.hitFields = new ArrayList<List<HitField>>();
                            hit.hitFields.add(new ArrayList());
                            hit.hitFields.get(0).add(new HitField(annotation.toString(), hit.beginTime, hit.endTime, positionInTier - this.nGramSizeLeftFromHit, 0, ann_tier_id));
                            hit.getFirstField().setHighlightInfo(0, annotation.length());
                            if (incomplete) {
                                continue;
                            }
                        } else if (this.isSimpleQuery) {
                            rs = this.hitStatement.executeQuery("SELECT annotation, ann_position FROM search" + this._queryIdInt + ".annotations WHERE ann_tier_id = " + ann_tier_id + " AND ann_position < " + positionInTier + " AND ann_position >= " + (positionInTier - contextSize) + " ORDER BY ann_position DESC");
                            while (rs.next()) {
                                hit.leftContext.add(rs.getString(1));
                            }
                            rs.close();
                            rs = this.hitStatement.executeQuery("SELECT annotation, ann_position FROM search" + this._queryIdInt + ".annotations WHERE ann_tier_id = " + ann_tier_id + " AND ann_position > " + positionInTier + " AND ann_position <= " + (positionInTier + contextSize) + " ORDER BY ann_position");
                            while (rs.next()) {
                                hit.rightContext.add(rs.getString(1));
                            }
                            rs.close();
                            rs = null;
                        }
                        hit.refreshTimes();
                        hitList.add(hit);
                        if (--count != 0) {
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (SQLException e) {
                _logger.log(Level.SEVERE, "SQLException in getHits: " + e, e);
                if (rs == null) break block36;
                try {
                    rs.close();
                }
                catch (SQLException e2) {
                    _logger.log(Level.SEVERE, "SQLException in closing ResultSet in getHits: " + e, e);
                }
            }
        }
        return hitList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Object> getViewerParametersFor(int annId, int fileId) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        ResultSet rs = null;
        try {
            File file = this._ingester.getDomain().get(fileId);
            AnnexTranscription transcription = new AnnexTranscription(file.getName(), 0, file);
            this._ingester.ingestCounting(transcription, this.hitCon);
            rs = this.hitStatement.executeQuery("SELECT begin_time, end_time, ann_tier_id FROM search" + this._queryIdInt + ".annotations WHERE ann_id = " + annId);
            rs.next();
            long beginTime = HSQLDBQuery.getValue(rs, 1);
            long endTime = HSQLDBQuery.getValue(rs, 2);
            int tierId = rs.getInt(3);
            rs.close();
            rs = null;
            rs = this.hitStatement.executeQuery("SELECT tier_name FROM search" + this._queryIdInt + ".tiers WHERE tier_id = " + tierId);
            rs.next();
            String tierName = rs.getString(1);
            rs.close();
            rs = null;
            parameters.add(file.getAbsolutePath());
            parameters.add(tierName);
            parameters.add(beginTime);
            parameters.add(endTime);
        }
        catch (SQLException e) {
            _logger.log(Level.SEVERE, "SQLException in getViewerParametersFor: " + e, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return parameters;
    }

    private String escape(String string) {
        String s = string.replaceAll("~", "~~");
        s = s.replaceAll("%", "~%");
        s = s.replaceAll("'", "''");
        return s.replaceAll("_", "~_");
    }

    private String escapeQ(String str) {
        return str.replaceAll("'", "''");
    }

    public SearchHSQLDB getIngester() {
        return this._ingester;
    }

    public void setDomain(ArrayList<File> eafFiles) {
        this.statistics.reset();
        this.clearFrequencyStatistics();
        this._ingester.setDomain(eafFiles);
    }

    public void setDomain(HSQLDBQuery query) {
        this.statistics.reset();
        this.clearFrequencyStatistics();
        this._ingester.setDomain(query.getIngester());
    }

    public float getDomainInitializationProgress() {
        return this._ingester.getDomainInitializationProgress();
    }

    public ArrayList<File> getDomain() {
        return this._ingester.getDomain();
    }

    public ArrayList<File> getProblemFiles() {
        return this._ingester.getProblemFiles();
    }

    public ArrayList<String> getTierNames() {
        return this._ingester.getTierNames();
    }

    public ArrayList<String> getTierTypes() {
        return this._ingester.getTierTypes();
    }

    public ArrayList<String> getParticipants() {
        return this._ingester.getParticipants();
    }

    public ArrayList<String> getAnnotators() {
        return this._ingester.getAnnotators();
    }

    static {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (ClassNotFoundException e) {
            _logger.log(Level.SEVERE, "No JAR with org.hsqldb.jdbcDriver in classpath!");
        }
    }

    private class QueryExecutor
    implements Runnable {
        String pattern;
        boolean patternNOTMode;
        Pattern regExpPattern;
        String[] queryModes;

        protected QueryExecutor() {
            if (HSQLDBQuery.this.firstNonEmptyPatternIndex >= 0) {
                this.pattern = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getPattern(HSQLDBQuery.this.firstNonEmptyPatternIndex);
                this.patternNOTMode = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getPatternNOTMode(HSQLDBQuery.this.firstNonEmptyPatternIndex);
                this.regExpPattern = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getRegExpPattern(HSQLDBQuery.this.firstNonEmptyPatternIndex);
                this.queryModes = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getMode(HSQLDBQuery.this.firstNonEmptyPatternIndex);
            } else if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "QueryExecutor: All patterns empty");
            }
        }

        @Override
        public void run() {
            if (this.pattern == null || HSQLDBQuery.this.firstNonEmptyLayerIndex < 0 || HSQLDBQuery.this.firstNonEmptyPatternIndex < 0) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "Bad or empty query: " + (this.pattern == null ? "null" : "") + " at " + HSQLDBQuery.this.firstNonEmptyPatternIndex + "/" + HSQLDBQuery.this.firstNonEmptyLayerIndex);
                }
                HSQLDBQuery.this.statistics.progress = 1.0f;
                HSQLDBQuery.this.isExecuting = false;
            } else {
                String queryString = "SELECT ann_id, annotation, begin_time, end_time, ann_position, ann_tier_id FROM search" + HSQLDBQuery.this._queryIdInt + ".annotations WHERE ";
                queryString = queryString + HSQLDBQuery.this.createQueryPatternPart(this.pattern, this.queryModes, this.regExpPattern, this.patternNOTMode);
                queryString = queryString + HSQLDBQuery.this.createGlobalTimeConstraintPart();
                try {
                    AnnexTranscription transcription = null;
                    boolean loggedQuery = false;
                    for (int fileIndex = 0; fileIndex < HSQLDBQuery.this._ingester.getDomain().size(); ++fileIndex) {
                        File file = HSQLDBQuery.this._ingester.getDomain().get(fileIndex);
                        if (file.exists()) {
                            transcription = new AnnexTranscription(file.getName(), 0, file);
                            if (transcription.isValid()) {
                                HSQLDBQuery.this.statistics.nAnnotationsSearched = (int)((long)HSQLDBQuery.this.statistics.nAnnotationsSearched + HSQLDBQuery.this._ingester.ingestCounting(transcription, HSQLDBQuery.this.queryCon));
                                if (fileIndex < HSQLDBQuery.this._ingester.getDomain().size() - 1) {
                                    HSQLDBQuery.this.statistics.progress = ((float)fileIndex - 0.5f) / (float)HSQLDBQuery.this._ingester.getDomain().size();
                                }
                                boolean tierFreeLayersExist = HSQLDBQuery.this.setTierDomainForLayers(false, HSQLDBQuery.this.queryCon, transcription.getNodeId());
                                String tierDomain = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getTierIdsInLayerDomain();
                                String query = queryString;
                                if (tierFreeLayersExist) continue;
                                if (!tierDomain.equals(HSQLDBQuery.this.fullTranscriptionTierDomain)) {
                                    query = query + tierDomain;
                                }
                                Object hint = "";
                                if (query.contains("nl.mpi.annot.search.lib.HSQLDBQuery.match")) {
                                    hint = (String)hint + "[regexp = '" + this.regExpPattern + "'] ";
                                }
                                if (!HSQLDBQuery.this.isSimpleQuery) {
                                    hint = (String)hint + "[" + (HSQLDBQuery.this.firstNonEmptyLayerIndex + 1) + "/" + HSQLDBQuery.this.nLayers + "][" + (HSQLDBQuery.this.firstNonEmptyPatternIndex + 1) + "/" + HSQLDBQuery.this.nPatternsPerLayer + "] ";
                                }
                                if (!loggedQuery) {
                                    if (_logger.isLoggable(Level.INFO)) {
                                        _logger.log(Level.INFO, "query: " + (String)hint + query);
                                    }
                                    loggedQuery = true;
                                }
                                boolean logLayerq = true;
                                ResultSet rs = HSQLDBQuery.this.queryStatement.executeQuery(query);
                                while (rs.next()) {
                                    int annId = rs.getInt(1);
                                    String annotation = rs.getString(2);
                                    int tierId = rs.getInt(6);
                                    if (HSQLDBQuery.this.isSimpleQuery) {
                                        if (this.queryModes[0].equals(" Annotation")) {
                                            long beginTime = SearchQuery.getValue(rs, 3);
                                            long endTime = SearchQuery.getValue(rs, 4);
                                            if (!HSQLDBQuery.this.isDurationInRange(endTime - beginTime)) continue;
                                            HSQLDBQuery.this.updateFrequencyStatistics(annotation, annId, fileIndex, HSQLDBQuery.this.firstNonEmptyLayerIndex, HSQLDBQuery.this.firstNonEmptyPatternIndex);
                                            ++HSQLDBQuery.this.statistics.nAnnotationsWithHit;
                                            int nHitsInAnnotation = 1;
                                            if (HSQLDBQuery.this.patternNeedsFullStatistics) {
                                                nHitsInAnnotation = HSQLDBQuery.this.countHitsInAnnotation(annotation, this.queryModes, this.pattern, this.regExpPattern, this.patternNOTMode);
                                            }
                                            for (int j = 0; j < nHitsInAnnotation; ++j) {
                                                HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].setHitAnnIdForPattern(HSQLDBQuery.this.firstNonEmptyPatternIndex, HSQLDBQuery.this.statistics.nHits, annId);
                                                HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].setHitNumberForPattern(HSQLDBQuery.this.firstNonEmptyPatternIndex, HSQLDBQuery.this.statistics.nHits, j + 1);
                                                HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].setHitFileId(HSQLDBQuery.this.statistics.nHits, fileIndex);
                                                ++HSQLDBQuery.this.statistics.nHits;
                                            }
                                        } else {
                                            String[] nGrams;
                                            if (this.queryModes[0].equals(" N-gram over annotations")) {
                                                HSQLDBQuery.this.nGramSizeLeftFromHit = SearchQuery.getLongestNonWildcardPartPosition(this.pattern);
                                                HSQLDBQuery.this.nGramSizeRightFromHit = HSQLDBQuery.this.getNGramLength(this.pattern) - HSQLDBQuery.this.nGramSizeLeftFromHit - 1;
                                            }
                                            if ((nGrams = HSQLDBQuery.this.constructNGrams(annId, HSQLDBQuery.this.queryStatement, HSQLDBQuery.this._queryIdInt, this.pattern, this.queryModes)) != null) {
                                                boolean frequencyStatisticsUpdated = false;
                                                boolean firstNAnnotationsUpdate = true;
                                                int hitNumber = 1;
                                                for (String nGram : nGrams) {
                                                    if (!HSQLDBQuery.this.isNGramMatch(nGram, this.pattern, this.queryModes)) continue;
                                                    if (!frequencyStatisticsUpdated) {
                                                        nGram = nGram.replace("xxxSAFE_SPLITTERxxx", " ");
                                                        HSQLDBQuery.this.updateFrequencyStatistics(nGram, annId, fileIndex, HSQLDBQuery.this.firstNonEmptyLayerIndex, HSQLDBQuery.this.firstNonEmptyPatternIndex);
                                                        frequencyStatisticsUpdated = true;
                                                    }
                                                    if (this.queryModes[0].equals(" N-gram over annotations") || firstNAnnotationsUpdate) {
                                                        ++HSQLDBQuery.this.statistics.nAnnotationsWithHit;
                                                        firstNAnnotationsUpdate = false;
                                                    }
                                                    HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].setHitAnnIdForPattern(HSQLDBQuery.this.firstNonEmptyPatternIndex, HSQLDBQuery.this.statistics.nHits, annId);
                                                    HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].setHitNumberForPattern(HSQLDBQuery.this.firstNonEmptyPatternIndex, HSQLDBQuery.this.statistics.nHits, hitNumber++);
                                                    HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].setHitFileId(HSQLDBQuery.this.statistics.nHits, fileIndex);
                                                    ++HSQLDBQuery.this.statistics.nHits;
                                                }
                                            }
                                        }
                                    } else {
                                        HSQLDBQuery.this.clearHitData(fileIndex);
                                        HashMap<String, String> variableMap = new HashMap<String, String>();
                                        if (this.queryModes[2].equals(" variable match")) {
                                            variableMap.put(this.pattern + this.queryModes[1], annotation);
                                        }
                                        HSQLDBQuery.this.globalHitAnnId[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = annId;
                                        HSQLDBQuery.this.globalHitTierId[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = tierId;
                                        HSQLDBQuery.this.globalHitBeginTime[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = SearchQuery.getValue(rs, 3);
                                        HSQLDBQuery.this.globalHitEndTime[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = SearchQuery.getValue(rs, 4);
                                        HSQLDBQuery.this.globalHitPosition[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = rs.getInt(5);
                                        HSQLDBQuery.this.investigateComplexPattern(HSQLDBQuery.this.firstNonEmptyLayerIndex, HSQLDBQuery.this.firstNonEmptyPatternIndex, HSQLDBQuery.this.queryCon, logLayerq, variableMap);
                                        logLayerq = false;
                                    }
                                    if (HSQLDBQuery.this.keepExecuting) continue;
                                    break;
                                }
                                if (!HSQLDBQuery.this.keepExecuting) break;
                            }
                            if (!HSQLDBQuery.this.keepExecuting) break;
                        }
                        if (!HSQLDBQuery.this.keepExecuting) break;
                        HSQLDBQuery.this.statistics.progress = (float)fileIndex / (float)HSQLDBQuery.this._ingester.getDomain().size();
                    }
                    HSQLDBQuery.this.statistics.progress = 1.0f;
                }
                catch (SQLException e) {
                    _logger.log(Level.SEVERE, "SQLException in run: " + e, e);
                    HSQLDBQuery.this.statistics.progress = 1.0f;
                }
                catch (RuntimeException re) {
                    _logger.log(Level.SEVERE, "RuntimeException in run: " + re, re);
                    HSQLDBQuery.this.statistics.progress = 1.0f;
                }
                HSQLDBQuery.this.isExecuting = false;
            }
        }
    }
}

