/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.mpi.annot.tools.data.AnnexAnnotation;
import nl.mpi.annot.tools.data.AnnexTier;
import nl.mpi.annot.tools.data.AnnexTranscription;

public class SearchHSQLDB
implements Runnable {
    private static Logger _logger = Logger.getLogger(SearchHSQLDB.class.getName());
    private String schemaName;
    private SearchHSQLDB cloneIngester;
    private ArrayList<File> eafFiles;
    private ArrayList<File> problemFiles = new ArrayList();
    private ArrayList<String> tierNames;
    private ArrayList<String> tierTypes;
    private ArrayList<String> participants;
    private ArrayList<String> annotators;
    private float domainInitializationProgress;

    public SearchHSQLDB(String dbSchemaName) {
        this.schemaName = dbSchemaName;
    }

    public long ingestCounting(AnnexTranscription transcription, Connection con) {
        FileStats stats = this.ingest(transcription, con);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Ingested: " + transcription.getNodeId() + " Found: " + stats.nTiers + " tiers, " + stats.nAnnotations + " annotations, " + stats.annotationsSize + " characters.");
        }
        return stats.nAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileStats ingest(AnnexTranscription transcription, Connection con) {
        Statement st = null;
        try {
            st = con.createStatement();
            st.executeUpdate("DELETE FROM " + this.schemaName + ".tiers");
            st.executeUpdate("DELETE FROM " + this.schemaName + ".annotations");
            st.close();
            st = null;
        }
        catch (SQLException e) {
            _logger.log(Level.SEVERE, "Failed to delete old tiers and annotations for schema " + this.schemaName + ": " + e);
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException e2) {
                _logger.log(Level.SEVERE, "Failed to close Statement in ingest: " + e2);
            }
        }
        st = null;
        FileStats stats = new FileStats();
        HashMap<AnnexTier, Integer> ids = new HashMap<AnnexTier, Integer>();
        int nTiers = transcription.getTiers().size();
        int tierId = 0;
        int annotationId = 0;
        stats.nTiers = nTiers;
        int[] nAlignedAnnotations = new int[nTiers];
        int[] nAnnotations = new int[nTiers];
        for (int i = 0; i < nTiers; ++i) {
            AnnexTier tier = (AnnexTier)transcription.getTiers().get(i);
            ids.put(tier, tierId++);
            nAnnotations[i] = tier.annotations.size();
            nAlignedAnnotations[i] = 0;
            stats.nAnnotations += (long)nAnnotations[i];
            for (int j = 0; j < nAnnotations[i]; ++j) {
                AnnexAnnotation annotation = (AnnexAnnotation)tier.annotations.get(j);
                stats.annotationsSize += (long)annotation.value.length();
                if (!annotation.isTimeAligned) continue;
                int n = i;
                nAlignedAnnotations[n] = nAlignedAnnotations[n] + 1;
            }
        }
        PreparedStatement stAnnotation = null;
        Statement stTier = null;
        try {
            stAnnotation = con.prepareStatement("INSERT INTO " + this.schemaName + ".annotations (ann_id, annotation, ann_position, begin_time, end_time, ann_tier_id) VALUES (?, ?, ?, ?, ?, ?)");
            stTier = con.prepareStatement("INSERT INTO " + this.schemaName + ".tiers (tier_id, tier_name, tier_type, default_locale, annotator, participant,  n_annotations, ref_tier_id, transcription_type, node_id, aligned_annotations) VALUES (?, ?, ?, ?, ?,  ?, ?, ?, ?, ?,  ?)");
            tierId = 0;
            annotationId = 0;
            for (int i = 0; i < nTiers; ++i) {
                AnnexTier tier = (AnnexTier)transcription.getTiers().get(i);
                int ref_tier_id = -1;
                if (tier.parentTier != null) {
                    ref_tier_id = (Integer)ids.get(tier.parentTier);
                }
                stTier.setInt(1, tierId);
                stTier.setString(2, tier.name);
                stTier.setString(3, tier.type);
                stTier.setString(4, tier.defaultLocale);
                stTier.setString(5, tier.annotator);
                stTier.setString(6, tier.participant);
                stTier.setInt(7, nAnnotations[i]);
                stTier.setInt(8, ref_tier_id);
                stTier.setInt(9, transcription.getType());
                stTier.setString(10, transcription.getNodeId());
                stTier.setInt(11, nAlignedAnnotations[i]);
                stTier.executeUpdate();
                for (int j = 0; j < nAnnotations[i]; ++j) {
                    AnnexAnnotation annotation = (AnnexAnnotation)tier.annotations.get(j);
                    if (annotation.value.length() > 2600 && _logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.WARNING, "Info: there is an annotation longer than 2600 characters in ID " + transcription.getNodeId());
                    }
                    stAnnotation.setInt(1, annotationId++);
                    stAnnotation.setString(2, annotation.value);
                    stAnnotation.setInt(3, j);
                    stAnnotation.setLong(4, annotation.beginTime);
                    stAnnotation.setLong(5, annotation.endTime);
                    stAnnotation.setInt(6, tierId);
                    stAnnotation.executeUpdate();
                }
                ++tierId;
            }
        }
        catch (SQLException e) {
            _logger.log(Level.SEVERE, "SQLException in ingest: " + e, e);
        }
        catch (RuntimeException re) {
            _logger.log(Level.SEVERE, "RuntimeException in ingest: " + re, re);
        }
        finally {
            try {
                if (stTier != null) {
                    stTier.close();
                }
            }
            catch (SQLException e2) {
                _logger.log(Level.SEVERE, "Failed to close tier PreparedStatement in ingest: " + e2);
            }
            try {
                if (stAnnotation != null) {
                    stAnnotation.close();
                }
            }
            catch (SQLException e2) {
                _logger.log(Level.SEVERE, "Failed to close annotation PreparedStatement in ingest: " + e2);
            }
        }
        return stats;
    }

    public void setDomain(ArrayList<File> eafFiles) {
        this.eafFiles = new ArrayList<File>(eafFiles);
        this.problemFiles.clear();
        this.domainInitializationProgress = 0.0f;
        new Thread(this).start();
    }

    public void setDomain(SearchHSQLDB otherIngester) {
        this.problemFiles.clear();
        this.cloneIngester = otherIngester;
        this.domainInitializationProgress = 0.0f;
        new Thread(this).start();
    }

    public float getDomainInitializationProgress() {
        return this.domainInitializationProgress;
    }

    public ArrayList<File> getDomain() {
        return this.eafFiles;
    }

    public ArrayList<File> getProblemFiles() {
        return this.problemFiles;
    }

    public ArrayList<String> getTierNames() {
        return this.tierNames;
    }

    public ArrayList<String> getTierTypes() {
        return this.tierTypes;
    }

    public ArrayList<String> getParticipants() {
        return this.participants;
    }

    public ArrayList<String> getAnnotators() {
        return this.annotators;
    }

    @Override
    public void run() {
        if (this.cloneIngester != null) {
            while (this.cloneIngester.getDomainInitializationProgress() < 1.0f) {
                try {
                    this.domainInitializationProgress = this.cloneIngester.getDomainInitializationProgress() - 0.01f;
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.eafFiles = new ArrayList<File>(this.cloneIngester.getDomain());
            this.tierNames = new ArrayList<String>(this.cloneIngester.getTierNames());
            this.tierTypes = new ArrayList<String>(this.cloneIngester.getTierTypes());
            this.participants = new ArrayList<String>(this.cloneIngester.getParticipants());
            this.annotators = new ArrayList<String>(this.cloneIngester.getAnnotators());
            this.domainInitializationProgress = 1.0f;
            this.cloneIngester = null;
        } else {
            TreeSet<String> tierNamesSet = new TreeSet<String>();
            TreeSet<String> tierTypesSet = new TreeSet<String>();
            TreeSet<String> participantsSet = new TreeSet<String>();
            TreeSet<String> annotatorsSet = new TreeSet<String>();
            this.problemFiles = new ArrayList();
            for (int i = 0; i < this.eafFiles.size(); ++i) {
                File file = this.eafFiles.get(i);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, file.getAbsolutePath());
                }
                if (file.exists()) {
                    AnnexTranscription transcription = new AnnexTranscription(file.getName(), 0, file);
                    if (transcription.isValid()) {
                        ArrayList tiers = transcription.getTiers();
                        for (AnnexTier tier : tiers) {
                            if (tier.name != null && tier.name.trim().length() > 0) {
                                tierNamesSet.add(tier.name);
                            }
                            if (tier.type != null && tier.type.trim().length() > 0) {
                                tierTypesSet.add(tier.type);
                            }
                            if (tier.participant != null && tier.participant.trim().length() > 0) {
                                participantsSet.add(tier.participant);
                            }
                            if (tier.annotator == null || tier.annotator.trim().length() <= 0) continue;
                            annotatorsSet.add(tier.annotator);
                        }
                    } else {
                        this.problemFiles.add(this.eafFiles.get(i));
                    }
                }
                this.domainInitializationProgress = (float)((double)this.domainInitializationProgress + 1.0 / (double)(this.eafFiles.size() + 1));
            }
            this.tierNames = new ArrayList(tierNamesSet);
            this.tierTypes = new ArrayList(tierTypesSet);
            this.participants = new ArrayList(participantsSet);
            this.annotators = new ArrayList(annotatorsSet);
            if (this.problemFiles.size() > 0) {
                for (File problemFile : this.problemFiles) {
                    this.eafFiles.remove(problemFile);
                }
            }
            this.domainInitializationProgress = 1.0f;
        }
    }

    private static class FileStats {
        public int nTiers;
        public long nAnnotations;
        public long annotationsSize;

        private FileStats() {
        }
    }
}

