/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.util.ArrayList;
import java.util.List;
import nl.mpi.annot.search.lib.HitField;
import nl.mpi.annot.search.lib.HitLayer;

public class SearchHit {
    public List<HitLayer> layerTiers;
    public List<List<HitField>> hitFields;
    public long beginTime;
    public long endTime;
    public String transcriptionName;
    public String transcriptionURL;
    public String transcriptionPID = null;
    public String transcriptionNodeId;
    public List<String> leftContext = new ArrayList<String>();
    public List<String> rightContext = new ArrayList<String>();

    public SearchHit() {
        this.layerTiers = new ArrayList<HitLayer>();
        this.hitFields = new ArrayList<List<HitField>>();
        this.hitFields.add(new ArrayList());
    }

    public boolean isComplex() {
        int nFields = 0;
        for (List<HitField> layer : this.hitFields) {
            for (HitField field : layer) {
                if (field == null) continue;
                ++nFields;
            }
        }
        return nFields > 1;
    }

    public void setError(String message) {
        this.beginTime = 0L;
        this.endTime = 1000L;
        this.layerTiers = new ArrayList<HitLayer>();
        this.layerTiers.add(new HitLayer("ERROR", "ERROR", null, null, false));
        this.hitFields = new ArrayList<List<HitField>>();
        this.hitFields.add(new ArrayList());
        HitField messageField = new HitField(message, this.beginTime, this.endTime, 0, 1, -1);
        messageField.setHighlightInfo(0, message.length());
        this.hitFields.get(0).add(messageField);
        this.transcriptionName = "/ERROR";
        this.transcriptionURL = "http://localhost/ERROR";
        this.transcriptionPID = null;
        this.transcriptionNodeId = "MPI999999999#";
        this.refreshTimes();
    }

    public void refreshTimes() {
        this.beginTime = Integer.MAX_VALUE;
        this.endTime = Integer.MIN_VALUE;
        for (List<HitField> layer : this.hitFields) {
            for (HitField field : layer) {
                if (field == null) continue;
                if (field.beginTime < this.beginTime) {
                    this.beginTime = field.beginTime;
                }
                if (field.endTime <= this.endTime) continue;
                this.endTime = field.endTime;
            }
        }
    }

    public HitField getFirstField() {
        for (List<HitField> layer : this.hitFields) {
            for (HitField field : layer) {
                if (field == null) continue;
                return field;
            }
        }
        return null;
    }
}

