/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class SearchLayer {
    private static Logger _logger = Logger.getLogger("Searchlib.SearchLayer");
    private static final int INITIAL_HIT_LIST_SIZE = 4096;
    private static final boolean AGGRESSIVE_HEAP_USAGE = false;
    private static final double MAX_HEAP_LOAD_RATIO = 0.125;
    private static final long RESERVED_HEAP_SIZE = 0x10000000L;
    private int _hitListSize = 4096;
    private boolean _patternsLocked = false;
    private boolean _memoryExhausted = false;
    private boolean isEmpty = true;
    private ArrayList<String> patterns = new ArrayList();
    private ArrayList<Boolean> patternsNOTMode = new ArrayList();
    private ArrayList<Pattern> regExpPatterns = new ArrayList();
    private ArrayList<String[]> modes = new ArrayList();
    private ArrayList<String> innerConstraints = new ArrayList();
    private ArrayList<String> outerConstraints;
    private ArrayList<String> tierConstraints = new ArrayList();
    private ArrayList<int[]> hitAnnIdsForPattern;
    private ArrayList<short[]> hitNumbersForPattern;
    private int[] hitFileIds;
    private String tierIdsInLayerDomain = "";
    private ArrayList<int[]> hitTierIdsForPattern;

    public SearchLayer() {
        this.outerConstraints = new ArrayList();
        this.hitAnnIdsForPattern = new ArrayList();
        this.hitNumbersForPattern = new ArrayList();
        this.hitTierIdsForPattern = new ArrayList();
    }

    public synchronized void addPattern(String pattern, String mode, String innerConstraint, String outerConstraint) {
        if (this._patternsLocked) {
            throw new IllegalStateException("Attempt to extend query while search is already in progress!");
        }
        boolean notMode = false;
        while (SearchLayer.isNOTPattern(pattern)) {
            notMode = !notMode;
            pattern = SearchLayer.stripNOTPattern(pattern);
        }
        this.patterns.add(pattern);
        this.patternsNOTMode.add(notMode);
        if (pattern.length() > 0) {
            block10: {
                this.isEmpty = false;
                String[] queryModes = mode.split("xxxMODE_SPLITTERxxx");
                this.modes.add(queryModes);
                if (queryModes[2].equals(" regular expression")) {
                    try {
                        if (queryModes[1].equals(" case sensitive")) {
                            this.regExpPatterns.add(Pattern.compile(pattern));
                            break block10;
                        }
                        this.regExpPatterns.add(Pattern.compile(pattern, 2));
                    }
                    catch (RuntimeException re) {
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, "Invalid regular expression in addPattern: '" + pattern + "' Error: " + re);
                        }
                        pattern = "INVALID REGULAR EXPRESSION";
                        this.regExpPatterns.add(Pattern.compile(pattern));
                    }
                } else {
                    this.regExpPatterns.add(null);
                }
            }
            this.hitAnnIdsForPattern.add(new int[this._hitListSize]);
            this.hitNumbersForPattern.add(new short[this._hitListSize]);
            this.hitTierIdsForPattern.add(new int[this._hitListSize]);
        } else {
            this.modes.add(null);
            this.regExpPatterns.add(null);
            this.hitAnnIdsForPattern.add(null);
            this.hitNumbersForPattern.add(null);
            this.hitTierIdsForPattern.add(null);
        }
        this.innerConstraints.add(innerConstraint);
        this.outerConstraints.add(outerConstraint);
    }

    public void addTierConstraint(String constraint) {
        this.tierConstraints.add(constraint);
    }

    public int getNumberOfPatterns() {
        return this.patterns.size();
    }

    public String getPattern(int i) {
        return this.patterns.get(i);
    }

    public boolean getPatternNOTMode(int i) {
        return this.patternsNOTMode.get(i);
    }

    public Pattern getRegExpPattern(int i) {
        return this.regExpPatterns.get(i);
    }

    public String[] getMode(int i) {
        return this.modes.get(i);
    }

    public String getInnerConstraint(int i) {
        return this.innerConstraints.get(i);
    }

    public ArrayList<String> getTierConstraints() {
        return this.tierConstraints;
    }

    public void setTierIdsInLayerDomain(String tierIds) {
        this.tierIdsInLayerDomain = tierIds;
    }

    public String getTierIdsInLayerDomain() {
        return this.tierIdsInLayerDomain;
    }

    public String getOuterConstraint(int i) {
        return this.outerConstraints.get(i);
    }

    public int getHitAnnIdForPattern(int patternIndex, int hitIndex) {
        if (this.hitAnnIdsForPattern.get(patternIndex) != null && hitIndex < this.hitAnnIdsForPattern.get(patternIndex).length) {
            return this.hitAnnIdsForPattern.get(patternIndex)[hitIndex];
        }
        return -1;
    }

    public void setHitAnnIdForPattern(int patternIndex, int hitIndex, int annID) {
        if (this.hitAnnIdsForPattern.get(patternIndex) != null && this.ensureCapacity(hitIndex + 1)) {
            this.hitAnnIdsForPattern.get((int)patternIndex)[hitIndex] = annID;
        }
    }

    public void setHitNumberForPattern(int patternIndex, int hitIndex, int hitNumber) {
        if (hitNumber <= Short.MAX_VALUE && hitNumber > 0) {
            if (this.ensureCapacity(hitIndex + 1)) {
                this.hitNumbersForPattern.get((int)patternIndex)[hitIndex] = (short)hitNumber;
            }
        } else {
            throw new IllegalArgumentException("setHitNumberForPattern(patternIndex=" + patternIndex + ", hitIndex=" + hitIndex + ", hitNumber=" + hitNumber + ") only allows hitNumbers 1..32767");
        }
    }

    public int getHitNumberForPattern(int patternIndex, int hitIndex) {
        if (this.hitNumbersForPattern.get(patternIndex) != null && hitIndex < this.hitNumbersForPattern.get(patternIndex).length) {
            return this.hitNumbersForPattern.get(patternIndex)[hitIndex];
        }
        return -1;
    }

    public void setHitFileId(int hitIndex, int fileIndex) {
        if (this.hitFileIds == null && fileIndex != -1) {
            this.hitFileIds = new int[this._hitListSize];
        }
        if (this.hitFileIds != null && this.ensureCapacity(hitIndex + 1)) {
            this.hitFileIds[hitIndex] = fileIndex;
        }
    }

    public int getHitFileId(int hitIndex) {
        if (this.hitFileIds != null && hitIndex < this.hitFileIds.length) {
            return this.hitFileIds[hitIndex];
        }
        return -1;
    }

    public int getHitTierIdForPattern(int patternIndex, int hitIndex) {
        if (this.hitTierIdsForPattern.get(patternIndex) != null && hitIndex < this.hitTierIdsForPattern.get(patternIndex).length) {
            return this.hitTierIdsForPattern.get(patternIndex)[hitIndex];
        }
        return -1;
    }

    public void setHitTierIdForPattern(int patternIndex, int hitIndex, int tierID) {
        if (this.hitTierIdsForPattern.get(patternIndex) != null && this.ensureCapacity(hitIndex + 1)) {
            this.hitTierIdsForPattern.get((int)patternIndex)[hitIndex] = tierID;
        }
    }

    public int getIndexOfFirstNonEmptyPattern() {
        for (int i = 0; i < this.patterns.size(); ++i) {
            if (this.patterns.get(i).length() <= 0) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public static boolean isNOTPattern(String pattern) {
        return pattern.trim().startsWith("NOT(") && pattern.trim().endsWith(")");
    }

    public static String stripNOTPattern(String pattern) {
        if (!SearchLayer.isNOTPattern(pattern)) {
            return pattern;
        }
        return pattern.trim().substring(4, pattern.length() - 1).trim();
    }

    public String display() {
        StringBuilder dump = new StringBuilder("\tPatterns and inner constraints: ");
        if (this.isEmpty()) {
            dump.append("[EMPTY LAYER]");
        } else {
            dump.append("First non-empty pattern: ").append(this.getIndexOfFirstNonEmptyPattern());
        }
        dump.append("\r\n");
        for (int j = 0; j < this.getNumberOfPatterns(); ++j) {
            if (this.patterns.get(j).length() > 0) {
                String mtarget = this.getMode(j)[0];
                String mcase = this.getMode(j)[1];
                String mmatch = this.getMode(j)[2];
                boolean not = this.getPatternNOTMode(j);
                dump.append("\t\t#").append(j).append(" |");
                dump.append(not ? " [NOT] " : "").append(this.patterns.get(j)).append("| as ");
                dump.append(mtarget).append(" ").append(mcase).append(" ").append(mmatch);
                dump.append("\r\n");
                dump.append("\t\t\tinner: ").append(this.getInnerConstraint(j)).append("\r\n");
                dump.append("\t\t\touter: ").append(this.getOuterConstraint(j)).append("\r\n");
                continue;
            }
            dump.append("\t\t#").append(j).append(" |[EMPTY]|").append("\r\n");
        }
        ArrayList<String> tc = this.getTierConstraints();
        if (tc.size() > 0) {
            dump.append("\tTier constraints: ").append("\r\n");
        }
        for (String constraint : tc) {
            dump.append("\t\t").append(constraint).append("\r\n");
        }
        dump.append("\tTierIdsInLayerDomain: ").append(this.getTierIdsInLayerDomain()).append("\r\n");
        return dump.toString();
    }

    private synchronized boolean ensureCapacity(int size) {
        Object[] larger;
        int i;
        int largerSize;
        this._patternsLocked = true;
        if (size <= this._hitListSize) {
            return true;
        }
        for (largerSize = this._hitListSize; largerSize < size; largerSize *= 2) {
        }
        if (largerSize > 0x100000) {
            if (this._memoryExhausted) {
                return false;
            }
            int factor = 4 * this.hitAnnIdsForPattern.size() + 2 * this.hitNumbersForPattern.size() + 2;
            long needed = factor * largerSize;
            long freeMemory = Runtime.getRuntime().freeMemory();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Free heap: " + freeMemory + " bytes, desired list size: " + needed + " bytes for " + largerSize + " items, reserved: 268435456 bytes, fraction: 0.125 Proceed: " + ((double)needed <= 0.125 * (double)(freeMemory - 0x10000000L)));
            }
            if ((double)needed > 0.125 * (double)(freeMemory - 0x10000000L)) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "NOT growing hit list, size stays " + this._hitListSize + " items. Not enough heap free.");
                }
                this._memoryExhausted = true;
                return false;
            }
        }
        if (largerSize > 666666 && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Growing hit list to new size: " + largerSize + " Requested: " + size);
        }
        if (this.hitFileIds != null) {
            int[] larger2 = new int[largerSize];
            System.arraycopy(this.hitFileIds, 0, larger2, 0, this.hitFileIds.length);
            this.hitFileIds = larger2;
        }
        for (i = 0; i < this.hitAnnIdsForPattern.size(); ++i) {
            int[] old = this.hitAnnIdsForPattern.get(i);
            if (old == null) continue;
            larger = new int[largerSize];
            System.arraycopy(old, 0, larger, 0, old.length);
            this.hitAnnIdsForPattern.set(i, (int[])larger);
        }
        for (i = 0; i < this.hitNumbersForPattern.size(); ++i) {
            short[] old = this.hitNumbersForPattern.get(i);
            if (old == null) continue;
            larger = new short[largerSize];
            System.arraycopy(old, 0, larger, 0, old.length);
            this.hitNumbersForPattern.set(i, (short[])larger);
        }
        this._hitListSize = largerSize;
        return true;
    }
}

