/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.mpi.annot.search.lib.FrequencyInfo;
import nl.mpi.annot.search.lib.FrequencyInfoTools;
import nl.mpi.annot.search.lib.HitField;
import nl.mpi.annot.search.lib.SearchHit;
import nl.mpi.annot.search.lib.SearchLayer;
import nl.mpi.annot.search.lib.SearchStatistics;
import nl.mpi.annot.tools.util.UnicodeNormalizer;

public abstract class SearchQuery {
    private static Logger _logger = Logger.getLogger("Searchlib.SearchQuery");
    protected final String schemaName;
    protected ArrayList<FrequencyInfo> orderedFrequencyInfoByAnnotation = new ArrayList();
    protected ArrayList<FrequencyInfo> orderedFrequencyInfoByFrequency = new ArrayList();
    protected HashMap<String, FrequencyInfo> frequencyMap = new HashMap();
    protected SearchStatistics statistics = new SearchStatistics();
    protected boolean patternNeedsFullStatistics;
    protected int firstNonEmptyLayerIndex;
    protected int firstNonEmptyPatternIndex;
    protected boolean isSimpleQuery;
    protected boolean isMultipleLayerQuery;
    protected boolean isExecuting;
    protected boolean keepExecuting;
    protected int nGramSizeLeftFromHit;
    protected int nGramSizeRightFromHit;
    protected int nLayers;
    protected int nPatternsPerLayer;
    protected SearchLayer[] searchLayers;
    protected int[][] globalHitAnnId;
    protected int[][] globalHitTierId;
    protected int[][] globalHitPosition;
    protected long[][] globalHitBeginTime;
    protected long[][] globalHitEndTime;
    protected int globalHitFileId = -1;
    private final ReentrantLock hitResetLock = new ReentrantLock();
    protected final int ANN_ID_SHIFT = 10;
    private PreparedStatement _prepStatComplexHitResultData;
    private long _minimalDuration = 0L;
    private long _maximalDuration = 0L;
    private long _beginAfter = 0L;
    private long _endBefore = 0L;
    protected String fullTranscriptionTierDomain;
    protected boolean thereIsALayerWithAnEmptyTierDomain;

    public SearchQuery(Integer index) {
        this.schemaName = "search" + (index == null ? "" : index.toString());
    }

    public void setSimpleQuery(String pattern, String matchScope, boolean caseInsensitive, String matchMode, ArrayList<String> tierConstraints) {
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("Pattern must not be empty");
        }
        if (!(" Annotation".equals(matchScope) || " N-gram over annotations".equals(matchScope) || " N-gram within annotation".equals(matchScope))) {
            throw new IllegalArgumentException("Invalid matchScope");
        }
        if (!(" exact match".equals(matchMode) || " substring match".equals(matchMode) || " regular expression".equals(matchMode))) {
            throw new IllegalArgumentException("Invalid matchMode");
        }
        this.setQueryMatrixDimensions(1, 1);
        this.isMultipleLayerQuery = false;
        this.isSimpleQuery = true;
        String normalized = UnicodeNormalizer.normalizeToNFC((String)pattern, (String)" in setSimpleQuery");
        String denormalized = UnicodeNormalizer.checkNFC((String)normalized);
        if (denormalized != null || !normalized.equals(pattern)) {
            if (denormalized != null && _logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "Could not normalize simple pattern: " + denormalized);
            }
            pattern = normalized;
        }
        String mode = matchScope + "xxxMODE_SPLITTERxxx" + (caseInsensitive ? " case insensitive" : " case sensitive") + "xxxMODE_SPLITTERxxx" + matchMode;
        this.searchLayers[0].addPattern(pattern, mode, "cns none", "cns none");
        this.firstNonEmptyLayerIndex = 0;
        this.firstNonEmptyPatternIndex = 0;
        if (tierConstraints != null && !tierConstraints.contains(" All Tiers ")) {
            for (String tierConstraint : tierConstraints) {
                this.searchLayers[0].addTierConstraint(tierConstraint);
            }
        }
    }

    public void setGlobalTimeConstraints(long minDuration, long maxDuration, long minStart, long maxEnd) {
        this._minimalDuration = minDuration;
        this._maximalDuration = maxDuration;
        this._beginAfter = minStart;
        this._endBefore = maxEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setQueryMatrixDimensions(int layers, int patterns) {
        this.hitResetLock.lock();
        try {
            this.firstNonEmptyLayerIndex = -1;
            this.firstNonEmptyPatternIndex = -1;
            this._prepStatComplexHitResultData = null;
            this.nLayers = layers;
            this.nPatternsPerLayer = patterns;
            this.searchLayers = new SearchLayer[layers];
            for (int i = 0; i < layers; ++i) {
                this.searchLayers[i] = new SearchLayer();
            }
            this.globalHitAnnId = new int[layers][patterns];
            this.globalHitTierId = new int[layers][patterns];
            this.globalHitPosition = new int[layers][patterns];
            this.globalHitBeginTime = new long[layers][patterns];
            this.globalHitEndTime = new long[layers][patterns];
        }
        finally {
            this.hitResetLock.unlock();
        }
    }

    public static long getValue(ResultSet rs, int column) throws SQLException {
        if (rs.getMetaData().getColumnType(column) == -5) {
            return rs.getLong(column);
        }
        return rs.getInt(column);
    }

    public static ArrayList<String> getSearchModes() {
        ArrayList<String> modes = new ArrayList<String>();
        String[] targetModes = " Annotation; N-gram over annotations; N-gram within annotation".split(";");
        String[] caseModes = " case insensitive; case sensitive".split(";");
        String[] matchModes = " substring match; exact match; regular expression; variable match".split(";");
        String[] interTierConstraintModes = " Must be in same file; Must be parent and child; Must have same parent; Must have same participant; Must have same annotator; Must have same type".split(";");
        modes.add(Integer.toString(targetModes.length));
        Collections.addAll(modes, targetModes);
        modes.add(Integer.toString(caseModes.length));
        Collections.addAll(modes, caseModes);
        modes.add(Integer.toString(matchModes.length));
        Collections.addAll(modes, matchModes);
        modes.add(Integer.toString(interTierConstraintModes.length));
        Collections.addAll(modes, interTierConstraintModes);
        return modes;
    }

    public void createLayers(String encodedQuery) {
        int i;
        String[] queryParts = encodedQuery.split("xxxSAFE_SPLITTERxxx");
        int partIndex = 0;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "createLayers: " + encodedQuery);
        }
        String[] header = queryParts[partIndex++].split(",");
        this.setGlobalTimeConstraints(Long.parseLong(header[0].trim()), Long.parseLong(header[1].trim()), Long.parseLong(header[2].trim()), Long.parseLong(header[3].trim()));
        this.setQueryMatrixDimensions(Integer.parseInt(header[4].trim()), Integer.parseInt(header[5].trim()));
        int nPatterns = 0;
        for (int i2 = 0; i2 < this.nLayers; ++i2) {
            this.searchLayers[i2] = new SearchLayer();
            for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                String pattern;
                if ((pattern = queryParts[partIndex++]).length() > 0) {
                    ++nPatterns;
                }
                String mode = queryParts[partIndex++];
                String innerConstraint = queryParts[partIndex++];
                String outerConstraint = queryParts[partIndex++];
                String normalized = UnicodeNormalizer.normalizeToNFC((String)pattern, (String)(" in createLayers, " + (i2 + 1) + ". layer, " + (j + 1) + ". pattern"));
                String denormalized = UnicodeNormalizer.checkNFC((String)normalized);
                if (denormalized != null || !normalized.equals(pattern)) {
                    if (denormalized != null && _logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.WARNING, "Could not normalize query pattern: " + denormalized);
                    }
                    pattern = normalized;
                }
                this.searchLayers[i2].addPattern(pattern, mode, innerConstraint, outerConstraint);
                if (this.firstNonEmptyPatternIndex >= 0 || pattern.length() <= 0) continue;
                this.firstNonEmptyLayerIndex = i2;
                this.firstNonEmptyPatternIndex = j;
            }
            int nTiers = Integer.parseInt(header[i2 + 6].trim());
            for (int j = 0; j < nTiers; ++j) {
                this.searchLayers[i2].addTierConstraint(queryParts[partIndex++]);
            }
        }
        int nNonEmptyLayers = 0;
        for (i = 0; i < this.nLayers; ++i) {
            if (this.searchLayers[i].isEmpty()) continue;
            ++nNonEmptyLayers;
        }
        this.isMultipleLayerQuery = nNonEmptyLayers > 1;
        boolean bl = this.isSimpleQuery = nPatterns <= 1;
        if (_logger.isLoggable(Level.FINE)) {
            for (i = 0; i < this.nLayers; ++i) {
                _logger.log(Level.FINE, "\nLayer " + i + " of " + this.nLayers);
                _logger.log(Level.FINE, this.searchLayers[i].display().trim());
            }
        }
    }

    public boolean isRunning() {
        return this.isExecuting;
    }

    public SearchStatistics getSearchStatistics() {
        this.statistics.nFrequencyInfoItems = this.frequencyMap.size();
        return this.statistics;
    }

    protected void clearFrequencyStatistics() {
        this.frequencyMap.clear();
        this.orderedFrequencyInfoByAnnotation.clear();
        this.orderedFrequencyInfoByFrequency.clear();
    }

    protected void updateFrequencyStatistics(String annotation, int annId, int fileIndex, int layerIndex, int patternIndex) {
        FrequencyInfoTools.updateFrequencyStatistics(this.frequencyMap, annotation, annId, fileIndex, layerIndex, patternIndex);
    }

    public ArrayList<FrequencyInfo> getFrequencyInfo(int from, int count, boolean sortByFreq) {
        ArrayList<FrequencyInfo> info = FrequencyInfoTools.getFrequencyInfo(this.frequencyMap, this.orderedFrequencyInfoByAnnotation, this.orderedFrequencyInfoByFrequency, from, count, sortByFreq);
        if (this.frequencyMap.size() >= 100000) {
            return info;
        }
        int mapSize = this.frequencyMap.size();
        for (FrequencyInfo freqInfo : info) {
            freqInfo.nOccurences = mapSize;
            if (freqInfo.hitPositionInAnnotation != 0 || freqInfo.hitLength != 0) continue;
            String[] queryModes = this.searchLayers[freqInfo.layerIndex].getMode(freqInfo.patternIndex);
            String pattern = this.searchLayers[freqInfo.layerIndex].getPattern(freqInfo.patternIndex);
            boolean patternNOTMode = this.searchLayers[freqInfo.layerIndex].getPatternNOTMode(freqInfo.patternIndex);
            Pattern regExpPattern = this.searchLayers[freqInfo.layerIndex].getRegExpPattern(freqInfo.patternIndex);
            if (queryModes[0].equals(" Annotation") && this.isSimpleQuery) {
                freqInfo.hitPositionInAnnotation = this.getHitPosition(freqInfo.annotation, 1, queryModes, pattern, regExpPattern, patternNOTMode);
                freqInfo.hitLength = this.getHitLength(freqInfo.annotation, 1, queryModes, pattern, regExpPattern, patternNOTMode);
                continue;
            }
            freqInfo.hitPositionInAnnotation = 0;
            freqInfo.hitLength = 0;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void investigateComplexPattern(int layerIndex, int patternIndex, Connection con, boolean logLayerq, HashMap<String, String> variableMap) throws SQLException {
        Statement statement = null;
        ResultSet rs = null;
        int variableLogCount = 0;
        try {
            Object queryString;
            statement = con.createStatement();
            if (statement.getMaxRows() == 0 || statement.getMaxRows() > 500) {
                statement.setFetchSize(500);
            } else {
                statement.setFetchSize(statement.getMaxRows() - 1);
            }
            do {
                if (patternIndex + 1 < this.nPatternsPerLayer) {
                    ++patternIndex;
                } else {
                    ++layerIndex;
                    patternIndex = 0;
                }
                if (layerIndex < this.nLayers) continue;
                if (!this.isDurationInRange(this.getGlobalHitDuration())) {
                    return;
                }
                for (int i = 0; i < this.nLayers; ++i) {
                    boolean layerHasHit = false;
                    for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                        if (this.globalHitAnnId[i][j] < -1) {
                            this.searchLayers[i].setHitAnnIdForPattern(j, this.statistics.nHits, this.globalHitAnnId[i][j]);
                            this.searchLayers[i].setHitTierIdForPattern(j, this.statistics.nHits, this.globalHitTierId[i][j]);
                            layerHasHit = true;
                            continue;
                        }
                        if (this.globalHitAnnId[i][j] == -1) continue;
                        this.searchLayers[i].setHitAnnIdForPattern(j, this.statistics.nHits, this.globalHitAnnId[i][j]);
                        layerHasHit = true;
                    }
                    if (!layerHasHit) continue;
                    this.searchLayers[i].setHitFileId(this.statistics.nHits, this.globalHitFileId);
                }
                String frequencyString = this.constructComplexHitString(con, statement, this.globalHitAnnId, this.globalHitTierId);
                int annId = this.globalHitAnnId[this.firstNonEmptyLayerIndex][this.firstNonEmptyPatternIndex];
                int fileId = this.globalHitFileId;
                this.updateFrequencyStatistics(frequencyString, annId, fileId, this.firstNonEmptyLayerIndex, this.firstNonEmptyPatternIndex);
                ++this.statistics.nHits;
                ++this.statistics.nAnnotationsWithHit;
                return;
            } while (this.searchLayers[layerIndex].getPattern(patternIndex).length() == 0);
            String pattern = this.searchLayers[layerIndex].getPattern(patternIndex);
            boolean patternNOTMode = this.searchLayers[layerIndex].getPatternNOTMode(patternIndex);
            Pattern regExpPattern = this.searchLayers[layerIndex].getRegExpPattern(patternIndex);
            String[] queryModes = this.searchLayers[layerIndex].getMode(patternIndex);
            boolean variableMatchMode = " variable match".equals(queryModes[2]);
            String fullVariableName = pattern + queryModes[1];
            boolean gatherVariableValue = false;
            if (variableMatchMode && variableMap == null) {
                variableMap = new HashMap();
            }
            boolean noAnnotationMode = false;
            if (layerIndex > 0 && this.searchLayers[layerIndex - 1].getOuterConstraint(patternIndex).equals("cns no annotation")) {
                noAnnotationMode = true;
            }
            if (variableMatchMode && !variableMap.containsKey(fullVariableName)) {
                gatherVariableValue = true;
                queryString = "SELECT ann_id, ann_tier_id, ann_position, begin_time, end_time, annotation FROM " + this.schemaName + ".annotations WHERE ";
            } else {
                queryString = "SELECT ann_id, ann_tier_id, ann_position, begin_time, end_time FROM " + this.schemaName + ".annotations WHERE ";
                if (variableMatchMode) {
                    pattern = variableMap.get(fullVariableName);
                    String[] matchedQueryModes = new String[]{queryModes[0], queryModes[1], " exact match"};
                    queryModes = matchedQueryModes;
                }
            }
            if (noAnnotationMode) {
                queryString = String.format("SELECT COUNT(%s.annotations.ann_id), %s.tiers.n_annotations, %s.tiers.tier_id, %s.annotations.ann_tier_id FROM %s.annotations ", this.schemaName, this.schemaName, this.schemaName, this.schemaName, this.schemaName);
                queryString = (String)queryString + String.format(" INNER JOIN %s.tiers ON %s.annotations.ann_tier_id=%s.tiers.tier_id WHERE", this.schemaName, this.schemaName, this.schemaName);
            }
            if (!noAnnotationMode) {
                queryString = (String)queryString + this.createQueryPatternPart(pattern, queryModes, regExpPattern, patternNOTMode);
            }
            if (patternIndex > 0 && this.searchLayers[layerIndex].getPattern(patternIndex - 1).length() > 0) {
                queryString = (String)queryString + this.createHorizontalConstraintPart(layerIndex, patternIndex);
            }
            if (layerIndex > 0 && this.searchLayers[layerIndex - 1].getPattern(patternIndex).length() > 0) {
                queryString = (String)queryString + this.createVerticalConstraintPart(layerIndex, patternIndex);
            }
            queryString = (String)queryString + this.createTierConstraintPart(layerIndex, patternIndex);
            queryString = (String)queryString + this.createGlobalTimeConstraintPart();
            queryString = this.convertRegexpPatternsIfNeeded((String)queryString);
            if (noAnnotationMode) {
                queryString = (String)queryString + String.format(" GROUP BY %s.annotations.ann_tier_id, %s.tiers.tier_id, %s.tiers.n_annotations", this.schemaName, this.schemaName, this.schemaName);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "no ann query: " + (String)queryString);
                }
            }
            if (logLayerq && !variableMatchMode) {
                String hint = "[" + (layerIndex + 1) + "/" + this.nLayers + "][" + (patternIndex + 1) + "/" + this.nPatternsPerLayer + "] ";
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.log(Level.INFO, "layerq: " + hint + (String)queryString);
                }
            }
            logLayerq = true;
            rs = statement.executeQuery((String)queryString);
            if (noAnnotationMode) {
                while (rs.next()) {
                    int numAnn = rs.getInt(1);
                    int maxPos = rs.getInt(2);
                    int tierId = rs.getInt(3);
                    if (numAnn != maxPos) continue;
                    this.globalHitAnnId[layerIndex][patternIndex] = this.flipAnnotationId(this.globalHitAnnId[layerIndex - 1][patternIndex]);
                    this.globalHitTierId[layerIndex][patternIndex] = tierId;
                    this.globalHitPosition[layerIndex][patternIndex] = -1;
                    this.globalHitBeginTime[layerIndex][patternIndex] = this.globalHitBeginTime[layerIndex - 1][patternIndex];
                    this.globalHitEndTime[layerIndex][patternIndex] = this.globalHitEndTime[layerIndex - 1][patternIndex];
                    if (variableMatchMode) continue;
                    this.investigateComplexPattern(layerIndex, patternIndex, con, logLayerq, variableMap);
                }
            } else {
                while (rs.next()) {
                    int annId = rs.getInt(1);
                    int tierId = rs.getInt(2);
                    this.globalHitAnnId[layerIndex][patternIndex] = annId;
                    this.globalHitTierId[layerIndex][patternIndex] = tierId;
                    this.globalHitPosition[layerIndex][patternIndex] = rs.getInt(3);
                    this.globalHitBeginTime[layerIndex][patternIndex] = SearchQuery.getValue(rs, 4);
                    this.globalHitEndTime[layerIndex][patternIndex] = SearchQuery.getValue(rs, 5);
                    if (!variableMatchMode) {
                        this.investigateComplexPattern(layerIndex, patternIndex, con, logLayerq, variableMap);
                    } else if (!gatherVariableValue) {
                        if (logLayerq && variableLogCount < 10) {
                            String hint = "[" + (layerIndex + 1) + "/" + this.nLayers + "][" + (patternIndex + 1) + "/" + this.nPatternsPerLayer + "] ";
                            if (_logger.isLoggable(Level.INFO)) {
                                _logger.log(Level.INFO, "layerq: 1st VARIABLE_MATCH " + fullVariableName + "='" + pattern + "' " + hint + (String)queryString);
                            }
                            if (++variableLogCount >= 10 && _logger.isLoggable(Level.INFO)) {
                                _logger.log(Level.INFO, "layerq: First ten values shown. No further 1st VARIABLE_MATCH logging for this branch of the search tree.");
                            }
                        }
                        this.investigateComplexPattern(layerIndex, patternIndex, con, logLayerq, variableMap);
                    } else {
                        String annotationValue = rs.getString(6);
                        if (fullVariableName.startsWith("!")) {
                            boolean caseSensitive = fullVariableName.endsWith(" case sensitive");
                            if (caseSensitive) {
                                if (variableMap.containsValue(annotationValue)) {
                                    return;
                                }
                            } else {
                                for (String value : variableMap.values()) {
                                    if (!value.equalsIgnoreCase(annotationValue)) continue;
                                    return;
                                }
                            }
                        } else {
                            for (Map.Entry<String, String> item : variableMap.entrySet()) {
                                boolean caseSensitive;
                                String otherFullVariableName = item.getKey();
                                if (!otherFullVariableName.startsWith("!") || !((caseSensitive = otherFullVariableName.endsWith(" case sensitive")) ? item.getValue().equals(annotationValue) : item.getValue().equalsIgnoreCase(annotationValue))) continue;
                                return;
                            }
                        }
                        variableMap.put(fullVariableName, annotationValue);
                        this.investigateComplexPattern(layerIndex, patternIndex, con, logLayerq, variableMap);
                    }
                    logLayerq = false;
                }
            }
            rs.close();
            rs = null;
            statement.close();
            statement = null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle2) {
                    _logger.log(Level.SEVERE, "investigateComplexPattern: Finally close ResultSet failed: " + sqle2);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle2) {
                    _logger.log(Level.SEVERE, "investigateComplexPattern: Finally close Statement failed: " + sqle2);
                }
            }
        }
    }

    protected abstract String createQueryPatternPart(String var1, String[] var2, Pattern var3, boolean var4);

    protected abstract String convertRegexpPatternsIfNeeded(String var1);

    private int constraintParseInt(String constraint) {
        String[] parts = constraint.split(":");
        if (parts.length != 2) {
            return -1;
        }
        try {
            return Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    protected String createHorizontalConstraintPart(int layerIndex, int patternIndex) {
        Object queryPart = "";
        try {
            if (patternIndex <= 0 || this.globalHitAnnId[layerIndex][patternIndex - 1] == -1) {
                return "";
            }
            if (patternIndex - 1 >= 0 && this.searchLayers[layerIndex].getPattern(patternIndex - 1).equals("<void>")) {
                return "";
            }
            if (patternIndex < this.searchLayers[layerIndex].getNumberOfPatterns() && this.searchLayers[layerIndex].getPattern(patternIndex).equals("<void>")) {
                return "";
            }
            int relativePosition = this.globalHitPosition[layerIndex][patternIndex - 1];
            long relativeEndTime = this.globalHitEndTime[layerIndex][patternIndex - 1];
            String constraint = this.searchLayers[layerIndex].getInnerConstraint(patternIndex - 1);
            if (constraint.equals("cns none")) {
                queryPart = " AND ann_position > " + relativePosition;
            } else if (constraint.contains("cns an=:")) {
                int nAnnotations = this.constraintParseInt(constraint) + 1;
                queryPart = " AND ann_position = " + (relativePosition + nAnnotations);
            } else if (constraint.contains("cns an-:")) {
                int nAnnotations = this.constraintParseInt(constraint) + 1;
                queryPart = " AND ann_position < " + (relativePosition + nAnnotations) + " AND ann_position > " + relativePosition;
            } else if (constraint.contains("cns an+:")) {
                int nAnnotations = this.constraintParseInt(constraint) + 1;
                queryPart = " AND ann_position > " + (relativePosition + nAnnotations);
            } else if (constraint.contains("cns ms=:")) {
                int nMilliSeconds = this.constraintParseInt(constraint);
                queryPart = " AND begin_time = " + (relativeEndTime + (long)nMilliSeconds);
            } else if (constraint.contains("cns ms-:")) {
                int nMilliSeconds = this.constraintParseInt(constraint);
                queryPart = " AND begin_time < " + (relativeEndTime + (long)nMilliSeconds) + " AND begin_time >= " + relativeEndTime;
            } else if (constraint.contains("cns ms+:")) {
                int nMilliSeconds = this.constraintParseInt(constraint);
                queryPart = " AND begin_time > " + (relativeEndTime + (long)nMilliSeconds);
            } else if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "createHorizontalConstraintPart: Unknown constraint ignored: " + constraint);
            }
        }
        catch (RuntimeException re) {
            _logger.log(Level.SEVERE, "createHorizontalConstraintPart: RuntimeException: " + re, re);
        }
        return queryPart;
    }

    protected String createVerticalConstraintPart(int layerIndex, int patternIndex) {
        Object queryPart = "";
        try {
            if (layerIndex <= 0 || this.globalHitAnnId[layerIndex - 1][patternIndex] == -1) {
                return "";
            }
            String constraint = this.searchLayers[layerIndex - 1].getOuterConstraint(patternIndex);
            if (constraint.equals("cns none")) {
                return "";
            }
            long relativeBeginTime = this.globalHitBeginTime[layerIndex - 1][patternIndex];
            long relativeEndTime = this.globalHitEndTime[layerIndex - 1][patternIndex];
            if (!constraint.equals("cns none")) {
                if (constraint.equals("cns aligned")) {
                    queryPart = " AND begin_time = " + relativeBeginTime + " AND end_time = " + relativeEndTime;
                } else if (constraint.equals("cns overlap")) {
                    queryPart = " AND end_time > " + relativeBeginTime + " AND begin_time < " + relativeEndTime;
                } else if (constraint.equals("cns l overlap")) {
                    queryPart = " AND begin_time <= " + relativeBeginTime + " AND end_time > " + relativeBeginTime + " AND end_time <= " + relativeEndTime;
                } else if (constraint.equals("cns r overlap")) {
                    queryPart = " AND begin_time < " + relativeEndTime + " AND end_time >= " + relativeEndTime + " AND begin_time >= " + relativeBeginTime;
                } else if (constraint.equals("cns surrounding")) {
                    queryPart = " AND begin_time <= " + relativeBeginTime + " AND end_time >= " + relativeEndTime;
                } else if (constraint.equals("cns within")) {
                    queryPart = " AND begin_time >= " + relativeBeginTime + " AND end_time <= " + relativeEndTime;
                } else if (constraint.equals("cns no overlap")) {
                    queryPart = " AND (end_time <= " + relativeBeginTime + " OR begin_time >= " + relativeEndTime + ")";
                } else if (constraint.equals("cns no annotation")) {
                    queryPart = " (end_time <= " + relativeBeginTime + " OR begin_time >= " + relativeEndTime + ")";
                } else if (constraint.contains("cns bb=:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time = " + (relativeBeginTime + (long)nMilliSeconds);
                } else if (constraint.contains("cns bb-:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time < " + (relativeBeginTime + (long)nMilliSeconds) + " AND begin_time >= " + relativeBeginTime;
                } else if (constraint.contains("cns bb+:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time > " + (relativeBeginTime + (long)nMilliSeconds);
                } else if (constraint.contains("cns be=:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time = " + (relativeEndTime + (long)nMilliSeconds);
                } else if (constraint.contains("cns be-:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time < " + (relativeEndTime + (long)nMilliSeconds) + " AND begin_time >= " + relativeEndTime;
                } else if (constraint.contains("cns be+:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time > " + (relativeEndTime + (long)nMilliSeconds);
                } else if (constraint.contains("cns eb=:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time = " + (relativeBeginTime + (long)nMilliSeconds);
                } else if (constraint.contains("cns eb-:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time < " + (relativeBeginTime + (long)nMilliSeconds) + " AND end_time >= " + relativeBeginTime;
                } else if (constraint.contains("cns eb+:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time > " + (relativeBeginTime + (long)nMilliSeconds);
                } else if (constraint.contains("cns ee=:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time = " + (relativeEndTime + (long)nMilliSeconds);
                } else if (constraint.contains("cns ee-:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time < " + (relativeEndTime + (long)nMilliSeconds) + " AND end_time >= " + relativeEndTime;
                } else if (constraint.contains("cns ee+:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time > " + (relativeEndTime + (long)nMilliSeconds);
                } else if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "createVerticalConstraintPart: Unknown constraint ignored: " + constraint);
                }
            }
        }
        catch (RuntimeException re) {
            _logger.log(Level.SEVERE, "createVerticalConstraintPart: RuntimeException: " + re, re);
        }
        return queryPart;
    }

    protected String createTierConstraintPart(int layerIndex, int patternIndex) {
        if (patternIndex > 0 && this.globalHitTierId[layerIndex][patternIndex - 1] != -1) {
            return " AND ann_tier_id = " + this.globalHitTierId[layerIndex][patternIndex - 1];
        }
        StringBuilder queryPart = new StringBuilder(128);
        String layerDomain = this.searchLayers[layerIndex].getTierIdsInLayerDomain();
        if (layerDomain != null) {
            queryPart.append(layerDomain);
        }
        ArrayList<String> tierConstraints = this.searchLayers[layerIndex].getTierConstraints();
        int parentTierId = -1;
        if (layerIndex > 0) {
            for (int i = 0; i < this.nPatternsPerLayer; ++i) {
                if (this.globalHitTierId[layerIndex - 1][i] == -1) continue;
                parentTierId = this.globalHitTierId[layerIndex - 1][i];
            }
        }
        if (tierConstraints.contains(" Must be parent and child")) {
            queryPart.append(" AND ann_tier_id IN ( SELECT tier_id FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE ref_tier_id = ");
            queryPart.append(parentTierId).append(" )");
            if (tierConstraints.contains(" Must have same parent")) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "createTierConstraintPart: Constraints ' Must be parent and child' and ' Must have same parent' cannot be met at the same time, result set will be empty.");
                }
                return " AND false";
            }
        }
        if (tierConstraints.contains(" Must have same parent")) {
            queryPart.append(" AND ann_tier_id IN ( SELECT tier_id FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE ref_tier_id = ");
            queryPart.append(" ( SELECT ref_tier_id FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE tier_id = ");
            queryPart.append(parentTierId).append(" ) AND node_id = ");
            queryPart.append(" ( SELECT node_id FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE tier_id = ");
            queryPart.append(parentTierId).append(" ) ");
            queryPart.append(" ) ");
        }
        if (tierConstraints.contains(" Must have same participant")) {
            queryPart.append(" AND ann_tier_id IN ( SELECT tier_id FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE participant = ");
            queryPart.append(" ( SELECT participant FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE tier_id = ");
            queryPart.append(parentTierId).append(" ) AND node_id = ");
            queryPart.append(" ( SELECT node_id FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE tier_id = ");
            queryPart.append(parentTierId).append(" ) ");
            queryPart.append(" ) ");
        }
        if (tierConstraints.contains(" Must have same annotator")) {
            queryPart.append(" AND ann_tier_id IN ( SELECT tier_id FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE coalesce(annotator,'') = ");
            queryPart.append(" ( SELECT coalesce(annotator,'') FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE tier_id = ");
            queryPart.append(parentTierId).append(" ) AND node_id = ");
            queryPart.append(" ( SELECT node_id FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE tier_id = ");
            queryPart.append(parentTierId).append(" ) ");
            queryPart.append(" ) ");
        }
        if (tierConstraints.contains(" Must have same type")) {
            queryPart.append(" AND ann_tier_id IN ( SELECT tier_id FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE tier_type = ");
            queryPart.append(" ( SELECT tier_type FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE tier_id = ");
            queryPart.append(parentTierId).append(" ) AND node_id = ");
            queryPart.append(" ( SELECT node_id FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE tier_id = ");
            queryPart.append(parentTierId).append(" ) ");
            queryPart.append(" ) ");
        }
        --layerIndex;
        while (layerIndex >= 0) {
            int lastForbiddenTierId = -1;
            for (int i = 0; i < this.nPatternsPerLayer; ++i) {
                int forbiddenTierId = this.globalHitTierId[layerIndex][i];
                if (forbiddenTierId == -1 || forbiddenTierId == lastForbiddenTierId) continue;
                if (lastForbiddenTierId != -1 && _logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "createTierConstraintPart: Layer has matches in multiple tiers?? Old: " + lastForbiddenTierId + " New: " + forbiddenTierId);
                }
                queryPart.append(" AND ann_tier_id != ").append(forbiddenTierId);
                lastForbiddenTierId = forbiddenTierId;
            }
            --layerIndex;
        }
        return queryPart.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setTierDomainForLayers(boolean defineFullTranscriptionTierDomain, Connection con, String currentNodeId) {
        this.fullTranscriptionTierDomain = "";
        this.thereIsALayerWithAnEmptyTierDomain = false;
        HashMap<String, TreeSet<Integer>> domainTierNames = new HashMap<String, TreeSet<Integer>>();
        HashMap<String, TreeSet<Integer>> domainTierTypes = new HashMap<String, TreeSet<Integer>>();
        HashMap<String, TreeSet<Integer>> domainTierParticipants = new HashMap<String, TreeSet<Integer>>();
        HashMap<String, TreeSet<Integer>> domainTierAnnotators = new HashMap<String, TreeSet<Integer>>();
        TreeSet<Integer> allTiers = new TreeSet<Integer>();
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            String queryString = "SELECT tier_id, tier_name, tier_type, participant, annotator FROM " + this.schemaName + ".tiers WHERE node_id = ?";
            ps = con.prepareStatement(queryString);
            if (ps.getMaxRows() == 0 || ps.getMaxRows() > 500) {
                ps.setFetchSize(500);
            } else {
                ps.setFetchSize(ps.getMaxRows() - 1);
            }
            ps.setString(1, currentNodeId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String tierAnnotator;
                String tierParticipant;
                String tierType;
                int domainTierId = rs.getInt(1);
                allTiers.add(domainTierId);
                String tierName = rs.getString(2);
                if (tierName != null) {
                    TreeSet<Integer> tnSet = (TreeSet<Integer>)domainTierNames.get(tierName = tierName.trim());
                    if (tnSet == null) {
                        tnSet = new TreeSet<Integer>();
                    }
                    tnSet.add(domainTierId);
                    domainTierNames.put(tierName, tnSet);
                }
                if ((tierType = rs.getString(3)) != null) {
                    TreeSet<Integer> ttSet = (TreeSet<Integer>)domainTierTypes.get(tierType = tierType.trim());
                    if (ttSet == null) {
                        ttSet = new TreeSet<Integer>();
                    }
                    ttSet.add(domainTierId);
                    domainTierTypes.put(tierType, ttSet);
                }
                if ((tierParticipant = rs.getString(4)) != null) {
                    TreeSet<Integer> tpSet = (TreeSet<Integer>)domainTierParticipants.get(tierParticipant = tierParticipant.trim());
                    if (tpSet == null) {
                        tpSet = new TreeSet<Integer>();
                    }
                    tpSet.add(domainTierId);
                    domainTierParticipants.put(tierParticipant, tpSet);
                }
                if ((tierAnnotator = rs.getString(5)) == null) continue;
                TreeSet<Integer> taSet = (TreeSet<Integer>)domainTierAnnotators.get(tierAnnotator = tierAnnotator.trim());
                if (taSet == null) {
                    taSet = new TreeSet<Integer>();
                }
                taSet.add(domainTierId);
                domainTierAnnotators.put(tierAnnotator, taSet);
            }
            rs.close();
            rs = null;
            ps.close();
            ps = null;
        }
        catch (SQLException sqle) {
            _logger.log(Level.SEVERE, "setTierDomainForLayers: SQLException: " + sqle, sqle);
            boolean domainTierId = true;
            return domainTierId;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e2) {
                    _logger.log(Level.SEVERE, "setTierDomainForLayers: Error closing ResultSet: " + e2);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e2) {
                    _logger.log(Level.SEVERE, "setTierDomainForLayers: Error closing PreparedStatement: " + e2);
                }
            }
        }
        String allTierDomain = this.makeInTierQuery(allTiers);
        if (allTiers.isEmpty()) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "setTierDomainForLayers: allTiers.isEmpty() for node " + currentNodeId);
            }
            this.fullTranscriptionTierDomain = " AND false ";
            this.thereIsALayerWithAnEmptyTierDomain = true;
        } else {
            this.fullTranscriptionTierDomain = defineFullTranscriptionTierDomain ? allTierDomain : "";
        }
        for (int l = 0; l < this.nLayers; ++l) {
            if (this.searchLayers[l].isEmpty()) continue;
            TreeMap<String, TreeSet<Integer>> layerTiersPerCategory = new TreeMap<String, TreeSet<Integer>>();
            boolean searchInAllTiers = false;
            ArrayList<String> tierConstraints = this.searchLayers[l].getTierConstraints();
            StringBuilder constraintExplain = new StringBuilder();
            for (int c = 0; c < tierConstraints.size(); ++c) {
                String constraint = tierConstraints.get(c);
                if (c > 0) {
                    constraintExplain.append(", ");
                }
                if (constraint.startsWith(" All Tiers ")) {
                    searchInAllTiers = true;
                    break;
                }
                if (constraint.equals(" Must be in same file") || constraint.equals(" Must be parent and child") || constraint.equals(" Must have same parent") || constraint.equals(" Must have same participant") || this.tierConstraintHelper(constraint, " Tier Name: ", "name", domainTierNames, constraintExplain, layerTiersPerCategory) || this.tierConstraintHelper(constraint, " Tier Type: ", "type", domainTierTypes, constraintExplain, layerTiersPerCategory) || this.tierConstraintHelper(constraint, " Participant: ", "participant", domainTierParticipants, constraintExplain, layerTiersPerCategory) || this.tierConstraintHelper(constraint, " Annotator: ", "annotator", domainTierAnnotators, constraintExplain, layerTiersPerCategory) || !_logger.isLoggable(Level.WARNING)) continue;
                _logger.log(Level.WARNING, "setTierDomainForLayers: Cannot parse constraint: '" + constraint + "'");
            }
            if (searchInAllTiers || layerTiersPerCategory.isEmpty()) {
                this.searchLayers[l].setTierIdsInLayerDomain(this.fullTranscriptionTierDomain);
                continue;
            }
            String firstCategory = (String)layerTiersPerCategory.firstKey();
            TreeSet layerTiers = (TreeSet)layerTiersPerCategory.get(firstCategory);
            layerTiersPerCategory.remove(firstCategory);
            while (!layerTiersPerCategory.isEmpty() && !layerTiers.isEmpty()) {
                String furtherCategory = (String)layerTiersPerCategory.firstKey();
                layerTiers.retainAll((Collection)layerTiersPerCategory.get(furtherCategory));
                layerTiersPerCategory.remove(furtherCategory);
            }
            if (layerTiers.isEmpty()) {
                this.searchLayers[l].setTierIdsInLayerDomain(" AND false ");
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "No tier satisfies constraints for node " + currentNodeId + ", query layer " + l + ": " + constraintExplain.toString());
                }
                this.thereIsALayerWithAnEmptyTierDomain = true;
                continue;
            }
            String foundDomain = this.makeInTierQuery(layerTiers);
            if (!allTierDomain.equals(foundDomain)) {
                this.searchLayers[l].setTierIdsInLayerDomain(foundDomain);
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "setTierDomainForLayers: Of " + allTiers.size() + " tiers, " + layerTiers.size() + " tiers match constraints: " + constraintExplain.toString());
                continue;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "setTierDomainForLayers: ALL tiers match constraints: " + constraintExplain.toString());
            }
            this.searchLayers[l].setTierIdsInLayerDomain(this.fullTranscriptionTierDomain);
        }
        return this.thereIsALayerWithAnEmptyTierDomain;
    }

    private boolean tierConstraintHelper(String constraint, String label, String category, HashMap<String, TreeSet<Integer>> tierSetThisCategory, StringBuilder constraintExplain, Map<String, TreeSet<Integer>> layerTiersPerCategory) {
        if (!constraint.startsWith(label)) {
            return false;
        }
        String constraintValue = constraint.substring(label.length());
        if (!layerTiersPerCategory.containsKey(category)) {
            layerTiersPerCategory.put(category, new TreeSet());
        }
        TreeSet<Integer> layerTiersThisCategory = layerTiersPerCategory.get(category);
        constraintExplain.append(category).append("='").append(constraintValue).append('\'');
        if (tierSetThisCategory.get(constraintValue) != null) {
            layerTiersThisCategory.addAll((Collection<Integer>)tierSetThisCategory.get(constraintValue));
        }
        return true;
    }

    private String makeInTierQuery(TreeSet<Integer> tiers) {
        if (tiers == null || tiers.isEmpty()) {
            return " AND false ";
        }
        if (tiers.size() == 1) {
            return " AND ( ann_tier_id = " + tiers.first() + " ) ";
        }
        StringBuilder inSet = new StringBuilder(" AND ann_tier_id IN ( " + tiers.first());
        Iterator<Integer> iter = tiers.iterator();
        iter.next();
        while (iter.hasNext()) {
            inSet.append(", ").append(iter.next());
        }
        inSet.append(" ) ");
        return inSet.toString();
    }

    protected void constructComplexHitResult(Connection con, Statement st, int[][] annIds, int[][] tierIds, SearchHit hit) {
        block14: {
            ResultSet rs = null;
            try {
                if (con != null && this._prepStatComplexHitResultData == null) {
                    String queryString = "SELECT annotation, ann_position, begin_time, end_time, ann_tier_id FROM " + this.schemaName + ".annotations WHERE ann_id = ?";
                    this._prepStatComplexHitResultData = con.prepareStatement(queryString, 1004, 1007);
                }
                hit.hitFields = new ArrayList<List<HitField>>();
                for (int i = 0; i < this.nLayers; ++i) {
                    ArrayList<HitField> hitFieldLayer = new ArrayList<HitField>();
                    for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                        int annId = annIds[i][j];
                        if (annId < -1) {
                            annId = this.flipAnnotationId(annId);
                        } else if (annId < 0) {
                            hitFieldLayer.add(null);
                            continue;
                        }
                        rs = null;
                        if (con != null) {
                            this._prepStatComplexHitResultData.setInt(1, annId);
                            rs = this._prepStatComplexHitResultData.executeQuery();
                        } else {
                            String queryString = "SELECT annotation, ann_position, begin_time, end_time, ann_tier_id FROM " + this.schemaName + ".annotations WHERE ann_id = " + annId;
                            rs = st.executeQuery(queryString);
                        }
                        rs.next();
                        String annotation = rs.getString(1);
                        int position = rs.getInt(2);
                        long beginTime = SearchQuery.getValue(rs, 3);
                        long endTime = SearchQuery.getValue(rs, 4);
                        int tierID = rs.getInt(5);
                        if (annIds[i][j] < -1) {
                            annotation = "<void>";
                            position = -1;
                            if (tierIds != null) {
                                tierID = tierIds[i][j];
                            }
                        }
                        HitField oneHitField = new HitField(annotation, beginTime, endTime, position, -1, tierID);
                        oneHitField.setHighlightInfo(0, annotation.length());
                        hitFieldLayer.add(oneHitField);
                        rs.close();
                        rs = null;
                    }
                    hit.hitFields.add(hitFieldLayer);
                }
            }
            catch (SQLException sqle) {
                _logger.log(Level.SEVERE, "constructComplexHitResult: SQLException: " + sqle, sqle);
                if (rs == null) break block14;
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        hit.refreshTimes();
    }

    protected String constructComplexHitString(Connection con, Statement st, int[][] annIds, int[][] tierIds) {
        StringBuilder hitString;
        block14: {
            hitString = new StringBuilder();
            ResultSet rs = null;
            try {
                if (con != null && this._prepStatComplexHitResultData == null) {
                    String queryString = "SELECT annotation FROM " + this.schemaName + ".annotations WHERE ann_id = ?";
                    this._prepStatComplexHitResultData = con.prepareStatement(queryString, 1004, 1007);
                }
                for (int i = 0; i < this.nLayers; ++i) {
                    hitString.append("  #").append(i + 1);
                    for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                        int annId = annIds[i][j];
                        if (annId < -1) {
                            annId = this.flipAnnotationId(annId);
                        } else if (annId < 0) {
                            hitString.append(" ").append("||");
                            continue;
                        }
                        rs = null;
                        if (con != null) {
                            this._prepStatComplexHitResultData.setInt(1, annId);
                            rs = this._prepStatComplexHitResultData.executeQuery();
                        } else {
                            String queryString = "SELECT annotation FROM " + this.schemaName + ".annotations WHERE ann_id = " + annId;
                            rs = st.executeQuery(queryString);
                        }
                        rs.next();
                        Object annotation = rs.getString(1);
                        if (annIds[i][j] < -1) {
                            annotation = "<void>";
                        }
                        rs.close();
                        rs = null;
                        if (((String)annotation).startsWith("|")) {
                            annotation = " " + (String)annotation;
                        }
                        hitString.append(" ").append("|");
                        hitString.append((String)annotation).append("|");
                    }
                }
            }
            catch (SQLException sqle) {
                _logger.log(Level.SEVERE, "constructComplexHitResult: SQLException: " + sqle, sqle);
                if (rs == null) break block14;
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return hitString.toString();
    }

    protected String[] constructNGramsWithinAnnotation(String annotation, String nGramPattern, String[] queryModes) {
        int nResults;
        String nGram;
        Matcher matcher;
        String[] result = null;
        String[] annotationParts = annotation.split(" +");
        String LongestNonWildcardPart = SearchQuery.getLongestNonWildcardPart(nGramPattern);
        boolean notMode = false;
        while (SearchLayer.isNOTPattern(LongestNonWildcardPart)) {
            notMode = !notMode;
            LongestNonWildcardPart = SearchLayer.stripNOTPattern(LongestNonWildcardPart);
        }
        ArrayList<String> resultList = new ArrayList<String>();
        if (queryModes[1].equals(" case sensitive")) {
            if (queryModes[2].equals(" exact match")) {
                for (int i = 0; i < annotationParts.length; ++i) {
                    String nGram2;
                    if (notMode == annotationParts[i].equals(LongestNonWildcardPart) || (nGram2 = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                    resultList.add(nGram2);
                }
            } else if (queryModes[2].equals(" substring match")) {
                for (int i = 0; i < annotationParts.length; ++i) {
                    String nGram3;
                    if (notMode == annotationParts[i].contains(LongestNonWildcardPart) || (nGram3 = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                    resultList.add(nGram3);
                }
            } else if (queryModes[2].equals(" regular expression")) {
                Pattern regExpPattern = Pattern.compile(LongestNonWildcardPart);
                for (int i = 0; i < annotationParts.length; ++i) {
                    matcher = regExpPattern.matcher(annotationParts[i]);
                    if (notMode == matcher.lookingAt() || (nGram = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                    resultList.add(nGram);
                }
            }
        } else if (queryModes[2].equals(" exact match")) {
            for (int i = 0; i < annotationParts.length; ++i) {
                String nGram4;
                if (notMode == annotationParts[i].toLowerCase().equals(LongestNonWildcardPart.toLowerCase()) || (nGram4 = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                resultList.add(nGram4);
            }
        } else if (queryModes[2].equals(" substring match")) {
            for (int i = 0; i < annotationParts.length; ++i) {
                String nGram5;
                if (notMode == annotationParts[i].toLowerCase().contains(LongestNonWildcardPart.toLowerCase()) || (nGram5 = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                resultList.add(nGram5);
            }
        } else if (queryModes[2].equals(" regular expression")) {
            Pattern regExpPattern = Pattern.compile(LongestNonWildcardPart, 2);
            for (int i = 0; i < annotationParts.length; ++i) {
                matcher = regExpPattern.matcher(annotationParts[i].toLowerCase());
                if (notMode == matcher.lookingAt() || (nGram = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                resultList.add(nGram);
            }
        }
        if ((nResults = resultList.size()) > 0) {
            result = new String[nResults];
            for (int i = 0; i < nResults; ++i) {
                result[i] = ((String)resultList.get(i)).trim();
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] constructNGrams(int annId, Statement st, Integer queryIdInt, String nGramPattern, String[] queryModes) {
        String[] result = null;
        ResultSet rs = null;
        String schemaName = "search" + (queryIdInt == null ? "" : queryIdInt.toString());
        try {
            String[] stringArray;
            if (queryModes[0].equals(" N-gram within annotation")) {
                String queryString = "SELECT annotation FROM " + schemaName + ".annotations WHERE ann_id = " + annId;
                rs = st.executeQuery(queryString);
                rs.next();
                String annotation = rs.getString(1);
                rs.close();
                rs = null;
                String[] stringArray2 = this.constructNGramsWithinAnnotation(annotation, nGramPattern, queryModes);
                return stringArray2;
            }
            String queryString = "SELECT ann_position, ann_tier_id FROM " + schemaName + ".annotations WHERE ann_id = " + annId;
            rs = st.executeQuery(queryString);
            rs.next();
            int annPosition = rs.getInt(1);
            int annTierId = rs.getInt(2);
            rs.close();
            rs = null;
            int firstPos = annPosition - SearchQuery.getLongestNonWildcardPartPosition(nGramPattern);
            if (firstPos < 0) {
                String[] stringArray3 = null;
                return stringArray3;
            }
            int lastPos = firstPos + this.getNGramLength(nGramPattern);
            queryString = "SELECT annotation, ann_position FROM " + schemaName + ".annotations WHERE ann_tier_id = " + annTierId + " AND ann_position >= " + firstPos + " AND ann_position < " + lastPos + " ORDER BY ann_position";
            rs = st.executeQuery(queryString);
            StringBuilder nGram = new StringBuilder("");
            int nParts = 0;
            while (rs.next()) {
                ++nParts;
                String nGramWord = rs.getString(1);
                if (nGramWord.contains("xxxSAFE_SPLITTERxxx")) {
                    nGramWord = "[UNPRINTABLE]";
                }
                nGram.append(nGramWord);
                nGram.append("xxxSAFE_SPLITTERxxx");
            }
            rs.close();
            rs = null;
            if (nParts != lastPos - firstPos) {
                stringArray = null;
                return stringArray;
            }
            result = new String[]{nGram.toString()};
            stringArray = result;
            return stringArray;
        }
        catch (SQLException sqle) {
            _logger.log(Level.SEVERE, "constructNGrams: SQLException: " + sqle, sqle);
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle2) {
                    _logger.log(Level.SEVERE, "constructNGrams: Finally close ResultSet failed: " + sqle2);
                }
            }
        }
    }

    private String constructNGram(String nGramPattern, String[] annotationParts, int hitIndex, String[] queryModes) {
        int firstPos = hitIndex - SearchQuery.getLongestNonWildcardPartPosition(nGramPattern);
        if (firstPos < 0) {
            return null;
        }
        int nGramLength = this.getNGramLength(nGramPattern);
        int lastPos = firstPos + nGramLength;
        if (lastPos > annotationParts.length) {
            return null;
        }
        StringBuilder nGram = new StringBuilder("");
        for (int i = 0; i < nGramLength; ++i) {
            int j = firstPos + i;
            if ("xxxSAFE_SPLITTERxxx".equals(annotationParts[j])) {
                annotationParts[j] = "[UNPRINTABLE]";
            }
            if (queryModes[0].equals(" N-gram over annotations")) {
                nGram.append(annotationParts[j]);
                if (j == lastPos - 1) continue;
                nGram.append("xxxSAFE_SPLITTERxxx");
                continue;
            }
            nGram.append(annotationParts[j]);
            if (j == lastPos - 1) continue;
            nGram.append(' ');
        }
        return nGram.toString();
    }

    protected boolean isNGramMatch(String nGram, String nGramPattern, String[] queryModes) {
        String[] nGramPatternParts;
        String[] nGramParts = queryModes[0].equals(" N-gram over annotations") ? nGram.split("xxxSAFE_SPLITTERxxx") : nGram.split(" +");
        if (nGramParts.length != (nGramPatternParts = nGramPattern.split(" +")).length) {
            return false;
        }
        for (int i = 0; i < nGramParts.length; ++i) {
            Pattern regExpPattern;
            Matcher matcher;
            String patternPart = nGramPatternParts[i];
            if (patternPart.equals("#")) continue;
            boolean notMode = false;
            while (SearchLayer.isNOTPattern(patternPart)) {
                notMode = !notMode;
                patternPart = SearchLayer.stripNOTPattern(patternPart);
            }
            if (!(queryModes[1].equals(" case sensitive") ? (queryModes[2].equals(" exact match") ? notMode == nGramParts[i].equals(patternPart) : (queryModes[2].equals(" substring match") ? notMode == nGramParts[i].contains(patternPart) : queryModes[2].equals(" regular expression") && notMode == (matcher = (regExpPattern = Pattern.compile(patternPart)).matcher(nGramParts[i])).lookingAt())) : (queryModes[2].equals(" exact match") ? notMode == nGramParts[i].toLowerCase().equals(patternPart.toLowerCase()) : (queryModes[2].equals(" substring match") ? notMode == nGramParts[i].toLowerCase().contains(patternPart.toLowerCase()) : queryModes[2].equals(" regular expression") && notMode == (matcher = (regExpPattern = Pattern.compile(patternPart, 2)).matcher(nGramParts[i].toLowerCase())).lookingAt())))) continue;
            return false;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, nGram + " ===  " + nGramPattern);
        }
        return true;
    }

    public static String getLongestNonWildcardPart(String nGramPattern) {
        String[] nGramPatternParts = nGramPattern.split(" +");
        int position = SearchQuery.getLongestNonWildcardPartPosition(nGramPattern);
        return nGramPatternParts[position];
    }

    public static int getLongestNonWildcardPartPosition(String nGramPattern) {
        String part;
        int i;
        String[] nGramPatternParts = nGramPattern.split(" +");
        int position = -1;
        int maxLength = 0;
        for (i = 0; i < nGramPatternParts.length; ++i) {
            part = nGramPatternParts[i];
            if (part.equals("#") || SearchLayer.isNOTPattern(part) || part.length() <= maxLength) continue;
            maxLength = part.length();
            position = i;
        }
        if (position >= 0) {
            return position;
        }
        for (i = 0; i < nGramPatternParts.length; ++i) {
            part = nGramPatternParts[i];
            if (part.equals("#")) continue;
            return i;
        }
        return 0;
    }

    protected int getNGramLength(String nGramPattern) {
        return nGramPattern.split(" +").length;
    }

    protected int countHitsInAnnotation(String annotation, String[] queryModes, String pattern, Pattern regExpPattern, boolean patternNOTMode) {
        if (patternNOTMode) {
            return 1;
        }
        if (!queryModes[0].equals(" Annotation")) {
            return 1;
        }
        if (!queryModes[1].equals(" case sensitive")) {
            pattern = pattern.toLowerCase();
            annotation = annotation.toLowerCase();
        }
        if (queryModes[2].equals(" exact match") || queryModes[2].equals(" variable match")) {
            return 1;
        }
        if (queryModes[2].equals(" substring match")) {
            int p = annotation.indexOf(pattern);
            int patternLength = pattern.length();
            int nHits = 0;
            while (p >= 0) {
                ++nHits;
                p = annotation.indexOf(pattern, p + patternLength);
            }
            return nHits;
        }
        if (queryModes[2].equals(" regular expression")) {
            int nHits = 0;
            Matcher matcher = regExpPattern.matcher(annotation);
            while (matcher.find()) {
                if (matcher.start() != matcher.end()) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Found: '" + annotation + "' start=" + matcher.start() + " end=" + matcher.end() + " hitEnd=" + matcher.hitEnd() + " state: " + matcher);
                    }
                    ++nHits;
                    continue;
                }
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Skipped: '" + annotation + "' start=" + matcher.start() + " end=" + matcher.end() + " hitEnd=" + matcher.hitEnd() + " state: " + matcher);
            }
            if (nHits == 0) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "countHitsInAnnotation: Only '' within '" + annotation + "' matches '" + pattern + "'");
                }
                ++nHits;
            }
            return nHits;
        }
        throw new RuntimeException("Impossible combination of modes: " + queryModes[0] + ", " + queryModes[1] + ", " + queryModes[2]);
    }

    protected int getHitPosition(String annotation, int nthHit, String[] queryModes, String pattern, Pattern regExpPattern, boolean patternNOTMode) {
        if (patternNOTMode) {
            return 0;
        }
        if (queryModes[0].equals(" N-gram over annotations")) {
            pattern = SearchQuery.getLongestNonWildcardPart(pattern);
            regExpPattern = queryModes[1].equals(" case sensitive") ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
        }
        int position = 0;
        if (queryModes[0].equals(" N-gram within annotation")) {
            int hitNumber = nthHit;
            String[] nGrams = this.constructNGramsWithinAnnotation(annotation, pattern, queryModes);
            if (nGrams == null) {
                return 0;
            }
            for (int i = 0; i < nGrams.length; ++i) {
                if (!this.isNGramMatch(nGrams[i], pattern, queryModes) || --hitNumber > 0) continue;
                String singleSpaceAnnotation = annotation.replaceAll(" +", " ");
                position = singleSpaceAnnotation.indexOf(nGrams[i]);
                int nSame = 0;
                for (int j = 0; j < i; ++j) {
                    if (!nGrams[i].equals(nGrams[j])) continue;
                    ++nSame;
                }
                while (nSame > 0) {
                    position = singleSpaceAnnotation.indexOf(nGrams[i], position + 1);
                    --nSame;
                }
                break;
            }
            return position;
        }
        if (!queryModes[1].equals(" case sensitive")) {
            pattern = pattern.toLowerCase();
            annotation = annotation.toLowerCase();
        }
        if (queryModes[2].equals(" substring match") || queryModes[2].equals(" exact match")) {
            int patternLength = pattern.length();
            int p = annotation.indexOf(pattern);
            while (nthHit > 1 && p != -1) {
                --nthHit;
                p = annotation.indexOf(pattern, p + patternLength);
            }
            if (p == -1) {
                throw new RuntimeException("Pattern '" + pattern + "' not actually present in '" + annotation + "'??");
            }
            position = p;
        } else if (queryModes[2].equals(" regular expression")) {
            Matcher matcher = regExpPattern.matcher(annotation);
            while (matcher.find() && nthHit > 0) {
                if (matcher.start() == matcher.end()) continue;
                --nthHit;
                position = matcher.start();
            }
            if (nthHit != 0) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Regexp '" + pattern + "' matches only empty substring of '" + annotation);
                }
                position = 0;
            }
        }
        return position;
    }

    private int getTokenNumberForPosition(String annotation, int p) {
        int pos = 0;
        int tokenNr = 0;
        while (pos < p) {
            pos = annotation.indexOf(32, pos) + 1;
            ++tokenNr;
        }
        return tokenNr;
    }

    protected int getHitLength(String annotation, int nthHit, String[] queryModes, String pattern, Pattern regExpPattern, boolean patternNOTMode) {
        if (queryModes[0].equals(" N-gram over annotations")) {
            pattern = SearchQuery.getLongestNonWildcardPart(pattern);
            regExpPattern = queryModes[1].equals(" case sensitive") ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
        }
        int length = pattern.length();
        if (patternNOTMode) {
            length = annotation.length();
        } else if (queryModes[0].equals(" N-gram within annotation")) {
            String[] nGrams = this.constructNGramsWithinAnnotation(annotation, pattern, queryModes);
            for (int i = 0; i < nGrams.length; ++i) {
                if (!this.isNGramMatch(nGrams[i], pattern, queryModes) || --nthHit > 0) continue;
                length = nGrams[i].length();
                break;
            }
        } else if (queryModes[2].equals(" regular expression")) {
            Matcher matcher = queryModes[1].equals(" case sensitive") ? regExpPattern.matcher(annotation) : regExpPattern.matcher(annotation.toLowerCase());
            while (matcher.find() && nthHit > 0) {
                if (matcher.start() == matcher.end()) continue;
                --nthHit;
                length = matcher.end() - matcher.start();
            }
            if (nthHit != 0) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Regexp '" + pattern + "' matches only empty substring of '" + annotation);
                }
                length = annotation.length();
            }
        }
        return length;
    }

    protected String createGlobalTimeConstraintPart() {
        Object queryPart = "";
        if (this._beginAfter > 0L) {
            queryPart = " AND begin_time > " + this._beginAfter;
        }
        if (this._endBefore > 0L) {
            queryPart = (String)queryPart + " AND end_time < " + this._endBefore;
        }
        return queryPart;
    }

    protected boolean isDurationInRange(long duration) {
        boolean retval = true;
        if (this._minimalDuration > 0L && duration < this._minimalDuration) {
            retval = false;
        }
        if (this._maximalDuration > 0L && duration > this._maximalDuration) {
            retval = false;
        }
        return retval;
    }

    protected long getGlobalHitDuration() {
        long smallestBeginTime = Long.MAX_VALUE;
        long biggestEndTime = Long.MIN_VALUE;
        for (int i = 0; i < this.nLayers; ++i) {
            for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                long endTime;
                if (this.globalHitAnnId[i][j] == -1) continue;
                long beginTime = this.globalHitBeginTime[i][j];
                if (beginTime < smallestBeginTime) {
                    smallestBeginTime = beginTime;
                }
                if ((endTime = this.globalHitEndTime[i][j]) <= biggestEndTime) continue;
                biggestEndTime = endTime;
            }
        }
        if (smallestBeginTime == Long.MAX_VALUE || biggestEndTime == Long.MIN_VALUE) {
            return 0L;
        }
        return biggestEndTime - smallestBeginTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearHitData(int fileId) {
        this.hitResetLock.lock();
        try {
            this.globalHitFileId = fileId;
            for (int i = 0; i < this.nLayers; ++i) {
                for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                    this.globalHitAnnId[i][j] = -1;
                    this.globalHitTierId[i][j] = -1;
                }
            }
        }
        finally {
            this.hitResetLock.unlock();
        }
    }

    protected int flipAnnotationId(int id) {
        if (id >= 0) {
            return -id - 10;
        }
        return -(id + 10);
    }
}

