/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.util.List;
import nl.mpi.annot.search.lib.FrequencyInfo;
import nl.mpi.annot.search.lib.HitField;
import nl.mpi.annot.search.lib.HitLayer;
import nl.mpi.annot.search.lib.SearchHit;
import nl.mpi.annot.tools.util.XmlUtil;

public class XmlHelpers {
    public static String getFreqInfoAsXML(FrequencyInfo info) {
        StringBuilder xml = new StringBuilder(256);
        xml.append("<hit>");
        xml.append(XmlUtil.xmlifyNameValuePair((String)"annotation", (String)info.annotation));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"occurences", (long)info.nOccurences));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"numberOfHits", (long)info.numberOfHits));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"hitPositionInAnnotation", (long)info.hitPositionInAnnotation));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"hitLength", (long)info.hitLength));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"annId", (long)info.annId));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"fileIndex", (long)info.fileIndex));
        return xml.append("</hit>\n").toString();
    }

    public static String getHitAsXML(SearchHit hit) {
        int i;
        StringBuilder xml = new StringBuilder(512);
        xml.append("<hit complex=\"").append(hit.isComplex() ? "true" : "false").append("\"");
        xml.append(" beginTime=\"").append(hit.beginTime).append("\"");
        xml.append(" endTime=\"").append(hit.endTime).append("\"");
        xml.append(" transcriptionNodeId=\"").append(XmlUtil.escapeXML((String)hit.transcriptionNodeId)).append("\"");
        xml.append(" transcriptionName=\"").append(XmlUtil.escapeXML((String)hit.transcriptionName)).append("\"");
        xml.append(" transcriptionURL=\"").append(XmlUtil.escapeXML((String)hit.transcriptionURL)).append("\"");
        if (hit.transcriptionPID != null && hit.transcriptionPID.length() > 0) {
            xml.append(" transcriptionPID=\"").append(XmlUtil.escapeXML((String)hit.transcriptionPID)).append("\"");
        }
        xml.append(" >");
        Object beforeString = "";
        for (i = 0; i < hit.leftContext.size(); ++i) {
            beforeString = hit.leftContext.get(i) + "  " + (String)beforeString;
        }
        xml.append("\n\t");
        xml.append(XmlUtil.xmlifyNameValuePair((String)"leftContext", (String)((String)beforeString).trim()));
        xml.append("\n\t<rightContext>");
        for (i = 0; i < hit.rightContext.size(); ++i) {
            xml.append(XmlUtil.escapeXML((String)hit.rightContext.get(i))).append(" ");
        }
        xml.append("</rightContext>");
        int n = 0;
        for (HitLayer layer : hit.layerTiers) {
            List<HitField> fields = hit.hitFields.get(n);
            xml.append("\n\t<layer tierName=\"").append(XmlUtil.escapeXML((String)layer.tierName));
            xml.append("\" tierType=\"").append(XmlUtil.escapeXML((String)layer.tierType));
            xml.append("\"");
            if (layer.participant != null) {
                xml.append(" participant=\"").append(XmlUtil.escapeXML((String)layer.participant)).append('\"');
            }
            if (layer.annotator != null) {
                xml.append(" annotator=\"").append(XmlUtil.escapeXML((String)layer.annotator)).append('\"');
            }
            xml.append(" aligned=\"").append(layer.aligned ? "true" : "false").append("\"");
            xml.append(" >");
            for (HitField field : fields) {
                if (field == null) {
                    xml.append("\n\t\t<field />");
                    continue;
                }
                xml.append("\n\t\t<field beginTime=\"").append(field.beginTime).append("\"");
                xml.append(" endTime=\"").append(field.endTime).append("\"");
                xml.append(" hitPositionInAnnotation=\"").append(field.hitPositionInAnnotation).append("\"");
                xml.append(" hitLength=\"").append(field.hitLength).append("\"");
                xml.append(" hitNumberInAnnotation=\"").append(field.hitNumberInAnnotation).append("\"");
                xml.append(" positionInTier=\"").append(field.positionInTier).append("\"");
                xml.append(" >");
                xml.append(XmlUtil.escapeXML((String)field.annotation));
                xml.append("</field>");
            }
            xml.append("\n\t</layer>");
            ++n;
        }
        xml.append("\n</hit>\n");
        return xml.toString();
    }
}

