/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import nl.mpi.lexiconcomponent.gui.LexiconGuiResources;
import nl.mpi.lexiconcomponent.impl.LexiconFields;

public class CreateEntryPanel
extends JPanel {
    private JDialog editEntryDialog;
    private JPanel editEntryFieldsPanel;
    private GridBagConstraints editFieldConstraints;
    private JLabel lexUnitLabel;
    private JTextField lexUnitTextField;
    private JLabel morphTypeLabel;
    private JTextField morphTypeTextField;
    private JLabel citationLabel;
    private JTextField citationTextField;
    private JLabel variantLabel;
    private JTextField variantTextField;
    private JLabel senseLabel;
    private JLabel gramCatLabel;
    private JTextField gramCatTextField;
    private JLabel glossLabel;
    private JTextField glossTextField;
    private JPanel editEntryWidgetsPanel;
    private JButton editEntryApply;
    private JButton editEntryCancel;
    private Map<LexiconFields, String> entryValues;
    private String newLexUnitValue = "";
    private String newMorphTypeValue = "";
    private String newCitationValue = "";
    private String newVariantValue = "";
    private String newGramCat = "";
    private String newGloss = "";
    private String lexiconName;
    private Map<String, String> initialFieldValues;

    public CreateEntryPanel() {
        this.createSwingObjects();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.editEntryFieldsPanel.setLayout(new GridBagLayout());
        this.editFieldConstraints.insets = new Insets(2, 2, 2, 2);
        this.editFieldConstraints.gridwidth = 1;
        this.editFieldConstraints.anchor = 17;
        this.placeComponent(this.lexUnitLabel, 0, 0, 1);
        this.placeComponent(this.lexUnitTextField, 1, 0, 2);
        this.placeComponent(this.morphTypeLabel, 0, 1, 1);
        this.placeComponent(this.morphTypeTextField, 1, 1, 2);
        this.placeComponent(this.citationLabel, 0, 2, 1);
        this.placeComponent(this.citationTextField, 1, 2, 2);
        this.placeComponent(this.variantLabel, 0, 3, 1);
        this.placeComponent(this.variantTextField, 1, 3, 2);
        this.placeComponent(this.senseLabel, 0, 4, 1);
        this.editFieldConstraints.insets = new Insets(2, 10, 2, 2);
        this.placeComponent(this.gramCatLabel, 0, 5, 1);
        this.placeComponent(this.gramCatTextField, 1, 5, 2);
        this.placeComponent(this.glossLabel, 0, 6, 1);
        this.placeComponent(this.glossTextField, 1, 6, 2);
        this.editEntryWidgetsPanel.add(this.editEntryApply);
        this.editEntryWidgetsPanel.add(this.editEntryCancel);
        this.add((Component)this.editEntryFieldsPanel, "North");
        this.add((Component)this.editEntryWidgetsPanel, "South");
    }

    public CreateEntryPanel(String lexiconName, Map<String, String> initialFieldValues) {
        this();
        this.lexiconName = lexiconName;
        this.initialFieldValues = initialFieldValues;
        this.fillFieldsInitially();
    }

    private void createSwingObjects() {
        this.editEntryFieldsPanel = new JPanel();
        this.editFieldConstraints = new GridBagConstraints();
        this.lexUnitLabel = new JLabel(LexiconFields.ENTRY_LEX_UNIT.getDisplayLabel());
        this.lexUnitTextField = new JTextField(30);
        this.morphTypeLabel = new JLabel(LexiconFields.ENTRY_MORPH_TYPE.getDisplayLabel());
        this.morphTypeTextField = new JTextField();
        this.citationLabel = new JLabel(LexiconFields.ENTRY_CITATION.getDisplayLabel());
        this.citationTextField = new JTextField();
        this.variantLabel = new JLabel(LexiconFields.ENTRY_VARIANT.getDisplayLabel());
        this.variantTextField = new JTextField();
        this.senseLabel = new JLabel(LexiconFields.SENSE.getDisplayLabel());
        this.gramCatLabel = new JLabel(LexiconFields.SENSE_GRAM_CAT.getDisplayLabel());
        this.gramCatTextField = new JTextField();
        this.glossLabel = new JLabel(LexiconFields.SENSE_GLOSS.getDisplayLabel());
        this.glossTextField = new JTextField();
        this.editEntryWidgetsPanel = new JPanel();
        ButtonActionListener actListener = new ButtonActionListener();
        this.editEntryApply = new JButton(LexiconGuiResources.getLocalizedString("Button.Apply", "Apply"));
        this.editEntryApply.addActionListener(actListener);
        this.editEntryCancel = new JButton(LexiconGuiResources.getLocalizedString("Button.Cancel", "Cancel"));
        this.editEntryCancel.addActionListener(actListener);
    }

    private void placeComponent(JComponent l, int x, int y, int w) {
        this.editFieldConstraints.gridx = x;
        this.editFieldConstraints.gridy = y;
        this.editFieldConstraints.gridwidth = w;
        if (x == 0) {
            this.editFieldConstraints.fill = 0;
            this.editFieldConstraints.weightx = 0.0;
        } else {
            this.editFieldConstraints.fill = 2;
            this.editFieldConstraints.weightx = 1.0;
        }
        this.editEntryFieldsPanel.add((Component)l, this.editFieldConstraints);
    }

    public Map<LexiconFields, String> showDialog(Window owner, Dialog.ModalityType modalityType, Component positionComponent) {
        this.editEntryDialog = new JDialog(owner, modalityType);
        this.editEntryDialog.setTitle(LexiconGuiResources.getLocalizedString("LexiconComponent.Entry.Entry", "New Lexical Entry"));
        this.editEntryDialog.getContentPane().setLayout(new BorderLayout());
        this.editEntryDialog.getContentPane().add((Component)this, "Center");
        this.editEntryDialog.pack();
        if (positionComponent != null) {
            this.editEntryDialog.setLocationRelativeTo(positionComponent);
        } else if (owner != null) {
            this.editEntryDialog.setLocationRelativeTo(owner);
        }
        if (this.lexiconName != null) {
            this.editEntryDialog.setTitle(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Name", "Lexicon Name") + ": " + this.lexiconName);
        }
        this.editEntryDialog.getRootPane().setDefaultButton(this.editEntryApply);
        this.editEntryDialog.setVisible(true);
        return this.entryValues;
    }

    private void cancelEditEntry() {
        this.entryValues = null;
        if (this.editEntryDialog != null) {
            this.editEntryDialog.setVisible(false);
            this.editEntryDialog.dispose();
        }
    }

    private boolean requiredFieldsFilled() {
        if (this.newLexUnitValue == null || this.newLexUnitValue.equals("")) {
            JOptionPane.showMessageDialog(this, LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit.Warning.Required", "The following value is required: ") + LexiconFields.ENTRY_LEX_UNIT.getDisplayLabel(), LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit.Warning.MissingValue", "Missing value"), 1);
            this.lexUnitTextField.requestFocus();
            this.lexUnitLabel.setForeground(Color.RED);
            return false;
        }
        if (this.newMorphTypeValue == null || this.newMorphTypeValue.equals("")) {
            JOptionPane.showMessageDialog(this, LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit.Warning.Required", "The following value is required: ") + LexiconFields.ENTRY_MORPH_TYPE.getDisplayLabel(), LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit.Warning.MissingValue", "Missing value"), 1);
            this.morphTypeTextField.requestFocus();
            this.morphTypeLabel.setForeground(Color.RED);
            return false;
        }
        if (this.newGramCat == null || this.newGramCat.equals("")) {
            JOptionPane.showMessageDialog(this, LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit.Warning.Required", "The following value is required: ") + LexiconFields.SENSE_GRAM_CAT.getDisplayLabel(), LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit.Warning.MissingValue", "Missing value"), 1);
            this.gramCatTextField.requestFocus();
            this.gramCatLabel.setForeground(Color.RED);
            return false;
        }
        return true;
    }

    private void applyEditEntry() {
        this.newLexUnitValue = this.lexUnitTextField.getText();
        this.newMorphTypeValue = this.morphTypeTextField.getText();
        this.newCitationValue = this.citationTextField.getText();
        this.newVariantValue = this.variantTextField.getText();
        this.newGramCat = this.gramCatTextField.getText();
        this.newGloss = this.glossTextField.getText();
        if (!this.requiredFieldsFilled()) {
            return;
        }
        this.entryValues = new HashMap<LexiconFields, String>();
        this.entryValues.put(LexiconFields.ENTRY_LEX_UNIT, this.newLexUnitValue);
        this.entryValues.put(LexiconFields.ENTRY_MORPH_TYPE, this.newMorphTypeValue);
        this.entryValues.put(LexiconFields.SENSE_GRAM_CAT, this.newGramCat);
        if (this.newCitationValue != null && !this.newCitationValue.isEmpty()) {
            this.entryValues.put(LexiconFields.ENTRY_CITATION, this.newCitationValue);
        }
        if (this.newVariantValue != null && !this.newVariantValue.isEmpty()) {
            this.entryValues.put(LexiconFields.ENTRY_VARIANT, this.newVariantValue);
        }
        if (this.newGloss != null) {
            this.entryValues.put(LexiconFields.SENSE_GLOSS, this.newGloss);
        } else {
            this.entryValues.put(LexiconFields.SENSE_GLOSS, "");
        }
        if (this.editEntryDialog != null) {
            this.editEntryDialog.setVisible(false);
            this.editEntryDialog.dispose();
        }
    }

    private void fillFieldsInitially() {
        if (this.initialFieldValues != null) {
            this.setNonNullValue(this.initialFieldValues.get(LexiconFields.ENTRY_LEX_UNIT.getFieldName()), this.lexUnitTextField);
            this.setNonNullValue(this.initialFieldValues.get(LexiconFields.ENTRY_MORPH_TYPE.getFieldName()), this.morphTypeTextField);
            this.setNonNullValue(this.initialFieldValues.get(LexiconFields.SENSE_GRAM_CAT.getFieldName()), this.gramCatTextField);
            this.setNonNullValue(this.initialFieldValues.get(LexiconFields.SENSE_GLOSS.getFieldName()), this.glossTextField);
            this.setNonNullValue(this.initialFieldValues.get(LexiconFields.ENTRY_CITATION.getFieldName()), this.citationTextField);
            this.setNonNullValue(this.initialFieldValues.get(LexiconFields.ENTRY_VARIANT.getFieldName()), this.variantTextField);
        }
    }

    private void setNonNullValue(String value, JTextField tf) {
        if (value != null) {
            tf.setText(value);
        }
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == CreateEntryPanel.this.editEntryApply) {
                CreateEntryPanel.this.applyEditEntry();
            } else if (e.getSource() == CreateEntryPanel.this.editEntryCancel) {
                CreateEntryPanel.this.cancelEditEntry();
            }
        }
    }
}

