/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui;

import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import nl.mpi.lexiconcomponent.exceptions.LexiconNotFoundException;
import nl.mpi.lexiconcomponent.exceptions.LexiconStructureException;
import nl.mpi.lexiconcomponent.gui.CreateEntryPanel;
import nl.mpi.lexiconcomponent.gui.LexiconGuiConstants;
import nl.mpi.lexiconcomponent.gui.LexiconGuiResources;
import nl.mpi.lexiconcomponent.gui.LexiconHandler;
import nl.mpi.lexiconcomponent.gui.LexiconListRenderer;
import nl.mpi.lexiconcomponent.gui.LexiconRootPanel;
import nl.mpi.lexiconcomponent.gui.LexiconViewManager;
import nl.mpi.lexiconcomponent.gui.table.EntryTableModel2;
import nl.mpi.lexiconcomponent.gui.table.TableColumnDescriptor;
import nl.mpi.lexiconcomponent.gui.tree.EditEntryDialog;
import nl.mpi.lexiconcomponent.impl.EntryImpl;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.impl.LexiconImpl;
import nl.mpi.lexiconcomponent.util.LexiconLogger;

public class ElanLexRootPanel
extends LexiconRootPanel {
    private JComboBox<String> lexComboBox;
    private JPopupMenu lexActionMenu = null;
    private JButton lexActionButton = null;
    private LexiconListRenderer lexListRenderer = null;
    private JButton addButton = null;
    private JButton removeButton = null;
    private JButton editButton = null;
    private MiscActionListener miscListener = null;
    private LexiconCBItemListener lexiconCBListener = null;

    public ElanLexRootPanel(LexiconHandler lexiconHandler) {
        super(lexiconHandler);
        if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
            LexiconLogger.LEXLOG.fine(String.format("Constructor of %s, param type %s", this.getClass().getName(), LexiconHandler.class.getName()));
        }
        this.initListeners();
        this.initComponents();
    }

    public ElanLexRootPanel(LexiconViewManager lexViewManager) {
        super(lexViewManager);
        if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
            LexiconLogger.LEXLOG.fine(String.format("Constructor of %s, param type %s", this.getClass().getName(), LexiconViewManager.class.getName()));
        }
        this.initListeners();
        this.initComponents();
    }

    @Override
    public void isClosing() {
        if (this.lexHandler.isLexiconChanged()) {
            int option = JOptionPane.showConfirmDialog(this, LexiconGuiResources.getLocalizedString("LexiconComponent.Message.SaveChanges", "The lexicon has unsaved changes, save the changes?"), "", 0, 3);
            if (option == 0) {
                this.lexHandler.saveLexicon();
            }
            this.lexHandler.closeLexicon();
        }
    }

    @Override
    public void setUserPreferences(Map<String, Object> loadedPrefMap) {
        if (loadedPrefMap != null) {
            Map storedVisColsMap;
            if (this.preferencesMap == null) {
                this.preferencesMap = new HashMap<String, Object>(loadedPrefMap);
            } else {
                this.preferencesMap.putAll(loadedPrefMap);
            }
            String selLex = (String)this.preferencesMap.get("LexiconPanel.SelectedLexicon");
            if (selLex != null) {
                if (selLex.equals("none")) {
                    this.lexComboBox.setSelectedIndex(0);
                } else {
                    this.lexComboBox.setSelectedItem(selLex);
                }
            }
            if ((storedVisColsMap = (Map)this.preferencesMap.get("LexiconPanel.VisibleColumnsMap")) != null) {
                List visColumns;
                this.visibleColumnsMap.putAll(storedVisColsMap);
                if (selLex != null && (visColumns = (List)this.visibleColumnsMap.get(selLex)) != null) {
                    this.setVisibleColumns(visColumns);
                }
            }
            this.restoreTableSortOrder();
        }
    }

    @Override
    public Map<String, Object> getUserPreferences() {
        if (this.preferencesMap == null) {
            this.preferencesMap = new HashMap();
        }
        if (this.lexComboBox.getSelectedIndex() == 0) {
            this.preferencesMap.put("LexiconPanel.SelectedLexicon", "none");
        } else {
            this.preferencesMap.put("LexiconPanel.SelectedLexicon", this.lexComboBox.getSelectedItem());
        }
        if (this.lexComboBox.getSelectedIndex() > 0) {
            this.visibleColumnsMap.put(String.valueOf(this.lexComboBox.getSelectedItem()), this.getVisibleColumns());
            this.preferencesMap.put("LexiconPanel.VisibleColumnsMap", this.visibleColumnsMap);
            this.storeTableSortOrder();
        }
        return this.preferencesMap;
    }

    @Override
    protected void initComponents() {
        super.initComponents();
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.miscListener = new MiscActionListener();
        this.lexiconCBListener = new LexiconCBItemListener();
    }

    @Override
    protected JPanel getTopWidgetPanel() {
        if (this.topWidgetPanel == null) {
            this.topWidgetPanel = new JPanel();
            this.topWidgetPanel.setLayout(new BoxLayout(this.topWidgetPanel, 0));
            this.lexComboBox = new JComboBox();
            this.fillLexiconComboBox();
            this.topWidgetPanel.add(this.lexComboBox);
            this.topWidgetPanel.add(Box.createHorizontalStrut(4));
            this.lexActionButton = new JButton();
            this.lexActionButton.setActionCommand("lexicon action");
            try {
                ImageIcon icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/triangle_down.gif"));
                this.lexActionButton.setIcon(icon);
                this.lexActionButton.setIconTextGap(4);
                this.lexActionButton.setHorizontalTextPosition(2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.topWidgetPanel.add(this.lexActionButton);
            this.lexActionButton.addMouseListener(this.miscListener);
        }
        return this.topWidgetPanel;
    }

    @Override
    protected JPanel getBottomWidgetPanel() {
        if (this.bottomWidgetPanel == null) {
            this.bottomWidgetPanel = new JPanel();
            this.bottomWidgetPanel.setLayout(new BoxLayout(this.bottomWidgetPanel, 2));
            this.addButton = new JButton();
            this.addButton.setActionCommand(this.menuListener.ADD_ENTRY);
            this.removeButton = new JButton();
            this.removeButton.setActionCommand(this.menuListener.REMOVE_ENTRY);
            this.editButton = new JButton();
            this.editButton.setActionCommand(this.menuListener.EDIT_ENTRY);
            this.bottomWidgetPanel.add(this.addButton);
            this.bottomWidgetPanel.add(Box.createHorizontalStrut(4));
            this.bottomWidgetPanel.add(this.removeButton);
            this.bottomWidgetPanel.add(Box.createHorizontalStrut(4));
            this.bottomWidgetPanel.add(this.editButton);
            this.addButton.addActionListener(this.menuListener);
            this.removeButton.addActionListener(this.menuListener);
            this.editButton.addActionListener(this.menuListener);
            this.entrySelectionChanged(null);
        }
        return this.bottomWidgetPanel;
    }

    private void fillLexiconComboBox() {
        List<String> availableNames = this.lexHandler.getAvailableLexiconNames();
        String noLexiconString = LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.NoLexicon", "<No Lexicon>");
        ArrayList<String> allNamesList = new ArrayList<String>();
        if (availableNames != null) {
            allNamesList.addAll(availableNames);
        }
        Collections.sort(allNamesList);
        allNamesList.add(0, noLexiconString);
        for (String s : allNamesList) {
            this.lexComboBox.addItem(s);
        }
        this.lexComboBox.setActionCommand("lexicon handling");
        this.lexComboBox.addItemListener(this.lexiconCBListener);
        String selectedLexiconName = null;
        if (this.lexHandler.isLexiconLoaded()) {
            selectedLexiconName = this.lexHandler.getCurrentLexicon().getHeader().getName();
            if (selectedLexiconName == null) {
                JOptionPane.showMessageDialog(this, "Lexicon combo box: failed to retrieve loaded lexicon name");
                selectedLexiconName = noLexiconString;
            }
        } else {
            selectedLexiconName = noLexiconString;
        }
        this.lexComboBox.setSelectedItem(selectedLexiconName);
        this.lexListRenderer = new LexiconListRenderer();
        this.lexComboBox.setRenderer(this.lexListRenderer);
    }

    private JPopupMenu getLexiconPopupMenu() {
        if (this.lexActionMenu == null) {
            this.lexActionMenu = new JPopupMenu();
            this.lexActionMenu.add(this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.OpenEditor", "Open Lexicon Editor Window..."), this.miscListener.OPEN_LEX_EDITOR_AC, this.miscListener));
            this.lexActionMenu.addSeparator();
            JMenuItem newLexItem = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.New", "New Lexicon..."), this.menuListener.NEW_LEX_AC, this.menuListener);
            this.lexActionMenu.add(newLexItem);
            JMenuItem openLexItem = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Open", "Open Lexicon..."), this.menuListener.OPEN_LEX_AC, this.menuListener);
            this.lexActionMenu.add(openLexItem);
            JMenuItem closeLexItem = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Close", "Close Lexicon"), this.menuListener.CLOSE_LEX_AC, this.menuListener);
            this.lexActionMenu.add(closeLexItem);
            this.lexActionMenu.addSeparator();
            JMenuItem saveLexItem = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Save", "Save Lexicon"), this.menuListener.SAVE_LEX_AC, this.menuListener);
            this.lexActionMenu.add(saveLexItem);
            JMenuItem saveAsLexItem = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.SaveAs", "Save Lexicon as..."), this.menuListener.SAVE_AS_LEX_AC, this.menuListener);
            this.lexActionMenu.add(saveAsLexItem);
            JMenuItem saveLexOrderItem = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.SaveOrder", "Save Lexicon in Current Order"), this.menuListener.SAVE_LEX_ORDER_AC, this.menuListener);
            this.lexActionMenu.add(saveLexOrderItem);
            this.lexActionMenu.addSeparator();
            JMenuItem editPropLexItem = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit", "Edit Lexicon Properties..."), this.menuListener.EDIT_LEX_AC, this.menuListener);
            this.lexActionMenu.add(editPropLexItem);
            this.lexActionMenu.addSeparator();
            JMenuItem importLexItem = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import", "Import Lexicon..."), this.menuListener.IMPORT_LEX_AC, this.menuListener);
            this.lexActionMenu.add(importLexItem);
            JMenuItem exportLexItem = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Export", "Export Lexicon..."), this.menuListener.EXPORT_LEX_AC, this.menuListener);
            this.lexActionMenu.add(exportLexItem);
        }
        return this.lexActionMenu;
    }

    private JMenuItem createMenuItem(String label, String action, ActionListener al) {
        JMenuItem mi = new JMenuItem(label);
        mi.setActionCommand(action);
        mi.addActionListener(al);
        return mi;
    }

    private void storeTableSortOrder() {
        if (this.lexComboBox.getSelectedIndex() > 0) {
            String selLEx = (String)this.lexComboBox.getSelectedItem();
            this.storeTableSortOrder(selLEx);
        }
    }

    private void restoreTableSortOrder() {
        Map storedSortOrder;
        if (this.preferencesMap != null && (storedSortOrder = (Map)this.preferencesMap.get("LexiconPanel.SortOrderMap")) != null) {
            if (storedSortOrder.containsKey(this.lexComboBox.getSelectedItem())) {
                this.restoreTableSortOrder((String)this.lexComboBox.getSelectedItem());
            } else {
                String selLex = String.valueOf(this.lexComboBox.getSelectedIndex());
                this.restoreTableSortOrder(selLex);
            }
        }
    }

    @Override
    protected void entrySelectionChanged(ListSelectionEvent e) {
        if (this.lexComboBox.getSelectedIndex() == 0) {
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
            int row = this.entryTable.getSelectedRow();
            boolean enabled = row >= 0 && row < this.entryTable.getRowCount();
            this.removeButton.setEnabled(enabled);
            this.editButton.setEnabled(enabled);
        }
    }

    @Override
    public void updateLocale() {
        this.addButton.setText(LexiconGuiResources.getLocalizedString("Button.Add", "Add"));
        this.removeButton.setText(LexiconGuiResources.getLocalizedString("Button.Remove", "Remove"));
        this.editButton.setText(LexiconGuiResources.getLocalizedString("Menu.Edit", "Edit"));
        this.lexActionMenu = null;
        this.lexActionButton.setText(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Actions", "Lexicon Actions"));
        this.tablePanel.setBorder(new TitledBorder(LexiconGuiResources.getLocalizedString("LexiconComponent.Entry.Entries", "Lexical Entries")));
        this.tablePopupMenu = null;
        this.customFieldItems.clear();
    }

    @Override
    protected void closeLexicon() {
        if (this.lexHandler.getCurrentLexicon() != null && this.lexComboBox.getSelectedIndex() > 0) {
            this.lexComboBox.setSelectedIndex(0);
        }
    }

    private void openLexiconEditor() {
        if (this.lexHandler.getCurrentLexicon() != null && this.lexHandler.isLexiconChanged()) {
            this.lexHandler.saveLexicon();
        }
        if (this.lexViewManager != null) {
            this.lexViewManager.updateUserPreferences(this.getUserPreferences());
            this.lexViewManager.createAndShowDialog(SwingUtilities.getWindowAncestor(this));
        }
    }

    @Override
    protected void createNewEntry() {
        CreateEntryPanel cew = new CreateEntryPanel();
        Map<LexiconFields, String> resultEntryData = cew.showDialog(SwingUtilities.getWindowAncestor(this), Dialog.ModalityType.DOCUMENT_MODAL, this);
        if (resultEntryData != null) {
            try {
                this.lexHandler.createNewEntry(resultEntryData);
            }
            catch (LexiconStructureException lse) {
                if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                    LexiconLogger.LEXLOG.warning(String.format("Error: %s", lse.getMessage()));
                }
                this.showMessage(String.format("Error while adding an entry: %s", lse.getMessage()), "", 2);
            }
            catch (LexiconNotFoundException lnfe) {
                if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                    LexiconLogger.LEXLOG.warning(String.format("Error: %s", lnfe.getMessage()));
                }
                this.showMessage(String.format("Error while adding an entry: %s", lnfe.getMessage()), "", 2);
            }
        }
    }

    public void createNewEntry(LexiconImpl forLexicon, Map<String, String> initialValues) {
        if (forLexicon == null) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning("Error: the lexicon is null");
            }
            return;
        }
        CreateEntryPanel cew = new CreateEntryPanel(forLexicon.getHeader().getName(), initialValues);
        Map<LexiconFields, String> resultEntryData = cew.showDialog(SwingUtilities.getWindowAncestor(this), Dialog.ModalityType.DOCUMENT_MODAL, this);
        if (resultEntryData != null) {
            try {
                this.lexHandler.createNewEntry(forLexicon, resultEntryData);
            }
            catch (LexiconStructureException lse) {
                if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                    LexiconLogger.LEXLOG.warning(String.format("Error: %s", lse.getMessage()));
                }
                this.showMessage(String.format("Error while adding an entry: %s", lse.getMessage()), "", 2);
            }
            catch (LexiconNotFoundException lnfe) {
                if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                    LexiconLogger.LEXLOG.warning(String.format("Error: %s", lnfe.getMessage()));
                }
                this.showMessage(String.format("Error while adding an entry: %s", lnfe.getMessage()), "", 2);
            }
        }
    }

    @Override
    protected void editCurrentEntry() {
        int selRow = this.entryTable.getSelectedRow();
        if (selRow < 0) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
                LexiconLogger.LEXLOG.info("Cannot edit an entry, no row selected");
            }
            return;
        }
        this.editEntryRow(selRow);
    }

    @Override
    protected void editEntry(EntryImpl curEntry) {
        if (curEntry != null) {
            EditEntryDialog editDiag = new EditEntryDialog(SwingUtilities.getWindowAncestor(this), Dialog.ModalityType.DOCUMENT_MODAL, curEntry);
            Rectangle wBounds = SwingUtilities.getWindowAncestor(this).getBounds();
            Rectangle diagBounds = editDiag.getBounds();
            if (diagBounds.width > wBounds.width) {
                diagBounds.width = wBounds.width - 40;
                diagBounds.x = wBounds.x + 20;
            }
            if (diagBounds.height > wBounds.height) {
                diagBounds.height = wBounds.height - 40;
                diagBounds.y = wBounds.y + 20;
            }
            Rectangle tableBounds = this.getBounds();
            tableBounds.y = wBounds.height - tableBounds.height;
            int vicinityX = tableBounds.x + tableBounds.width + 8 + wBounds.x;
            if (diagBounds.x > vicinityX) {
                diagBounds.x = vicinityX;
            }
            int heightDif = (tableBounds.height - diagBounds.height) / 2;
            diagBounds.y = wBounds.y + tableBounds.y + heightDif;
            if (diagBounds.y + diagBounds.height > wBounds.y + wBounds.height) {
                diagBounds.y = wBounds.y + wBounds.height - diagBounds.height - 4;
            }
            editDiag.setBounds(diagBounds);
            editDiag.setVisible(true);
        }
    }

    @Override
    protected void addAndSelectLexicon(String lexiconName) {
        this.lexComboBox.addItem(lexiconName);
        this.lexComboBox.setSelectedItem(lexiconName);
    }

    @Override
    protected void updateLexiconName(String oldName, String newName) {
        for (int i = 0; i < this.lexComboBox.getItemCount(); ++i) {
            if (!this.lexComboBox.getItemAt(i).equals(oldName)) continue;
            this.lexComboBox.removeItemListener(this.lexiconCBListener);
            this.lexComboBox.removeItemAt(i);
            this.lexComboBox.insertItemAt(newName, i);
            this.lexComboBox.setSelectedIndex(i);
            this.lexComboBox.addItemListener(this.lexiconCBListener);
            break;
        }
    }

    @Override
    protected void setChangedStateOfLexicon(String name, boolean changed) {
        if (changed) {
            this.lexComboBox.setForeground(LexiconGuiConstants.MODIFIED_FG_COLOR);
            this.lexListRenderer.setChangedStateOfItem(name, true);
        } else {
            this.lexComboBox.setForeground(this.getForeground());
            this.lexListRenderer.setChangedStateOfItem(name, false);
        }
    }

    private class LexiconCBItemListener
    implements ItemListener {
        private String previousSelectedItem;

        private LexiconCBItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (e.getItemSelectable() instanceof JComboBox) {
                    if (ElanLexRootPanel.this.lexHandler.isLexiconChanged()) {
                        int option = JOptionPane.showConfirmDialog(ElanLexRootPanel.this, LexiconGuiResources.getLocalizedString("LexiconComponent.Message.SaveChanges", "The lexicon has unsaved changes, save the changes?"), "", 1, 3);
                        if (option == 2) {
                            if (this.previousSelectedItem != null) {
                                ElanLexRootPanel.this.lexComboBox.removeItemListener(ElanLexRootPanel.this.lexiconCBListener);
                                ElanLexRootPanel.this.lexComboBox.setSelectedItem(this.previousSelectedItem);
                                ElanLexRootPanel.this.lexComboBox.addItemListener(ElanLexRootPanel.this.lexiconCBListener);
                            }
                            return;
                        }
                        if (option == 0) {
                            ElanLexRootPanel.this.lexHandler.saveLexicon();
                        }
                    }
                    if (ElanLexRootPanel.this.lexHandler.getCurrentLexicon() != null) {
                        List<String> visColumns = ElanLexRootPanel.this.getVisibleColumns();
                        if (visColumns != null) {
                            ElanLexRootPanel.this.visibleColumnsMap.put(ElanLexRootPanel.this.lexHandler.getCurrentLexicon().getHeader().getName(), visColumns);
                        }
                        ElanLexRootPanel.this.storeTableSortOrder();
                    }
                    if (((JComboBox)e.getItemSelectable()).getSelectedIndex() == 0) {
                        ElanLexRootPanel.this.lexHandler.getCurrentLexicon().removeLexiconEditListener(ElanLexRootPanel.this.entryModel);
                        ElanLexRootPanel.this.lexHandler.getCurrentLexicon().removeLexiconEditListener(ElanLexRootPanel.this.lexChangeListener);
                        ElanLexRootPanel.this.lexHandler.closeLexicon();
                        EntryTableModel2 nextEntryModel = new EntryTableModel2(null, null);
                        ElanLexRootPanel.this.replaceTableModel(nextEntryModel);
                        ElanLexRootPanel.this.lexComboBox.setForeground(ElanLexRootPanel.this.getForeground());
                        if (ElanLexRootPanel.this.bottomWidgetPanel != null) {
                            ElanLexRootPanel.this.entrySelectionChanged(null);
                        }
                    } else {
                        block19: {
                            String nextLexName = (String)e.getItem();
                            List<TableColumnDescriptor> currentColumns = null;
                            if (ElanLexRootPanel.this.entryModel != null) {
                                currentColumns = ElanLexRootPanel.this.entryModel.getColumnDescriptors();
                                if (ElanLexRootPanel.this.lexHandler.getCurrentLexicon() != null) {
                                    ElanLexRootPanel.this.lexHandler.getCurrentLexicon().removeLexiconEditListener(ElanLexRootPanel.this.entryModel);
                                    ElanLexRootPanel.this.lexHandler.getCurrentLexicon().removeLexiconEditListener(ElanLexRootPanel.this.lexChangeListener);
                                    ElanLexRootPanel.this.lexHandler.closeLexicon();
                                }
                            }
                            try {
                                LexiconImpl nextLexicon = ElanLexRootPanel.this.lexHandler.loadLexicon(nextLexName);
                                EntryTableModel2 nextEntryModel = new EntryTableModel2(nextLexicon, currentColumns);
                                ElanLexRootPanel.this.replaceTableModel(nextEntryModel);
                                nextLexicon.addLexiconEditListener(ElanLexRootPanel.this.lexChangeListener);
                                List visColumns = (List)ElanLexRootPanel.this.visibleColumnsMap.get(nextLexicon.getHeader().getName());
                                ElanLexRootPanel.this.setVisibleColumns(visColumns);
                                ElanLexRootPanel.this.restoreTableSortOrder();
                                if (nextLexicon.isChanged()) {
                                    ElanLexRootPanel.this.lexComboBox.setForeground(LexiconGuiConstants.MODIFIED_FG_COLOR);
                                } else {
                                    ElanLexRootPanel.this.lexComboBox.setForeground(ElanLexRootPanel.this.getForeground());
                                }
                            }
                            catch (LexiconNotFoundException lnfe) {
                                ElanLexRootPanel.this.showMessage(String.format(LexiconGuiResources.getLocalizedString("LexiconComponent.Warning.LoadError", "Could not load the lexicon by the name %s"), nextLexName), "", 1);
                                if (!LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) break block19;
                                LexiconLogger.LEXLOG.warning(String.format("Could not load the lexicon by the name %s", nextLexName));
                            }
                        }
                        if (ElanLexRootPanel.this.bottomWidgetPanel != null) {
                            ElanLexRootPanel.this.entrySelectionChanged(null);
                        }
                    }
                }
            } else {
                this.previousSelectedItem = (String)e.getItem();
            }
        }
    }

    private class MiscActionListener
    extends MouseAdapter
    implements ActionListener {
        final String OPEN_LEX_EDITOR_AC = "openEditor";

        private MiscActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ("openEditor".equals(e.getActionCommand())) {
                ElanLexRootPanel.this.openLexiconEditor();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == ElanLexRootPanel.this.lexActionButton) {
                ElanLexRootPanel.this.getLexiconPopupMenu().show(ElanLexRootPanel.this.lexActionButton.getParent(), ElanLexRootPanel.this.lexActionButton.getX(), ElanLexRootPanel.this.lexActionButton.getY() + ElanLexRootPanel.this.lexActionButton.getHeight());
            }
        }
    }
}

