/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import nl.mpi.lexiconcomponent.exceptions.LexiconNotFoundException;
import nl.mpi.lexiconcomponent.exceptions.LexiconStructureException;
import nl.mpi.lexiconcomponent.gui.LexiconGuiResources;
import nl.mpi.lexiconcomponent.gui.LexiconHandler;
import nl.mpi.lexiconcomponent.gui.LexiconViewManager;
import nl.mpi.lexiconcomponent.gui.tree.EditEntryTreePanel;
import nl.mpi.lexiconcomponent.impl.EntryImpl;
import nl.mpi.lexiconcomponent.impl.LexiconFields;

public class EntryEditRootPanel
extends JPanel {
    private LexiconViewManager lexViewManager;
    private LexiconHandler lexHandler;
    private EditEntryTreePanel editEntryPanel;
    private Map<LexiconFields, String> templateEntryData;

    public EntryEditRootPanel(LexiconViewManager lexViewManager) {
        this.lexViewManager = lexViewManager;
        this.lexHandler = lexViewManager.getLexiconHandler();
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.editEntryPanel = new EditEntryTreePanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(4, 2, 0, 2);
        this.add((Component)this.editEntryPanel, gbc);
        this.updateLocale();
    }

    public void isClosing() {
        this.showEntry(null);
    }

    public void setUserPreferences(Map<String, Object> loadedPrefMap) {
        if (loadedPrefMap != null) {
            // empty if block
        }
    }

    public Map<String, Object> getUserPreferences() {
        return null;
    }

    public void updateLocale() {
        this.setBorder(new TitledBorder(LexiconGuiResources.getLocalizedString("LexiconComponent.Entry.Entry", "Lexical Entry")));
    }

    public void initNewEntry() {
        if (this.templateEntryData == null) {
            this.createTemplateEntryData();
        }
        try {
            EntryImpl nextEntry = this.lexHandler.createNewEntry(this.templateEntryData);
            this.showEntry(nextEntry);
        }
        catch (LexiconStructureException lse) {
            JOptionPane.showMessageDialog(this, LexiconGuiResources.getLocalizedString("LexiconComponent.Entry.Warning.Create", "Could not create a new entry:") + "/n" + lse.getMessage(), LexiconGuiResources.getLocalizedString("Message.Warning", "Warning"), 2);
        }
        catch (LexiconNotFoundException e) {
            JOptionPane.showMessageDialog(this, LexiconGuiResources.getLocalizedString("LexiconComponent.Entry.Warning.Create", "Could not create a new entry:") + "/n" + e.getMessage(), LexiconGuiResources.getLocalizedString("Message.Warning", "Warning"), 2);
        }
    }

    public void showEntry(EntryImpl entry) {
        this.editEntryPanel.setEntry(entry);
    }

    private void createTemplateEntryData() {
        this.templateEntryData = new HashMap<LexiconFields, String>();
        this.templateEntryData.put(LexiconFields.ENTRY_LEX_UNIT, "new_unit");
        this.templateEntryData.put(LexiconFields.ENTRY_MORPH_TYPE, "new_type");
        this.templateEntryData.put(LexiconFields.SENSE_GRAM_CAT, "new_cat");
        this.templateEntryData.put(LexiconFields.SENSE_GLOSS, "new_gloss");
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (this.editEntryPanel != null) {
            this.editEntryPanel.processKeyEvent(e);
        } else {
            super.processKeyEvent(e);
        }
    }
}

