/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableRowSorter;
import nl.mpi.lexiconcomponent.exceptions.LexiconNotFoundException;
import nl.mpi.lexiconcomponent.gui.LexiconGuiConstants;
import nl.mpi.lexiconcomponent.gui.LexiconGuiResources;
import nl.mpi.lexiconcomponent.gui.LexiconHandler;
import nl.mpi.lexiconcomponent.gui.LexiconRootPanel;
import nl.mpi.lexiconcomponent.gui.LexiconViewManager;
import nl.mpi.lexiconcomponent.gui.table.EntryTableModel2;
import nl.mpi.lexiconcomponent.gui.table.TableColumnDescriptor;
import nl.mpi.lexiconcomponent.impl.EntryImpl;
import nl.mpi.lexiconcomponent.impl.LexiconImpl;
import nl.mpi.lexiconcomponent.util.LexiconLogger;

public class LexEditRootPanel
extends LexiconRootPanel {
    private JMenuBar lexiconMenuBar;
    private JMenu lexiconViewMenu;
    private JMenu lexiconEditMenu;
    private JMenu lexiconFileMenu;
    private JMenuItem newLexiconMI;
    private JMenuItem openLexiconMI;
    private JMenuItem closeLexiconMI;
    private JMenuItem saveLexiconMI;
    private JMenuItem saveAsLexiconMI;
    private JMenuItem saveCurOrderMI;
    private JMenuItem editPropertiesMI;
    private JMenuItem importLexiconMI;
    private JMenuItem exportLexiconMI;
    private JLabel nameLabel;
    private JLabel curNameLabel;
    private JLabel savedStateLabel;
    private JPanel filterPanel;
    private JLabel filterLabel;
    private JTextField filterField;
    private JButton clearFieldButton;
    private JLabel columnLabel;
    private JComboBox<String> columnNameBox;
    private LexEntryRowFilter<EntryTableModel2, Integer> rowFilter;
    private String allColumnsString;
    private JButton addButton;
    private JButton removeButton;
    private LexiconSelectionListener lexSelectionListener;
    private TableModelChangeListener tableModelChangeListener;
    private ACListener actListener;
    private FilterKeyListener filterKeyListener;

    public LexEditRootPanel(LexiconHandler lexiconHandler) {
        super(lexiconHandler);
        if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
            LexiconLogger.LEXLOG.fine(String.format("Constructor of %s, param type %s", this.getClass().getName(), LexiconHandler.class.getName()));
        }
        this.initListeners();
        this.initComponents();
    }

    public LexEditRootPanel(LexiconViewManager lexViewManager) {
        super(lexViewManager);
        if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
            LexiconLogger.LEXLOG.fine(String.format("Constructor of %s, param type %s", this.getClass().getName(), LexiconViewManager.class.getName()));
        }
        this.initListeners();
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.getMenuBar();
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.lexSelectionListener = new LexiconSelectionListener();
        this.tableModelChangeListener = new TableModelChangeListener();
        this.actListener = new ACListener();
        this.filterKeyListener = new FilterKeyListener();
    }

    @Override
    public void isClosing() {
        if (this.lexHandler.isLexiconChanged()) {
            int option = JOptionPane.showConfirmDialog(this, LexiconGuiResources.getLocalizedString("LexiconComponent.Message.SaveChanges", "The lexicon has unsaved changes, save the changes?"), "", 0, 3);
            if (option == 0) {
                this.lexHandler.saveLexicon();
            }
            this.lexHandler.closeLexicon();
        }
    }

    @Override
    public void setUserPreferences(Map<String, Object> loadedPrefMap) {
        if (loadedPrefMap != null) {
            Map storedVisColsMap;
            if (this.preferencesMap == null) {
                this.preferencesMap = new HashMap<String, Object>(loadedPrefMap);
            } else {
                this.preferencesMap.putAll(loadedPrefMap);
            }
            String selLex = (String)this.preferencesMap.get("LexiconPanel.SelectedLexicon");
            if (selLex != null && !selLex.equals("none")) {
                this.selectLexicon(selLex);
            }
            if ((storedVisColsMap = (Map)this.preferencesMap.get("LexiconPanel.VisibleColumnsMap")) != null) {
                List visColumns;
                this.visibleColumnsMap.putAll(storedVisColsMap);
                if (selLex != null && (visColumns = (List)this.visibleColumnsMap.get(selLex)) != null) {
                    this.setVisibleColumns(visColumns);
                }
            }
            this.restoreTableSortOrder(selLex);
        }
    }

    @Override
    public Map<String, Object> getUserPreferences() {
        if (this.preferencesMap == null) {
            this.preferencesMap = new HashMap();
        }
        if (this.lexHandler.getCurrentLexicon() == null) {
            this.preferencesMap.put("LexiconPanel.SelectedLexicon", "none");
        } else {
            this.preferencesMap.put("LexiconPanel.SelectedLexicon", this.lexHandler.getCurrentLexicon().getHeader().getName());
            this.visibleColumnsMap.put(this.lexHandler.getCurrentLexicon().getHeader().getName(), this.getVisibleColumns());
            this.preferencesMap.put("LexiconPanel.VisibleColumnsMap", this.visibleColumnsMap);
            this.storeTableSortOrder(this.lexHandler.getCurrentLexicon().getHeader().getName());
        }
        return this.preferencesMap;
    }

    @Override
    public void updateLocale() {
        this.addButton.setText(LexiconGuiResources.getLocalizedString("Button.Add", "Add"));
        this.removeButton.setText(LexiconGuiResources.getLocalizedString("Button.Remove", "Remove"));
        this.tablePanel.setBorder(new TitledBorder(LexiconGuiResources.getLocalizedString("LexiconComponent.Entry.Entries", "Lexical Entries")));
        this.nameLabel.setText(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Name", "Lexicon Name"));
    }

    @Override
    protected JPanel getTopWidgetPanel() {
        if (this.topWidgetPanel == null) {
            this.topWidgetPanel = new JPanel(new GridBagLayout());
            this.nameLabel = new JLabel(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Name", "Lexicon Name"));
            this.savedStateLabel = new JLabel("");
            this.curNameLabel = new JLabel("-");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 4, 2, 4);
            gbc.anchor = 18;
            this.topWidgetPanel.add((Component)this.nameLabel, gbc);
            gbc.gridx = 1;
            gbc.insets = new Insets(2, 4, 2, 0);
            this.topWidgetPanel.add((Component)this.savedStateLabel, gbc);
            gbc.gridx = 2;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 0, 2, 4);
            this.topWidgetPanel.add((Component)this.curNameLabel, gbc);
            this.topWidgetPanel.setBorder(new TitledBorder(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon", "Lexicon")));
            if (this.lexHandler.getCurrentLexicon() != null) {
                this.curNameLabel.setText(this.lexHandler.getCurrentLexicon().getHeader().getName());
            }
            this.savedStateLabel.setForeground(LexiconGuiConstants.MODIFIED_FG_COLOR);
            this.filterPanel = new JPanel(new GridBagLayout());
            this.filterLabel = new JLabel(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.FilterEntries", "Filter Entries"));
            this.filterField = new JTextField(6);
            this.filterField.addKeyListener(this.filterKeyListener);
            this.clearFieldButton = new JButton(LexiconGuiResources.getLocalizedString("Button.Reset", "Reset"));
            this.clearFieldButton.setActionCommand("X");
            this.clearFieldButton.addActionListener(this.actListener);
            this.columnLabel = new JLabel(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.FilterColumn", "Column"));
            this.allColumnsString = LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.FilterAllColumns", "All columns");
            this.columnNameBox = new JComboBox<String>(new String[]{this.allColumnsString});
            this.columnNameBox.addActionListener(this.actListener);
            GridBagConstraints fgbc = new GridBagConstraints();
            fgbc.anchor = 17;
            fgbc.insets = new Insets(2, 4, 2, 4);
            this.filterPanel.add((Component)this.filterLabel, fgbc);
            fgbc.gridx = 1;
            fgbc.weightx = 0.8;
            fgbc.fill = 2;
            this.filterPanel.add((Component)this.filterField, fgbc);
            fgbc.gridx = 2;
            fgbc.weightx = 0.0;
            fgbc.fill = 0;
            fgbc.insets = new Insets(2, 1, 2, 4);
            this.filterPanel.add((Component)this.clearFieldButton, fgbc);
            fgbc.gridx = 3;
            fgbc.insets = new Insets(2, 4, 2, 4);
            this.filterPanel.add((Component)this.columnLabel, fgbc);
            fgbc.gridx = 4;
            this.filterPanel.add(this.columnNameBox, fgbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 3;
            this.topWidgetPanel.add((Component)this.filterPanel, gbc);
        }
        return this.topWidgetPanel;
    }

    @Override
    protected JPanel getBottomWidgetPanel() {
        if (this.bottomWidgetPanel == null) {
            this.bottomWidgetPanel = new JPanel();
            this.bottomWidgetPanel.setLayout(new BoxLayout(this.bottomWidgetPanel, 2));
            this.addButton = new JButton();
            this.addButton.setActionCommand(this.menuListener.ADD_ENTRY);
            this.removeButton = new JButton();
            this.removeButton.setActionCommand(this.menuListener.REMOVE_ENTRY);
            this.bottomWidgetPanel.add(this.addButton);
            this.bottomWidgetPanel.add(Box.createHorizontalStrut(4));
            this.bottomWidgetPanel.add(this.removeButton);
            this.addButton.addActionListener(this.menuListener);
            this.removeButton.addActionListener(this.menuListener);
            this.entrySelectionChanged(null);
        }
        return this.bottomWidgetPanel;
    }

    public JMenuBar getMenuBar() {
        if (this.lexiconMenuBar == null) {
            this.lexiconMenuBar = new JMenuBar();
            this.lexiconFileMenu = new JMenu(LexiconGuiResources.getLocalizedString("Menu.File", "File"));
            this.lexiconMenuBar.add(this.lexiconFileMenu);
            this.lexiconEditMenu = new JMenu(LexiconGuiResources.getLocalizedString("Menu.Edit", "Edit"));
            this.lexiconMenuBar.add(this.lexiconEditMenu);
            this.lexiconViewMenu = new JMenu(LexiconGuiResources.getLocalizedString("Menu.View", "View"));
            this.lexiconMenuBar.add(this.lexiconViewMenu);
            this.newLexiconMI = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.New", "New Lexicon..."), this.menuListener.NEW_LEX_AC, this.menuListener);
            this.lexiconFileMenu.add(this.newLexiconMI);
            this.openLexiconMI = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Open", "Open Lexicon..."), this.menuListener.OPEN_LEX_AC, this.menuListener);
            this.lexiconFileMenu.add(this.openLexiconMI);
            this.closeLexiconMI = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Close", "Close Lexicon"), this.menuListener.CLOSE_LEX_AC, this.menuListener);
            this.lexiconFileMenu.add(this.closeLexiconMI);
            this.lexiconFileMenu.addSeparator();
            this.saveLexiconMI = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Save", "Save Lexicon"), this.menuListener.SAVE_LEX_AC, this.menuListener);
            this.lexiconFileMenu.add(this.saveLexiconMI);
            this.saveAsLexiconMI = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.SaveAs", "Save Lexicon as..."), this.menuListener.SAVE_AS_LEX_AC, this.menuListener);
            this.lexiconFileMenu.add(this.saveAsLexiconMI);
            this.saveCurOrderMI = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.SaveOrder", "Save Lexicon in Current Order"), this.menuListener.SAVE_LEX_ORDER_AC, this.menuListener);
            this.lexiconFileMenu.add(this.saveCurOrderMI);
            this.lexiconFileMenu.addSeparator();
            this.importLexiconMI = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import", "Import Lexicon..."), this.menuListener.IMPORT_LEX_AC, this.menuListener);
            this.lexiconFileMenu.add(this.importLexiconMI);
            this.exportLexiconMI = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Export", "Export Lexicon..."), this.menuListener.EXPORT_LEX_AC, this.menuListener);
            this.lexiconFileMenu.add(this.exportLexiconMI);
            this.editPropertiesMI = this.createMenuItem(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit", "Edit Lexicon Properties..."), this.menuListener.EDIT_LEX_AC, this.menuListener);
            this.lexiconEditMenu.add(this.editPropertiesMI);
            this.fillLexiconMenu();
        }
        return this.lexiconMenuBar;
    }

    private void fillLexiconMenu() {
        List<String> availableNames = this.lexHandler.getAvailableLexiconNames();
        ArrayList<String> allNamesList = new ArrayList<String>();
        if (availableNames != null) {
            allNamesList.addAll(availableNames);
        }
        Collections.sort(allNamesList);
        for (String ln : allNamesList) {
            JMenuItem lnItem = new JMenuItem(ln);
            this.lexiconViewMenu.add(lnItem);
            lnItem.addActionListener(this.lexSelectionListener);
        }
    }

    private JMenuItem createMenuItem(String label, String action, ActionListener al) {
        JMenuItem mi = new JMenuItem(label);
        mi.setActionCommand(action);
        mi.addActionListener(al);
        return mi;
    }

    private boolean unloadLexicon() {
        if (this.lexHandler.getCurrentLexicon() != null) {
            List<String> visColumns;
            if (this.lexHandler.isLexiconChanged()) {
                int option = JOptionPane.showConfirmDialog(this, LexiconGuiResources.getLocalizedString("LexiconComponent.Message.SaveChanges", "The lexicon has unsaved changes, save the changes?"), "", 1, 3);
                if (option == 2) {
                    return false;
                }
                if (option == 0) {
                    this.lexHandler.saveLexicon();
                }
            }
            if ((visColumns = this.getVisibleColumns()) != null) {
                this.visibleColumnsMap.put(this.lexHandler.getCurrentLexicon().getHeader().getName(), visColumns);
            }
            this.storeTableSortOrder(this.lexHandler.getCurrentLexicon().getHeader().getName());
            this.lexHandler.getCurrentLexicon().removeLexiconEditListener(this.entryModel);
            this.lexHandler.getCurrentLexicon().removeLexiconEditListener(this.lexChangeListener);
            this.editEntry(null);
            this.lexHandler.closeLexicon();
        }
        return true;
    }

    private void updateFilterUI() {
        if (this.topWidgetPanel != null) {
            this.filterField.setText("");
            this.columnNameBox.setSelectedIndex(0);
            boolean active = this.entryModel != null;
            this.filterField.setEnabled(active);
            this.columnNameBox.setEnabled(active);
            this.clearFieldButton.setEnabled(active);
        }
    }

    private void updateColumnNameBox() {
        if (this.topWidgetPanel != null) {
            this.columnNameBox.removeAllItems();
            this.columnNameBox.addItem(this.allColumnsString);
            List<String> nextVisColumns = this.getVisibleColumns();
            if (nextVisColumns != null) {
                for (String s : nextVisColumns) {
                    this.columnNameBox.addItem(s);
                }
            }
        }
    }

    private void applyRowFilter() {
        if (this.topWidgetPanel != null && this.entryTable != null) {
            String filter = this.filterField.getText().strip();
            if (filter.isEmpty()) {
                ((TableRowSorter)this.entryTable.getRowSorter()).setRowFilter(null);
            } else {
                int columnIndex = this.columnNameBox.getSelectedIndex() - 1;
                if (this.rowFilter != null) {
                    this.rowFilter.updateFilter(filter, columnIndex);
                    ((TableRowSorter)this.entryTable.getRowSorter()).sort();
                } else {
                    this.rowFilter = new LexEntryRowFilter(filter, columnIndex);
                    ((TableRowSorter)this.entryTable.getRowSorter()).setRowFilter(this.rowFilter);
                }
            }
        }
    }

    @Override
    protected void replaceTableModel(EntryTableModel2 nextModel) {
        if (this.entryModel != null) {
            this.entryModel.removeTableModelListener(this.tableModelChangeListener);
        }
        if (this.entryTable != null) {
            this.entryTable.getColumnModel().removeColumnModelListener(this.tableModelChangeListener);
        }
        super.replaceTableModel(nextModel);
        if (this.entryModel != null) {
            this.entryModel.addTableModelListener(this.tableModelChangeListener);
        }
        if (this.entryTable != null) {
            this.entryTable.getColumnModel().addColumnModelListener(this.tableModelChangeListener);
        }
        this.updateFilterUI();
        this.applyRowFilter();
    }

    @Override
    protected void closeLexicon() {
        if (this.unloadLexicon()) {
            EntryTableModel2 nextEntryModel = new EntryTableModel2(null, null);
            this.replaceTableModel(nextEntryModel);
            this.curNameLabel.setText("-");
            this.setChangedStateOfLexicon("-", false);
            if (this.bottomWidgetPanel != null) {
                this.entrySelectionChanged(null);
            }
        }
    }

    @Override
    protected void createNewEntry() {
        this.lexViewManager.initNewEntry();
    }

    @Override
    void removeEntryRow(int row) {
        int numEntries = this.entryModel.getRowCount();
        super.removeEntryRow(row);
        if (numEntries > this.entryModel.getRowCount()) {
            this.editEntry(null);
        }
    }

    @Override
    protected void editEntry(EntryImpl curEntry) {
        this.lexViewManager.editEntry(curEntry);
    }

    @Override
    protected void entrySelectionChanged(ListSelectionEvent e) {
        if (this.lexHandler.getCurrentLexicon() == null) {
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
            int row = this.entryTable.getSelectedRow();
            this.removeButton.setEnabled(row >= 0 && row < this.entryTable.getRowCount());
            this.editEntryRow(row);
        }
    }

    @Override
    protected void addAndSelectLexicon(String lexiconName) {
        if (lexiconName != null) {
            JMenuItem openLexMI = new JMenuItem(lexiconName);
            this.lexiconViewMenu.add(openLexMI);
            openLexMI.doClick();
        }
    }

    @Override
    protected void updateLexiconName(String oldName, String newName) {
        if (oldName == null || newName == null) {
            return;
        }
        for (Component c : this.lexiconViewMenu.getMenuComponents()) {
            String curTExt;
            if (!(c instanceof JMenuItem) || !oldName.equals(curTExt = ((JMenuItem)c).getText())) continue;
            ((JMenuItem)c).setText(newName);
            break;
        }
        if (oldName.equals(this.curNameLabel.getText())) {
            this.curNameLabel.setText(newName);
        }
    }

    @Override
    protected void setChangedStateOfLexicon(String name, boolean changed) {
        if (name.equals(this.curNameLabel.getText())) {
            if (changed) {
                this.curNameLabel.setForeground(LexiconGuiConstants.MODIFIED_FG_COLOR);
                this.savedStateLabel.setText("*");
            } else {
                this.curNameLabel.setForeground(this.nameLabel.getForeground());
                this.savedStateLabel.setText("");
            }
        }
    }

    private void selectLexicon(String nextLexiconName) {
        block8: {
            if (this.lexHandler.getCurrentLexicon() != null && this.entryModel != null) {
                if (this.lexHandler.getCurrentLexicon().getHeader().getName().equals(nextLexiconName)) {
                    return;
                }
                if (!this.unloadLexicon()) {
                    return;
                }
            }
            if (nextLexiconName != null) {
                List<TableColumnDescriptor> currentColumns = null;
                if (this.entryModel != null) {
                    currentColumns = this.entryModel.getColumnDescriptors();
                }
                try {
                    LexiconImpl nextLexicon = this.lexHandler.loadLexicon(nextLexiconName);
                    EntryTableModel2 nextEntryModel = new EntryTableModel2(nextLexicon, currentColumns);
                    this.replaceTableModel(nextEntryModel);
                    nextLexicon.addLexiconEditListener(this.lexChangeListener);
                    List visColumns = (List)this.visibleColumnsMap.get(nextLexicon.getHeader().getName());
                    this.setVisibleColumns(visColumns);
                    this.restoreTableSortOrder(nextLexiconName);
                    this.curNameLabel.setText(nextLexiconName);
                    this.setChangedStateOfLexicon(nextLexiconName, nextLexicon.isChanged());
                }
                catch (LexiconNotFoundException lnfe) {
                    this.showMessage(String.format(LexiconGuiResources.getLocalizedString("LexiconComponent.Warning.LoadError", "Could not load the lexicon by the name %s"), nextLexiconName), "", 1);
                    if (!LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) break block8;
                    LexiconLogger.LEXLOG.warning(String.format("Could not load the lexicon by the name %s", nextLexiconName));
                }
            }
        }
        if (this.bottomWidgetPanel != null) {
            this.entrySelectionChanged(null);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
            if (this.entryTable != null && this.entryTable.getRowCount() > 0) {
                int row = this.entryTable.getSelectedRow();
                if (e.getKeyCode() == 40) {
                    if (++row >= 0 && row < this.entryTable.getRowCount()) {
                        if (this.entryTable.getCellEditor() != null) {
                            this.entryTable.getCellEditor().stopCellEditing();
                        }
                        this.entryTable.setRowSelectionInterval(row, row);
                        this.entryTable.scrollRectToVisible(this.entryTable.getCellRect(this.entryTable.getSelectedRow(), 0, true));
                    }
                    return;
                }
                if (e.getKeyCode() == 38) {
                    if (--row >= 0 && row < this.entryTable.getRowCount()) {
                        if (this.entryTable.getCellEditor() != null) {
                            this.entryTable.getCellEditor().stopCellEditing();
                        }
                        this.entryTable.setRowSelectionInterval(row, row);
                        this.entryTable.scrollRectToVisible(this.entryTable.getCellRect(this.entryTable.getSelectedRow(), 0, true));
                    }
                    return;
                }
            }
        } else if (e.getKeyCode() == 10 && this.entryTable != null && this.entryTable.getCellEditor() != null) {
            this.entryTable.getCellEditor().stopCellEditing();
        }
        super.processKeyEvent(e);
    }

    class LexiconSelectionListener
    implements ActionListener {
        LexiconSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LexEditRootPanel.this.selectLexicon(e.getActionCommand());
        }
    }

    class TableModelChangeListener
    implements TableModelListener,
    TableColumnModelListener {
        TableModelChangeListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            LexEditRootPanel.this.updateColumnNameBox();
            LexEditRootPanel.this.updateFilterUI();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            LexEditRootPanel.this.updateColumnNameBox();
            LexEditRootPanel.this.updateFilterUI();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            LexEditRootPanel.this.updateFilterUI();
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            LexEditRootPanel.this.updateFilterUI();
        }
    }

    class ACListener
    implements ActionListener {
        ACListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("X")) {
                LexEditRootPanel.this.filterField.setText("");
                LexEditRootPanel.this.applyRowFilter();
            }
            if (e.getSource() == LexEditRootPanel.this.columnNameBox) {
                LexEditRootPanel.this.applyRowFilter();
            }
        }
    }

    private class FilterKeyListener
    implements KeyListener {
        private FilterKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                LexEditRootPanel.this.applyRowFilter();
            }
        }
    }

    private class LexEntryRowFilter<M, I>
    extends RowFilter<M, I> {
        private Pattern p;
        private int colIndex;

        public LexEntryRowFilter() {
            this.colIndex = -1;
        }

        public LexEntryRowFilter(String regex, int colIndex) {
            this.updateFilter(regex, colIndex);
        }

        void updateFilter(String regex, int colIndex) {
            if (this.colIndex == colIndex && this.p != null && this.p.pattern().equals(regex)) {
                return;
            }
            this.colIndex = colIndex;
            try {
                this.p = Pattern.compile(regex);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }

        @Override
        public boolean include(RowFilter.Entry<? extends M, ? extends I> entry) {
            if (this.p == null) {
                return true;
            }
            if (this.colIndex < 0) {
                for (int i = 0; i < entry.getValueCount(); ++i) {
                    if (entry.getStringValue(i).startsWith("[")) {
                        String[] subValues = this.getValues(entry.getStringValue(i));
                        if (subValues == null) continue;
                        for (String sv : subValues) {
                            if (!this.p.matcher(sv).find()) continue;
                            return true;
                        }
                        continue;
                    }
                    if (!this.p.matcher(entry.getStringValue(i)).find()) continue;
                    return true;
                }
            } else if (this.colIndex < entry.getValueCount()) {
                if (entry.getStringValue(this.colIndex).startsWith("[")) {
                    String[] subValues = this.getValues(entry.getStringValue(this.colIndex));
                    if (subValues != null) {
                        for (String sv : subValues) {
                            if (!this.p.matcher(sv).find()) continue;
                            return true;
                        }
                    }
                } else {
                    return this.p.matcher(entry.getStringValue(this.colIndex)).find();
                }
            }
            return false;
        }

        private String[] getValues(String compoundValue) {
            if (compoundValue == null) {
                return null;
            }
            if (compoundValue.startsWith("[")) {
                return compoundValue.split("[\\[\\]]");
            }
            return null;
        }
    }
}

