/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import nl.mpi.lexiconcomponent.gui.LexiconEditorPanel;
import nl.mpi.lexiconcomponent.gui.LexiconGuiResources;
import nl.mpi.lexiconcomponent.gui.LexiconViewManager;

public class LexiconEditorDialog
extends JDialog {
    private LexiconEditorPanel editorPanel;
    private LexiconViewManager lexViewManager;
    private KeyDispatcher keyDispatcher;
    private CloseHandler windowCloseHandler;
    private JMenuItem closeMI;

    public LexiconEditorDialog(Window owner, Dialog.ModalityType modalityType, LexiconViewManager lexViewManager) {
        super(owner, modalityType);
        this.lexViewManager = lexViewManager;
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Editor", "Lexicon Editor"));
        this.editorPanel = this.lexViewManager.getLexiconEditorPanel();
        this.closeMI = new JMenuItem(LexiconGuiResources.getLocalizedString("Button.Close", "Close"));
        if (this.editorPanel != null) {
            this.setContentPane(this.editorPanel);
            this.setJMenuBar(this.editorPanel.getMenuBar());
            if (this.getJMenuBar() != null && this.getJMenuBar().getMenuCount() > 0) {
                this.getJMenuBar().getMenu(0).addSeparator();
                this.getJMenuBar().getMenu(0).add(this.closeMI);
            }
        }
        this.pack();
        this.setMinimumSize(new Dimension(500, 400));
        this.setLocationRelativeTo(this.getParent());
        this.windowCloseHandler = new CloseHandler();
        this.addWindowListener(this.windowCloseHandler);
        this.closeMI.addActionListener(this.windowCloseHandler);
        this.keyDispatcher = new KeyDispatcher();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyDispatcher);
    }

    private void isClosing() {
        if (this.editorPanel != null) {
            if (this.editorPanel.getMenuBar() != null) {
                // empty if block
            }
            if (this.getJMenuBar() != null && this.getJMenuBar().getMenuCount() > 0) {
                this.getJMenuBar().getMenu(0).remove(this.closeMI);
                this.getJMenuBar().getMenu(0).remove(this.getJMenuBar().getMenu(0).getItemCount() - 1);
            }
            this.editorPanel.isClosing();
        }
    }

    private void doClose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyDispatcher);
        this.setVisible(false);
        this.dispose();
    }

    class CloseHandler
    extends WindowAdapter
    implements ActionListener {
        CloseHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            LexiconEditorDialog.this.isClosing();
            LexiconEditorDialog.this.doClose();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LexiconEditorDialog.this.isClosing();
            LexiconEditorDialog.this.doClose();
        }
    }

    class KeyDispatcher
    implements KeyEventDispatcher {
        final int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();

        KeyDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (LexiconEditorDialog.this.getFocusOwner() instanceof JRootPane) {
                return false;
            }
            if (e.getKeyCode() == 27 && e.getID() == 401 || e.getKeyCode() == 87 && e.getID() == 401 && e.getModifiersEx() == this.menuShortcutKeyMask) {
                LexiconEditorDialog.this.isClosing();
                LexiconEditorDialog.this.doClose();
                return true;
            }
            if (e.getKeyCode() == 9 && e.getID() == 401 || e.getKeyCode() == 61 && e.getID() == 401) {
                LexiconEditorDialog.this.editorPanel.processKeyEvent(e);
                return true;
            }
            if (e.getKeyCode() == 10 && e.getID() == 401) {
                LexiconEditorDialog.this.editorPanel.processKeyEvent(e, LexiconEditorDialog.this.getFocusOwner());
                return true;
            }
            if (e.getKeyCode() == 40 && e.getID() == 401 || e.getKeyCode() == 38 && e.getID() == 401) {
                LexiconEditorDialog.this.editorPanel.processKeyEvent(e);
                return true;
            }
            return false;
        }
    }
}

