/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import nl.mpi.lexiconcomponent.gui.EntryEditRootPanel;
import nl.mpi.lexiconcomponent.gui.LexEditRootPanel;
import nl.mpi.lexiconcomponent.gui.LexiconViewManager;

public class LexiconEditorPanel
extends JPanel {
    private JSplitPane leftRightSplitPane;
    private LexEditRootPanel lexiconRootPanel;
    private LexiconViewManager lexViewManager;
    private EntryEditRootPanel entryRootPanel;
    protected Map<String, Object> preferencesMap;
    protected final String DIVIDER_LOC_KEY = "LexiconEditor.DividerLocation";

    public LexiconEditorPanel(LexiconViewManager lexViewManager) {
        this.lexViewManager = lexViewManager;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.leftRightSplitPane = new JSplitPane(1);
        this.lexiconRootPanel = (LexEditRootPanel)this.lexViewManager.getLexiconRootPanel(LexiconViewManager.LAYOUT_MODE.EXPANDED);
        this.entryRootPanel = this.lexViewManager.getEntryRootPanel();
        this.leftRightSplitPane.setLeftComponent(this.lexiconRootPanel);
        this.leftRightSplitPane.setRightComponent(this.entryRootPanel);
        this.leftRightSplitPane.setDividerLocation(0.5);
        this.leftRightSplitPane.setOneTouchExpandable(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.leftRightSplitPane, gbc);
    }

    public JMenuBar getMenuBar() {
        if (this.lexiconRootPanel != null) {
            return this.lexiconRootPanel.getMenuBar();
        }
        return null;
    }

    public void isClosing() {
        if (this.entryRootPanel != null) {
            this.entryRootPanel.isClosing();
        }
        if (this.lexiconRootPanel != null) {
            this.lexiconRootPanel.isClosing();
        }
    }

    public void setUserPreferences(Map<String, Object> loadedPrefMap) {
        if (loadedPrefMap != null) {
            double nextLoc;
            Object divLocObj;
            if (this.preferencesMap == null) {
                this.preferencesMap = new HashMap<String, Object>(loadedPrefMap);
            } else {
                this.preferencesMap.putAll(loadedPrefMap);
            }
            if (this.lexiconRootPanel != null) {
                this.lexiconRootPanel.setUserPreferences(this.preferencesMap);
            }
            if (this.entryRootPanel != null) {
                this.entryRootPanel.setUserPreferences(this.preferencesMap);
            }
            if ((divLocObj = this.preferencesMap.get("LexiconEditor.DividerLocation")) instanceof Double && (nextLoc = ((Double)divLocObj).doubleValue()) >= 0.0 && nextLoc <= 1.0) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LexiconEditorPanel.this.leftRightSplitPane.setDividerLocation(nextLoc);
                    }
                });
            }
        }
    }

    public Map<String, Object> getUserPreferences() {
        Map<String, Object> entryEditMap;
        Map<String, Object> lexEditMap;
        HashMap<String, Object> preferencesMap = new HashMap<String, Object>();
        if (this.lexiconRootPanel != null && (lexEditMap = this.lexiconRootPanel.getUserPreferences()) != null) {
            preferencesMap.putAll(lexEditMap);
        }
        if (this.entryRootPanel != null && (entryEditMap = this.entryRootPanel.getUserPreferences()) != null) {
            preferencesMap.putAll(entryEditMap);
        }
        preferencesMap.put("LexiconEditor.DividerLocation", (double)this.leftRightSplitPane.getDividerLocation() / (double)this.leftRightSplitPane.getMaximumDividerLocation());
        if (!preferencesMap.isEmpty()) {
            return preferencesMap;
        }
        return null;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (this.entryRootPanel == null && this.lexiconRootPanel == null) {
            super.processKeyEvent(e);
            return;
        }
        if (e.getKeyCode() == 9 || e.getKeyCode() == 61 || e.getKeyCode() == 10) {
            this.entryRootPanel.processKeyEvent(e);
            return;
        }
        if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
            this.lexiconRootPanel.processKeyEvent(e);
            return;
        }
        super.processKeyEvent(e);
    }

    protected void processKeyEvent(KeyEvent e, Component focusOwner) {
        if (focusOwner != null) {
            if (this.lexiconRootPanel != null && this.lexiconRootPanel.isAncestorOf(focusOwner)) {
                this.lexiconRootPanel.processKeyEvent(e);
                return;
            }
            if (this.entryRootPanel != null && this.entryRootPanel.isAncestorOf(focusOwner)) {
                this.entryRootPanel.processKeyEvent(e);
                return;
            }
        } else {
            this.processKeyEvent(e);
        }
    }
}

