/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui;

import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.transform.TransformerException;
import nl.mpi.lexiconcomponent.exceptions.LexiconConversionException;
import nl.mpi.lexiconcomponent.exceptions.LexiconNotFoundException;
import nl.mpi.lexiconcomponent.exceptions.LexiconNotSavedException;
import nl.mpi.lexiconcomponent.exceptions.LexiconStructureException;
import nl.mpi.lexiconcomponent.impl.EntryImpl;
import nl.mpi.lexiconcomponent.impl.HeaderImpl;
import nl.mpi.lexiconcomponent.impl.LexiconContext;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.impl.LexiconImpl;
import nl.mpi.lexiconcomponent.impl.SenseImpl;
import nl.mpi.lexiconcomponent.model.CustomFieldSpec;
import nl.mpi.lexiconcomponent.model.CustomFieldSpecification;
import nl.mpi.lexiconcomponent.model.Header;
import nl.mpi.lexiconcomponent.util.EntryFieldTriplet;
import nl.mpi.lexiconcomponent.util.LexiconConverter;
import nl.mpi.lexiconcomponent.util.LexiconLogger;
import nl.mpi.lexiconcomponent.util.toolbox.ImportToolboxDictDialog;
import nl.mpi.lexiconcomponent.util.toolbox.ToolboxConverter;
import nl.mpi.lexiconcomponent.util.toolbox.ToolboxDictDecodeInfo;

public class LexiconHandler {
    private String folderName = null;
    private File lexiconFolder = null;
    private String lexiconName = null;
    boolean canChangeLexiconFlag = false;
    private List<String> availableLexiconNames;
    private LexiconImpl curLexicon = null;

    public LexiconHandler(String lexFolderName, String lexName, boolean canChangeLexicon) {
        this.folderName = lexFolderName;
        this.lexiconName = lexName;
        this.canChangeLexiconFlag = canChangeLexicon;
        this.availableLexiconNames = new ArrayList<String>();
        if (!this.isValidDirectory(lexFolderName)) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning(String.format("The provided folder name does not refer to a valid folder: @s", lexFolderName));
            }
            return;
        }
        this.initAvailableLexiconList();
        if (lexName != null && !lexName.isEmpty()) {
            this.initLoadLexicon(lexName);
        }
    }

    private boolean isValidDirectory(String folderName) {
        if (folderName == null) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning("The lexicon folder name is null");
            }
            return false;
        }
        if (folderName.length() <= 0) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning("The lexicon folder name has zero characters");
            }
            return false;
        }
        File f = new File(folderName);
        try {
            if (!f.isDirectory()) {
                if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                    LexiconLogger.LEXLOG.warning("The lexicon folder name points to a file, not to a folder");
                }
                return false;
            }
            if (!f.canRead()) {
                if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                    LexiconLogger.LEXLOG.warning("No read access to the lexicon folder");
                }
                return false;
            }
            if (!f.canRead() || !f.canWrite()) {
                if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                    LexiconLogger.LEXLOG.warning("No write access to the lexicon folder");
                }
                return false;
            }
        }
        catch (Throwable t) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning(String.format("No access to the lexicon folder: %s", t.getMessage()));
            }
            return false;
        }
        this.lexiconFolder = f;
        return true;
    }

    private void initAvailableLexiconList() {
        if (this.lexiconFolder != null) {
            int numLexicons = LexiconContext.getInstance().loadLexiconsFromFolder(this.lexiconFolder);
            if (numLexicons > 0) {
                String[] candidates;
                for (String c : candidates = LexiconContext.getInstance().getAvailableLexicons()) {
                    if (this.availableLexiconNames.contains(c)) continue;
                    this.availableLexiconNames.add(c);
                }
            }
            if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
                LexiconLogger.LEXLOG.info(String.format("Found %d lexicons in the folder %s", numLexicons, this.lexiconFolder));
            }
        }
    }

    public List<String> getAvailableLexiconNames() {
        return this.availableLexiconNames;
    }

    private void initLoadLexicon(String lexName) {
        block2: {
            try {
                this.curLexicon = LexiconContext.getInstance().getLexicon(lexName);
            }
            catch (LexiconNotFoundException lnfe) {
                if (!LexiconLogger.LEXLOG.isLoggable(Level.INFO)) break block2;
                LexiconLogger.LEXLOG.info(String.format("Cannot load lexicon \"%s\", cause: %s", lexName, lnfe.getMessage()));
            }
        }
    }

    public LexiconImpl getCurrentLexicon() {
        return this.curLexicon;
    }

    public boolean isLexiconLoaded() {
        return this.curLexicon != null;
    }

    public boolean isLexiconChanged() {
        return this.curLexicon != null && this.curLexicon.isChanged();
    }

    protected void saveChangedLexicon() {
        block5: {
            if (this.isLexiconChanged()) {
                try {
                    LexiconContext.getInstance().saveLexicon(this.curLexicon);
                }
                catch (LexiconNotSavedException lnse) {
                    if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                        LexiconLogger.LEXLOG.warning(String.format("Cannot save the lexicon \"%s\": %s", this.lexiconName, lnse.getMessage()));
                    }
                }
                catch (Throwable t) {
                    if (!LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) break block5;
                    LexiconLogger.LEXLOG.warning(String.format("Cannot save the lexicon \"%s\": %s", this.lexiconName, t.getMessage()));
                }
            }
        }
    }

    public LexiconImpl loadLexicon(String folder, String lexName) {
        LexiconImpl impl;
        LexiconContext.getInstance().scanLexiconsFromFolder(new File(folder));
        try {
            impl = LexiconContext.getInstance().getLexicon(lexName);
            if (impl != null) {
                if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
                    LexiconLogger.LEXLOG.info(String.format("Loaded the lexicon named: %s", lexName));
                }
            } else if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning(String.format("Failed to load the lexicon named: %s", lexName));
            }
        }
        catch (Throwable e) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning(String.format("Failed to load the lexicon named: %s. Cause: %s", lexName, e.getMessage()));
            }
            return null;
        }
        return impl;
    }

    public LexiconImpl loadLexicon(String lexName) throws LexiconNotFoundException {
        LexiconImpl lexicon = LexiconContext.getInstance().getLexicon(lexName);
        this.closeLexicon();
        this.curLexicon = lexicon;
        this.lexiconName = lexName;
        return this.curLexicon;
    }

    public void editLexiconProperties(Map<String, String> lexProperties) throws LexiconStructureException {
        if (lexProperties != null && this.curLexicon != null) {
            String author;
            String version;
            String descript;
            String langField;
            boolean changed = false;
            Header header = this.curLexicon.getHeader();
            String curName = header.getName();
            String lexiconName = lexProperties.get(LexiconFields.HEADER_NAME.getFieldName());
            if (lexiconName != null && !lexiconName.isEmpty() && !lexiconName.equals(curName)) {
                header.setName(lexiconName);
                changed = true;
            }
            if ((langField = lexProperties.get(LexiconFields.HEADER_LANG.getFieldName())) != null && !langField.isEmpty() && !langField.equals(header.getLanguage())) {
                header.setLanguage(langField);
                changed = true;
            }
            if ((descript = lexProperties.get(LexiconFields.HEADER_DESC.getFieldName())) != null) {
                if (!descript.equals(header.getDescription())) {
                    header.setDescription(descript);
                    changed = true;
                }
            } else if (header.getDescription() != null) {
                header.setDescription(null);
                changed = true;
            }
            if ((version = lexProperties.get(LexiconFields.HEADER_VERSION.getFieldName())) != null) {
                if (!version.equals(header.getVersion())) {
                    header.setVersion(version);
                    changed = true;
                }
            } else if (header.getVersion() != null) {
                header.setVersion(version);
            }
            if ((author = lexProperties.get(LexiconFields.HEADER_AUTHOR.getFieldName())) != null && !author.isEmpty()) {
                String[] authors = author.split(",");
                if (header.getAuthor().size() != authors.length) {
                    header.getAuthor().clear();
                    for (String au : authors) {
                        header.getAuthor().add(au.trim());
                    }
                    changed = true;
                } else {
                    boolean sameOrder = true;
                    for (int i = 0; i < authors.length; ++i) {
                        if (header.getAuthor().get(i).equals(authors[i].trim())) continue;
                        sameOrder = false;
                        break;
                    }
                    if (!sameOrder) {
                        header.getAuthor().clear();
                        for (String au : authors) {
                            header.getAuthor().add(au.trim());
                        }
                        changed = true;
                    }
                }
            } else if (header.getAuthor().size() > 0) {
                header.getAuthor().clear();
                changed = true;
            }
            if (changed) {
                this.curLexicon.changeHeader(header);
            }
            if (!curName.equals(this.curLexicon.getHeader().getName())) {
                int index = this.availableLexiconNames.indexOf(curName);
                if (index > -1) {
                    this.availableLexiconNames.set(index, this.curLexicon.getHeader().getName());
                } else {
                    this.availableLexiconNames.add(this.curLexicon.getHeader().getName());
                }
            }
        }
    }

    public void editCustomFields(Map<String, Object> custFieldsProperties) throws LexiconStructureException {
        block9: {
            CustomFieldSpecification curFieldSpecs;
            block10: {
                if (this.curLexicon == null) break block9;
                curFieldSpecs = this.curLexicon.getHeader().getCustomFields();
                if (curFieldSpecs != null && curFieldSpecs.getFieldSpec() != null && !curFieldSpecs.getFieldSpec().isEmpty()) break block10;
                if (custFieldsProperties == null) break block9;
                Iterator<String> keyIt = custFieldsProperties.keySet().iterator();
                while (keyIt.hasNext()) {
                    EntryFieldTriplet triplet;
                    Object value = custFieldsProperties.get(keyIt.next());
                    if (!(value instanceof EntryFieldTriplet) || !((triplet = (EntryFieldTriplet)value).getOrig() instanceof CustomFieldSpec)) continue;
                    CustomFieldSpec cfs = (CustomFieldSpec)triplet.getOrig();
                    String name = cfs.getName();
                    if (triplet.isAdded() && triplet.getEdit() != null) {
                        name = (String)triplet.getEdit();
                    }
                    String level = cfs.getLevel();
                    this.curLexicon.addCustomFieldSpec(name, level);
                }
                break block9;
            }
            List<CustomFieldSpec> curFieldList = curFieldSpecs.getFieldSpec();
            if (custFieldsProperties == null || custFieldsProperties.isEmpty()) {
                this.curLexicon.removeAllCustomFieldSpecs();
            } else {
                for (int j = curFieldList.size() - 1; j >= 0; --j) {
                    CustomFieldSpec existCfs = curFieldList.get(j);
                    if (custFieldsProperties.containsKey(existCfs.getName())) continue;
                    this.curLexicon.removeCustomFieldSpec(existCfs);
                }
                block2: for (String key : custFieldsProperties.keySet()) {
                    EntryFieldTriplet triplet;
                    Object value = custFieldsProperties.get(key);
                    if (!(value instanceof EntryFieldTriplet) || !((triplet = (EntryFieldTriplet)value).getOrig() instanceof CustomFieldSpec)) continue;
                    CustomFieldSpec cfs = (CustomFieldSpec)triplet.getOrig();
                    String oldName = cfs.getName();
                    String level = cfs.getLevel();
                    if (triplet.isAdded()) {
                        if (triplet.getEdit() == null) continue;
                        String name = (String)triplet.getEdit();
                        this.curLexicon.addCustomFieldSpec(name, level);
                        continue;
                    }
                    String editName = oldName;
                    if (triplet.getEdit() != null) {
                        editName = (String)triplet.getEdit();
                    }
                    for (CustomFieldSpec oldCfs : curFieldList) {
                        if (!oldCfs.getName().equals(oldName) || oldName.equals(editName) && level.equals(oldCfs.getLevel())) continue;
                        this.curLexicon.modifyCustomFieldSpec(oldCfs, editName, level);
                        continue block2;
                    }
                }
            }
        }
    }

    public void editSortOrder(String sortOrder) throws LexiconStructureException, ParseException {
        if (this.curLexicon != null) {
            Header header = this.curLexicon.getHeader();
            String curOrder = header.getSortOrder();
            if (curOrder == null || curOrder.isEmpty()) {
                if (sortOrder != null && !sortOrder.isEmpty()) {
                    this.curLexicon.changeSortOrder(header, sortOrder);
                }
            } else if (sortOrder == null || sortOrder.isEmpty()) {
                this.curLexicon.changeSortOrder(header, null);
            } else if (!curOrder.equals(sortOrder)) {
                this.curLexicon.changeSortOrder(header, sortOrder);
            }
        }
    }

    public void saveLexicon() {
        if (!this.isLexiconLoaded()) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
                LexiconLogger.LEXLOG.fine("There is no lexicon to save");
            }
        } else {
            this.saveChangedLexicon();
        }
    }

    public void saveLexiconAs(Window owner) throws LexiconNotSavedException {
        if (!this.isLexiconLoaded()) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
                LexiconLogger.LEXLOG.fine("There is no lexicon to save as....");
            }
        } else {
            File f;
            JFileChooser chooser = new JFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.addChoosableFileFilter(new FileNameExtensionFilter("Lexicon xml", "xml"));
            int option = chooser.showSaveDialog(owner);
            if (option == 0 && (f = chooser.getSelectedFile()) != null) {
                try {
                    LexiconContext.getInstance().saveLexicon(this.curLexicon, f.toURI().toURL());
                }
                catch (MalformedURLException mue) {
                    throw new LexiconNotSavedException(mue.getMessage());
                }
            }
        }
    }

    public void saveLexiconInOrder(List<EntryImpl> visibleList) {
        if (visibleList == null) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
                LexiconLogger.LEXLOG.fine("The specified list of ordered entries is null");
            }
            return;
        }
        if (!this.isLexiconLoaded()) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
                LexiconLogger.LEXLOG.fine("There is no lexicon order to save");
            }
        } else if (this.curLexicon != null) {
            this.curLexicon.sortEntriesFromList(visibleList);
            this.saveChangedLexicon();
        }
    }

    public LexiconImpl createNewLexicon(Map<String, String> lexProperties) throws LexiconStructureException, LexiconNotSavedException {
        String version;
        String author;
        if (lexProperties == null) {
            throw new LexiconStructureException("Information for mandatory fields is missing");
        }
        String lexiconName = lexProperties.get(LexiconFields.HEADER_NAME.getFieldName());
        if (lexiconName == null || lexiconName.isEmpty()) {
            throw new LexiconStructureException("The name for the new lexicon is missing");
        }
        String langField = lexProperties.get(LexiconFields.HEADER_LANG.getFieldName());
        if (langField == null || langField.isEmpty()) {
            throw new LexiconStructureException("The language name or code is missing");
        }
        LexiconImpl lexImpl = new LexiconImpl();
        lexImpl.setProducer(LexiconContext.getInstance().PRODUCER);
        lexImpl.setSchemaVersion(LexiconContext.getInstance().SCHEMA_VERSION);
        HeaderImpl header = lexImpl.createHeader();
        header.setName(lexiconName);
        header.setLanguage(langField);
        String descript = lexProperties.get(LexiconFields.HEADER_DESC.getFieldName());
        if (descript != null) {
            header.setDescription(descript);
        }
        if ((author = lexProperties.get(LexiconFields.HEADER_AUTHOR.getFieldName())) != null && !author.isEmpty()) {
            String[] authors;
            for (String au : authors = author.split(",")) {
                header.getAuthor().add(au.trim());
            }
        }
        if ((version = lexProperties.get(LexiconFields.HEADER_VERSION.getFieldName())) != null) {
            header.setVersion(version);
        }
        lexImpl.addHeader(header);
        LexiconContext.getInstance().saveNewLexicon(lexImpl);
        this.availableLexiconNames.add(lexImpl.getHeader().getName());
        return lexImpl;
    }

    public EntryImpl createNewEntry(Map<LexiconFields, String> resultEntryData) throws LexiconNotFoundException, LexiconStructureException {
        return this.createNewEntry(this.curLexicon, resultEntryData);
    }

    public EntryImpl createNewEntry(LexiconImpl lexicon, Map<LexiconFields, String> resultEntryData) throws LexiconNotFoundException, LexiconStructureException {
        if (lexicon == null) {
            throw new LexiconNotFoundException("Cannot add entry, the lexicon is not loaded");
        }
        if (resultEntryData != null) {
            EntryImpl nextEntry = lexicon.createEntry(resultEntryData.get((Object)LexiconFields.ENTRY_LEX_UNIT));
            SenseImpl firstSense = lexicon.createSense(resultEntryData.get((Object)LexiconFields.SENSE_GRAM_CAT), "");
            if (resultEntryData.get((Object)LexiconFields.ENTRY_MORPH_TYPE) == null) {
                throw new LexiconStructureException("Cannot create a new entry, required field \"morph\" is missing");
            }
            for (LexiconFields lf : resultEntryData.keySet()) {
                String value = resultEntryData.get((Object)lf);
                switch (lf) {
                    case ENTRY_CITATION: {
                        nextEntry.setCitation(value);
                        break;
                    }
                    case ENTRY_VARIANT: {
                        nextEntry.getVariant().add(value);
                        break;
                    }
                    case ENTRY_MORPH_TYPE: {
                        nextEntry.setMorphType(value);
                        break;
                    }
                    case SENSE_GLOSS: {
                        firstSense.getGloss().get(0).setValue(value);
                        break;
                    }
                }
            }
            lexicon.addEntry(nextEntry);
            lexicon.addSense(nextEntry, firstSense);
            return nextEntry;
        }
        throw new LexiconStructureException("Cannot create a new entry, all required input is missing");
    }

    public void removeEntry(EntryImpl entry) throws LexiconNotFoundException, LexiconStructureException {
        if (this.curLexicon == null) {
            throw new LexiconNotFoundException("Cannot remove entry, no lexicon loaded");
        }
        this.curLexicon.removeEntry(entry);
    }

    public LexiconImpl openLexicon(Window owner) throws LexiconNotFoundException, LexiconNotSavedException {
        JFileChooser chooser = new JFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("Lexicon xml", "xml"));
        int option = chooser.showOpenDialog(owner);
        if (option == 0) {
            LexiconImpl openLexicon = null;
            File f = chooser.getSelectedFile();
            if (f != null) {
                try {
                    URL fURL = f.toURI().toURL();
                    openLexicon = LexiconContext.getInstance().loadLexiconFromURL(fURL);
                    LexiconContext.getInstance().saveNewLexicon(openLexicon);
                }
                catch (MalformedURLException mue) {
                    throw new LexiconNotFoundException(mue.getMessage());
                }
            }
            return openLexicon;
        }
        return null;
    }

    public void closeLexicon() {
        if (this.curLexicon != null) {
            if (this.curLexicon.isChanged()) {
                LexiconContext.getInstance().unloadLexicon(this.curLexicon);
            }
            this.curLexicon = null;
            this.lexiconName = null;
        }
    }

    public LexiconImpl importLexicon(Window owner) throws LexiconNotFoundException, LexiconNotSavedException, LexiconConversionException {
        JFileChooser chooser = new JFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        FileNameExtensionFilter liftFilter = new FileNameExtensionFilter("LIFT format (*.lift)", "lift");
        FileNameExtensionFilter eaflFilter = new FileNameExtensionFilter("CorpAfroAs format (*.eafl)", "eafl");
        FileNameExtensionFilter toolboxFilter = new FileNameExtensionFilter("Toolbox dictionary format (*.dic, *.db, *.txt)", "dic", "db", "txt");
        chooser.addChoosableFileFilter(toolboxFilter);
        chooser.addChoosableFileFilter(liftFilter);
        chooser.addChoosableFileFilter(eaflFilter);
        int option = chooser.showOpenDialog(owner);
        if (option == 0) {
            LexiconImpl importLexicon = null;
            File f = chooser.getSelectedFile();
            if (f != null) {
                String inputType = null;
                String extLow = f.getName().toLowerCase();
                inputType = extLow.endsWith(".lift") ? "lift" : (extLow.endsWith(".eafl") ? "eafl" : (extLow.endsWith(".dic") || extLow.endsWith(".db") || extLow.endsWith(".txt") ? "toolbox" : ""));
                if (inputType.equals("toolbox")) {
                    ImportToolboxDictDialog tbDialog = new ImportToolboxDictDialog(owner, f);
                    tbDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                    tbDialog.setVisible(true);
                    ToolboxDictDecodeInfo result = tbDialog.getValue();
                    if (result != null) {
                        ToolboxConverter tbConverter = new ToolboxConverter();
                        try {
                            importLexicon = tbConverter.convertFromToolbox(f, result);
                            if (importLexicon != null) {
                                importLexicon.sortEntries();
                                LexiconContext.getInstance().saveNewLexicon(importLexicon);
                            }
                            return importLexicon;
                        }
                        catch (IOException ioe) {
                            throw new LexiconConversionException("Toolbox conversion error: " + ioe.getMessage());
                        }
                        catch (LexiconStructureException lse) {
                            throw new LexiconConversionException("Toolbox conversion error: " + lse.getMessage());
                        }
                    }
                    return null;
                }
                String tempName = String.format("LexiconConvert-%d", new Random().nextInt(16));
                File tempFile = null;
                try {
                    tempFile = File.createTempFile(tempName, ".xml");
                }
                catch (IOException ioe) {
                    tempFile = new File(this.folderName, tempName + ".temp");
                }
                if (tempFile == null) {
                    throw new LexiconNotSavedException("Unable to create a temporary file for the conversion");
                }
                tempFile.deleteOnExit();
                try {
                    block20: {
                        LexiconConverter converter = new LexiconConverter();
                        if (inputType.equals("eafl")) {
                            converter.convertFromCorpafroasToLexiconComponent(f, tempFile);
                        } else {
                            converter.convertFromLiftToLexiconComponent(f, tempFile);
                        }
                        importLexicon = LexiconContext.getInstance().loadLexiconFromURL(tempFile.toURI().toURL());
                        importLexicon.sortEntries();
                        String lexName = JOptionPane.showInputDialog("Please enter a name for the lexicon:");
                        if (lexName == null || lexName.isEmpty()) {
                            lexName = "Unnamed Lexicon";
                        }
                        importLexicon.getHeader().setName(lexName);
                        LexiconContext.getInstance().saveNewLexicon(importLexicon);
                        try {
                            tempFile.delete();
                        }
                        catch (Throwable t) {
                            if (!LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) break block20;
                            LexiconLogger.LEXLOG.warning("The temp file for the lexicon could not be deleted!");
                        }
                    }
                    return importLexicon;
                }
                catch (MalformedURLException mue) {
                    throw new LexiconConversionException("Conversion error: " + mue.getMessage());
                }
                catch (TransformerException te) {
                    throw new LexiconConversionException("Transformation error: " + te.getMessage());
                }
            }
            if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
                LexiconLogger.LEXLOG.info("No lexicon file was selected for import.");
            }
        }
        return null;
    }

    public void exportLexicon(Window owner) throws LexiconNotFoundException, LexiconConversionException {
        File f;
        if (!this.isLexiconLoaded()) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
                LexiconLogger.LEXLOG.fine("There is no lexicon to export");
            }
            throw new LexiconNotFoundException("There is no lexicon selected for export");
        }
        String filePath = LexiconContext.getInstance().getFileLocationOfLexicon(this.lexiconName);
        if (filePath == null) {
            throw new LexiconNotFoundException("The file path for the current lexicon is not found");
        }
        File inputFile = new File(filePath);
        if (!inputFile.exists()) {
            throw new LexiconNotFoundException("The file for the current lexicon does not exist " + filePath);
        }
        JFileChooser chooser = new JFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("Lift lexicon (*.lift)", "lift"));
        int option = chooser.showSaveDialog(owner);
        if (option == 0 && (f = chooser.getSelectedFile()) != null) {
            try {
                LexiconConverter converter = new LexiconConverter();
                converter.convertFromLexiconComponentToLift(inputFile, f);
            }
            catch (TransformerException te) {
                throw new LexiconConversionException(te.getMessage());
            }
        }
    }
}

