/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import nl.mpi.lexiconcomponent.gui.LexiconGuiResources;
import nl.mpi.lexiconcomponent.gui.lexproperties.CustomFieldsEditPanel;
import nl.mpi.lexiconcomponent.gui.lexproperties.GeneralPropertiesPanel;
import nl.mpi.lexiconcomponent.gui.lexproperties.LexPropertyEditor;
import nl.mpi.lexiconcomponent.gui.lexproperties.SortOrderPanel;
import nl.mpi.lexiconcomponent.impl.LexiconImpl;

public class LexiconHeaderDialog
extends JDialog
implements ActionListener {
    private LexiconImpl lexiconImpl;
    private Map<PropPanelID, Map<String, Object>> resultMap;
    private JTabbedPane propTabPane;
    private PropPanelID[] panelIDs;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel buttonPanel;

    public LexiconHeaderDialog(Window owner, String title) {
        super(owner, title);
        this.initComponents();
        this.postInit();
    }

    public LexiconHeaderDialog(Window owner) {
        super(owner);
        this.initComponents();
        this.postInit();
    }

    public LexiconHeaderDialog(Window owner, String title, LexiconImpl lexiconImpl) {
        super(owner, title);
        this.lexiconImpl = lexiconImpl;
        this.initComponents();
        this.postInit();
    }

    public LexiconHeaderDialog(Window owner, LexiconImpl lexiconImpl) {
        super(owner);
        this.lexiconImpl = lexiconImpl;
        this.initComponents();
        this.postInit();
    }

    public LexiconHeaderDialog(Window owner, LexiconImpl lexiconImpl, PropPanelID ... panelIDs) {
        super(owner);
        this.lexiconImpl = lexiconImpl;
        if (lexiconImpl != null) {
            this.panelIDs = panelIDs;
        }
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        this.propTabPane = new JTabbedPane(1);
        if (this.panelIDs == null) {
            this.panelIDs = new PropPanelID[]{PropPanelID.GENERAL};
        }
        this.addTabs();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 2, 2, 2));
        this.okButton = new JButton(LexiconGuiResources.getLocalizedString("Button.Apply", "Apply"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LexiconGuiResources.getLocalizedString("Button.Cancel", "Cancel"));
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(6, 4, 2, 4);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.propTabPane, gbc);
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(6, 4, 6, 4);
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void addTabs() {
        if (this.panelIDs == null) {
            this.propTabPane.addTab(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit.Tab.General", "General Properties"), new GeneralPropertiesPanel(this.lexiconImpl));
        } else {
            block5: for (PropPanelID ppid : this.panelIDs) {
                switch (ppid) {
                    case GENERAL: {
                        this.propTabPane.addTab(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit.Tab.General", "General Properties"), new GeneralPropertiesPanel(this.lexiconImpl));
                        continue block5;
                    }
                    case CUSTOM_FIELDS: {
                        this.propTabPane.addTab(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit.Tab.CustomFields", "Custom Fields"), new CustomFieldsEditPanel(this.lexiconImpl));
                        continue block5;
                    }
                    case SORT_ORDER: {
                        this.propTabPane.addTab(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit.Tab.SortOrder", "Sort Order"), new SortOrderPanel(this.lexiconImpl));
                        continue block5;
                    }
                }
            }
        }
    }

    private void postInit() {
        this.pack();
        Dimension dim = this.getSize();
        this.setSize(dim.width + 100, dim.height);
        this.setLocationRelativeTo(this.getParent());
    }

    public Map<PropPanelID, Map<String, Object>> getValue() {
        return this.resultMap;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.resultMap = null;
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.okButton) {
            int i;
            for (i = 0; i < this.propTabPane.getTabCount(); ++i) {
                LexPropertyEditor editor = (LexPropertyEditor)((Object)this.propTabPane.getComponentAt(i));
                if (editor.validateFields()) continue;
                this.propTabPane.setSelectedIndex(i);
                return;
            }
            if (this.propTabPane.getTabCount() >= 1) {
                this.resultMap = new HashMap<PropPanelID, Map<String, Object>>(this.panelIDs.length);
                for (i = 0; i < this.panelIDs.length; ++i) {
                    this.resultMap.put(this.panelIDs[i], ((LexPropertyEditor)((Object)this.propTabPane.getComponentAt(i))).getValueMap());
                }
            } else {
                this.resultMap = null;
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    public static enum PropPanelID {
        GENERAL,
        CUSTOM_FIELDS,
        FIELD_CONFIG,
        SORT_ORDER;

    }
}

