/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import nl.mpi.lexiconcomponent.events.LexiconEditListener;
import nl.mpi.lexiconcomponent.events.LexiconEvent;
import nl.mpi.lexiconcomponent.exceptions.LexiconConversionException;
import nl.mpi.lexiconcomponent.exceptions.LexiconNotFoundException;
import nl.mpi.lexiconcomponent.exceptions.LexiconNotSavedException;
import nl.mpi.lexiconcomponent.exceptions.LexiconStructureException;
import nl.mpi.lexiconcomponent.gui.LexiconGuiResources;
import nl.mpi.lexiconcomponent.gui.LexiconHandler;
import nl.mpi.lexiconcomponent.gui.LexiconHeaderDialog;
import nl.mpi.lexiconcomponent.gui.LexiconViewManager;
import nl.mpi.lexiconcomponent.gui.table.EntryTable;
import nl.mpi.lexiconcomponent.gui.table.EntryTableModel2;
import nl.mpi.lexiconcomponent.gui.table.RowAction;
import nl.mpi.lexiconcomponent.gui.table.TableColumnDescriptor;
import nl.mpi.lexiconcomponent.impl.EntryImpl;
import nl.mpi.lexiconcomponent.impl.LexiconContext;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.impl.LexiconImpl;
import nl.mpi.lexiconcomponent.impl.SenseImpl;
import nl.mpi.lexiconcomponent.util.LexiconLogger;

public abstract class LexiconRootPanel
extends JPanel {
    protected LexiconViewManager lexViewManager = null;
    protected LexiconHandler lexHandler = null;
    protected JPanel topWidgetPanel = null;
    protected JPanel tablePanel = null;
    protected JPanel bottomWidgetPanel = null;
    protected EntryTable entryTable = null;
    protected EntryTableModel2 entryModel = null;
    protected JPopupMenu tablePopupMenu = null;
    protected JMenuItem menuItemAdd = null;
    protected JMenuItem menuItemRemove = null;
    protected JMenuItem menuItemEdit = null;
    protected JMenu menuVisibleColumns = null;
    protected List<JMenuItem> customFieldItems = null;
    protected List<LexiconFields> availableColumns;
    protected final String COLUMN_AC = "fieldName:";
    protected Map<String, Object> preferencesMap;
    protected Map<String, List<String>> visibleColumnsMap;
    protected Map<LexiconFields, Comparator<Object>> comparatorMap;
    protected final String SEL_LEXICON_KEY = "LexiconPanel.SelectedLexicon";
    protected final String VIS_COLUMN_MAP_KEY = "LexiconPanel.VisibleColumnsMap";
    protected final String NO_LEXICON_KEY = "none";
    protected final String VIS_SORT_ORDER = "LexiconPanel.SortOrderMap";
    protected final String SORT_COL_ID = "LexiconPanel.SortColumnID";
    protected final String SORT_ORDER = "LexiconPanel.SortOrder";
    protected AllActionsListener menuListener = null;
    protected TableMouseActionListener mouseListener = null;
    protected EntryTableSelectionListener entrySelectListener = null;
    protected LexiconChangeListener lexChangeListener = null;

    public LexiconRootPanel() {
        this((LexiconHandler)null);
    }

    public LexiconRootPanel(LexiconHandler lexiconHandler) {
        if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
            LexiconLogger.LEXLOG.fine(String.format("Constructor of %s", this.getClass().getName()));
        }
        this.visibleColumnsMap = new HashMap<String, List<String>>();
        this.comparatorMap = new HashMap<LexiconFields, Comparator<Object>>();
        this.lexHandler = lexiconHandler;
        this.initAvailableColumns();
    }

    public LexiconRootPanel(LexiconViewManager lexViewManager) {
        this(lexViewManager.getLexiconHandler());
        this.lexViewManager = lexViewManager;
    }

    public abstract void isClosing();

    public abstract void setUserPreferences(Map<String, Object> var1);

    public abstract Map<String, Object> getUserPreferences();

    public void showMessage(String message, String title, int messageType) {
        JOptionPane.showMessageDialog(this.getRootPane(), message, title, messageType);
    }

    public void updateLocale() {
    }

    protected void initComponents() {
        GridBagConstraints gbc;
        this.setLayout(new GridBagLayout());
        this.customFieldItems = new ArrayList<JMenuItem>();
        this.getTableViewPanel();
        this.getTopWidgetPanel();
        this.getBottomWidgetPanel();
        int gridy = 0;
        if (this.topWidgetPanel != null) {
            gbc = new GridBagConstraints();
            gbc.anchor = 11;
            gbc.insets = new Insets(4, 2, 2, 2);
            gbc.gridy = gridy++;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.topWidgetPanel, gbc);
        }
        if (this.tablePanel != null) {
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(4, 2, 2, 2);
            gbc.gridy = gridy++;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.add((Component)this.tablePanel, gbc);
        }
        if (this.bottomWidgetPanel != null) {
            gbc = new GridBagConstraints();
            gbc.gridy = gridy;
            gbc.anchor = 11;
            gbc.fill = 0;
            gbc.weighty = 0.0;
            gbc.weightx = 0.0;
            gbc.insets = new Insets(2, 2, 4, 2);
            this.add((Component)this.bottomWidgetPanel, gbc);
        }
        this.updateLocale();
    }

    protected void initListeners() {
        this.menuListener = new AllActionsListener();
        this.mouseListener = new TableMouseActionListener();
        this.entrySelectListener = new EntryTableSelectionListener();
        this.lexChangeListener = new LexiconChangeListener();
    }

    protected void initAvailableColumns() {
        if (this.availableColumns == null) {
            this.availableColumns = new ArrayList<LexiconFields>();
            this.availableColumns.add(LexiconFields.ENTRY_MORPH_TYPE);
            this.availableColumns.add(LexiconFields.ENTRY_CITATION);
            this.availableColumns.add(LexiconFields.ENTRY_VARIANT);
            this.availableColumns.add(LexiconFields.ENTRY_PHONETIC);
            this.availableColumns.add(LexiconFields.SENSE_GRAM_CAT);
            this.availableColumns.add(LexiconFields.SENSE_GLOSS);
            this.availableColumns.add(LexiconFields.SENSE_ORDER);
        }
    }

    protected JPanel getTableViewPanel() {
        if (this.tablePanel == null) {
            this.tablePanel = new JPanel(new GridBagLayout());
            this.entryModel = new EntryTableModel2(this.lexHandler.getCurrentLexicon(), null);
            if (this.lexHandler.getCurrentLexicon() != null) {
                this.lexHandler.getCurrentLexicon().addLexiconEditListener(this.lexChangeListener);
            }
            this.replaceTableModel(this.entryModel);
            this.entryTable.getSelectionModel().addListSelectionListener(this.entrySelectListener);
            this.entryTable.setFillsViewportHeight(true);
            JScrollPane tableScroll = new JScrollPane(this.entryTable);
            tableScroll.setPreferredSize(new Dimension(80, 300));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.tablePanel.add((Component)tableScroll, gbc);
            this.entryTable.addMouseListener(this.mouseListener);
        }
        return this.tablePanel;
    }

    protected abstract JPanel getTopWidgetPanel();

    protected abstract JPanel getBottomWidgetPanel();

    protected void updateRowSorterMap() {
        if (this.lexHandler.getCurrentLexicon() != null && this.lexHandler.getCurrentLexicon().getCollator() != null) {
            RuleBasedCollator customComp = this.lexHandler.getCurrentLexicon().getCollator();
            this.comparatorMap.put(LexiconFields.ENTRY_LEX_UNIT, customComp);
            this.comparatorMap.put(LexiconFields.ENTRY_CITATION, customComp);
            this.comparatorMap.put(LexiconFields.ENTRY_VARIANT, customComp);
        }
    }

    protected void removeCustomComparators() {
        if (this.entryTable.getRowSorter() instanceof TableRowSorter) {
            TableRowSorter rowSorter = (TableRowSorter)this.entryTable.getRowSorter();
            for (LexiconFields lf : this.comparatorMap.keySet()) {
                int lfColumn = this.entryModel.findColumn(lf.getFieldName());
                if (lfColumn <= -1) continue;
                rowSorter.setComparator(lfColumn, null);
            }
        }
    }

    protected void addCustomComparators() {
        if (this.entryTable.getRowSorter() instanceof TableRowSorter) {
            TableRowSorter rowSorter = (TableRowSorter)this.entryTable.getRowSorter();
            for (LexiconFields lf : this.comparatorMap.keySet()) {
                int lfColumn = this.entryModel.findColumn(lf.getFieldName());
                if (lfColumn <= -1) continue;
                rowSorter.setComparator(lfColumn, this.comparatorMap.get((Object)lf));
            }
        }
    }

    protected JPopupMenu getTablePopupMenu() {
        if (this.tablePopupMenu == null) {
            this.tablePopupMenu = new JPopupMenu();
            this.menuItemAdd = new JMenuItem(LexiconGuiResources.getLocalizedString("Button.Add", "Add New Entry"));
            this.menuItemAdd.setActionCommand(this.menuListener.ADD_ENTRY);
            RowAction removeAction = new RowAction(LexiconGuiResources.getLocalizedString("Button.Remove", "Remove Current Entry"));
            this.menuItemRemove = new JMenuItem(removeAction);
            this.menuItemRemove.setActionCommand(this.menuListener.REMOVE_ENTRY);
            RowAction editAction = new RowAction(LexiconGuiResources.getLocalizedString("Menu.Edit", "Edit Current Entry"));
            this.menuItemEdit = new JMenuItem(editAction);
            this.menuItemEdit.setActionCommand(this.menuListener.EDIT_ENTRY);
            this.menuItemAdd.addActionListener(this.menuListener);
            this.menuItemRemove.addActionListener(this.menuListener);
            this.menuItemEdit.addActionListener(this.menuListener);
            this.tablePopupMenu.add(this.menuItemAdd);
            this.tablePopupMenu.add(this.menuItemRemove);
            this.tablePopupMenu.add(this.menuItemEdit);
            this.tablePopupMenu.addSeparator();
            this.menuVisibleColumns = new JMenu(LexiconGuiResources.getLocalizedString("LexiconComponent.VisibleColumns", "Visible Columns"));
            this.tablePopupMenu.add(this.menuVisibleColumns);
            for (LexiconFields lf : this.availableColumns) {
                JCheckBoxMenuItem nextItem = new JCheckBoxMenuItem(lf.getDisplayLabel());
                nextItem.setSelected(true);
                nextItem.addActionListener(this.menuListener);
                nextItem.setActionCommand("fieldName:" + lf.getFieldName());
                this.menuVisibleColumns.add(nextItem);
            }
            this.menuVisibleColumns.addSeparator();
            this.replaceCustomFieldMenuItems();
        }
        return this.tablePopupMenu;
    }

    protected void updateTablePopupMenu(int row) {
        this.getTablePopupMenu();
        if (this.lexHandler.getCurrentLexicon() == null) {
            this.menuItemAdd.setEnabled(false);
            this.menuVisibleColumns.setEnabled(false);
        } else {
            this.menuItemAdd.setEnabled(true);
            this.menuVisibleColumns.setEnabled(true);
        }
        this.menuItemRemove.setEnabled(row >= 0);
        ((RowAction)this.menuItemRemove.getAction()).setRow(row);
        this.menuItemEdit.setEnabled(row >= 0);
        ((RowAction)this.menuItemEdit.getAction()).setRow(row);
        List<TableColumnDescriptor> curColumns = this.entryModel.getColumnDescriptors();
        for (int i = 0; i < this.menuVisibleColumns.getItemCount(); ++i) {
            JMenuItem mi = this.menuVisibleColumns.getItem(i);
            if (!(mi instanceof JCheckBoxMenuItem)) continue;
            JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)mi;
            boolean visible = false;
            for (TableColumnDescriptor tcd : curColumns) {
                if (!tcd.getDisplayName().equals(cbmi.getText())) continue;
                visible = true;
                break;
            }
            if (cbmi.isSelected() == visible) continue;
            cbmi.setSelected(visible);
        }
    }

    protected void replaceCustomFieldMenuItems() {
        if (this.tablePopupMenu != null) {
            for (JMenuItem menuItem : this.customFieldItems) {
                menuItem.removeActionListener(this.menuListener);
                this.menuVisibleColumns.remove(menuItem);
                String actionCom = menuItem.getActionCommand();
                if (actionCom == null || !actionCom.startsWith("fieldName:")) continue;
                this.entryModel.removeColumnDescriptor(actionCom.substring("fieldName:".length()));
            }
            List<String> allFieldNames = null;
            if (this.lexHandler.getCurrentLexicon() != null) {
                allFieldNames = this.lexHandler.getCurrentLexicon().getEntryFieldNames();
            }
            if (allFieldNames != null) {
                for (String fieldName : allFieldNames) {
                    LexiconFields lf = null;
                    if (fieldName.startsWith(LexiconFields.ENTRY_FIELD.getFieldName())) {
                        lf = LexiconFields.ENTRY_FIELD;
                    } else if (fieldName.startsWith(LexiconFields.SENSE_FIELD.getFieldName())) {
                        lf = LexiconFields.SENSE_FIELD;
                    }
                    if (lf == null) continue;
                    JCheckBoxMenuItem nextItem = new JCheckBoxMenuItem(lf.getDisplayLabel() + ": " + fieldName.substring(fieldName.lastIndexOf(47) + 1));
                    nextItem.setSelected(true);
                    nextItem.addActionListener(this.menuListener);
                    nextItem.setActionCommand("fieldName:" + fieldName);
                    this.menuVisibleColumns.add(nextItem);
                    this.customFieldItems.add(nextItem);
                }
            }
        }
    }

    protected List<String> getVisibleColumns() {
        if (this.entryTable != null) {
            ArrayList<String> cols = new ArrayList<String>();
            for (int i = 0; i < this.entryTable.getColumnCount(); ++i) {
                int modelIndex = this.entryTable.convertColumnIndexToModel(i);
                if (modelIndex < 0 || modelIndex >= this.entryModel.getColumnDescriptors().size()) continue;
                cols.add(this.entryModel.getColumnDescriptors().get(modelIndex).getFieldName());
            }
            return cols;
        }
        if (this.entryModel != null) {
            ArrayList<String> cols = new ArrayList<String>();
            for (TableColumnDescriptor tcd : this.entryModel.getColumnDescriptors()) {
                cols.add(tcd.getFieldName());
            }
            return cols;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void setVisibleColumns(List<String> visColumns) {
        if (visColumns != null && this.entryModel != null && this.lexHandler.getCurrentLexicon() != null) {
            List<TableColumnDescriptor> tcdList = this.entryModel.getColumnDescriptors();
            for (int i = tcdList.size() - 1; i >= 0; --i) {
                TableColumnDescriptor tcd = tcdList.get(i);
                if (visColumns.contains(tcd.getFieldName())) continue;
                this.entryModel.removeColumnDescriptor(tcd.getFieldName());
            }
            List<String> allFieldNames = this.lexHandler.getCurrentLexicon().getEntryFieldNames();
            for (String field : visColumns) {
                void var8_20;
                boolean alreadyThere = false;
                for (TableColumnDescriptor tableColumnDescriptor : this.entryModel.getColumnDescriptors()) {
                    if (!tableColumnDescriptor.getFieldName().equals(field)) continue;
                    alreadyThere = true;
                    break;
                }
                if (alreadyThere) continue;
                boolean added = false;
                for (LexiconFields lf : this.availableColumns) {
                    if (!lf.getFieldName().equals(field)) continue;
                    boolean editable = lf == LexiconFields.ENTRY_MORPH_TYPE || lf == LexiconFields.ENTRY_CITATION;
                    TableColumnDescriptor tcdd = new TableColumnDescriptor(lf, editable);
                    this.entryModel.addColumnDescriptor(tcdd);
                    added = true;
                    break;
                }
                if (added || !allFieldNames.contains(field)) continue;
                Object var8_17 = null;
                if (field.startsWith(LexiconFields.ENTRY_FIELD.getFieldName())) {
                    LexiconFields lexiconFields = LexiconFields.ENTRY_FIELD;
                } else if (field.startsWith(LexiconFields.SENSE_FIELD.getFieldName())) {
                    LexiconFields lexiconFields = LexiconFields.SENSE_FIELD;
                }
                if (var8_20 == null) continue;
                TableColumnDescriptor tcdd = new TableColumnDescriptor(field, var8_20.getDisplayLabel() + ": " + field.substring(field.lastIndexOf(47) + 1), false);
                this.entryModel.addColumnDescriptor(tcdd);
            }
            int indexPointer = 0;
            block6: for (String field : visColumns) {
                for (int i = 0; i < this.entryModel.getColumnCount(); ++i) {
                    if (!this.entryModel.getColumnDescriptors().get(i).getFieldName().equals(field)) continue;
                    int n = this.entryTable.convertColumnIndexToView(i);
                    if (n != indexPointer) {
                        try {
                            this.entryTable.moveColumn(n, indexPointer);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ++indexPointer;
                    continue block6;
                }
            }
            this.removeCustomComparators();
            this.addCustomComparators();
        }
    }

    protected void replaceTableModel(EntryTableModel2 nextModel) {
        this.entryModel = nextModel;
        if (this.entryTable == null) {
            this.entryTable = new EntryTable(this.entryModel);
        } else {
            this.entryTable.setRowSorter(null);
            this.entryTable.setModel(this.entryModel);
        }
        TableRowSorter<EntryTableModel2> entryRowSorter = new TableRowSorter<EntryTableModel2>(this.entryModel);
        entryRowSorter.setSortsOnUpdates(true);
        this.comparatorMap.clear();
        this.entryTable.setRowSorter(entryRowSorter);
        this.updateRowSorterMap();
        this.addCustomComparators();
        this.replaceCustomFieldMenuItems();
    }

    void storeTableSortOrder(String sortOrderForKey) {
        if (sortOrderForKey != null) {
            List<RowSorter.SortKey> sortKeys = null;
            TableColumnDescriptor sortColumnDesc = null;
            if (this.entryTable.getRowSorter() != null) {
                Map allOrderMap;
                sortKeys = this.entryTable.getRowSorter().getSortKeys();
                if (!sortKeys.isEmpty()) {
                    HashMap allOrderMap2;
                    RowSorter.SortKey sk = sortKeys.get(0);
                    sortColumnDesc = this.entryModel.getColumnDescriptors().get(sk.getColumn());
                    HashMap<String, String> sortMap = new HashMap<String, String>(2);
                    sortMap.put("LexiconPanel.SortColumnID", sortColumnDesc.getFieldName());
                    sortMap.put("LexiconPanel.SortOrder", sk.getSortOrder().toString());
                    if (this.preferencesMap == null) {
                        this.preferencesMap = new HashMap<String, Object>();
                    }
                    if ((allOrderMap2 = (HashMap)this.preferencesMap.get("LexiconPanel.SortOrderMap")) == null) {
                        allOrderMap2 = new HashMap();
                        this.preferencesMap.put("LexiconPanel.SortOrderMap", allOrderMap2);
                    }
                    allOrderMap2.put(sortOrderForKey, sortMap);
                } else if (this.preferencesMap != null && (allOrderMap = (Map)this.preferencesMap.get("LexiconPanel.SortOrderMap")) != null) {
                    allOrderMap.remove(sortOrderForKey);
                }
            }
        }
    }

    void restoreTableSortOrder(String sortOrderForKey) {
        Map curOrder;
        Map storedSortOrder;
        if (this.preferencesMap != null && this.entryTable != null && (storedSortOrder = (Map)this.preferencesMap.get("LexiconPanel.SortOrderMap")) != null && this.entryTable.getRowSorter() != null && (curOrder = (Map)storedSortOrder.get(sortOrderForKey)) != null) {
            String colId = (String)curOrder.get("LexiconPanel.SortColumnID");
            String soMode = (String)curOrder.get("LexiconPanel.SortOrder");
            int col = this.entryModel.findColumn(colId);
            SortOrder so = SortOrder.valueOf(soMode);
            if (col > -1 && so != null) {
                RowSorter.SortKey sk = new RowSorter.SortKey(col, so);
                ArrayList<RowSorter.SortKey> nextSortKeys = new ArrayList<RowSorter.SortKey>(1);
                nextSortKeys.add(sk);
                this.entryTable.getRowSorter().setSortKeys(nextSortKeys);
            }
        }
    }

    protected void createNewLexicon() {
        Window parent = SwingUtilities.getWindowAncestor(this);
        LexiconHeaderDialog lhDialog = new LexiconHeaderDialog(parent, LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.New", "New Lexicon"));
        lhDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        lhDialog.setVisible(true);
        Map<LexiconHeaderDialog.PropPanelID, Map<String, Object>> resultMap = lhDialog.getValue();
        if (resultMap != null) {
            try {
                Map<String, String> lexProps = this.getStringMap(resultMap, LexiconHeaderDialog.PropPanelID.GENERAL);
                if (lexProps == null) {
                    return;
                }
                LexiconImpl nextLex = this.lexHandler.createNewLexicon(lexProps);
                String lexiconName = nextLex.getHeader().getName();
                this.addAndSelectLexicon(lexiconName);
                this.showMessage(String.format("The new lexicon \"%s\" is saved at location:\n %s", nextLex.getHeader().getName(), LexiconContext.getInstance().getFileLocationOfLexicon(nextLex.getHeader().getName())), "", 1);
            }
            catch (LexiconNotSavedException lnse) {
                if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                    LexiconLogger.LEXLOG.warning(String.format("Could not save the new lexicon: %s", lnse.getMessage()));
                }
                this.showMessage(String.format("Could not save the new lexicon: %s", lnse.getMessage()), "", 2);
            }
            catch (LexiconStructureException lse) {
                if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                    LexiconLogger.LEXLOG.warning(String.format("Could not save the new lexicon: %s", lse.getMessage()));
                }
                this.showMessage(String.format("Could not save the new lexicon: %s", lse.getMessage()), "", 2);
            }
        }
    }

    protected Map<String, String> getStringMap(Map<LexiconHeaderDialog.PropPanelID, Map<String, Object>> propsMap, LexiconHeaderDialog.PropPanelID propKey) {
        Map<String, Object> subProps = propsMap.get((Object)propKey);
        if (subProps == null) {
            return null;
        }
        HashMap<String, String> lexProps = new HashMap<String, String>();
        for (String key : subProps.keySet()) {
            Object value = subProps.get(key);
            if (!(value instanceof String)) continue;
            lexProps.put(key, (String)value);
        }
        return lexProps;
    }

    protected void openLexicon() {
        try {
            LexiconImpl openLexicon = this.lexHandler.openLexicon(SwingUtilities.getWindowAncestor(this));
            if (openLexicon != null) {
                String lexiconName = openLexicon.getHeader().getName();
                this.addAndSelectLexicon(lexiconName);
                this.showMessage(String.format("The opened lexicon \"%s\" is saved at location:\n %s", openLexicon.getHeader().getName(), LexiconContext.getInstance().getFileLocationOfLexicon(openLexicon.getHeader().getName())), "", 1);
            }
        }
        catch (LexiconNotFoundException lnfe) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning(String.format("Could not open the lexicon: %s", lnfe.getMessage()));
            }
            this.showMessage(String.format("Could not open the lexicon: %s", lnfe.getMessage()), "", 2);
        }
        catch (LexiconNotSavedException lnse) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning(String.format("Could not save the opened lexicon: %s", lnse.getMessage()));
            }
            this.showMessage(String.format("Could not save the opened lexicon: %s", lnse.getMessage()), "", 2);
        }
    }

    protected abstract void closeLexicon();

    protected void editLexicon() {
        if (this.lexHandler.getCurrentLexicon() != null) {
            Window parent = SwingUtilities.getWindowAncestor(this);
            LexiconHeaderDialog lhDialog = new LexiconHeaderDialog(parent, this.lexHandler.getCurrentLexicon(), LexiconHeaderDialog.PropPanelID.GENERAL, LexiconHeaderDialog.PropPanelID.CUSTOM_FIELDS, LexiconHeaderDialog.PropPanelID.SORT_ORDER);
            lhDialog.setTitle(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit", "Edit Lexicon"));
            lhDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            lhDialog.setVisible(true);
            String curName = this.lexHandler.getCurrentLexicon().getHeader().getName();
            Map<LexiconHeaderDialog.PropPanelID, Map<String, Object>> resultMap = lhDialog.getValue();
            if (resultMap != null) {
                try {
                    Map<String, String> lexProps = this.getStringMap(resultMap, LexiconHeaderDialog.PropPanelID.GENERAL);
                    if (lexProps == null) {
                        return;
                    }
                    this.lexHandler.editLexiconProperties(lexProps);
                    if (!this.lexHandler.getCurrentLexicon().getHeader().getName().equals(curName)) {
                        this.updateLexiconName(curName, this.lexHandler.getCurrentLexicon().getHeader().getName());
                    }
                }
                catch (LexiconStructureException lse) {
                    this.showMessage(String.format("Could not change lexicon properties: %s", lse.getMessage()), "", 2);
                }
                try {
                    Map<String, Object> custFieldsProps = resultMap.get((Object)LexiconHeaderDialog.PropPanelID.CUSTOM_FIELDS);
                    this.lexHandler.editCustomFields(custFieldsProps);
                }
                catch (LexiconStructureException lse) {
                    this.showMessage(String.format("Could not change custom fields of the lexicon: %s", lse.getMessage()), "", 2);
                }
                try {
                    Map<String, Object> sortOrderProps = resultMap.get((Object)LexiconHeaderDialog.PropPanelID.SORT_ORDER);
                    String newOrder = (String)sortOrderProps.get("SortOrderString");
                    this.lexHandler.editSortOrder(newOrder);
                }
                catch (LexiconStructureException lse) {
                    this.showMessage(String.format("Could not change the sort order of the lexicon: %s", lse.getMessage()), "", 2);
                }
                catch (ParseException pe) {
                    this.showMessage(String.format("Could not change the sort order of the lexicon: %s", pe.getMessage()), "", 2);
                }
            } else if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
                LexiconLogger.LEXLOG.info(String.format("No changes made to properties of the lexicon: %s", this.lexHandler.getCurrentLexicon().getHeader().getName()));
            }
        }
    }

    void saveVisibleEntryOrder() {
        if (this.entryTable != null && this.entryModel != null) {
            ArrayList<EntryImpl> visibleList = new ArrayList<EntryImpl>(this.entryTable.getRowCount());
            for (int i = 0; i < this.entryTable.getRowCount(); ++i) {
                int row = this.entryTable.convertRowIndexToModel(i);
                visibleList.add(this.entryModel.getEntryAt(row));
            }
            this.lexHandler.saveLexiconInOrder(visibleList);
        }
    }

    protected void importLexicon() {
        try {
            LexiconImpl impLexicon = this.lexHandler.importLexicon(SwingUtilities.getWindowAncestor(this));
            if (impLexicon != null) {
                String lexiconName = impLexicon.getHeader().getName();
                this.addAndSelectLexicon(lexiconName);
                this.showMessage(String.format("The opened lexicon \"%s\" is saved at location:\n %s", impLexicon.getHeader().getName(), LexiconContext.getInstance().getFileLocationOfLexicon(impLexicon.getHeader().getName())), "", 1);
            }
        }
        catch (LexiconNotFoundException lnfe) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning(String.format("Could not import the lexicon: %s", lnfe.getMessage()));
            }
            this.showMessage(String.format("Could not import the lexicon: %s", lnfe.getMessage()), "", 2);
        }
        catch (LexiconNotSavedException lnse) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning(String.format("Could not save the imported lexicon: %s", lnse.getMessage()));
            }
            this.showMessage(String.format("Could not save the imported lexicon: %s", lnse.getMessage()), "", 2);
        }
        catch (LexiconConversionException lce) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning(String.format("Could not convert the lexicon: %s", lce.getMessage()));
            }
            this.showMessage(String.format("Could not convert the lexicon: %s", lce.getMessage()), "", 2);
        }
    }

    protected abstract void createNewEntry();

    protected void removeCurrentEntry() {
        int selRow = this.entryTable.getSelectedRow();
        if (selRow < 0) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
                LexiconLogger.LEXLOG.info("Cannot remove an entry, no row selected");
            }
            return;
        }
        this.removeEntryRow(selRow);
    }

    void removeEntryRow(int row) {
        int rowInModel = this.entryTable.convertRowIndexToModel(row);
        if (rowInModel < 0 || rowInModel >= this.entryModel.getRowCount()) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
                LexiconLogger.LEXLOG.info(String.format("Cannot remove an entry, the table row (%d) does not exist in de model (%d)", row, rowInModel));
            }
            return;
        }
        EntryImpl curEntry = this.entryModel.getEntryAt(rowInModel);
        if (curEntry != null) {
            int option = JOptionPane.showConfirmDialog(this, String.format("Are you sure you want to remove this entry?\nLexical unit: %s (row: %d)\nIt can not be undone.", curEntry.getLexicalUnit(), row), LexiconGuiResources.getLocalizedString("Message.Warning", "Remove?"), 0);
            if (option != 0) {
                return;
            }
            try {
                this.lexHandler.removeEntry(curEntry);
            }
            catch (Throwable t) {
                if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                    LexiconLogger.LEXLOG.warning(String.format("Error: %s", t.getMessage()));
                }
                this.showMessage(String.format("Error while removing an entry: %s", t.getMessage()), "", 2);
            }
        }
    }

    protected void editCurrentEntry() {
        int selRow = this.entryTable.getSelectedRow();
        if (selRow < 0) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
                LexiconLogger.LEXLOG.info("Cannot edit an entry, no row selected");
            }
            return;
        }
        this.editEntryRow(selRow);
    }

    protected void editEntryRow(int row) {
        if (row < 0 || row >= this.entryTable.getRowCount()) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
                LexiconLogger.LEXLOG.fine(String.format("Cannot edit an entry, the row does not exist in the table (%d)", row));
            }
            return;
        }
        int rowInModel = this.entryTable.convertRowIndexToModel(row);
        if (rowInModel < 0 || rowInModel >= this.entryModel.getRowCount()) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
                LexiconLogger.LEXLOG.info(String.format("Cannot edit an entry, the row in the table (%d) does not exist in the model (%d)", row, rowInModel));
            }
            return;
        }
        EntryImpl curEntry = this.entryModel.getEntryAt(rowInModel);
        if (curEntry != null) {
            this.editEntry(curEntry);
        }
    }

    protected abstract void editEntry(EntryImpl var1);

    protected abstract void entrySelectionChanged(ListSelectionEvent var1);

    protected abstract void addAndSelectLexicon(String var1);

    protected abstract void updateLexiconName(String var1, String var2);

    protected abstract void setChangedStateOfLexicon(String var1, boolean var2);

    class AllActionsListener
    implements ActionListener {
        final String NEW_LEX_AC = "new";
        final String OPEN_LEX_AC = "open";
        final String CLOSE_LEX_AC = "close";
        final String SAVE_LEX_AC = "save";
        final String SAVE_AS_LEX_AC = "saveas";
        final String SAVE_LEX_ORDER_AC = "saveorder";
        final String EDIT_LEX_AC = "edit";
        final String IMPORT_LEX_AC = "import";
        final String EXPORT_LEX_AC = "export";
        final String ADD_ENTRY = "add_entry";
        final String REMOVE_ENTRY = "remove_entry";
        final String EDIT_ENTRY = "edit_entry";

        AllActionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if (actionCommand == null) {
                return;
            }
            if (actionCommand.equals("new")) {
                LexiconRootPanel.this.createNewLexicon();
            } else if (actionCommand.equals("open")) {
                LexiconRootPanel.this.openLexicon();
            } else if (actionCommand.equals("edit")) {
                if (LexiconRootPanel.this.lexHandler.getCurrentLexicon() != null) {
                    LexiconRootPanel.this.editLexicon();
                }
            } else if (actionCommand.equals("save")) {
                if (LexiconRootPanel.this.lexHandler.getCurrentLexicon() != null && LexiconRootPanel.this.lexHandler.getCurrentLexicon().isChanged()) {
                    LexiconRootPanel.this.lexHandler.saveLexicon();
                }
            } else if (actionCommand.equalsIgnoreCase("saveas")) {
                if (LexiconRootPanel.this.lexHandler.getCurrentLexicon() != null) {
                    try {
                        LexiconRootPanel.this.lexHandler.saveLexiconAs(SwingUtilities.getWindowAncestor(LexiconRootPanel.this));
                    }
                    catch (LexiconNotSavedException lnse) {
                        LexiconRootPanel.this.showMessage(String.format("The lexicon is not saved as: %s", lnse.getMessage()), LexiconGuiResources.getLocalizedString("Message.Warning", "Warning"), 2);
                    }
                }
            } else if (actionCommand.equals("saveorder")) {
                if (LexiconRootPanel.this.lexHandler.getCurrentLexicon() != null) {
                    LexiconRootPanel.this.saveVisibleEntryOrder();
                }
            } else if (actionCommand.equals("close")) {
                if (LexiconRootPanel.this.lexHandler.getCurrentLexicon() != null) {
                    LexiconRootPanel.this.closeLexicon();
                }
            } else if (actionCommand.equals("import")) {
                LexiconRootPanel.this.importLexicon();
            } else if (actionCommand.equals("export")) {
                if (LexiconRootPanel.this.lexHandler.getCurrentLexicon() != null) {
                    try {
                        LexiconRootPanel.this.lexHandler.exportLexicon(SwingUtilities.getWindowAncestor(LexiconRootPanel.this));
                    }
                    catch (LexiconNotFoundException lnfe) {
                        LexiconRootPanel.this.showMessage(String.format("The lexicon was not exported: %s", lnfe.getMessage()), LexiconGuiResources.getLocalizedString("Message.Warning", "Warning"), 2);
                    }
                    catch (LexiconConversionException lce) {
                        LexiconRootPanel.this.showMessage(String.format("The lexicon was not exported: %s", lce.getMessage()), LexiconGuiResources.getLocalizedString("Message.Warning", "Warning"), 2);
                    }
                }
            } else if (e.getActionCommand().equals("add_entry")) {
                LexiconRootPanel.this.createNewEntry();
            } else if (e.getActionCommand().equals("remove_entry")) {
                if (e.getSource() instanceof JMenuItem) {
                    int row;
                    JMenuItem source = (JMenuItem)e.getSource();
                    if (source.getAction() instanceof RowAction && (row = ((RowAction)source.getAction()).getRow()) > -1) {
                        LexiconRootPanel.this.removeEntryRow(row);
                    }
                } else {
                    LexiconRootPanel.this.removeCurrentEntry();
                }
            } else if (e.getActionCommand().equals("edit_entry")) {
                if (e.getSource() instanceof JMenuItem) {
                    int row;
                    JMenuItem source = (JMenuItem)e.getSource();
                    if (source.getAction() instanceof RowAction && (row = ((RowAction)source.getAction()).getRow()) > -1) {
                        LexiconRootPanel.this.editEntryRow(row);
                    }
                } else {
                    LexiconRootPanel.this.editCurrentEntry();
                }
            } else if (e.getActionCommand() != null && e.getActionCommand().startsWith("fieldName:") && e.getSource() instanceof JCheckBoxMenuItem) {
                int col;
                String field = e.getActionCommand().substring("fieldName:".length());
                JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)e.getSource();
                boolean visible = cbmi.isSelected();
                List<RowSorter.SortKey> sortKeys = null;
                TableColumnDescriptor sortColumnDesc = null;
                if (LexiconRootPanel.this.entryTable.getRowSorter() != null && !(sortKeys = LexiconRootPanel.this.entryTable.getRowSorter().getSortKeys()).isEmpty()) {
                    sortColumnDesc = LexiconRootPanel.this.entryModel.getColumnDescriptors().get(sortKeys.get(0).getColumn());
                }
                if (visible) {
                    boolean editable = field.equals(LexiconFields.ENTRY_CITATION.getFieldName()) || field.equals(LexiconFields.ENTRY_MORPH_TYPE.getFieldName());
                    TableColumnDescriptor gramDesc = new TableColumnDescriptor(field, cbmi.getText(), editable);
                    if (LexiconRootPanel.this.entryModel != null) {
                        LexiconRootPanel.this.entryModel.addColumnDescriptor(gramDesc);
                    }
                } else if (LexiconRootPanel.this.entryModel != null) {
                    LexiconRootPanel.this.entryModel.removeColumnDescriptor(field);
                }
                if (sortColumnDesc != null && (col = LexiconRootPanel.this.entryModel.findColumn(sortColumnDesc.getFieldName())) > -1) {
                    ArrayList<RowSorter.SortKey> nextSortKeys = new ArrayList<RowSorter.SortKey>(1);
                    nextSortKeys.add(new RowSorter.SortKey(col, sortKeys.get(0).getSortOrder()));
                    LexiconRootPanel.this.entryTable.getRowSorter().setSortKeys(nextSortKeys);
                }
            }
        }
    }

    private class TableMouseActionListener
    extends MouseAdapter {
        private TableMouseActionListener() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.getSource() == LexiconRootPanel.this.entryTable && (SwingUtilities.isRightMouseButton(me) || me.isPopupTrigger())) {
                int row = LexiconRootPanel.this.entryTable.getSelectedRow();
                if (row < 0 && (row = LexiconRootPanel.this.entryTable.rowAtPoint(me.getPoint())) >= 0) {
                    LexiconRootPanel.this.entryTable.getSelectionModel().setSelectionInterval(row, row);
                }
                LexiconRootPanel.this.updateTablePopupMenu(LexiconRootPanel.this.entryTable.rowAtPoint(me.getPoint()));
                LexiconRootPanel.this.getTablePopupMenu().show(LexiconRootPanel.this.entryTable, me.getX(), me.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            int row;
            if (me.getSource() == LexiconRootPanel.this.entryTable && me.getClickCount() >= 2 && (row = LexiconRootPanel.this.entryTable.getSelectedRow()) >= 0) {
                LexiconRootPanel.this.editEntryRow(row);
            }
            super.mouseClicked(me);
        }
    }

    private class EntryTableSelectionListener
    implements ListSelectionListener {
        private EntryTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                LexiconRootPanel.this.entrySelectionChanged(e);
            }
        }
    }

    protected class LexiconChangeListener
    implements LexiconEditListener {
        protected LexiconChangeListener() {
        }

        @Override
        public void lexiconEdited(LexiconEvent<LexiconImpl> e) {
            if (e.getType() == LexiconEvent.LexiconEventType.SAVE) {
                LexiconRootPanel.this.setChangedStateOfLexicon(e.getEditObject().getHeader().getName(), false);
            } else {
                LexiconRootPanel.this.setChangedStateOfLexicon(e.getEditObject().getHeader().getName(), true);
            }
            if (e.getType() == LexiconEvent.LexiconEventType.SORT_ORDER_CHANGE) {
                int col;
                List<RowSorter.SortKey> sortKeys = LexiconRootPanel.this.entryTable.getRowSorter().getSortKeys();
                LexiconRootPanel.this.removeCustomComparators();
                LexiconRootPanel.this.comparatorMap.clear();
                LexiconRootPanel.this.updateRowSorterMap();
                LexiconRootPanel.this.addCustomComparators();
                if (sortKeys != null && !sortKeys.isEmpty()) {
                    ((TableRowSorter)LexiconRootPanel.this.entryTable.getRowSorter()).sort();
                } else if (!LexiconRootPanel.this.comparatorMap.isEmpty() && (col = LexiconRootPanel.this.entryModel.findColumn(LexiconFields.ENTRY_LEX_UNIT.getFieldName())) > -1) {
                    RowSorter.SortKey sk = new RowSorter.SortKey(col, SortOrder.ASCENDING);
                    ArrayList<RowSorter.SortKey> sKeys = new ArrayList<RowSorter.SortKey>(1);
                    sKeys.add(sk);
                    LexiconRootPanel.this.entryTable.getRowSorter().setSortKeys(sKeys);
                }
            }
        }

        @Override
        public void lexiconEntryEdited(LexiconEvent<EntryImpl> e) {
            LexiconRootPanel.this.setChangedStateOfLexicon(e.getEditObject().getLexicon().getHeader().getName(), true);
        }

        @Override
        public void lexiconSenseEdited(LexiconEvent<SenseImpl> e) {
            if (e.getSource() instanceof LexiconImpl) {
                LexiconRootPanel.this.setChangedStateOfLexicon(((LexiconImpl)e.getSource()).getHeader().getName(), true);
            }
        }
    }
}

