/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui;

import java.awt.Dialog;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import nl.mpi.lexiconcomponent.gui.ElanLexRootPanel;
import nl.mpi.lexiconcomponent.gui.EntryEditRootPanel;
import nl.mpi.lexiconcomponent.gui.LexEditRootPanel;
import nl.mpi.lexiconcomponent.gui.LexiconEditorDialog;
import nl.mpi.lexiconcomponent.gui.LexiconEditorFrame;
import nl.mpi.lexiconcomponent.gui.LexiconEditorPanel;
import nl.mpi.lexiconcomponent.gui.LexiconHandler;
import nl.mpi.lexiconcomponent.gui.LexiconRootPanel;
import nl.mpi.lexiconcomponent.impl.EntryImpl;

public class LexiconViewManager {
    private LexiconHandler lexiconHandler;
    private LexiconEditorPanel lexiconEditorPanel;
    private ElanLexRootPanel compactLexPanel;
    private LexEditRootPanel expandLexPanel;
    private EntryEditRootPanel entryEditPanel;
    protected Map<String, Object> preferencesMap;

    public LexiconViewManager(String lexFolderName, String lexName) {
        this(lexFolderName, lexName, true);
    }

    public LexiconViewManager(String lexFolderName, String lexName, boolean canChangeLexicon) {
        this.lexiconHandler = new LexiconHandler(lexFolderName, lexName, canChangeLexicon);
    }

    public LexiconHandler getLexiconHandler() {
        return this.lexiconHandler;
    }

    public LexiconRootPanel getLexiconRootPanel(LAYOUT_MODE forMode) {
        switch (forMode) {
            case COMPACT: {
                if (this.compactLexPanel == null) {
                    this.compactLexPanel = new ElanLexRootPanel(this);
                }
                return this.compactLexPanel;
            }
            case EXPANDED: {
                if (this.expandLexPanel == null) {
                    this.expandLexPanel = new LexEditRootPanel(this);
                }
                return this.expandLexPanel;
            }
        }
        return null;
    }

    public EntryEditRootPanel getEntryRootPanel() {
        if (this.entryEditPanel == null) {
            this.entryEditPanel = new EntryEditRootPanel(this);
        }
        return this.entryEditPanel;
    }

    public LexiconEditorPanel getLexiconEditorPanel() {
        if (this.lexiconEditorPanel == null) {
            this.lexiconEditorPanel = new LexiconEditorPanel(this);
        }
        return this.lexiconEditorPanel;
    }

    public void createAndShowDialog(Window parent) {
        LexiconEditorDialog lexDialog = new LexiconEditorDialog(parent, Dialog.ModalityType.DOCUMENT_MODAL, this);
        if (parent != null) {
            lexDialog.setBounds(parent.getBounds());
        }
        if (this.lexiconEditorPanel != null && this.preferencesMap != null) {
            this.lexiconEditorPanel.setUserPreferences(this.preferencesMap);
        }
        lexDialog.setVisible(true);
    }

    public void createAndShowFrame(Window parent) {
        LexiconEditorFrame lexFrame = new LexiconEditorFrame(this);
        if (parent != null) {
            lexFrame.setBounds(parent.getBounds());
        }
        lexFrame.setVisible(true);
    }

    public void initNewEntry() {
        if (this.entryEditPanel != null) {
            this.entryEditPanel.initNewEntry();
        }
    }

    public void editEntry(EntryImpl entry) {
        if (this.entryEditPanel != null) {
            this.entryEditPanel.showEntry(entry);
        }
    }

    public void isClosing() {
        if (this.compactLexPanel != null) {
            this.compactLexPanel.isClosing();
        } else if (this.lexiconEditorPanel != null) {
            this.lexiconEditorPanel.isClosing();
        }
    }

    public void setUserPreferences(Map<String, Object> loadedPrefMap) {
        if (loadedPrefMap != null) {
            if (this.preferencesMap == null) {
                this.preferencesMap = new HashMap<String, Object>(loadedPrefMap);
            } else {
                this.preferencesMap.putAll(loadedPrefMap);
            }
            if (this.compactLexPanel != null) {
                this.compactLexPanel.setUserPreferences(this.preferencesMap);
            }
            if (this.lexiconEditorPanel != null) {
                this.lexiconEditorPanel.setUserPreferences(this.preferencesMap);
            }
        }
    }

    public void updateUserPreferences(Map<String, Object> curPrefMap) {
        if (curPrefMap != null) {
            if (this.preferencesMap == null) {
                this.preferencesMap = new HashMap<String, Object>(curPrefMap);
            } else {
                this.preferencesMap.putAll(curPrefMap);
            }
        }
    }

    public Map<String, Object> getUserPreferences() {
        Map<String, Object> expMap;
        Map<String, Object> comMap;
        if (this.preferencesMap == null) {
            this.preferencesMap = new HashMap<String, Object>();
        }
        if (this.compactLexPanel != null && (comMap = this.compactLexPanel.getUserPreferences()) != null) {
            this.preferencesMap.putAll(comMap);
        }
        if (this.lexiconEditorPanel != null && (expMap = this.lexiconEditorPanel.getUserPreferences()) != null) {
            this.preferencesMap.putAll(expMap);
        }
        if (!this.preferencesMap.isEmpty()) {
            return this.preferencesMap;
        }
        return null;
    }

    public static enum LAYOUT_MODE {
        COMPACT,
        EXPANDED;

    }
}

