/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui.lexproperties;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.model.CustomFieldSpec;
import nl.mpi.lexiconcomponent.util.EntryFieldTriplet;

public class CustomFieldTableModel
extends DefaultTableModel {
    private int numColumns = 2;
    private List<EntryFieldTriplet<LexiconFields, CustomFieldSpec, String>> fieldList = new ArrayList<EntryFieldTriplet<LexiconFields, CustomFieldSpec, String>>(10);
    private List<EntryFieldTriplet<LexiconFields, CustomFieldSpec, String>> removedList;

    public void addRow(EntryFieldTriplet<LexiconFields, CustomFieldSpec, String> rowData) {
        if (rowData != null) {
            this.fieldList.add(rowData);
            rowData.setAdded(true);
            this.fireTableRowsInserted(this.fieldList.size() - 1, this.fieldList.size() - 1);
        }
    }

    public void insertRow(int row, EntryFieldTriplet<LexiconFields, CustomFieldSpec, String> rowData) {
        if (rowData != null) {
            if (row < this.fieldList.size()) {
                this.fieldList.add(row, rowData);
                rowData.setAdded(true);
                this.fireTableRowsInserted(row, row);
            } else {
                this.addRow(rowData);
            }
        }
    }

    @Override
    public void removeRow(int row) {
        if (row > -1 && row < this.fieldList.size()) {
            EntryFieldTriplet<LexiconFields, CustomFieldSpec, String> field = this.fieldList.remove(row);
            field.setRemoved(true);
            if (this.removedList == null) {
                this.removedList = new ArrayList<EntryFieldTriplet<LexiconFields, CustomFieldSpec, String>>();
            }
            this.removedList.add(field);
            this.fireTableRowsDeleted(row, row);
        }
    }

    @Override
    public int getColumnCount() {
        return this.numColumns;
    }

    @Override
    public int getRowCount() {
        if (this.fieldList == null) {
            return 0;
        }
        return this.fieldList.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row > -1 && row < this.fieldList.size()) {
            EntryFieldTriplet<LexiconFields, CustomFieldSpec, String> field = this.fieldList.get(row);
            if (column == 0) {
                if (field.isEdited()) {
                    return field.getEdit();
                }
                return field.getOrig().getName();
            }
            if (column == 1) {
                return field.getOrig().getLevel();
            }
        }
        return null;
    }

    public EntryFieldTriplet<LexiconFields, CustomFieldSpec, String> getValueAt(int row) {
        if (row > -1 && row < this.fieldList.size()) {
            return this.fieldList.get(row);
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (row > -1 && row < this.fieldList.size() && column > -1 && column < this.numColumns) {
            EntryFieldTriplet<LexiconFields, CustomFieldSpec, String> field = this.fieldList.get(row);
            if (column == 0) {
                field.setEdit(aValue.toString());
            } else if (column == 1) {
                field.getOrig().setLevel(aValue.toString());
            }
            this.fireTableCellUpdated(row, column);
        }
    }
}

