/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui.lexproperties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import nl.mpi.lexiconcomponent.gui.LexiconGuiResources;
import nl.mpi.lexiconcomponent.gui.lexproperties.CustomFieldTableModel;
import nl.mpi.lexiconcomponent.gui.lexproperties.LexPropertyEditor;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.impl.LexiconImpl;
import nl.mpi.lexiconcomponent.model.CustomFieldSpec;
import nl.mpi.lexiconcomponent.model.CustomFieldSpecification;
import nl.mpi.lexiconcomponent.util.EntryFieldTriplet;
import nl.mpi.lexiconcomponent.util.NCNameCheck;

public class CustomFieldsEditPanel
extends JPanel
implements LexPropertyEditor,
ActionListener,
TableModelListener,
ListSelectionListener {
    private LexiconImpl lexiconImpl;
    private Map<String, Object> resultMap;
    private CustomFieldTableModel tableModel;
    private JTable cfTable;
    private JComboBox levelCombo;
    private String[] colIds;
    private JLabel titleLabel;
    private JButton removeButton;
    private String emptyRowNameText;
    private String emptyRowSelectText;
    private final String ALL = "all";
    private NCNameCheck nameChecker = new NCNameCheck();

    public CustomFieldsEditPanel(LexiconImpl lexiconImpl) {
        this.lexiconImpl = lexiconImpl;
        this.initComponents();
        this.fillTableModel();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.titleLabel = new JLabel(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit.CustomFields.Title", "Edit custom fields of this lexicon"));
        this.tableModel = new CustomFieldTableModel();
        this.colIds = new String[2];
        this.colIds[0] = LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.CustomField.Name", "Custom Field Name");
        this.colIds[1] = LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.CustomField.Under", "Field Under");
        this.tableModel.setColumnIdentifiers(this.colIds);
        this.cfTable = new JTable(this.tableModel);
        this.cfTable.getTableHeader().setReorderingAllowed(false);
        this.cfTable.getSelectionModel().setSelectionMode(0);
        this.emptyRowNameText = LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit.CustomFields.Enter", "<enter custom field name>");
        this.emptyRowSelectText = LexiconGuiResources.getLocalizedString("InterlinearAnalyzerConfigDlg.ComboBoxDefaultString", "<select>");
        FieldCellEditor fieldNameEditor = new FieldCellEditor(new JTextField());
        fieldNameEditor.setClickCountToStart(1);
        this.cfTable.getColumn(this.colIds[0]).setCellEditor(fieldNameEditor);
        FieldCellRenderer fieldCellRenderer = new FieldCellRenderer();
        this.cfTable.getColumn(this.colIds[0]).setCellRenderer(fieldCellRenderer);
        this.cfTable.getColumn(this.colIds[1]).setCellRenderer(fieldCellRenderer);
        this.levelCombo = new JComboBox();
        this.levelCombo.addItem(LexiconFields.ENTRY.getFieldName());
        this.levelCombo.addItem(LexiconFields.SENSE.getFieldName());
        this.levelCombo.addItem(LexiconFields.ENTRY.getFieldName() + " & " + LexiconFields.SENSE.getFieldName());
        this.cfTable.getColumn(this.colIds[1]).setCellEditor(new DefaultCellEditor(this.levelCombo));
        this.cfTable.setRowHeight(this.levelCombo.getPreferredSize().height);
        this.removeButton = new JButton(LexiconGuiResources.getLocalizedString("Button.Remove", "Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 4, 2, 4);
        this.add((Component)this.titleLabel, gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(2, 4, 4, 4);
        JScrollPane tableScroll = new JScrollPane(this.cfTable);
        tableScroll.setPreferredSize(new Dimension(200, 50));
        this.add((Component)tableScroll, gbc);
        gbc.gridy = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        this.add((Component)this.removeButton, gbc);
    }

    private void fillTableModel() {
        List<CustomFieldSpec> curFieldList;
        CustomFieldSpecification curFieldSpecs;
        if (this.lexiconImpl != null && (curFieldSpecs = this.lexiconImpl.getHeader().getCustomFields()) != null && (curFieldList = curFieldSpecs.getFieldSpec()) != null) {
            for (CustomFieldSpec cfs : curFieldList) {
                String level = cfs.getLevel();
                if (level.equals("all")) {
                    level = (String)this.levelCombo.getItemAt(this.levelCombo.getItemCount() - 1);
                }
                CustomFieldSpec copySpec = new CustomFieldSpec();
                copySpec.setName(cfs.getName());
                copySpec.setLevel(level);
                EntryFieldTriplet<LexiconFields, CustomFieldSpec, Object> eft = new EntryFieldTriplet<LexiconFields, CustomFieldSpec, Object>(LexiconFields.ENTRY_FIELD, copySpec, null);
                this.tableModel.addRow(eft);
            }
        }
        CustomFieldSpec fillField = new CustomFieldSpec();
        fillField.setName(this.emptyRowNameText);
        fillField.setLevel(this.emptyRowSelectText);
        EntryFieldTriplet<LexiconFields, CustomFieldSpec, Object> emptyRowTriplet = new EntryFieldTriplet<LexiconFields, CustomFieldSpec, Object>(LexiconFields.ENTRY_FIELD, fillField, null);
        emptyRowTriplet.setAdded(true);
        this.tableModel.addRow(emptyRowTriplet);
        this.tableModel.addTableModelListener(this);
        this.cfTable.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public boolean validateFields() {
        if (this.cfTable.isEditing()) {
            this.cfTable.getCellEditor().stopCellEditing();
        }
        return true;
    }

    @Override
    public Map<String, Object> getValueMap() {
        if (this.tableModel.getRowCount() > 1) {
            this.resultMap = new HashMap<String, Object>();
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                EntryFieldTriplet<LexiconFields, CustomFieldSpec, String> fieldTriplet = this.tableModel.getValueAt(i);
                String fieldId = fieldTriplet.getOrig().getName();
                if (fieldId.equals(this.emptyRowNameText)) {
                    if (!fieldTriplet.isEdited()) continue;
                    fieldId = fieldTriplet.getEdit();
                }
                if (fieldTriplet.getOrig().getLevel().equals(this.emptyRowSelectText)) {
                    fieldTriplet.getOrig().setLevel(LexiconFields.ENTRY.getFieldName());
                }
                String level = fieldTriplet.getOrig().getLevel();
                if (!this.resultMap.containsKey(fieldId)) {
                    this.resultMap.put(fieldId, fieldTriplet);
                    continue;
                }
                EntryFieldTriplet existTriplet = (EntryFieldTriplet)this.resultMap.get(fieldId);
                String curLevel = ((CustomFieldSpec)existTriplet.getOrig()).getLevel();
                if (curLevel.equals(level) || curLevel.equals("all")) continue;
                ((CustomFieldSpec)existTriplet.getOrig()).setLevel("all");
            }
            return this.resultMap;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.removeButton) {
            String warningMes;
            int option;
            int selRow;
            if (this.cfTable.isEditing()) {
                this.cfTable.getCellEditor().cancelCellEditing();
            }
            if ((selRow = this.cfTable.getSelectedRow()) > -1 && selRow < this.cfTable.getRowCount() - 1 && (option = JOptionPane.showConfirmDialog(this, warningMes = LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit.CustomFields.Remove.Warn", "Removing a custom field here will remove all fields of the same name from the lexical entries!"), LexiconGuiResources.getLocalizedString("Message.Warning", "Warning"), 2, 2, null)) == 0) {
                this.tableModel.removeRow(selRow);
                this.updateButtonState();
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            EntryFieldTriplet<LexiconFields, CustomFieldSpec, String> eft;
            if (e.getColumn() == 0) {
                String value = (String)this.tableModel.getValueAt(e.getLastRow(), 0);
                String ncNameValue = this.toNCName(value);
                if (ncNameValue == null || ncNameValue.isEmpty()) {
                    this.tableModel.setValueAt("X", e.getLastRow(), 0);
                } else if (!ncNameValue.equals(value)) {
                    this.tableModel.setValueAt(ncNameValue, e.getLastRow(), 0);
                }
            }
            if (e.getColumn() == 0 && e.getLastRow() == this.tableModel.getRowCount() - 1 && this.emptyRowNameText.equals((eft = this.tableModel.getValueAt(e.getLastRow())).getOrig().getName()) && eft.isEdited()) {
                CustomFieldSpec fillField = new CustomFieldSpec();
                fillField.setName(this.emptyRowNameText);
                fillField.setLevel(this.emptyRowSelectText);
                EntryFieldTriplet<LexiconFields, CustomFieldSpec, Object> emptyRowTriplet = new EntryFieldTriplet<LexiconFields, CustomFieldSpec, Object>(LexiconFields.ENTRY_FIELD, fillField, null);
                emptyRowTriplet.setAdded(true);
                this.tableModel.addRow(emptyRowTriplet);
                this.cfTable.setRowSelectionInterval(this.cfTable.getRowCount() - 1, this.cfTable.getRowCount() - 1);
                this.updateButtonState();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.updateButtonState();
        }
    }

    private void updateButtonState() {
        int selRow = this.cfTable.getSelectedRow();
        if (selRow > -1 && selRow < this.cfTable.getRowCount() - 1) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }

    private String toNCName(String name) {
        String resultName = this.nameChecker.convertName(name);
        if (resultName.isEmpty() || resultName.matches("[_]*")) {
            return null;
        }
        return resultName;
    }

    private class FieldCellEditor
    extends DefaultCellEditor {
        public FieldCellEditor(JTextField textField) {
            super(textField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (CustomFieldsEditPanel.this.emptyRowNameText.equals(value)) {
                value = "";
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private class FieldCellRenderer
    extends DefaultTableCellRenderer {
        private Font plainFont;
        private Font italicFont;

        private FieldCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (row == table.getRowCount() - 1) {
                if (this.italicFont == null) {
                    this.plainFont = c.getFont();
                    this.italicFont = c.getFont().deriveFont(2);
                }
                c.setFont(this.italicFont);
            } else {
                c.setFont(this.plainFont);
            }
            return c;
        }
    }
}

