/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui.lexproperties;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import nl.mpi.lexiconcomponent.gui.LexiconGuiResources;
import nl.mpi.lexiconcomponent.gui.lexproperties.LexPropertyEditor;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.impl.LexiconImpl;
import nl.mpi.lexiconcomponent.model.Header;

public class GeneralPropertiesPanel
extends JPanel
implements LexPropertyEditor {
    private LexiconImpl lexiconImpl;
    private Map<String, Object> resultMap;
    private JLabel titleLabel;
    private JPanel inputPanel;
    private JLabel nameLabel;
    private JLabel languageLabel;
    private JLabel descriptionLabel;
    private JLabel authorLabel;
    private JLabel versionLabel;
    private JTextField nameField;
    private JTextField languageField;
    private JTextField authorField;
    private JTextField versionField;
    private JTextArea descriptionArea;
    private String origAuthors;

    public GeneralPropertiesPanel(LexiconImpl lexiconImpl) {
        this.lexiconImpl = lexiconImpl;
        this.initComponents();
        this.initFieldValues();
    }

    private void initComponents() {
        this.inputPanel = new JPanel();
        GroupLayout grpLayout = new GroupLayout(this.inputPanel);
        this.inputPanel.setLayout(grpLayout);
        grpLayout.setAutoCreateGaps(true);
        grpLayout.setAutoCreateContainerGaps(true);
        this.nameLabel = new JLabel(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Name", "Lexicon Name"));
        this.descriptionLabel = new JLabel(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Description", "Description"));
        this.languageLabel = new JLabel(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Language", "Main language"));
        this.authorLabel = new JLabel(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Author", "Author"));
        this.versionLabel = new JLabel(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Version", "Version"));
        this.nameField = new JTextField();
        this.descriptionArea = new JTextArea();
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setRows(3);
        JScrollPane descriptionScroll = new JScrollPane(this.descriptionArea);
        this.languageField = new JTextField();
        this.authorField = new JTextField();
        this.versionField = new JTextField();
        GroupLayout.SequentialGroup hGroup = grpLayout.createSequentialGroup();
        hGroup.addGroup(grpLayout.createParallelGroup().addComponent(this.nameLabel).addComponent(this.descriptionLabel).addComponent(this.languageLabel).addComponent(this.authorLabel).addComponent(this.versionLabel));
        hGroup.addGroup(grpLayout.createParallelGroup().addComponent(this.nameField).addComponent(descriptionScroll).addComponent(this.languageField).addComponent(this.authorField).addComponent(this.versionField));
        grpLayout.setHorizontalGroup(hGroup);
        GroupLayout.SequentialGroup vGroup = grpLayout.createSequentialGroup();
        vGroup.addGroup(grpLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameField));
        vGroup.addGroup(grpLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.descriptionLabel).addComponent(descriptionScroll));
        vGroup.addGroup(grpLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.languageLabel).addComponent(this.languageField));
        vGroup.addGroup(grpLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.authorLabel).addComponent(this.authorField));
        vGroup.addGroup(grpLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionLabel).addComponent(this.versionField));
        grpLayout.setVerticalGroup(vGroup);
        this.titleLabel = this.lexiconImpl == null ? new JLabel(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.New.Title", "Specify properties for a new lexicon")) : new JLabel(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit.Title", "Edit properties of this lexicon"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 4, 2, 4);
        this.add((Component)this.titleLabel, gbc);
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 4, 4, 4);
        this.add((Component)this.inputPanel, gbc);
    }

    private void initFieldValues() {
        if (this.lexiconImpl != null) {
            Header header = this.lexiconImpl.getHeader();
            this.nameField.setText(header.getName());
            this.languageField.setText(header.getLanguage());
            if (header.getDescription() != null) {
                this.descriptionArea.setText(header.getDescription());
            }
            if (header.getAuthor() != null && header.getAuthor().size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < header.getAuthor().size(); ++i) {
                    sb.append(header.getAuthor().get(i));
                    if (i == header.getAuthor().size() - 1) continue;
                    sb.append(", ");
                }
                this.origAuthors = sb.toString();
                this.authorField.setText(this.origAuthors);
            }
            if (header.getVersion() != null) {
                this.versionField.setText(header.getVersion());
            }
        }
    }

    @Override
    public boolean validateFields() {
        String version;
        String author;
        String name = this.nameField.getText();
        if (name == null || name.isEmpty()) {
            this.nameField.requestFocusInWindow();
            this.nameLabel.setForeground(Color.RED);
            return false;
        }
        String language = this.languageField.getText();
        if (language == null || language.isEmpty()) {
            this.languageField.requestFocusInWindow();
            this.languageLabel.setForeground(Color.RED);
            return false;
        }
        this.resultMap = new HashMap<String, Object>(4);
        this.resultMap.put(LexiconFields.HEADER_NAME.getFieldName(), name);
        this.resultMap.put(LexiconFields.HEADER_LANG.getFieldName(), language);
        String description = this.descriptionArea.getText();
        if (description != null && !description.isEmpty()) {
            this.resultMap.put(LexiconFields.HEADER_DESC.getFieldName(), description);
        }
        if ((author = this.authorField.getText()) != null && !author.isEmpty()) {
            this.resultMap.put(LexiconFields.HEADER_AUTHOR.getFieldName(), author);
        }
        if ((version = this.versionField.getText()) != null && !version.isEmpty()) {
            this.resultMap.put(LexiconFields.HEADER_VERSION.getFieldName(), version);
        }
        return true;
    }

    @Override
    public Map<String, Object> getValueMap() {
        return this.resultMap;
    }
}

