/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui.lexproperties;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import nl.mpi.lexiconcomponent.gui.LexiconGuiResources;
import nl.mpi.lexiconcomponent.gui.lexproperties.LexPropertyEditor;
import nl.mpi.lexiconcomponent.impl.LexiconImpl;

public class SortOrderPanel
extends JPanel
implements LexPropertyEditor {
    private LexiconImpl lexiconImpl;
    private JLabel titleLabel;
    private JLabel titleLabel2;
    private JTextArea textArea;

    public SortOrderPanel(LexiconImpl lexiconImpl) {
        this.lexiconImpl = lexiconImpl;
        this.initComponents();
        this.initOrder();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.titleLabel = new JLabel(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit.SortOrder.Title1", "Edit the preferred sort order"));
        this.titleLabel2 = new JLabel(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Edit.SortOrder.Title2", "Enter a space separated list of one or more characters"));
        this.textArea = new JTextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        float fontSize = this.textArea.getFont().getSize2D();
        this.textArea.setFont(this.textArea.getFont().deriveFont(1.4f * fontSize));
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 4, 2, 4);
        this.add((Component)this.titleLabel, gbc);
        gbc.gridy = 1;
        gbc.insets = new Insets(2, 4, 4, 4);
        this.add((Component)this.titleLabel2, gbc);
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)scrollPane, gbc);
    }

    private void initOrder() {
        String so;
        if (this.lexiconImpl != null && (so = this.lexiconImpl.getHeader().getSortOrder()) != null && this.textArea != null) {
            this.textArea.setText(so);
        }
    }

    @Override
    public boolean validateFields() {
        return true;
    }

    @Override
    public Map<String, Object> getValueMap() {
        if (this.textArea != null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            String text = this.textArea.getText();
            if (text != null) {
                text = text.replaceAll("\\s+", " ");
            }
            result.put("SortOrderString", text);
            return result;
        }
        return null;
    }
}

