/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import nl.mpi.lexiconcomponent.events.LexiconEditListener;
import nl.mpi.lexiconcomponent.events.LexiconEvent;
import nl.mpi.lexiconcomponent.exceptions.LexiconStructureException;
import nl.mpi.lexiconcomponent.gui.table.TableColumnDescriptor;
import nl.mpi.lexiconcomponent.impl.EntryImpl;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.impl.LexiconImpl;
import nl.mpi.lexiconcomponent.impl.SenseImpl;
import nl.mpi.lexiconcomponent.model.Entry;
import nl.mpi.lexiconcomponent.query.EntryFieldGetter;
import nl.mpi.lexiconcomponent.query.EntryFieldGetterFactory;

public class EntryTableModel2
extends AbstractTableModel
implements LexiconEditListener {
    private LexiconImpl lexiconImpl = null;
    private List<TableColumnDescriptor> columnDescriptors = null;
    private List<EntryFieldGetter> fieldGetters = null;
    private List<Entry> entries;

    public EntryTableModel2(LexiconImpl lexiconImpl, List<TableColumnDescriptor> columnDescriptorList) {
        this.lexiconImpl = lexiconImpl;
        this.columnDescriptors = columnDescriptorList != null ? new ArrayList<TableColumnDescriptor>(columnDescriptorList) : this.createDefaultColumnDescriptors();
        this.fieldGetters = new ArrayList<EntryFieldGetter>(this.columnDescriptors.size());
        for (TableColumnDescriptor tcd : this.columnDescriptors) {
            this.fieldGetters.add(EntryFieldGetterFactory.createGetter(tcd.getFieldName(), true));
        }
        if (lexiconImpl != null) {
            this.entries = new ArrayList<Entry>(this.lexiconImpl.getEntries());
            lexiconImpl.addLexiconEditListener(this);
        } else {
            this.entries = new ArrayList<Entry>();
        }
    }

    private List<TableColumnDescriptor> createDefaultColumnDescriptors() {
        ArrayList<TableColumnDescriptor> defDescs = new ArrayList<TableColumnDescriptor>(3);
        defDescs.add(new TableColumnDescriptor(LexiconFields.ENTRY_LEX_UNIT, false));
        defDescs.add(new TableColumnDescriptor(LexiconFields.ENTRY_MORPH_TYPE, true));
        defDescs.add(new TableColumnDescriptor(LexiconFields.ENTRY_CITATION, true));
        return defDescs;
    }

    public void addColumnDescriptor(TableColumnDescriptor nextDescriptor) {
        if (nextDescriptor != null) {
            for (TableColumnDescriptor tcd : this.columnDescriptors) {
                if (!tcd.getFieldName().equals(nextDescriptor.getFieldName())) continue;
                return;
            }
            this.columnDescriptors.add(nextDescriptor);
            this.fieldGetters.add(EntryFieldGetterFactory.createGetter(nextDescriptor.getFieldName(), true));
            this.fireTableStructureChanged();
        }
    }

    public TableColumnDescriptor removeColumnDescriptor(String fieldName) {
        for (TableColumnDescriptor tcd : this.columnDescriptors) {
            if (!tcd.getFieldName().equals(fieldName)) continue;
            int index = this.columnDescriptors.indexOf(tcd);
            this.columnDescriptors.remove(index);
            this.fieldGetters.remove(index);
            this.fireTableStructureChanged();
            return tcd;
        }
        return null;
    }

    public List<TableColumnDescriptor> getColumnDescriptors() {
        return this.columnDescriptors;
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnDescriptors.size();
    }

    @Override
    public int findColumn(String columnName) {
        for (int i = 0; i < this.columnDescriptors.size(); ++i) {
            TableColumnDescriptor tcd = this.columnDescriptors.get(i);
            if (!tcd.getFieldName().equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        if (column >= 0 && column < this.columnDescriptors.size()) {
            return this.columnDescriptors.get(column).getDisplayName();
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column >= 0 && column < this.columnDescriptors.size()) {
            return this.columnDescriptors.get(column).isEditable();
        }
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.entries.size()) {
            EntryImpl entry = (EntryImpl)this.entries.get(rowIndex);
            if (columnIndex >= 0 && columnIndex < this.columnDescriptors.size()) {
                EntryFieldGetter getter = this.fieldGetters.get(columnIndex);
                List<String> vals = getter.getValues(entry);
                if (vals.size() == 0) {
                    return "-";
                }
                if (vals.size() == 1) {
                    return this.nonNull(vals.get(0));
                }
                return this.concatValues(vals);
            }
        }
        return "-";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Object oldValue;
        String nextValue = null;
        if (aValue instanceof String) {
            nextValue = (String)aValue;
        }
        if (nextValue.equals(oldValue = this.getValueAt(rowIndex, columnIndex))) {
            return;
        }
        if (oldValue == null && nextValue.isEmpty()) {
            return;
        }
        if (rowIndex >= 0 && rowIndex < this.entries.size()) {
            EntryImpl entry = (EntryImpl)this.entries.get(rowIndex);
            if (columnIndex >= 0 && columnIndex < this.columnDescriptors.size()) {
                try {
                    this.lexiconImpl.changeSingleEntryField(entry, this.columnDescriptors.get(columnIndex).getFieldName(), nextValue);
                }
                catch (LexiconStructureException lexiconStructureException) {
                    // empty catch block
                }
            }
        }
    }

    public EntryImpl getEntryAt(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.entries.size()) {
            return (EntryImpl)this.entries.get(rowIndex);
        }
        return null;
    }

    private String concatValues(List<String> values) {
        StringBuilder sb = new StringBuilder();
        for (String v : values) {
            sb.append("[");
            sb.append(this.nonNull(v));
            sb.append(']');
        }
        return sb.toString();
    }

    private String nonNull(String v) {
        return v != null ? v : "";
    }

    @Override
    public void lexiconEdited(LexiconEvent<LexiconImpl> e) {
        if (e.getType() == LexiconEvent.LexiconEventType.SAVE) {
            // empty if block
        }
    }

    @Override
    public void lexiconEntryEdited(LexiconEvent<EntryImpl> e) {
        EntryImpl entry = e.getEditObject();
        LexiconEvent.LexiconEventType type = e.getType();
        switch (e.getType()) {
            case ADD: {
                int index = this.lexiconImpl.getEntries().indexOf(entry);
                try {
                    this.entries.add(index, entry);
                }
                catch (IndexOutOfBoundsException iobe) {
                    this.entries.add(entry);
                }
                this.fireTableRowsInserted(index, index);
                break;
            }
            case REMOVE: {
                int delIndex = this.entries.indexOf(entry);
                if (delIndex < 0) break;
                this.entries.remove(entry);
                this.fireTableRowsDeleted(delIndex, delIndex);
                break;
            }
            case CHANGE: {
                int changeIndex = this.entries.indexOf(entry);
                if (changeIndex < 0) break;
                this.fireTableRowsUpdated(changeIndex, changeIndex);
                break;
            }
        }
    }

    @Override
    public void lexiconSenseEdited(LexiconEvent<SenseImpl> e) {
        SenseImpl sense = e.getEditObject();
        EntryImpl entry = sense.getEntry();
        int changeIndex = this.entries.indexOf(entry);
        if (changeIndex >= 0) {
            this.fireTableRowsUpdated(changeIndex, changeIndex);
        }
    }
}

