/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui.tree;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JDialog;
import nl.mpi.lexiconcomponent.gui.tree.EditEntryTreePanel;
import nl.mpi.lexiconcomponent.impl.EntryImpl;

public class EditEntryDialog
extends JDialog {
    private EntryImpl entry;
    private EditEntryTreePanel editPanel;
    private EditListener editListener;
    private KeyDispatcher keyDispatcher;

    public EditEntryDialog(Window owner, Dialog.ModalityType modalityType, EntryImpl entry) {
        super(owner, modalityType);
        this.entry = entry;
        this.initComponents();
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private void initComponents() {
        this.editPanel = new EditEntryTreePanel(this.entry);
        this.getContentPane().add((Component)this.editPanel, "Center");
        this.editListener = new EditListener();
        this.editPanel.addActionListener(this.editListener);
        this.keyDispatcher = new KeyDispatcher();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyDispatcher);
    }

    private void doClose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyDispatcher);
        this.setVisible(false);
        this.dispose();
    }

    class EditListener
    implements ActionListener {
        EditListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command != null && (command.equals("apply") || command.equals("cancel"))) {
                EditEntryDialog.this.doClose();
            }
        }
    }

    class KeyDispatcher
    implements KeyEventDispatcher {
        final int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

        KeyDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 27 && e.getID() == 401 || e.getKeyCode() == 87 && e.getID() == 401 && e.getModifiers() == this.menuShortcutKeyMask) {
                EditEntryDialog.this.doClose();
                return true;
            }
            if (e.getKeyCode() == 9 && e.getID() == 401 || e.getKeyCode() == 61 && e.getID() == 401) {
                EditEntryDialog.this.editPanel.processKeyEvent(e);
                return true;
            }
            if (e.getKeyCode() == 10 && e.getID() == 401) {
                EditEntryDialog.this.editPanel.processKeyEvent(e);
                return true;
            }
            return false;
        }
    }
}

