/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import nl.mpi.lexiconcomponent.exceptions.LexiconStructureException;
import nl.mpi.lexiconcomponent.gui.LexiconGuiResources;
import nl.mpi.lexiconcomponent.gui.tree.EntryEditCommitter;
import nl.mpi.lexiconcomponent.gui.tree.EntryTreeCellEditor;
import nl.mpi.lexiconcomponent.gui.tree.EntryTreeCellRenderer;
import nl.mpi.lexiconcomponent.gui.tree.EntryTreeModel;
import nl.mpi.lexiconcomponent.impl.EntryImpl;

public class EditEntryTreePanel
extends JPanel
implements ActionListener {
    private EntryImpl curEntry;
    private DefaultTreeModel curModel;
    private JTree entryTree;
    private JScrollPane entryScrollPane;
    private JPanel buttonPanel;
    private JButton applyButton;
    private JButton cancelButton;
    private List<ActionListener> listeners;

    public EditEntryTreePanel(EntryImpl entry) {
        this.curEntry = entry;
        this.initComponents();
    }

    public EditEntryTreePanel() {
        this.initComponents();
    }

    public void setEntry(EntryImpl nextEntry) {
        this.applyChanges();
        this.clearEntry();
        if (nextEntry != null) {
            this.curEntry = nextEntry;
            this.curModel = this.createModel(nextEntry);
            this.entryTree = this.createTree(this.curModel);
            this.entryScrollPane.setViewportView(this.entryTree);
            this.entryTree.startEditingAtPath(this.entryTree.getPathForRow(0));
        }
        this.updateButtonStates();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.buttonPanel = new JPanel(new FlowLayout());
        this.applyButton = new JButton();
        this.applyButton.setActionCommand("apply");
        this.cancelButton = new JButton();
        this.cancelButton.setActionCommand("cancel");
        this.buttonPanel.add(this.applyButton);
        this.buttonPanel.add(this.cancelButton);
        this.entryScrollPane = new JScrollPane();
        this.setEntry(this.curEntry);
        this.applyButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.updateLocale();
        this.add((Component)this.entryScrollPane, "Center");
        this.add((Component)this.buttonPanel, "South");
    }

    private JTree createTree(DefaultTreeModel model) {
        if (model != null) {
            JTree tree = new JTree(model);
            for (int i = 0; i < tree.getRowCount(); ++i) {
                tree.expandRow(i);
            }
            if (model instanceof EntryTreeModel) {
                EntryTreeCellRenderer renderer = new EntryTreeCellRenderer();
                tree.setCellRenderer(renderer);
                EntryTreeCellEditor editor = new EntryTreeCellEditor();
                tree.setCellEditor(editor);
                tree.setRowHeight(0);
                tree.setEditable(true);
            } else {
                tree.setEditable(false);
            }
            return tree;
        }
        return new JTree(new DefaultMutableTreeNode(LexiconGuiResources.getLocalizedString("LexiconComponent.Entry.NotLoaded", "No entry loaded")));
    }

    private DefaultTreeModel createModel(EntryImpl entry) {
        if (entry != null) {
            return new EntryTreeModel(entry);
        }
        return new DefaultTreeModel(new DefaultMutableTreeNode(LexiconGuiResources.getLocalizedString("LexiconComponent.Entry.NotLoaded", "No entry loaded")));
    }

    private void clearEntry() {
        this.entryScrollPane.setViewportView(this.createTree(null));
        this.curEntry = null;
        this.curModel = null;
        this.entryTree = null;
    }

    private void updateButtonStates() {
        this.applyButton.setEnabled(this.curEntry != null);
        this.cancelButton.setEnabled(this.curEntry != null);
    }

    public void updateLocale() {
        this.applyButton.setText(LexiconGuiResources.getLocalizedString("Button.Apply", "Apply"));
        this.cancelButton.setText(LexiconGuiResources.getLocalizedString("Button.Cancel", "Cancel"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.applyButton) {
            this.applyChanges();
            this.postActionEvent(e);
        } else if (e.getSource() == this.cancelButton) {
            this.cancelChanges();
            this.postActionEvent(e);
        } else if (e.getActionCommand() != null && e.getActionCommand().equals("cancel")) {
            this.cancelChanges();
        }
    }

    public void applyChanges() {
        if (this.curModel instanceof EntryTreeModel) {
            this.entryTree.stopEditing();
            EntryTreeModel etModel = (EntryTreeModel)this.curModel;
            if (etModel.isChanged()) {
                try {
                    new EntryEditCommitter().applyChangesFromModel(etModel);
                    EntryImpl storeEntry = this.curEntry;
                    this.clearEntry();
                    this.curEntry = storeEntry;
                    this.curModel = this.createModel(this.curEntry);
                    this.entryTree = this.createTree(this.curModel);
                    this.entryScrollPane.setViewportView(this.entryTree);
                }
                catch (LexiconStructureException lse) {
                    JOptionPane.showMessageDialog(this, LexiconGuiResources.getLocalizedString("LexiconComponent.Entry.Warning.ChangeError", "An error occurred while applying the changes to the entry:") + "\n" + lse.getMessage(), LexiconGuiResources.getLocalizedString("Message.Warning", "Warning"), 2);
                }
            }
        }
    }

    public void cancelChanges() {
        if (this.curModel instanceof EntryTreeModel) {
            this.clearEntry();
            this.updateButtonStates();
        }
    }

    private void postActionEvent(ActionEvent ae) {
        if (this.listeners != null) {
            for (ActionListener al : this.listeners) {
                al.actionPerformed(ae);
            }
        }
    }

    public void addActionListener(ActionListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ActionListener>(5);
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeActionListener(ActionListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.entryTree != null) {
            Dimension treePref = this.entryTree.getPreferredSize();
            Dimension buttonPref = this.buttonPanel.getPreferredSize();
            int scrollExtra = this.entryScrollPane.getVerticalScrollBar().getPreferredSize().width;
            int w = treePref.width > buttonPref.width ? treePref.width : buttonPref.width;
            int h = treePref.height + buttonPref.height + 5 + scrollExtra;
            return new Dimension(w += 5 + scrollExtra, h);
        }
        return super.getPreferredSize();
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 9) {
            if (this.entryTree.isEditing()) {
                EntryTreeCellEditor etcEditor = (EntryTreeCellEditor)this.entryTree.getCellEditor();
                if (etcEditor.getCurrentEditorComponent() != null) {
                    etcEditor.getCurrentEditorComponent().processKeyEvent(e);
                }
            } else {
                this.entryTree.addSelectionInterval(0, 0);
                if (this.entryTree.getSelectionPath() != null) {
                    this.entryTree.startEditingAtPath(this.entryTree.getSelectionPath());
                }
            }
        } else if (e.getKeyCode() == 61) {
            EntryTreeCellEditor etcEditor;
            if (this.entryTree.isEditing() && (etcEditor = (EntryTreeCellEditor)this.entryTree.getCellEditor()).getCurrentEditorComponent() != null) {
                etcEditor.getCurrentEditorComponent().processKeyEvent(e);
            }
        } else if (e.getKeyCode() == 10) {
            this.applyButton.doClick();
        } else {
            super.processKeyEvent(e);
        }
    }
}

