/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui.tree;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import nl.mpi.lexiconcomponent.exceptions.LexiconStructureException;
import nl.mpi.lexiconcomponent.gui.tree.EntryCompoundNode;
import nl.mpi.lexiconcomponent.gui.tree.EntryTreeModel;
import nl.mpi.lexiconcomponent.gui.tree.EntryTreeNode;
import nl.mpi.lexiconcomponent.impl.EntryImpl;
import nl.mpi.lexiconcomponent.impl.LexiconFactory;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.impl.LexiconImpl;
import nl.mpi.lexiconcomponent.impl.SenseImpl;
import nl.mpi.lexiconcomponent.model.CustomField;
import nl.mpi.lexiconcomponent.model.CustomFieldSpec;
import nl.mpi.lexiconcomponent.model.Definition;
import nl.mpi.lexiconcomponent.model.Gloss;
import nl.mpi.lexiconcomponent.model.Sense;
import nl.mpi.lexiconcomponent.model.TextLang;
import nl.mpi.lexiconcomponent.util.EntryFieldTriplet;

public class EntryEditCommitter {
    private LexiconFactory factory = new LexiconFactory();

    public void applyChangesFromModel(EntryTreeModel model) throws LexiconStructureException {
        List<EntryTreeNode> custNodes;
        if (model == null) {
            return;
        }
        if (!model.isChanged()) {
            return;
        }
        if (!(model.getRoot() instanceof EntryCompoundNode)) {
            return;
        }
        EntryImpl entry = model.getEntry();
        EntryCompoundNode rootNode = (EntryCompoundNode)model.getRoot();
        boolean lexUnitChanged = rootNode.isChanged();
        Enumeration<TreeNode> nodeEnum = rootNode.children();
        while (nodeEnum.hasMoreElements()) {
            EntryTreeNode node = (EntryTreeNode)nodeEnum.nextElement();
            if (node.getUserTriplet().FIELD == LexiconFields.SENSE) {
                if (node.getUserTriplet().isRemoved()) continue;
                this.applySenseChanges(node);
                continue;
            }
            if (!node.isChanged()) continue;
            switch ((LexiconFields)((Object)node.getUserTriplet().FIELD)) {
                case ENTRY_MORPH_TYPE: {
                    if (node.getUserTriplet().isRemoved()) {
                        entry.setMorphType(null);
                        break;
                    }
                    entry.setMorphType(node.getUserTriplet().getEdit());
                    break;
                }
                case ENTRY_CITATION: {
                    if (node.getUserTriplet().isRemoved()) {
                        entry.setCitation(null);
                        break;
                    }
                    entry.setCitation(node.getUserTriplet().getEdit());
                    break;
                }
                case ENTRY_VARIANT: {
                    this.processZeroOrMoreStringField(node.getUserTriplet(), entry.getVariant());
                    break;
                }
                case ENTRY_PHONETIC: {
                    break;
                }
                case ENTRY_NOTE: {
                    this.processZeroOrMoreStringField(node.getUserTriplet(), entry.getNote());
                    break;
                }
                case ENTRY_FIELD: {
                    break;
                }
            }
        }
        List<EntryTreeNode> phonNodes = this.getChildrenOfType(rootNode, LexiconFields.ENTRY_PHONETIC);
        if (phonNodes != null && !phonNodes.isEmpty()) {
            this.processTextLangFields(entry.getPhonetic(), phonNodes);
        }
        if ((custNodes = this.getChildrenOfType(rootNode, LexiconFields.ENTRY_FIELD)) != null && !custNodes.isEmpty()) {
            this.processCustomFields(entry.getField(), custNodes);
        }
        Enumeration<TreeNode> nodeEnum2 = rootNode.children();
        while (nodeEnum2.hasMoreElements()) {
            EntryTreeNode node = (EntryTreeNode)nodeEnum2.nextElement();
            if (node.getUserTriplet().FIELD != LexiconFields.SENSE || !node.getUserTriplet().isRemoved()) continue;
            this.removeSense((EntryCompoundNode)node);
        }
        LexiconImpl lexicon = entry.getLexicon();
        String nextLexUnit = null;
        if (lexUnitChanged) {
            nextLexUnit = rootNode.getUserTriplet().getEdit();
        }
        lexicon.changeEntry(entry, nextLexUnit);
    }

    private void applySenseChanges(EntryTreeNode node) throws LexiconStructureException {
        EntryCompoundNode senseNode = (EntryCompoundNode)node;
        Sense curSense = (Sense)senseNode.getEntrySubObject();
        if (curSense == null) {
            if (!senseNode.getUserTriplet().isRemoved()) {
                this.createNewSense(senseNode);
            }
        } else {
            List<EntryTreeNode> custNodes;
            List<EntryTreeNode> defNodes;
            Enumeration<TreeNode> nodeEnum = senseNode.children();
            while (nodeEnum.hasMoreElements()) {
                EntryTreeNode nn = (EntryTreeNode)nodeEnum.nextElement();
                if (!nn.isChanged()) continue;
                switch ((LexiconFields)((Object)nn.getUserTriplet().FIELD)) {
                    case SENSE_GRAM_CAT: {
                        if (nn.getUserTriplet().getEdit() == null) break;
                        curSense.setGrammaticalCategory(nn.getUserTriplet().getEdit());
                        break;
                    }
                    case SENSE_GLOSS: {
                        break;
                    }
                    case SENSE_DEFINITION: {
                        break;
                    }
                    case SENSE_COMMENT: {
                        this.processZeroOrMoreStringField(nn.getUserTriplet(), curSense.getComment());
                        break;
                    }
                    case SENSE_INT_NOTE: {
                        this.processZeroOrMoreStringField(nn.getUserTriplet(), curSense.getInternalNote());
                        break;
                    }
                }
            }
            List<EntryTreeNode> glNodes = this.getChildrenOfType(senseNode, LexiconFields.SENSE_GLOSS);
            if (glNodes != null && !glNodes.isEmpty()) {
                this.processGlossFields(curSense.getGloss(), glNodes);
            }
            if ((defNodes = this.getChildrenOfType(senseNode, LexiconFields.SENSE_DEFINITION)) != null && !defNodes.isEmpty()) {
                this.processDefinitionFields(curSense.getDefinition(), defNodes);
            }
            if ((custNodes = this.getChildrenOfType(senseNode, LexiconFields.SENSE_FIELD)) != null && !custNodes.isEmpty()) {
                this.processCustomFields(curSense.getField(), custNodes);
            }
        }
    }

    private void createNewSense(EntryCompoundNode senseNode) throws LexiconStructureException {
        EntryImpl entry = (EntryImpl)((EntryCompoundNode)senseNode.getRoot()).getEntrySubObject();
        String gramCat = null;
        String gloss = null;
        EntryCompoundNode firstGloss = null;
        Enumeration<TreeNode> nodeEnum = senseNode.children();
        while (nodeEnum.hasMoreElements()) {
            EntryTreeNode nn = (EntryTreeNode)nodeEnum.nextElement();
            switch ((LexiconFields)((Object)nn.getUserTriplet().FIELD)) {
                case SENSE_GRAM_CAT: {
                    if (nn.getUserTriplet().getEdit() == null) break;
                    gramCat = nn.getUserTriplet().getEdit();
                    break;
                }
                case SENSE_GLOSS: {
                    if (gloss != null) break;
                    gloss = nn.getUserTriplet().getEdit();
                    firstGloss = (EntryCompoundNode)nn;
                    break;
                }
            }
            if (gramCat == null || gloss == null) continue;
            break;
        }
        if (gramCat == null) {
            gramCat = "NN";
        }
        if (gloss == null) {
            gloss = "";
        }
        SenseImpl nextSense = entry.getLexicon().createSense(gramCat, gloss);
        Gloss gl = nextSense.getGloss().get(0);
        List<EntryFieldTriplet<LexiconFields, String, String>> childList = firstGloss.getInternalChildren();
        if (childList != null && childList.size() > 0) {
            EntryFieldTriplet<LexiconFields, String, String> langTrip = childList.get(0);
            if (langTrip.FIELD == LexiconFields.ATTRIB_LANG && langTrip.getEdit() != null) {
                gl.setLang(langTrip.getEdit());
            }
        }
        Enumeration<TreeNode> nodeEnumTwo = senseNode.children();
        block12: while (nodeEnumTwo.hasMoreElements()) {
            EntryTreeNode nn = (EntryTreeNode)nodeEnumTwo.nextElement();
            if (!nn.isChanged()) continue;
            switch ((LexiconFields)((Object)nn.getUserTriplet().FIELD)) {
                case SENSE_GRAM_CAT: {
                    break;
                }
                case SENSE_GLOSS: {
                    if (nn == firstGloss) break;
                    Gloss nextGloss = this.createNewGloss((EntryCompoundNode)nn);
                    if (nextGloss == null) continue block12;
                    nextSense.getGloss().add(nextGloss);
                    break;
                }
                case SENSE_DEFINITION: {
                    Definition nextDef = this.createNewDefinition((EntryCompoundNode)nn);
                    if (nextDef == null) break;
                    nextSense.getDefinition().add(nextDef);
                    break;
                }
                case SENSE_COMMENT: {
                    this.processZeroOrMoreStringField(nn.getUserTriplet(), nextSense.getComment());
                    break;
                }
                case SENSE_INT_NOTE: {
                    this.processZeroOrMoreStringField(nn.getUserTriplet(), nextSense.getInternalNote());
                    break;
                }
            }
        }
        entry.getLexicon().addSense(entry, nextSense);
    }

    private void removeSense(EntryCompoundNode senseNode) throws LexiconStructureException {
        EntryImpl entry;
        SenseImpl curSense = (SenseImpl)senseNode.getEntrySubObject();
        if (curSense != null && (entry = curSense.getEntry()) != null && entry.getSense().contains(curSense) && entry.getSense().size() > 1) {
            entry.getLexicon().removeSense(entry, curSense);
        }
    }

    private List<EntryTreeNode> getChildrenOfType(EntryTreeNode parentNode, LexiconFields field) {
        ArrayList<EntryTreeNode> nodeList = null;
        Enumeration<TreeNode> nodeEnum = parentNode.children();
        while (nodeEnum.hasMoreElements()) {
            EntryTreeNode nn = (EntryTreeNode)nodeEnum.nextElement();
            if (nn.getUserTriplet().FIELD != field || !nn.isChanged()) continue;
            if (nodeList == null) {
                nodeList = new ArrayList<EntryTreeNode>(5);
            }
            nodeList.add(nn);
        }
        return nodeList;
    }

    private void processZeroOrMoreStringField(EntryFieldTriplet<LexiconFields, String, String> triplet, List<String> curFields) {
        if (!triplet.isAdded() && !triplet.isRemoved()) {
            int index = curFields.indexOf(triplet.getOrig());
            if (index >= 0) {
                curFields.set(index, triplet.getEdit());
            }
        } else if (triplet.isRemoved()) {
            curFields.remove(triplet.getOrig());
        } else if (triplet.isAdded() && !curFields.contains(triplet.getEdit())) {
            curFields.add(triplet.getEdit());
        }
    }

    private void processGlossFields(List<Gloss> curFieldList, List<EntryTreeNode> nodes) {
        for (int i = nodes.size() - 1; i >= 0; --i) {
            EntryCompoundNode ecn = (EntryCompoundNode)nodes.get(i);
            EntryFieldTriplet<LexiconFields, String, String> triplet = ecn.getUserTriplet();
            if (triplet.isAdded()) {
                Gloss gloss = this.createNewGloss(ecn);
                if (gloss == null) continue;
                curFieldList.add(gloss);
                continue;
            }
            if (triplet.isRemoved()) {
                if (curFieldList.size() <= 1) continue;
                curFieldList.remove(ecn.getEntrySubObject());
                continue;
            }
            int index = curFieldList.indexOf(ecn.getEntrySubObject());
            if (index < 0) continue;
            Gloss curGloss = curFieldList.get(index);
            if (triplet.getEdit() != null) {
                curGloss.setValue(triplet.getEdit());
            }
            this.setLanguageAttribute(curGloss, ecn.getInternalChildren());
        }
    }

    private void processDefinitionFields(List<Definition> curFieldList, List<EntryTreeNode> nodes) {
        for (int i = nodes.size() - 1; i >= 0; --i) {
            EntryCompoundNode ecn = (EntryCompoundNode)nodes.get(i);
            EntryFieldTriplet<LexiconFields, String, String> triplet = ecn.getUserTriplet();
            if (triplet.isAdded()) {
                Definition definition = this.createNewDefinition(ecn);
                if (definition == null) continue;
                curFieldList.add(definition);
                continue;
            }
            if (triplet.isRemoved()) {
                curFieldList.remove(ecn.getEntrySubObject());
                continue;
            }
            int index = curFieldList.indexOf(ecn.getEntrySubObject());
            if (index < 0) continue;
            Definition curDef = curFieldList.get(index);
            if (triplet.getEdit() != null) {
                curDef.setValue(triplet.getEdit());
            }
            this.setLanguageAttribute(curDef, ecn.getInternalChildren());
        }
    }

    private <T extends TextLang> void processTextLangFields(List<T> curFieldList, List<EntryTreeNode> nodes) {
        for (int i = nodes.size() - 1; i >= 0; --i) {
            EntryCompoundNode ecn = (EntryCompoundNode)nodes.get(i);
            EntryFieldTriplet<LexiconFields, String, String> triplet = ecn.getUserTriplet();
            if (triplet.isAdded()) {
                TextLang tl = this.createNewTextLang(ecn);
                if (tl == null) continue;
                curFieldList.add(tl);
                continue;
            }
            if (triplet.isRemoved()) {
                if (triplet.FIELD == LexiconFields.SENSE_GLOSS) {
                    if (curFieldList.size() <= 1) continue;
                    curFieldList.remove(ecn.getEntrySubObject());
                    continue;
                }
                curFieldList.remove(ecn.getEntrySubObject());
                continue;
            }
            int index = curFieldList.indexOf(ecn.getEntrySubObject());
            if (index < 0) continue;
            TextLang curTL = (TextLang)curFieldList.get(index);
            if (triplet.getEdit() != null) {
                curTL.setValue(triplet.getEdit());
            }
            this.setLanguageAttribute(curTL, ecn.getInternalChildren());
        }
    }

    private void processCustomFields(List<CustomField> curFields, List<EntryTreeNode> nodes) {
        for (int i = nodes.size() - 1; i >= 0; --i) {
            EntryCompoundNode ecn = (EntryCompoundNode)nodes.get(i);
            EntryFieldTriplet<LexiconFields, String, String> triplet = ecn.getUserTriplet();
            if (triplet.isAdded()) {
                CustomField cf = this.createNewCustomField(ecn);
                if (cf == null) continue;
                curFields.add(cf);
                continue;
            }
            if (triplet.isRemoved()) {
                curFields.remove(ecn.getEntrySubObject());
                continue;
            }
            int index = curFields.indexOf(ecn.getEntrySubObject());
            if (index < 0) continue;
            CustomField cf = curFields.get(index);
            if (triplet.getEdit() != null) {
                cf.setValue(triplet.getEdit());
            }
            if (ecn.getInternalChildren() == null) continue;
            for (EntryFieldTriplet<LexiconFields, String, String> langTrip : ecn.getInternalChildren()) {
                if (langTrip.FIELD != LexiconFields.ATTRIB_LANG || langTrip.getEdit() == null) continue;
                if (!langTrip.getEdit().isEmpty()) {
                    cf.setLang(langTrip.getEdit());
                    continue;
                }
                cf.setLang(null);
            }
        }
    }

    private Gloss createNewGloss(EntryCompoundNode ecNode) {
        EntryFieldTriplet<LexiconFields, String, String> triplet = ecNode.getUserTriplet();
        if (triplet.getEdit() == null) {
            return null;
        }
        Gloss gloss = this.factory.createGloss();
        gloss.setValue(triplet.getEdit());
        this.setLanguageAttribute(gloss, ecNode.getInternalChildren());
        return gloss;
    }

    private Definition createNewDefinition(EntryCompoundNode ecNode) {
        EntryFieldTriplet<LexiconFields, String, String> triplet = ecNode.getUserTriplet();
        if (triplet.getEdit() == null) {
            return null;
        }
        Definition definition = this.factory.createDefinition();
        definition.setValue(triplet.getEdit());
        this.setLanguageAttribute(definition, ecNode.getInternalChildren());
        return definition;
    }

    private TextLang createNewTextLang(EntryCompoundNode ecNode) {
        EntryFieldTriplet<LexiconFields, String, String> triplet = ecNode.getUserTriplet();
        if (triplet.getEdit() == null) {
            return null;
        }
        TextLang textLang = null;
        switch ((LexiconFields)((Object)triplet.FIELD)) {
            case ENTRY_PHONETIC: {
                textLang = this.factory.createPhonetic();
                break;
            }
            case SENSE_GLOSS: {
                textLang = this.factory.createGloss();
                break;
            }
            case SENSE_DEFINITION: {
                textLang = this.factory.createDefinition();
                break;
            }
        }
        if (textLang != null) {
            textLang.setValue(triplet.getEdit());
            this.setLanguageAttribute(textLang, ecNode.getInternalChildren());
        }
        return textLang;
    }

    private CustomField createNewCustomField(EntryCompoundNode ecNode) {
        EntryFieldTriplet<LexiconFields, String, String> triplet = ecNode.getUserTriplet();
        if (triplet.getEdit() == null) {
            return null;
        }
        CustomField customField = this.factory.createCustomField();
        Object subObject = ecNode.getEntrySubObject();
        if (subObject instanceof CustomFieldSpec) {
            customField.setName(((CustomFieldSpec)subObject).getName());
            customField.setValue(triplet.getEdit());
            if (ecNode.getInternalChildren() != null) {
                for (EntryFieldTriplet<LexiconFields, String, String> langTrip : ecNode.getInternalChildren()) {
                    if (langTrip.FIELD != LexiconFields.ATTRIB_LANG || langTrip.getEdit() == null || langTrip.getEdit().isEmpty()) continue;
                    customField.setLang(langTrip.getEdit());
                }
            }
            return customField;
        }
        return null;
    }

    private void setLanguageAttribute(TextLang fieldWithLanguage, List<EntryFieldTriplet<LexiconFields, String, String>> childrenList) {
        if (fieldWithLanguage == null) {
            return;
        }
        if (childrenList != null && !childrenList.isEmpty()) {
            for (EntryFieldTriplet<LexiconFields, String, String> langTrip : childrenList) {
                if (langTrip.FIELD != LexiconFields.ATTRIB_LANG) continue;
                if (langTrip.getEdit() == null) break;
                if (!langTrip.getEdit().isEmpty()) {
                    fieldWithLanguage.setLang(langTrip.getEdit());
                    break;
                }
                fieldWithLanguage.setLang(null);
                break;
            }
        }
    }
}

