/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui.tree;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.CellEditorListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import nl.mpi.lexiconcomponent.gui.tree.EntryCompoundNode;
import nl.mpi.lexiconcomponent.gui.tree.EntryTreeModel;
import nl.mpi.lexiconcomponent.gui.tree.EntryTreeNode;
import nl.mpi.lexiconcomponent.gui.tree.FieldCellEditListener;
import nl.mpi.lexiconcomponent.gui.tree.FieldEditPanel;
import nl.mpi.lexiconcomponent.gui.tree.FieldRenderPanel;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.model.CustomField;
import nl.mpi.lexiconcomponent.model.CustomFieldSpec;
import nl.mpi.lexiconcomponent.model.Sense;
import nl.mpi.lexiconcomponent.model.TextLang;
import nl.mpi.lexiconcomponent.util.EntryFieldTriplet;

public class EntryTreeCellEditor
extends JPanel
implements TreeCellEditor,
FieldCellEditListener {
    private FieldEditPanel entryTopKVPanel = null;
    private FieldEditPanel senseTopKVPanel = null;
    private FieldEditPanel singleKVPanel = null;
    private FieldEditPanel doubleKVPanel = null;
    private FieldEditPanel currentEditor = null;
    private JTree currentTree;
    private int currentRow;

    public EntryTreeCellEditor() {
        this.initEditors();
    }

    private void initEditors() {
        this.entryTopKVPanel = new FieldEditPanel(FieldRenderPanel.FieldMode.ENTRY_MAIN_FIELD);
        this.senseTopKVPanel = new FieldEditPanel(FieldRenderPanel.FieldMode.SENSE_MAIN_FIELD);
        this.singleKVPanel = new FieldEditPanel(FieldRenderPanel.FieldMode.SINGLE_FIELD);
        this.doubleKVPanel = new FieldEditPanel(FieldRenderPanel.FieldMode.TWO_FIELDS);
        this.entryTopKVPanel.addFieldCellEditListener(this);
        this.senseTopKVPanel.addFieldCellEditListener(this);
        this.singleKVPanel.addFieldCellEditListener(this);
        this.doubleKVPanel.addFieldCellEditListener(this);
    }

    public FieldEditPanel getCurrentEditorComponent() {
        return this.currentEditor;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.currentEditor != null) {
            return this.currentEditor.getCellEditorValue();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.currentEditor != null) {
            return this.currentEditor.stopCellEditing();
        }
        return false;
    }

    @Override
    public void cancelCellEditing() {
        if (this.currentEditor != null) {
            this.currentEditor.stopCellEditing();
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.setBackground(tree.getBackground());
        this.currentTree = tree;
        this.currentRow = row;
        EntryTreeModel model = (EntryTreeModel)this.currentTree.getModel();
        int viewPortWidth = -1;
        if (tree.getParent() instanceof JViewport) {
            viewPortWidth = ((JViewport)tree.getParent()).getExtentSize().width;
        }
        if (value instanceof EntryCompoundNode) {
            EntryCompoundNode cNode = (EntryCompoundNode)value;
            EntryFieldTriplet<LexiconFields, String, String> cTriplet = cNode.getUserTriplet();
            Object entrySubField = cNode.getEntrySubObject();
            if (cNode.isRoot()) {
                this.currentEditor = this.entryTopKVPanel;
            } else if (entrySubField instanceof Sense || cTriplet.FIELD == LexiconFields.SENSE) {
                this.currentEditor = this.senseTopKVPanel;
            } else if (entrySubField instanceof TextLang || cTriplet.FIELD == LexiconFields.ENTRY_PHONETIC || cTriplet.FIELD == LexiconFields.SENSE_GLOSS || cTriplet.FIELD == LexiconFields.SENSE_DEFINITION) {
                this.currentEditor = this.doubleKVPanel;
            } else if (entrySubField instanceof CustomField || entrySubField instanceof CustomFieldSpec) {
                this.currentEditor = this.doubleKVPanel;
                this.doubleKVPanel.setFieldUserObject(entrySubField);
            }
            this.currentEditor.setAddFieldEnabled((LexiconFields)((Object)cTriplet.FIELD), model.canFieldBeAdded(cNode));
            this.currentEditor.setRemoveFieldEnabled((LexiconFields)((Object)cTriplet.FIELD), model.canFieldBeRemoved(cNode));
            this.currentEditor.setBackground(tree.getBackground());
            this.currentEditor.setTriplet(cTriplet);
            this.currentEditor.addTriplets(cNode.getInternalChildren());
            this.currentEditor.setViewPortWidth(viewPortWidth);
            this.currentEditor.revalidate();
            return this.currentEditor;
        }
        if (value instanceof EntryTreeNode) {
            EntryTreeNode node = (EntryTreeNode)value;
            EntryFieldTriplet<LexiconFields, String, String> triplet = node.getUserTriplet();
            this.singleKVPanel.setAddFieldEnabled((LexiconFields)((Object)triplet.FIELD), model.canFieldBeAdded(node));
            this.singleKVPanel.setRemoveFieldEnabled((LexiconFields)((Object)triplet.FIELD), model.canFieldBeRemoved(node));
            this.singleKVPanel.setBackground(tree.getBackground());
            this.singleKVPanel.setTriplet(triplet);
            this.singleKVPanel.setViewPortWidth(viewPortWidth);
            this.singleKVPanel.revalidate();
            this.currentEditor = this.singleKVPanel;
            return this.singleKVPanel;
        }
        this.currentEditor = null;
        return this;
    }

    @Override
    public void commitEditsSelectNext() {
        this.stopCellEditing();
        this.selectNextCell();
    }

    @Override
    public void commitEditsSelectPrevious() {
        this.stopCellEditing();
        this.selectPreviousCell();
    }

    @Override
    public void cancelEditsSelectNext() {
        this.cancelCellEditing();
        this.selectPreviousCell();
    }

    @Override
    public void cancelEditsSelectPrevious() {
        this.cancelCellEditing();
        this.selectPreviousCell();
    }

    private void selectNextCell() {
        if (this.currentTree != null) {
            int nextRow = this.currentRow < this.currentTree.getRowCount() - 1 ? this.currentRow + 1 : 0;
            this.currentTree.setSelectionRow(nextRow);
            this.currentTree.startEditingAtPath(this.currentTree.getPathForRow(nextRow));
        }
    }

    private void selectPreviousCell() {
        if (this.currentTree != null) {
            int nextRow = this.currentRow > 0 ? this.currentRow - 1 : this.currentTree.getRowCount() - 1;
            this.currentTree.setSelectionRow(nextRow);
            this.currentTree.startEditingAtPath(this.currentTree.getPathForRow(nextRow));
        }
    }

    @Override
    public void addNewField(EntryFieldTriplet<LexiconFields, String, String> selectedField) {
        if (this.currentTree != null) {
            TreePath currentPath = this.currentTree.getPathForRow(this.currentRow);
            EntryTreeNode currentNode = (EntryTreeNode)currentPath.getLastPathComponent();
            EntryTreeModel model = (EntryTreeModel)this.currentTree.getModel();
            EntryTreeNode activeNode = model.addNewFieldNode(currentNode, selectedField);
            this.stopCellEditing();
            if (activeNode != null) {
                if (activeNode == currentNode) {
                    this.currentTree.startEditingAtPath(currentPath);
                } else {
                    for (int i = this.currentRow; i < this.currentTree.getRowCount(); ++i) {
                        TreePath nextPath = this.currentTree.getPathForRow(i);
                        if (nextPath.getLastPathComponent() != activeNode) continue;
                        this.currentTree.expandPath(nextPath);
                        this.currentTree.scrollPathToVisible(nextPath);
                        this.currentTree.startEditingAtPath(nextPath);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void removeField(EntryFieldTriplet<LexiconFields, String, String> selectedField) {
        if (this.currentTree != null) {
            TreePath currentPath = this.currentTree.getPathForRow(this.currentRow);
            EntryTreeNode currentNode = (EntryTreeNode)currentPath.getLastPathComponent();
            EntryTreeModel model = (EntryTreeModel)this.currentTree.getModel();
            model.removeFieldNode(currentNode);
            this.currentTree.stopEditing();
        }
    }
}

