/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui.tree;

import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.tree.TreeCellRenderer;
import nl.mpi.lexiconcomponent.gui.tree.EntryCompoundNode;
import nl.mpi.lexiconcomponent.gui.tree.EntryTreeNode;
import nl.mpi.lexiconcomponent.gui.tree.FieldRenderPanel;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.model.CustomField;
import nl.mpi.lexiconcomponent.model.CustomFieldSpec;
import nl.mpi.lexiconcomponent.model.Sense;
import nl.mpi.lexiconcomponent.model.TextLang;
import nl.mpi.lexiconcomponent.util.EntryFieldTriplet;

public class EntryTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private FieldRenderPanel entryTopKVPanel = null;
    private FieldRenderPanel senseTopKVPanel = null;
    private FieldRenderPanel singleKVPanel = null;
    private FieldRenderPanel doubleKVPanel = null;
    private FieldRenderPanel currentRenderPanel = null;

    public EntryTreeCellRenderer() {
        this.initRenderer();
    }

    private void initRenderer() {
        this.entryTopKVPanel = new FieldRenderPanel(FieldRenderPanel.FieldMode.ENTRY_MAIN_FIELD);
        this.senseTopKVPanel = new FieldRenderPanel(FieldRenderPanel.FieldMode.SENSE_MAIN_FIELD);
        this.singleKVPanel = new FieldRenderPanel(FieldRenderPanel.FieldMode.SINGLE_FIELD);
        this.doubleKVPanel = new FieldRenderPanel(FieldRenderPanel.FieldMode.TWO_FIELDS);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setBackground(tree.getBackground());
        int viewPortWidth = -1;
        if (tree.getParent() instanceof JViewport) {
            viewPortWidth = ((JViewport)tree.getParent()).getExtentSize().width;
        }
        if (value instanceof EntryCompoundNode) {
            EntryCompoundNode cNode = (EntryCompoundNode)value;
            EntryFieldTriplet<LexiconFields, String, String> cTriplet = cNode.getUserTriplet();
            Object entrySubField = cNode.getEntrySubObject();
            if (cNode.isRoot()) {
                this.currentRenderPanel = this.entryTopKVPanel;
            } else if (entrySubField instanceof Sense || cTriplet.FIELD == LexiconFields.SENSE) {
                this.currentRenderPanel = this.senseTopKVPanel;
            } else if (entrySubField instanceof TextLang || cTriplet.FIELD == LexiconFields.ENTRY_PHONETIC || cTriplet.FIELD == LexiconFields.SENSE_GLOSS || cTriplet.FIELD == LexiconFields.SENSE_DEFINITION) {
                this.currentRenderPanel = this.doubleKVPanel;
            } else if (entrySubField instanceof CustomField || entrySubField instanceof CustomFieldSpec) {
                this.currentRenderPanel = this.doubleKVPanel;
                this.currentRenderPanel.setFieldUserObject(entrySubField);
            }
            this.currentRenderPanel.setBackground(tree.getBackground());
            this.currentRenderPanel.setTriplet(cTriplet);
            this.currentRenderPanel.addTriplets(cNode.getInternalChildren());
            this.currentRenderPanel.setViewPortWidth(viewPortWidth);
            this.currentRenderPanel.revalidate();
            return this.currentRenderPanel;
        }
        if (value instanceof EntryTreeNode) {
            EntryTreeNode node = (EntryTreeNode)value;
            EntryFieldTriplet<LexiconFields, String, String> triplet = node.getUserTriplet();
            this.singleKVPanel.setBackground(tree.getBackground());
            this.singleKVPanel.setTriplet(triplet);
            this.singleKVPanel.setViewPortWidth(viewPortWidth);
            this.singleKVPanel.revalidate();
            return this.singleKVPanel;
        }
        return this;
    }
}

