/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui.tree;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import nl.mpi.lexiconcomponent.gui.tree.EntryCompoundNode;
import nl.mpi.lexiconcomponent.gui.tree.EntryTreeNode;
import nl.mpi.lexiconcomponent.impl.EntryImpl;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.model.CustomField;
import nl.mpi.lexiconcomponent.model.CustomFieldSpec;
import nl.mpi.lexiconcomponent.model.CustomFieldSpecification;
import nl.mpi.lexiconcomponent.model.Definition;
import nl.mpi.lexiconcomponent.model.Gloss;
import nl.mpi.lexiconcomponent.model.Phonetic;
import nl.mpi.lexiconcomponent.model.Sense;
import nl.mpi.lexiconcomponent.util.EntryFieldTriplet;
import nl.mpi.lexiconcomponent.util.FieldMultiplicity;

public class EntryTreeModel
extends DefaultTreeModel {
    private EntryImpl entry;
    private EntryCompoundNode rootNode;

    public EntryTreeModel(EntryImpl entry) {
        super(null);
        this.entry = entry;
        this.createRoot();
        this.addChildren();
    }

    public EntryImpl getEntry() {
        return this.entry;
    }

    private void createRoot() {
        this.rootNode = new EntryCompoundNode((Object)this.entry, new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.ENTRY_LEX_UNIT, this.entry.getLexicalUnit(), null));
        this.rootNode.addInternalChild(new EntryFieldTriplet<LexiconFields, Object, Object>(LexiconFields.ENTRY_ORDER, (this.entry.getOrder() == null ? null : String.valueOf(this.entry.getOrder())), null));
        this.rootNode.addInternalChild(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.ENTRY_ID, this.entry.getId(), null));
        this.rootNode.addInternalChild(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.ENTRY_DATE_CREATED, this.entry.getDateCreated() == null ? "" : this.entry.getDateCreated().toString(), null));
        this.rootNode.addInternalChild(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.ENTRY_DATE_MODIFIED, this.entry.getDateModified() == null ? "" : this.entry.getDateModified().toString(), null));
        this.setRoot(this.rootNode);
    }

    private void addChildren() {
        CustomFieldSpecification customFieldSpecs;
        EntryTreeNode root = (EntryTreeNode)this.getRoot();
        root.add(new EntryTreeNode(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.ENTRY_MORPH_TYPE, this.entry.getMorphType(), null)));
        if (this.entry.getCitation() != null) {
            root.add(new EntryTreeNode(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.ENTRY_CITATION, this.entry.getCitation(), null)));
        } else {
            root.add(this.createPlaceHolderNode(LexiconFields.ENTRY_CITATION));
        }
        for (String vr : this.entry.getVariant()) {
            root.add(new EntryTreeNode(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.ENTRY_VARIANT, vr, null)));
        }
        if (this.entry.getVariant().isEmpty()) {
            root.add(this.createPlaceHolderNode(LexiconFields.ENTRY_VARIANT));
        }
        for (Phonetic ph : this.entry.getPhonetic()) {
            EntryCompoundNode phNode = new EntryCompoundNode((Object)ph, new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.ENTRY_PHONETIC, ph.getValue(), null));
            phNode.addInternalChild(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.ATTRIB_LANG, ph.getLang(), null));
            root.add(phNode);
        }
        if (this.entry.getPhonetic().isEmpty()) {
            root.add(this.createPlaceHolderNode(LexiconFields.ENTRY_PHONETIC));
        }
        for (String n : this.entry.getNote()) {
            root.add(new EntryTreeNode(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.ENTRY_NOTE, n, null)));
        }
        if (this.entry.getNote().isEmpty()) {
            root.add(this.createPlaceHolderNode(LexiconFields.ENTRY_NOTE));
        }
        if ((customFieldSpecs = this.entry.getLexicon().getHeader().getCustomFields()) != null && !customFieldSpecs.getFieldSpec().isEmpty()) {
            for (CustomFieldSpec cfs : customFieldSpecs.getFieldSpec()) {
                if (!cfs.getLevel().equals(LexiconFields.ALL.getFieldName()) && !cfs.getLevel().equals(LexiconFields.ENTRY.getFieldName())) continue;
                boolean alreadyThere = false;
                for (CustomField cf : this.entry.getField()) {
                    if (!cf.getName().equals(cfs.getName())) continue;
                    alreadyThere = true;
                    root.add(this.createCustomFieldNode(cf, LexiconFields.ENTRY_FIELD));
                }
                if (alreadyThere) continue;
                root.add(this.createCustomFieldNode(cfs, LexiconFields.ENTRY_FIELD));
            }
        }
        for (Sense sense : this.entry.getSense()) {
            EntryCompoundNode senseNode = new EntryCompoundNode((Object)sense, new EntryFieldTriplet<LexiconFields, Object, Object>(LexiconFields.SENSE, null, null));
            senseNode.addInternalChild(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.SENSE_ORDER, String.valueOf(sense.getOrder()), null));
            senseNode.addInternalChild(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.SENSE_ID, sense.getId(), null));
            root.add(senseNode);
            senseNode.add(new EntryTreeNode(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.SENSE_GRAM_CAT, sense.getGrammaticalCategory(), null)));
            for (Gloss gl : sense.getGloss()) {
                EntryCompoundNode glossNode = new EntryCompoundNode((Object)gl, new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.SENSE_GLOSS, gl.getValue(), null));
                senseNode.add(glossNode);
                glossNode.addInternalChild(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.ATTRIB_LANG, gl.getLang(), null));
            }
            if (sense.getGloss().isEmpty()) {
                senseNode.add(new EntryTreeNode(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.SENSE_GLOSS, "gloss value", null)));
            }
            for (Definition df : sense.getDefinition()) {
                EntryCompoundNode definNode = new EntryCompoundNode((Object)df, new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.SENSE_DEFINITION, df.getValue(), null));
                senseNode.add(definNode);
                definNode.addInternalChild(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.ATTRIB_LANG, df.getLang(), null));
            }
            if (sense.getDefinition().isEmpty()) {
                senseNode.add(this.createPlaceHolderNode(LexiconFields.SENSE_DEFINITION));
            }
            for (String comment : sense.getComment()) {
                senseNode.add(new EntryTreeNode(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.SENSE_COMMENT, comment, null)));
            }
            if (sense.getComment().isEmpty()) {
                senseNode.add(this.createPlaceHolderNode(LexiconFields.SENSE_COMMENT));
            }
            for (String in : sense.getInternalNote()) {
                senseNode.add(new EntryTreeNode(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.SENSE_INT_NOTE, in, null)));
            }
            if (sense.getInternalNote().isEmpty()) {
                senseNode.add(this.createPlaceHolderNode(LexiconFields.SENSE_INT_NOTE));
            }
            if (customFieldSpecs == null || customFieldSpecs.getFieldSpec().isEmpty()) continue;
            for (CustomFieldSpec cfs : customFieldSpecs.getFieldSpec()) {
                if (!cfs.getLevel().equals(LexiconFields.ALL.getFieldName()) && !cfs.getLevel().equals(LexiconFields.SENSE.getFieldName())) continue;
                boolean alreadyThere = false;
                for (CustomField cf : sense.getField()) {
                    if (!cf.getName().equals(cfs.getName())) continue;
                    senseNode.add(this.createCustomFieldNode(cf, LexiconFields.SENSE_FIELD));
                    alreadyThere = true;
                }
                if (alreadyThere) continue;
                senseNode.add(this.createCustomFieldNode(cfs, LexiconFields.SENSE_FIELD));
            }
        }
    }

    private EntryTreeNode createPlaceHolderNode(LexiconFields lf) {
        switch (lf) {
            case SENSE: {
                List<EntryTreeNode> numSenses = this.getChildrenOfType(this.rootNode, lf);
                int index = 1;
                if (numSenses != null) {
                    index = numSenses.size() + 1;
                }
                EntryCompoundNode senseNode = new EntryCompoundNode(null, new EntryFieldTriplet<LexiconFields, String, String>(LexiconFields.SENSE));
                senseNode.addInternalChild(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.SENSE_ORDER, String.valueOf(index), null));
                senseNode.addInternalChild(new EntryFieldTriplet<LexiconFields, String, String>(LexiconFields.SENSE_ID));
                EntryTreeNode gramCat = new EntryTreeNode(new EntryFieldTriplet<LexiconFields, String, String>(LexiconFields.SENSE_GRAM_CAT));
                senseNode.add(gramCat);
                EntryTreeNode glossNode = this.createPlaceHolderNode(LexiconFields.SENSE_GLOSS);
                senseNode.add(glossNode);
                senseNode.add(this.createPlaceHolderNode(LexiconFields.SENSE_DEFINITION));
                senseNode.add(this.createPlaceHolderNode(LexiconFields.SENSE_COMMENT));
                senseNode.add(this.createPlaceHolderNode(LexiconFields.SENSE_INT_NOTE));
                return senseNode;
            }
            case ENTRY_PHONETIC: 
            case SENSE_GLOSS: 
            case SENSE_DEFINITION: {
                EntryCompoundNode chNode = new EntryCompoundNode(null, new EntryFieldTriplet<LexiconFields, String, String>(lf));
                chNode.addInternalChild(new EntryFieldTriplet<LexiconFields, String, String>(LexiconFields.ATTRIB_LANG));
                return chNode;
            }
        }
        return new EntryTreeNode(new EntryFieldTriplet<LexiconFields, String, String>(lf));
    }

    private EntryTreeNode createCustomFieldNode(Object nodeObject, LexiconFields lf) {
        if (nodeObject instanceof CustomField) {
            CustomField cf = (CustomField)nodeObject;
            EntryCompoundNode fieldNode = new EntryCompoundNode(nodeObject, new EntryFieldTriplet<LexiconFields, String, Object>(lf, cf.getValue(), null));
            fieldNode.addInternalChild(new EntryFieldTriplet<LexiconFields, String, Object>(LexiconFields.ATTRIB_LANG, cf.getLang(), null));
            return fieldNode;
        }
        if (nodeObject instanceof CustomFieldSpec) {
            EntryCompoundNode fieldNode = new EntryCompoundNode(nodeObject, new EntryFieldTriplet<LexiconFields, String, String>(lf));
            fieldNode.addInternalChild(new EntryFieldTriplet<LexiconFields, String, String>(LexiconFields.ATTRIB_LANG));
            return fieldNode;
        }
        return null;
    }

    private void setNodeAsAdded(EntryTreeNode node) {
        if (node != null) {
            node.getUserTriplet().setAdded(true);
            if (node instanceof EntryCompoundNode) {
                EntryCompoundNode cNode = (EntryCompoundNode)node;
                for (EntryFieldTriplet<LexiconFields, String, String> tn : cNode.getInternalChildren()) {
                    if (tn.FIELD != LexiconFields.ATTRIB_LANG) continue;
                    tn.setAdded(true);
                }
            }
            if (node.getUserTriplet().FIELD == LexiconFields.SENSE) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    EntryTreeNode etn = (EntryTreeNode)node.getChildAt(i);
                    if (etn.getUserTriplet().FIELD != LexiconFields.SENSE_GRAM_CAT && etn.getUserTriplet().FIELD != LexiconFields.SENSE_GLOSS) continue;
                    this.setNodeAsAdded(etn);
                }
            }
        }
    }

    private void setNodeAsRemoved(EntryTreeNode node) {
        if (node != null) {
            node.getUserTriplet().setRemoved(true);
            if (node instanceof EntryCompoundNode) {
                EntryCompoundNode cNode = (EntryCompoundNode)node;
                for (EntryFieldTriplet<LexiconFields, String, String> tn : cNode.getInternalChildren()) {
                    tn.setRemoved(true);
                }
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.setNodeAsRemoved((EntryTreeNode)node.getChildAt(i));
            }
        }
    }

    public EntryTreeNode addNewFieldNode(EntryTreeNode sourceNode, EntryFieldTriplet<LexiconFields, String, String> fieldTriplet) {
        if (sourceNode != null) {
            EntryFieldTriplet<LexiconFields, String, String> sourceTriplet = sourceNode.getUserTriplet();
            if (sourceTriplet.isPlaceHolder() && sourceTriplet.FIELD != LexiconFields.SENSE) {
                this.setNodeAsAdded(sourceNode);
                int index = sourceNode.getParent().getIndex(sourceNode);
                this.fireTreeNodesChanged(this, ((EntryTreeNode)sourceNode.getParent()).getPath(), new int[]{index}, new Object[]{sourceNode});
                return sourceNode;
            }
            EntryTreeNode nextNode = null;
            if (sourceTriplet.FIELD == LexiconFields.ENTRY_FIELD || sourceTriplet.FIELD == LexiconFields.SENSE_FIELD) {
                CustomFieldSpec cfSpecification = this.getCustomFieldSpecsFor(sourceNode);
                if (cfSpecification != null) {
                    nextNode = this.createCustomFieldNode(cfSpecification, (LexiconFields)((Object)sourceTriplet.FIELD));
                }
            } else {
                nextNode = this.createPlaceHolderNode((LexiconFields)((Object)sourceTriplet.FIELD));
            }
            if (nextNode != null) {
                this.setNodeAsAdded(nextNode);
                EntryTreeNode parentNode = (EntryTreeNode)sourceNode.getParent();
                int numChildren = parentNode.getChildCount();
                for (int i = numChildren - 1; i >= 0; --i) {
                    EntryTreeNode etn = (EntryTreeNode)parentNode.getChildAt(i);
                    if (etn.getUserTriplet().FIELD != sourceTriplet.FIELD) continue;
                    if (sourceTriplet.FIELD == LexiconFields.ENTRY_FIELD || sourceTriplet.FIELD == LexiconFields.SENSE_FIELD) {
                        String name1 = null;
                        String name2 = null;
                        EntryCompoundNode ecn1 = (EntryCompoundNode)etn;
                        EntryCompoundNode ecn2 = (EntryCompoundNode)nextNode;
                        if (ecn1.getEntrySubObject() instanceof CustomField) {
                            name1 = ((CustomField)ecn1.getEntrySubObject()).getName();
                        } else if (ecn1.getEntrySubObject() instanceof CustomFieldSpec) {
                            name1 = ((CustomFieldSpec)ecn1.getEntrySubObject()).getName();
                        }
                        if (ecn2.getEntrySubObject() instanceof CustomFieldSpec) {
                            name2 = ((CustomFieldSpec)ecn2.getEntrySubObject()).getName();
                        }
                        if (!name1.equals(name2)) continue;
                    }
                    if (i == numChildren - 1) {
                        parentNode.add(nextNode);
                    } else {
                        parentNode.insert(nextNode, i + 1);
                    }
                    this.fireTreeNodesInserted(this, parentNode.getPath(), new int[]{i + 1}, new Object[]{nextNode});
                    return nextNode;
                }
            }
        }
        return null;
    }

    public void removeFieldNode(EntryTreeNode sourceNode) {
        if (sourceNode != null) {
            int index = sourceNode.getParent().getIndex(sourceNode);
            this.setNodeAsRemoved(sourceNode);
            this.fireTreeNodesChanged(this, ((EntryTreeNode)sourceNode.getParent()).getPath(), new int[]{index}, new Object[]{sourceNode});
        }
    }

    public boolean canFieldBeAdded(EntryTreeNode node) {
        if (node.isRoot()) {
            return false;
        }
        if (node.getUserTriplet().isRemoved()) {
            return false;
        }
        if (node.getUserTriplet().isPlaceHolder()) {
            return true;
        }
        FieldMultiplicity.Multiplicity multi = FieldMultiplicity.getMultiplicityForField((LexiconFields)((Object)node.getUserTriplet().FIELD));
        if (multi == FieldMultiplicity.Multiplicity.ONE_OR_MORE || multi == FieldMultiplicity.Multiplicity.ZERO_OR_MORE) {
            return true;
        }
        List<EntryTreeNode> curElements = this.getChildrenOfType((EntryTreeNode)node.getParent(), (LexiconFields)((Object)node.getUserTriplet().FIELD));
        if (curElements == null) {
            return true;
        }
        if (curElements.size() == 1) {
            return multi != FieldMultiplicity.Multiplicity.ONE && multi != FieldMultiplicity.Multiplicity.ZERO_OR_ONE;
        }
        return true;
    }

    public boolean canFieldBeRemoved(EntryTreeNode node) {
        if (node.isRoot()) {
            return false;
        }
        EntryFieldTriplet<LexiconFields, String, String> triplet = node.getUserTriplet();
        if (triplet.isRemoved()) {
            return false;
        }
        if (triplet.isPlaceHolder() && triplet.FIELD != LexiconFields.SENSE) {
            return false;
        }
        FieldMultiplicity.Multiplicity multi = FieldMultiplicity.getMultiplicityForField((LexiconFields)((Object)triplet.FIELD));
        if (multi == FieldMultiplicity.Multiplicity.ZERO_OR_ONE || multi == FieldMultiplicity.Multiplicity.ZERO_OR_MORE) {
            return true;
        }
        List<EntryTreeNode> curElements = this.getChildrenOfType((EntryTreeNode)node.getParent(), (LexiconFields)((Object)node.getUserTriplet().FIELD));
        if (curElements == null) {
            return false;
        }
        if (curElements.size() == 1) {
            if (multi == FieldMultiplicity.Multiplicity.ONE || multi == FieldMultiplicity.Multiplicity.ONE_OR_MORE) {
                return false;
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean isChanged() {
        Enumeration<TreeNode> nodeEnum = this.rootNode.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            EntryTreeNode node = (EntryTreeNode)nodeEnum.nextElement();
            if (!node.isChanged()) continue;
            return true;
        }
        return false;
    }

    private List<EntryTreeNode> getChildrenOfType(EntryTreeNode parentNode, LexiconFields field) {
        ArrayList<EntryTreeNode> nodeList = null;
        Enumeration<TreeNode> nodeEnum = parentNode.children();
        while (nodeEnum.hasMoreElements()) {
            EntryTreeNode nn = (EntryTreeNode)nodeEnum.nextElement();
            if (nn.getUserTriplet().FIELD != field) continue;
            if (nodeList == null) {
                nodeList = new ArrayList<EntryTreeNode>(5);
            }
            nodeList.add(nn);
        }
        return nodeList;
    }

    private CustomFieldSpec getCustomFieldSpecsFor(EntryTreeNode node) {
        if (node instanceof EntryCompoundNode) {
            Object subObject = ((EntryCompoundNode)node).getEntrySubObject();
            if (subObject instanceof CustomFieldSpec) {
                return (CustomFieldSpec)subObject;
            }
            if (subObject instanceof CustomField) {
                CustomField cf = (CustomField)subObject;
                CustomFieldSpecification customFieldSpecs = this.entry.getLexicon().getHeader().getCustomFields();
                if (customFieldSpecs != null) {
                    for (CustomFieldSpec cfs : customFieldSpecs.getFieldSpec()) {
                        if (!cfs.getName().equals(cf.getName()) || !cfs.getLevel().equals(LexiconFields.ALL.getFieldName()) && (!cfs.getLevel().equals(LexiconFields.ENTRY.getFieldName()) || node.getUserTriplet().FIELD != LexiconFields.ENTRY_FIELD) && (!cfs.getLevel().equals(LexiconFields.SENSE.getFieldName()) || node.getUserTriplet().FIELD != LexiconFields.SENSE_FIELD)) continue;
                        return cfs;
                    }
                }
            }
        }
        return null;
    }
}

