/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.CellEditor;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import nl.mpi.lexiconcomponent.gui.tree.FieldCellEditListener;
import nl.mpi.lexiconcomponent.gui.tree.FieldCellEditor;
import nl.mpi.lexiconcomponent.gui.tree.FieldRenderPanel;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.util.EntryFieldTriplet;

public class FieldEditPanel
extends FieldRenderPanel
implements CellEditor,
FieldCellEditor {
    protected JButton addButton;
    protected JButton removeButton;
    protected ImageIcon plusIcon;
    protected ImageIcon minusIcon;
    protected GroupLayout.ParallelGroup col3Group;
    protected GroupLayout.ParallelGroup col4Group;
    protected FieldCellEditListener fieldEditListener;
    protected FieldListener fieldListener;
    private int viewPortWidth = -1;

    public FieldEditPanel(FieldRenderPanel.FieldMode mode) {
        super(mode);
    }

    @Override
    protected void initPanel() {
        this.addButton = new JButton();
        this.removeButton = new JButton();
        try {
            this.plusIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Plus16.gif"));
            this.addButton.setIcon(this.plusIcon);
        }
        catch (Throwable t) {
            this.addButton.setText("+");
        }
        try {
            this.minusIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Minus16.gif"));
            this.removeButton.setIcon(this.minusIcon);
        }
        catch (Throwable t) {
            this.removeButton.setText("-");
        }
        this.prefTextFieldWidth -= 2 * this.addButton.getPreferredSize().width;
        this.fieldListener = new FieldListener();
        this.addButton.addActionListener(this.fieldListener);
        this.removeButton.addActionListener(this.fieldListener);
        super.initPanel();
        this.setBorder(BorderFactory.createCompoundBorder(new LineBorder(Color.BLUE), this.emptyBorder));
    }

    @Override
    protected void initFirstField() {
        super.initFirstField();
        this.row1Group.addComponent(this.addButton).addComponent(this.removeButton);
        this.col3Group = this.groupLayout.createParallelGroup();
        this.col3Group.addComponent(this.addButton);
        this.hGroup.addGroup(this.col3Group);
        this.col4Group = this.groupLayout.createParallelGroup();
        this.col4Group.addComponent(this.removeButton);
        this.hGroup.addGroup(this.col4Group);
        this.addButton.setFocusable(false);
        this.removeButton.setFocusable(false);
        this.valueField.addKeyListener(this.fieldListener);
        this.valueField.addMouseListener(this.fieldListener);
        this.addMouseListener(this.fieldListener);
    }

    @Override
    protected void initSecondField() {
        super.initSecondField();
        this.valueField2.addKeyListener(this.fieldListener);
        this.valueField2.addMouseListener(this.fieldListener);
    }

    @Override
    protected void initEntryMainPanel() {
        super.initEntryMainPanel();
        this.valueField.addKeyListener(this.fieldListener);
    }

    @Override
    protected void initSenseMainPanel() {
        super.initSenseMainPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.insets = new Insets(2, this.hGap, 2, 2);
        this.add((Component)this.addButton, gbc);
        gbc.gridy = 1;
        this.add((Component)this.removeButton, gbc);
        this.addButton.setFocusable(false);
        this.removeButton.setFocusable(false);
        this.valueField.setEditable(false);
        this.valueField.setEnabled(false);
    }

    @Override
    public void setTriplet(EntryFieldTriplet<LexiconFields, String, String> triplet) {
        super.setTriplet(triplet);
        if (triplet.getOrig() == null && !triplet.isAdded() || triplet.isRemoved() || this.currentMode == FieldRenderPanel.FieldMode.SENSE_MAIN_FIELD) {
            this.valueField.setEditable(false);
            this.valueField.setEnabled(false);
        } else {
            this.valueField.setEditable(true);
            this.valueField.setEnabled(true);
        }
    }

    @Override
    protected void setSecondTriplet(EntryFieldTriplet<LexiconFields, String, String> triplet2) {
        super.setSecondTriplet(triplet2);
        if (triplet2.isPlaceHolder() || triplet2.isRemoved()) {
            this.valueField2.setEditable(false);
            this.valueField2.setEnabled(false);
        } else {
            this.valueField2.setEditable(true);
            this.valueField2.setEnabled(true);
        }
    }

    @Override
    public void addTriplets(List<EntryFieldTriplet<LexiconFields, String, String>> secTriplets) {
        super.addTriplets(secTriplets);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.addButton != null) {
            this.addButton.setBackground(bg);
            this.removeButton.setBackground(bg);
        }
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        String value2;
        String value1;
        if (this.valueField.isEditable() && (value1 = this.valueField.getText()) != null && !value1.equals(this.triplet.getOrig())) {
            this.triplet.setEdit(value1);
        }
        if (this.triplet2 != null && this.valueField2.isEditable() && (value2 = this.valueField2.getText()) != null && !value2.equals(this.triplet2.getOrig())) {
            if (this.triplet2.FIELD == LexiconFields.ENTRY_ORDER) {
                try {
                    Integer.parseInt(value2);
                    this.triplet2.setEdit(value2);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.triplet2.setEdit(value2);
            }
        }
        return true;
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
    }

    @Override
    public void addFieldCellEditListener(FieldCellEditListener listener) {
        this.fieldEditListener = listener;
    }

    @Override
    public void removeFieldCellEditListener(FieldCellEditListener listener) {
        if (this.fieldEditListener == listener) {
            this.fieldEditListener = null;
        }
    }

    @Override
    public void setAddFieldEnabled(LexiconFields targetField, boolean enabled) {
        this.addButton.setEnabled(enabled);
    }

    @Override
    public void setRemoveFieldEnabled(LexiconFields targetField, boolean enabled) {
        this.removeButton.setEnabled(enabled);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 9 || e.getKeyCode() == 521 || e.getKeyCode() == 61 || e.getKeyCode() == 45) {
            switch (e.getID()) {
                case 400: {
                    this.fieldListener.keyTyped(e);
                    break;
                }
                case 401: {
                    this.fieldListener.keyPressed(e);
                    break;
                }
                case 402: {
                    this.fieldListener.keyReleased(e);
                }
            }
        } else {
            super.processKeyEvent(e);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.viewPortWidth > width) {
            width = this.viewPortWidth - x - this.hGap;
        }
        super.setBounds(x, y, width, height);
    }

    @Override
    public void setViewPortWidth(int viewPortWidth) {
        this.viewPortWidth = viewPortWidth;
    }

    class FieldListener
    extends MouseAdapter
    implements KeyListener,
    ActionListener {
        FieldListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 9) {
                if (!e.isShiftDown()) {
                    if (FieldEditPanel.this.currentMode == FieldRenderPanel.FieldMode.SINGLE_FIELD || FieldEditPanel.this.currentMode == FieldRenderPanel.FieldMode.ENTRY_MAIN_FIELD || FieldEditPanel.this.currentMode == FieldRenderPanel.FieldMode.SENSE_MAIN_FIELD) {
                        if (FieldEditPanel.this.fieldEditListener != null) {
                            FieldEditPanel.this.fieldEditListener.commitEditsSelectNext();
                        }
                    } else if (FieldEditPanel.this.currentMode == FieldRenderPanel.FieldMode.TWO_FIELDS) {
                        if (e.getSource() == FieldEditPanel.this.valueField) {
                            if (FieldEditPanel.this.valueField2.isEditable()) {
                                FieldEditPanel.this.valueField.transferFocus();
                            } else if (FieldEditPanel.this.fieldEditListener != null) {
                                FieldEditPanel.this.fieldEditListener.cancelEditsSelectNext();
                            }
                        } else if (e.getSource() == FieldEditPanel.this.valueField2) {
                            if (FieldEditPanel.this.fieldEditListener != null) {
                                FieldEditPanel.this.fieldEditListener.commitEditsSelectNext();
                            }
                        } else if (FieldEditPanel.this.fieldEditListener != null) {
                            FieldEditPanel.this.fieldEditListener.commitEditsSelectNext();
                        }
                    }
                } else if (FieldEditPanel.this.currentMode == FieldRenderPanel.FieldMode.SINGLE_FIELD || FieldEditPanel.this.currentMode == FieldRenderPanel.FieldMode.ENTRY_MAIN_FIELD || FieldEditPanel.this.currentMode == FieldRenderPanel.FieldMode.SENSE_MAIN_FIELD) {
                    if (FieldEditPanel.this.fieldEditListener != null) {
                        FieldEditPanel.this.fieldEditListener.commitEditsSelectPrevious();
                    }
                } else if (FieldEditPanel.this.currentMode == FieldRenderPanel.FieldMode.TWO_FIELDS) {
                    if (e.getSource() == FieldEditPanel.this.valueField2) {
                        if (FieldEditPanel.this.valueField.isEditable()) {
                            FieldEditPanel.this.valueField.requestFocus();
                        } else if (FieldEditPanel.this.fieldEditListener != null) {
                            FieldEditPanel.this.fieldEditListener.cancelEditsSelectPrevious();
                        }
                    } else if (e.getSource() == FieldEditPanel.this.valueField) {
                        if (FieldEditPanel.this.fieldEditListener != null) {
                            FieldEditPanel.this.fieldEditListener.commitEditsSelectPrevious();
                        }
                    } else if (FieldEditPanel.this.fieldEditListener != null) {
                        FieldEditPanel.this.fieldEditListener.commitEditsSelectPrevious();
                    }
                }
            } else if (e.getKeyCode() == 521 || e.getKeyCode() == 61) {
                if (FieldEditPanel.this.addButton.isEnabled() && (e.getSource() != FieldEditPanel.this.valueField && e.getSource() != FieldEditPanel.this.valueField2 || e.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) && FieldEditPanel.this.fieldEditListener != null) {
                    FieldEditPanel.this.fieldEditListener.addNewField(FieldEditPanel.this.triplet);
                }
            } else if (e.getKeyCode() == 45 && FieldEditPanel.this.removeButton.isEnabled() && (e.getSource() != FieldEditPanel.this.valueField && e.getSource() != FieldEditPanel.this.valueField2 || e.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) && FieldEditPanel.this.fieldEditListener != null) {
                FieldEditPanel.this.fieldEditListener.removeField(FieldEditPanel.this.triplet);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == FieldEditPanel.this.addButton) {
                if (FieldEditPanel.this.fieldEditListener != null) {
                    FieldEditPanel.this.fieldEditListener.addNewField(FieldEditPanel.this.triplet);
                }
            } else if (e.getSource() == FieldEditPanel.this.removeButton && FieldEditPanel.this.fieldEditListener != null) {
                FieldEditPanel.this.fieldEditListener.removeField(FieldEditPanel.this.triplet);
            }
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (!FieldEditPanel.this.triplet.isPlaceHolder()) {
                return;
            }
            if ((me.getSource() == FieldEditPanel.this.valueField || me.getSource() == FieldEditPanel.this.valueField2 || me.getSource() instanceof FieldRenderPanel) && FieldEditPanel.this.fieldEditListener != null) {
                FieldEditPanel.this.fieldEditListener.addNewField(FieldEditPanel.this.triplet);
            }
        }
    }
}

