/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.gui.tree;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import nl.mpi.lexiconcomponent.gui.LexiconGuiConstants;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.model.CustomField;
import nl.mpi.lexiconcomponent.model.CustomFieldSpec;
import nl.mpi.lexiconcomponent.util.EntryFieldTriplet;

public class FieldRenderPanel
extends JPanel {
    protected EmptyBorder emptyBorder = new EmptyBorder(4, 2, 4, 2);
    protected EntryFieldTriplet<LexiconFields, String, String> triplet;
    protected GroupLayout groupLayout;
    protected GroupLayout.SequentialGroup vGroup;
    protected GroupLayout.SequentialGroup hGroup;
    protected GroupLayout.ParallelGroup col1Group;
    protected GroupLayout.ParallelGroup col2Group;
    protected GroupLayout.ParallelGroup row1Group;
    protected int hGap = 8;
    protected int prefTextFieldWidth = 300;
    protected JLabel keyLabel;
    protected JTextField valueField;
    protected JComboBox valueCombo;
    protected JLabel keyLabel2;
    protected JTextField valueField2;
    protected JComboBox valueCombo2;
    protected EntryFieldTriplet<LexiconFields, String, String> triplet2;
    protected JLabel idLabel;
    protected JLabel dateCreatedLabel;
    protected JLabel dateModifiedLabel;
    protected JPanel datePanel;
    private int renderWidth = -1;
    protected FieldMode currentMode = FieldMode.SINGLE_FIELD;
    private Object fieldUserObject;

    public FieldRenderPanel(FieldMode mode) {
        this.currentMode = mode;
        this.initPanel();
    }

    protected void initPanel() {
        this.setBorder(this.emptyBorder);
        switch (this.currentMode) {
            case SINGLE_FIELD: {
                this.initFirstField();
                break;
            }
            case TWO_FIELDS: {
                this.initFirstField();
                this.initSecondField();
                break;
            }
            case ENTRY_MAIN_FIELD: {
                this.initEntryMainPanel();
                break;
            }
            case SENSE_MAIN_FIELD: {
                this.initSenseMainPanel();
                break;
            }
            default: {
                this.initFirstField();
            }
        }
    }

    protected void initFirstField() {
        this.groupLayout = new GroupLayout(this);
        this.setLayout(this.groupLayout);
        this.keyLabel = new JLabel();
        this.keyLabel.setFont(this.keyLabel.getFont().deriveFont(1));
        this.valueField = new JTextField();
        this.valueField.setBorder(null);
        this.valueCombo = new JComboBox();
        this.vGroup = this.groupLayout.createSequentialGroup();
        this.row1Group = this.groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE);
        this.vGroup.addGroup(this.row1Group.addComponent(this.keyLabel).addComponent(this.valueField));
        this.groupLayout.setVerticalGroup(this.vGroup);
        this.hGroup = this.groupLayout.createSequentialGroup();
        this.col1Group = this.groupLayout.createParallelGroup();
        this.col1Group.addComponent(this.keyLabel);
        this.hGroup.addGroup(this.col1Group);
        this.hGroup.addGap(this.hGap);
        this.col2Group = this.groupLayout.createParallelGroup();
        this.col2Group.addComponent(this.valueField, 40, this.prefTextFieldWidth, 1000);
        this.hGroup.addGroup(this.col2Group);
        this.groupLayout.setHorizontalGroup(this.hGroup);
    }

    protected void initSecondField() {
        this.keyLabel2 = new JLabel();
        this.keyLabel2.setFont(this.keyLabel2.getFont().deriveFont(1));
        this.valueField2 = new JTextField();
        this.valueField2.setBorder(null);
        this.valueCombo2 = new JComboBox();
        this.vGroup.addGroup(this.groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyLabel2).addComponent(this.valueField2));
        this.col1Group.addComponent(this.keyLabel2);
        this.col2Group.addComponent(this.valueField2);
    }

    protected void initEntryMainPanel() {
        this.setLayout(new GridBagLayout());
        this.keyLabel = new JLabel();
        this.keyLabel.setFont(this.keyLabel.getFont().deriveFont(1));
        this.valueField = new JTextField();
        this.valueField.setBorder(null);
        this.keyLabel2 = new JLabel();
        this.keyLabel2.setFont(this.keyLabel2.getFont().deriveFont(1));
        this.valueField2 = new JTextField(2);
        this.valueField2.setBorder(null);
        this.valueField2.setEditable(false);
        this.idLabel = new JLabel();
        this.dateCreatedLabel = new JLabel();
        this.dateModifiedLabel = new JLabel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, this.hGap);
        this.add((Component)this.keyLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.valueField, gbc);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.add((Component)this.keyLabel2, gbc);
        gbc.gridx = 3;
        this.add((Component)this.valueField2, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.idLabel, gbc);
        gbc.gridy = 2;
        this.datePanel = new JPanel(new GridLayout(1, 2, this.hGap, 0));
        this.datePanel.add(this.dateCreatedLabel);
        this.datePanel.add(this.dateModifiedLabel);
        this.datePanel.setOpaque(false);
        this.add((Component)this.datePanel, gbc);
    }

    protected void initSenseMainPanel() {
        this.initEntryMainPanel();
        this.remove(this.datePanel);
    }

    public void setTriplet(EntryFieldTriplet<LexiconFields, String, String> triplet) {
        this.triplet = triplet;
        this.keyLabel.setText(((LexiconFields)((Object)triplet.FIELD)).getDisplayLabel());
        if (triplet.FIELD == LexiconFields.ENTRY_FIELD || triplet.FIELD == LexiconFields.SENSE_FIELD) {
            if (this.fieldUserObject instanceof CustomField) {
                this.keyLabel.setText(((LexiconFields)((Object)triplet.FIELD)).getDisplayLabel() + ": " + ((CustomField)this.fieldUserObject).getName());
            } else if (this.fieldUserObject instanceof CustomFieldSpec) {
                this.keyLabel.setText(((LexiconFields)((Object)triplet.FIELD)).getDisplayLabel() + ": " + ((CustomFieldSpec)this.fieldUserObject).getName());
            }
        }
        if (triplet.isEdited()) {
            this.valueField.setText(triplet.getEdit());
        } else if (triplet.getOrig() != null) {
            this.valueField.setText(triplet.getOrig());
        } else {
            this.valueField.setText("");
        }
        if (triplet.isRemoved()) {
            this.keyLabel.setForeground(LexiconGuiConstants.REMOVED_FG_COLOR);
            this.valueField.setForeground(LexiconGuiConstants.REMOVED_FG_COLOR);
        } else if (triplet.getOrig() == null && !triplet.isAdded()) {
            this.keyLabel.setForeground(LexiconGuiConstants.NOT_PRESENT_FG_COLOR);
            if (triplet.isEdited()) {
                this.valueField.setForeground(LexiconGuiConstants.MODIFIED_FG_COLOR);
            } else {
                this.valueField.setForeground(LexiconGuiConstants.NOT_PRESENT_FG_COLOR);
            }
        } else {
            this.keyLabel.setForeground(this.getForeground());
            if (triplet.isEdited()) {
                this.valueField.setForeground(LexiconGuiConstants.MODIFIED_FG_COLOR);
            } else {
                this.valueField.setForeground(this.getForeground());
            }
        }
        if (this.currentMode == FieldMode.SENSE_MAIN_FIELD && !triplet.isRemoved()) {
            this.keyLabel.setForeground(this.getForeground());
        }
        this.revalidate();
    }

    protected void setSecondTriplet(EntryFieldTriplet<LexiconFields, String, String> triplet2) {
        if (this.currentMode == FieldMode.SINGLE_FIELD) {
            throw new IllegalStateException("The panel is configured for a single field");
        }
        this.triplet2 = triplet2;
        if (triplet2.FIELD == LexiconFields.ENTRY_ORDER) {
            this.keyLabel2.setText(((LexiconFields)((Object)triplet2.FIELD)).getDisplayLabel());
            String order = triplet2.getOrig();
            if (order != null && !order.equals("null")) {
                this.valueField2.setText(order);
            } else {
                this.valueField2.setText("-");
            }
        } else {
            this.keyLabel2.setText(((LexiconFields)((Object)triplet2.FIELD)).getDisplayLabel());
            if (triplet2.isEdited()) {
                this.valueField2.setText(triplet2.getEdit());
            } else if (triplet2.getOrig() != null) {
                this.valueField2.setText(triplet2.getOrig());
            } else {
                this.valueField2.setText("");
            }
            if (triplet2.isRemoved()) {
                this.keyLabel2.setForeground(LexiconGuiConstants.REMOVED_FG_COLOR);
                this.valueField2.setForeground(LexiconGuiConstants.REMOVED_FG_COLOR);
            } else if (triplet2.getOrig() == null && !triplet2.isAdded()) {
                this.keyLabel2.setForeground(LexiconGuiConstants.NOT_PRESENT_FG_COLOR);
                if (triplet2.isEdited()) {
                    this.valueField2.setForeground(LexiconGuiConstants.MODIFIED_FG_COLOR);
                } else {
                    this.valueField2.setForeground(LexiconGuiConstants.NOT_PRESENT_FG_COLOR);
                }
            } else {
                this.keyLabel2.setForeground(this.getForeground());
                if (triplet2.isEdited()) {
                    this.valueField2.setForeground(LexiconGuiConstants.MODIFIED_FG_COLOR);
                } else {
                    this.valueField2.setForeground(this.getForeground());
                }
            }
        }
        this.revalidate();
    }

    public void addTriplets(List<EntryFieldTriplet<LexiconFields, String, String>> secTriplets) {
        if (secTriplets != null) {
            if (!secTriplets.isEmpty()) {
                this.setSecondTriplet(secTriplets.get(0));
            }
            if (secTriplets.size() > 1) {
                for (int i = 1; i < secTriplets.size(); ++i) {
                    EntryFieldTriplet<LexiconFields, String, String> eft = secTriplets.get(i);
                    if (eft.FIELD == LexiconFields.ENTRY_ORDER || eft.FIELD == LexiconFields.SENSE_ORDER) {
                        this.setSecondTriplet(eft);
                    }
                    if (eft.FIELD == LexiconFields.ENTRY_ID || eft.FIELD == LexiconFields.SENSE_ID) {
                        String id = eft.getOrig() == null ? "-" : eft.getOrig();
                        this.idLabel.setText(((LexiconFields)((Object)eft.FIELD)).getDisplayLabel() + ": " + id);
                        if (eft.isRemoved()) {
                            this.idLabel.setForeground(LexiconGuiConstants.REMOVED_FG_COLOR);
                        } else {
                            this.idLabel.setForeground(this.getForeground());
                        }
                    }
                    if (eft.FIELD == LexiconFields.ENTRY_DATE_CREATED) {
                        String dc = eft.getOrig() == null ? "-" : eft.getOrig();
                        this.dateCreatedLabel.setText(((LexiconFields)((Object)eft.FIELD)).getDisplayLabel() + ": " + dc);
                        if (eft.isRemoved()) {
                            this.dateCreatedLabel.setForeground(LexiconGuiConstants.REMOVED_FG_COLOR);
                        } else {
                            this.dateCreatedLabel.setForeground(this.getForeground());
                        }
                    }
                    if (eft.FIELD != LexiconFields.ENTRY_DATE_MODIFIED) continue;
                    String dm = eft.getOrig() == null ? "-" : eft.getOrig();
                    this.dateModifiedLabel.setText(((LexiconFields)((Object)eft.FIELD)).getDisplayLabel() + ": " + dm);
                    if (eft.isRemoved()) {
                        this.dateModifiedLabel.setForeground(LexiconGuiConstants.REMOVED_FG_COLOR);
                        continue;
                    }
                    this.dateModifiedLabel.setForeground(this.getForeground());
                }
                this.revalidate();
            }
        }
    }

    public void setViewPortWidth(int viewPortWidth) {
        this.renderWidth = viewPortWidth;
    }

    public void setFieldUserObject(Object fieldUserObject) {
        this.fieldUserObject = fieldUserObject;
    }

    public Object getFieldUserObject() {
        return this.fieldUserObject;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.renderWidth > width) {
            width = this.renderWidth - x - this.hGap;
        }
        super.setBounds(x, y, width, height);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle clip = g.getClipBounds();
        if (clip.width < this.renderWidth) {
            g.setClip(clip.x, clip.y, this.renderWidth - this.hGap, clip.height);
        }
        super.paintComponent(g);
    }

    public static enum FieldMode {
        SINGLE_FIELD,
        TWO_FIELDS,
        ENTRY_MAIN_FIELD,
        SENSE_MAIN_FIELD,
        EXAMPLE_FIELD,
        CUSTOM_FIELD;

    }
}

