/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import nl.mpi.lexiconcomponent.exceptions.LexiconNotFoundException;
import nl.mpi.lexiconcomponent.exceptions.LexiconNotSavedException;
import nl.mpi.lexiconcomponent.impl.LexiconFactory;
import nl.mpi.lexiconcomponent.impl.LexiconImpl;
import nl.mpi.lexiconcomponent.model.ObjectFactory;
import nl.mpi.lexiconcomponent.util.LexiconLogger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LexiconContext {
    private static LexiconContext lexContext;
    private File lexiconFolder;
    private LexiconFactory lexFactory = new LexiconFactory();
    private Map<String, LexiconImpl> loadedLexicons = new HashMap<String, LexiconImpl>();
    private Map<String, URL> lexiconNameURLMap = new HashMap<String, URL>();
    private JAXBContext jaxbContext;
    public final String PRODUCER = "ELAN Lexicon Component";
    public final String SCHEMA_VERSION = "1.0";
    public final String LEXICON_COMP_SCHEMA_LOCATION = "http://www.mpi.nl/tools/elan/LexiconComponent-%s.xsd";
    private static Pattern pattern;

    private LexiconContext() {
    }

    public static LexiconContext getInstance() {
        if (lexContext == null) {
            lexContext = new LexiconContext();
        }
        return lexContext;
    }

    public LexiconFactory getLexiconFactory() {
        return this.lexFactory;
    }

    public static void main(String[] args) {
        File baseDir = new File(".");
        try {
            JAXBContext jaxbContext = LexiconContext.getInstance().getJAXBContext();
            class MySchemaOutputResolver
            extends SchemaOutputResolver {
                final /* synthetic */ File val$baseDir;

                MySchemaOutputResolver(File file) {
                    this.val$baseDir = file;
                }

                public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                    File storeIn = new File(this.val$baseDir, suggestedFileName);
                    System.out.printf("Storing schema in %s\n", storeIn.getAbsolutePath());
                    return new StreamResult(storeIn);
                }
            }
            jaxbContext.generateSchema((SchemaOutputResolver)new MySchemaOutputResolver(baseDir));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String[] getAvailableLexicons() {
        if (this.lexiconNameURLMap.isEmpty()) {
            return new String[0];
        }
        return this.lexiconNameURLMap.keySet().toArray(new String[0]);
    }

    public List<String> getAvailableLexiconsList() {
        if (this.lexiconNameURLMap.isEmpty()) {
            return new ArrayList<String>(0);
        }
        return new ArrayList<String>(this.lexiconNameURLMap.keySet());
    }

    public String getFileLocationOfLexicon(String lexiconName) {
        if (lexiconName != null) {
            URL url = this.lexiconNameURLMap.get(lexiconName);
            try {
                return url == null ? null : url.toURI().getPath();
            }
            catch (URISyntaxException use) {
                return url == null ? null : url.getPath();
            }
        }
        return null;
    }

    public LexiconImpl getLexicon(String name) throws LexiconNotFoundException {
        if (!this.loadedLexicons.containsKey(name)) {
            try {
                LexiconImpl l = this.loadLexicon(name);
                this.loadedLexicons.put(name, l);
                return l;
            }
            catch (LexiconNotFoundException lnfe) {
                this.loadedLexicons.put(name, null);
                throw lnfe;
            }
        }
        return this.loadedLexicons.get(name);
    }

    public void saveLexicon(LexiconImpl lexImpl, URL lexSaveLocation) throws LexiconNotSavedException {
        if (lexImpl == null) {
            throw new LexiconNotSavedException("Cannot save the lexicon, the lexicon is null.");
        }
        if (lexSaveLocation == null) {
            throw new LexiconNotSavedException("Cannot save the lexicon, no location provided (url = null).");
        }
        if (!this.loadedLexicons.containsKey(lexImpl.getHeader().getName())) {
            this.loadedLexicons.put(lexImpl.getHeader().getName(), lexImpl);
        }
        if (!this.lexiconNameURLMap.containsValue(lexSaveLocation)) {
            this.lexiconNameURLMap.put(lexImpl.getHeader().getName(), lexSaveLocation);
        }
        this.saveLexiconPr(lexImpl, lexSaveLocation);
    }

    public void saveLexicon(LexiconImpl lexImpl) throws LexiconNotSavedException {
        URL lexSaveLocation;
        if (lexImpl == null) {
            throw new LexiconNotSavedException("Cannot save the lexicon, the lexicon is null.");
        }
        if (!this.loadedLexicons.containsValue(lexImpl)) {
            throw new LexiconNotSavedException("Cannot save the lexicon, it is unknown where it should be saved.");
        }
        String lexName = null;
        for (String key : this.loadedLexicons.keySet()) {
            if (this.loadedLexicons.get(key) != lexImpl) continue;
            lexName = key;
            break;
        }
        if ((lexSaveLocation = this.lexiconNameURLMap.get(lexName)) == null) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning("Cannot save: the location for the lexicon is unknown");
            }
            throw new LexiconNotSavedException("Cannot save the lexicon, there is no URL specifying where to save.");
        }
        this.saveLexiconPr(lexImpl, lexSaveLocation);
        lexImpl.setChanged(false);
    }

    public void saveNewLexicon(LexiconImpl lexImpl) throws LexiconNotSavedException {
        int counter;
        if (lexImpl == null) {
            throw new LexiconNotSavedException("The lexicon is null");
        }
        if (this.lexiconFolder == null) {
            throw new LexiconNotSavedException("The preferred folder for lexicons has not been set");
        }
        Object lexName = lexImpl.getHeader().getName();
        boolean duplicateName = false;
        if (this.loadedLexicons.containsKey(lexName)) {
            duplicateName = true;
        }
        Object lexFileName = ((String)lexName).replaceAll("[ :;/?!\\*|<>\"]", "_");
        int MAX = 20;
        for (counter = 0; counter < MAX; ++counter) {
            String nextFileName = counter == 0 ? (String)lexFileName + ".xml" : (String)lexFileName + "_" + counter + ".xml";
            File targetFile = new File(this.lexiconFolder, nextFileName);
            if (targetFile.exists()) continue;
            lexFileName = nextFileName;
            break;
        }
        if (counter >= MAX) {
            throw new LexiconNotSavedException(String.format("Lexicon could not be saved: too many files with the same base file name %s", lexFileName));
        }
        if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
            LexiconLogger.LEXLOG.info(String.format("The file name for the new lexicon is %s", lexFileName));
        }
        if (duplicateName) {
            if (counter == 0) {
                counter = 1;
            }
            while (counter < MAX) {
                String nextLexName = (String)lexName + "_" + counter;
                if (this.loadedLexicons.containsKey(nextLexName)) continue;
                lexImpl.getHeader().setName(nextLexName);
                lexName = nextLexName;
                break;
            }
        }
        File saveFile = new File(this.lexiconFolder, (String)lexFileName);
        URL saveURL = null;
        try {
            saveURL = saveFile.toURI().toURL();
            this.saveLexiconPr(lexImpl, saveURL);
        }
        catch (MalformedURLException mue) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning(String.format("Cannot save the lexicon to a file: %s", mue.getMessage()));
            }
            throw new LexiconNotSavedException(mue.getMessage());
        }
        this.loadedLexicons.put((String)lexName, lexImpl);
        this.lexiconNameURLMap.put((String)lexName, saveURL);
        lexImpl.setChanged(false);
    }

    private void saveLexiconPr(LexiconImpl lexImpl, URL lexUrl) throws LexiconNotSavedException {
        StreamResult res = new StreamResult(lexUrl.toExternalForm());
        this.saveLexicon(lexImpl, res);
    }

    public void saveLexicon(LexiconImpl lexImpl, StreamResult res) throws LexiconNotSavedException {
        try {
            Marshaller m = this.getJAXBContext().createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.noNamespaceSchemaLocation", (Object)String.format("http://www.mpi.nl/tools/elan/LexiconComponent-%s.xsd", "1.0"));
            m.marshal((Object)lexImpl, (Result)res);
        }
        catch (JAXBException je) {
            throw new LexiconNotSavedException("The lexicon could not be marshalled: " + je.getMessage(), je);
        }
    }

    public LexiconImpl loadLexiconFromURL(URL lexUrl) throws LexiconNotFoundException {
        if (this.lexiconNameURLMap.containsValue(lexUrl)) {
            for (String name : this.lexiconNameURLMap.keySet()) {
                if (!lexUrl.equals(this.lexiconNameURLMap.get(name))) continue;
                return this.loadedLexicons.get(name);
            }
        }
        InputSource is = new InputSource(lexUrl.toExternalForm());
        LexiconImpl lexicon = this.loadLexicon(is);
        this.lexiconNameURLMap.put(lexicon.getHeader().getName(), lexUrl);
        this.loadedLexicons.put(lexicon.getHeader().getName(), lexicon);
        return lexicon;
    }

    public void unloadLexicon(LexiconImpl lexImpl) {
        if (lexImpl == null || !this.loadedLexicons.containsValue(lexImpl)) {
            return;
        }
        String lexName = null;
        for (String key : this.loadedLexicons.keySet()) {
            if (this.loadedLexicons.get(key) != lexImpl) continue;
            lexName = key;
            break;
        }
        this.loadedLexicons.remove(lexName);
        if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
            LexiconLogger.LEXLOG.fine(String.format("Removed lexicon from cache: %s", lexName));
        }
    }

    public int loadLexiconsFromFolder(File folder) {
        if (folder == null || !folder.exists() || !folder.isDirectory()) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning(String.format("The folder to load lexicons from does not exist %s", folder));
            }
            return 0;
        }
        this.lexiconFolder = folder;
        if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
            LexiconLogger.LEXLOG.fine(String.format("The preferred folder for lexicons is: %s", this.lexiconFolder.toString()));
        }
        int numLoaded = 0;
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml");
            }
        };
        for (File f : folder.listFiles(filter)) {
            try {
                this.loadLexiconFromURL(f.toURI().toURL());
                ++numLoaded;
            }
            catch (MalformedURLException e) {
                if (!LexiconLogger.LEXLOG.isLoggable(Level.INFO)) continue;
                LexiconLogger.LEXLOG.info(String.format("Unable to load a lexicon from a file %s", e.getMessage()));
            }
            catch (LexiconNotFoundException e) {
                if (!LexiconLogger.LEXLOG.isLoggable(Level.INFO)) continue;
                LexiconLogger.LEXLOG.info(String.format("Unable to load a lexicon from a file %s", e.getMessage()));
            }
        }
        return numLoaded;
    }

    public void scanLexiconsFromFolder(File folder) {
        if (folder == null || !folder.exists() || !folder.isDirectory()) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning(String.format("The folder to scan for lexicons does not exist %s", folder));
            }
            return;
        }
        for (File f : folder.listFiles()) {
            if (f.isDirectory()) {
                this.scanLexiconsFromFolder(f);
                continue;
            }
            if (!f.getName().toLowerCase().endsWith(".xml")) continue;
            this.scanLexiconFromFile(f);
        }
    }

    private void scanLexiconFromFile(File f) {
        block6: {
            try {
                Matcher matcher;
                FileReader fr = new FileReader(f);
                char[] cbuf = new char[2048];
                fr.read(cbuf);
                fr.close();
                String s = new String(cbuf);
                if (pattern == null) {
                    pattern = Pattern.compile("<lexicon.*?<header>.*?<name>(.*?)</name>", 32);
                }
                if ((matcher = pattern.matcher(s)).find()) {
                    String name = matcher.group(1);
                    this.lexiconNameURLMap.put(name, f.toURI().toURL());
                }
            }
            catch (FileNotFoundException e) {
                if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
                    LexiconLogger.LEXLOG.info(String.format("Unable to scan for a lexicon in a file %s", e.getMessage()));
                }
            }
            catch (IOException e) {
                if (!LexiconLogger.LEXLOG.isLoggable(Level.INFO)) break block6;
                LexiconLogger.LEXLOG.info(String.format("Unable to scan for a lexicon in a file %s", e.getMessage()));
            }
        }
    }

    private LexiconImpl loadLexicon(String name) throws LexiconNotFoundException {
        URL url = this.lexiconNameURLMap.get(name);
        if (url == null) {
            throw new LexiconNotFoundException("The file for the specified Lexicon was not found");
        }
        InputSource is = new InputSource(url.toExternalForm());
        return this.loadLexicon(is);
    }

    public LexiconImpl loadLexicon(InputSource is) throws LexiconNotFoundException {
        try {
            Unmarshaller u = this.getJAXBContext().createUnmarshaller();
            try {
                u.setProperty("com.sun.xml.internal.bind.ObjectFactory", (Object)this.lexFactory);
            }
            catch (PropertyException ex) {
                u.setProperty("com.sun.xml.bind.ObjectFactory", (Object)this.lexFactory);
            }
            return (LexiconImpl)u.unmarshal(is);
        }
        catch (JAXBException je) {
            throw new LexiconNotFoundException("The specified Lexicon could not be loaded: " + je.toString(), je);
        }
    }

    private JAXBContext getJAXBContext() throws JAXBException {
        if (this.jaxbContext != null) {
            return this.jaxbContext;
        }
        this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class, LexiconFactory.class});
        return this.jaxbContext;
    }

    private Schema getSchema(String ofThisVersion) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            return schemaFactory.newSchema(this.getClass().getResource(String.format("/nl/mpi/lexiconcomponent/schema/LexiconComponent-%s.xsd", ofThisVersion)));
        }
        catch (SAXException sax) {
            sax.printStackTrace();
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }
}

