/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.impl;

import nl.mpi.lexiconcomponent.impl.LexiconFields;

public class LexiconFieldUtil {
    private LexiconFieldUtil() {
    }

    public static LexiconFields getLexiconFieldForFieldName(String fieldName) {
        if (fieldName != null && !fieldName.isEmpty()) {
            for (LexiconFields lf : LexiconFields.values()) {
                if (!lf.getFieldName().equals(fieldName)) continue;
                return lf;
            }
            if (fieldName.startsWith(LexiconFields.ENTRY_FIELD.getFieldName())) {
                return LexiconFields.ENTRY_FIELD;
            }
            if (fieldName.startsWith(LexiconFields.SENSE_FIELD.getFieldName())) {
                return LexiconFields.SENSE_FIELD;
            }
        }
        return null;
    }

    public static LexiconFields getLexiconFieldForDisplayLabel(String displayName) {
        if (displayName != null && !displayName.isEmpty()) {
            for (LexiconFields lf : LexiconFields.values()) {
                if (lf.getDisplayLabel().equals(displayName)) {
                    return lf;
                }
                if (displayName.startsWith(LexiconFields.ENTRY_FIELD.getDisplayLabel())) {
                    return LexiconFields.ENTRY_FIELD;
                }
                if (!displayName.startsWith(LexiconFields.SENSE_FIELD.getDisplayLabel())) continue;
                return LexiconFields.SENSE_FIELD;
            }
        }
        return null;
    }

    public static boolean hasLanguageAttribute(LexiconFields field) {
        if (field == null) {
            return false;
        }
        switch (field) {
            case ENTRY_PHONETIC: 
            case ENTRY_FIELD: 
            case SENSE_GLOSS: 
            case SENSE_DEFINITION: 
            case SENSE_FIELD: 
            case SENSE_EXAMPLE: 
            case SENSE_EXAM_TEXT: 
            case SENSE_EXAM_TEXT_ALL: 
            case SENSE_EXAM_TRANS: {
                return true;
            }
        }
        return false;
    }
}

