/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.impl;

import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import javax.swing.event.EventListenerList;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import nl.mpi.lexiconcomponent.events.LexiconEditListener;
import nl.mpi.lexiconcomponent.events.LexiconEvent;
import nl.mpi.lexiconcomponent.exceptions.LexiconStructureException;
import nl.mpi.lexiconcomponent.impl.EntryImpl;
import nl.mpi.lexiconcomponent.impl.HeaderImpl;
import nl.mpi.lexiconcomponent.impl.LexiconContext;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.impl.SenseImpl;
import nl.mpi.lexiconcomponent.model.CustomField;
import nl.mpi.lexiconcomponent.model.CustomFieldSpec;
import nl.mpi.lexiconcomponent.model.CustomFieldSpecification;
import nl.mpi.lexiconcomponent.model.Entry;
import nl.mpi.lexiconcomponent.model.Gloss;
import nl.mpi.lexiconcomponent.model.Header;
import nl.mpi.lexiconcomponent.model.Lexicon;
import nl.mpi.lexiconcomponent.model.Sense;
import nl.mpi.lexiconcomponent.util.CollatorUtil;
import nl.mpi.lexiconcomponent.util.EntryComparator;
import nl.mpi.lexiconcomponent.util.LexiconLogger;

public class LexiconImpl
extends Lexicon {
    public static final String ENTRY_ID_PREFIX = "e_";
    public static final String SENSE_ID_PREFIX = "s_";
    private DatatypeFactory datatypeFact;
    private List<String> fieldIdsList;
    private RuleBasedCollator lexUnitCollator;
    protected EventListenerList listenerList = new EventListenerList();
    private boolean changed;

    public LexiconImpl() {
        this.getEntries();
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object parent) {
        if (this.header.getSortOrder() != null && !this.header.getSortOrder().isEmpty()) {
            this.initCustomCollator();
        }
    }

    public List<String> getEntryFieldNames() {
        if (this.fieldIdsList == null) {
            this.fieldIdsList = new ArrayList<String>();
            this.fieldIdsList.add(LexiconFields.ENTRY_CITATION.getFieldName());
            this.fieldIdsList.add(LexiconFields.ENTRY_ID.getFieldName());
            this.fieldIdsList.add(LexiconFields.ENTRY_LEX_UNIT.getFieldName());
            this.fieldIdsList.add(LexiconFields.ENTRY_MORPH_TYPE.getFieldName());
            this.fieldIdsList.add(LexiconFields.ENTRY_NOTE.getFieldName());
            this.fieldIdsList.add(LexiconFields.ENTRY_ORDER.getFieldName());
            this.fieldIdsList.add(LexiconFields.ENTRY_VARIANT.getFieldName());
            if (this.getHeader().getCustomFields() != null) {
                for (CustomFieldSpec cfs : this.getHeader().getCustomFields().getFieldSpec()) {
                    if (!cfs.getLevel().equals(LexiconFields.ENTRY.getFieldName()) && !cfs.getLevel().equals(LexiconFields.ALL.getFieldName())) continue;
                    this.fieldIdsList.add(LexiconFields.ENTRY_FIELD.getFieldName() + "/" + cfs.getName());
                }
            }
            this.fieldIdsList.add(LexiconFields.SENSE_COMMENT.getFieldName());
            this.fieldIdsList.add(LexiconFields.SENSE_DEFINITION.getFieldName());
            this.fieldIdsList.add(LexiconFields.SENSE_EXAM_TEXT_ALL.getFieldName());
            this.fieldIdsList.add(LexiconFields.SENSE_EXAM_TRANS_ALL.getFieldName());
            this.fieldIdsList.add(LexiconFields.SENSE_GLOSS.getFieldName());
            this.fieldIdsList.add(LexiconFields.SENSE_GRAM_CAT.getFieldName());
            this.fieldIdsList.add(LexiconFields.SENSE_ID.getFieldName());
            this.fieldIdsList.add(LexiconFields.SENSE_INT_NOTE.getFieldName());
            this.fieldIdsList.add(LexiconFields.SENSE_ORDER.getFieldName());
            if (this.getHeader().getCustomFields() != null) {
                for (CustomFieldSpec cfs : this.getHeader().getCustomFields().getFieldSpec()) {
                    if (!cfs.getLevel().equals(LexiconFields.SENSE.getFieldName()) && !cfs.getLevel().equals(LexiconFields.ALL.getFieldName())) continue;
                    this.fieldIdsList.add(LexiconFields.SENSE_FIELD.getFieldName() + "/" + cfs.getName());
                }
            }
        }
        return this.fieldIdsList;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
        if (!changed) {
            this.fireLexiconSaved();
        }
    }

    public List<? extends Entry> getEntries() {
        return this.getEntryList();
    }

    public int findInsertionPointFor(String lexUnit) {
        Entry searchEntry = LexiconContext.getInstance().getLexiconFactory().createEntry();
        searchEntry.setLexicalUnit(lexUnit);
        EntryComparator<Entry> eComparator = this.createEntryComparator();
        int insertionPoint = Collections.binarySearch(this.entryList, searchEntry, eComparator);
        int entryListSize = this.entryList.size();
        if (insertionPoint >= 0 && insertionPoint < entryListSize) {
            ++insertionPoint;
            while (insertionPoint < entryListSize) {
                Entry e = (Entry)this.entryList.get(insertionPoint);
                if (!(this.lexUnitCollator != null ? this.lexUnitCollator.compare(lexUnit, e.getLexicalUnit()) != 0 : lexUnit.compareTo(e.getLexicalUnit()) != 0)) {
                    ++insertionPoint;
                    continue;
                }
                break;
            }
        } else {
            insertionPoint = -(insertionPoint + 1);
        }
        return insertionPoint;
    }

    public EntryImpl getEntryWithId(String id) {
        for (Entry e : this.entryList) {
            if (!e.getId().equals(id)) continue;
            return (EntryImpl)e;
        }
        return null;
    }

    public List<EntryImpl> getEntriesWithLexUnit(String lexUnit) {
        ArrayList<EntryImpl> matchEntries = new ArrayList<EntryImpl>();
        int insertionPoint = this.binarySearchInsertionPoint(lexUnit);
        if (insertionPoint >= 0) {
            Entry e;
            int i;
            matchEntries.add((EntryImpl)this.entryList.get(insertionPoint));
            for (i = insertionPoint - 1; i >= 0 && lexUnit.compareTo((e = (Entry)this.entryList.get(i)).getLexicalUnit()) == 0; --i) {
                matchEntries.add(0, (EntryImpl)e);
            }
            for (i = insertionPoint + 1; i < this.entryList.size() && lexUnit.compareTo((e = (Entry)this.entryList.get(i)).getLexicalUnit()) == 0; ++i) {
                matchEntries.add((EntryImpl)e);
            }
        }
        return matchEntries;
    }

    public void sortEntries() {
        this.sortEntries(LexiconFields.ENTRY_LEX_UNIT, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortEntries(LexiconFields fieldToSortOn, boolean descending) {
        List list = this.entryList;
        synchronized (list) {
            Collections.sort(this.entryList, new EntryComparator(fieldToSortOn, this.lexUnitCollator));
            this.fireLexiconEdited(new LexiconEvent<LexiconImpl>(this, this, LexiconEvent.LexiconEventType.ORDER_CHANGE));
        }
    }

    private int binarySearchInsertionPoint(String lexUnit) {
        Entry searchEntry = LexiconContext.getInstance().getLexiconFactory().createEntry();
        searchEntry.setLexicalUnit(lexUnit);
        return Collections.binarySearch(this.entryList, searchEntry, new EntryComparator());
    }

    private void initCustomCollator() {
        block3: {
            if (this.lexUnitCollator == null && this.header.getSortOrder() != null && !this.header.getSortOrder().isEmpty()) {
                try {
                    CollatorUtil cu = new CollatorUtil();
                    this.lexUnitCollator = cu.createCollator(this.header.getSortOrder());
                }
                catch (ParseException pe) {
                    if (!LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) break block3;
                    LexiconLogger.LEXLOG.warning(String.format("Unable to create sorting rules for: \"%s\", message: %s", this.header.getSortOrder(), pe.getMessage()));
                }
            }
        }
    }

    public RuleBasedCollator getCollator() {
        if (this.lexUnitCollator == null) {
            this.initCustomCollator();
        }
        return this.lexUnitCollator;
    }

    public EntryComparator<Entry> createEntryComparator() {
        if (this.getCollator() != null) {
            return new EntryComparator<Entry>(this.lexUnitCollator);
        }
        return new EntryComparator<Entry>();
    }

    public EntryImpl createEntry(String lexicalUnit) throws LexiconStructureException {
        if (lexicalUnit == null || lexicalUnit.isEmpty()) {
            throw new LexiconStructureException("Cannot create an entry without a lexical unit");
        }
        EntryImpl nextEntry = (EntryImpl)LexiconContext.getInstance().getLexiconFactory().createEntry();
        nextEntry.setLexicalUnit(lexicalUnit);
        nextEntry.setId(ENTRY_ID_PREFIX + UUID.randomUUID());
        nextEntry.setDateCreated(this.createXMLGregorianCalendar());
        return nextEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(EntryImpl nextEntry) throws LexiconStructureException {
        if (nextEntry == null) {
            throw new LexiconStructureException("Cannot add the entry, it is null");
        }
        nextEntry.setLexicon(this);
        List list = this.entryList;
        synchronized (list) {
            int insertionPoint = this.findInsertionPointFor(nextEntry.getLexicalUnit());
            try {
                List<EntryImpl> homonyms = this.getEntriesWithLexUnit(nextEntry.getLexicalUnit());
                this.entryList.add(insertionPoint, nextEntry);
                int order = 1;
                if (!homonyms.isEmpty()) {
                    for (int i = 0; i < homonyms.size(); ++i) {
                        EntryImpl e = homonyms.get(i);
                        if (e.getOrder() == null) {
                            e.setOrder(i + 1);
                        } else if (e.getOrder() != i + 1) {
                            e.setOrder(i + 1);
                        }
                        ++order;
                    }
                }
                nextEntry.setOrder(order);
            }
            catch (IndexOutOfBoundsException ibe) {
                if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                    LexiconLogger.LEXLOG.warning(String.format("Could not add the new entry at the specified index: %s", ibe.getMessage()));
                }
                throw new LexiconStructureException(String.format("Could not add the new entry at the specified index: %s", ibe.getMessage()));
            }
            catch (Throwable t) {
                if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                    LexiconLogger.LEXLOG.warning(String.format("Could not add the entry: %s", t.getMessage()));
                }
                throw new LexiconStructureException(String.format("Could not add the entry: %s", t.getMessage()));
            }
        }
        this.setChanged(true);
        this.fireEntryAdded(nextEntry);
    }

    public void changeEntry(EntryImpl entry, String changedLexicalUnit) throws LexiconStructureException {
        if (entry == null) {
            throw new LexiconStructureException("Cannot change the entry, it is null");
        }
        if (!this.entryList.contains(entry)) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning("The modified entry is not part of this lexicon");
            }
            throw new LexiconStructureException("Cannot change the entry, it is not part of this lexicon");
        }
        if (changedLexicalUnit != null && !changedLexicalUnit.isEmpty() && !changedLexicalUnit.equals(entry.getLexicalUnit())) {
            int insertionPoint = this.findInsertionPointFor(changedLexicalUnit);
            int curIndex = this.entryList.indexOf(entry);
            List<EntryImpl> curHomonyms = this.getEntriesWithLexUnit(entry.getLexicalUnit());
            List<EntryImpl> nextHomonyms = this.getEntriesWithLexUnit(changedLexicalUnit);
            boolean removeAndAdd = false;
            if (curHomonyms.size() > 1) {
                removeAndAdd = true;
            }
            removeAndAdd = nextHomonyms.isEmpty() ? insertionPoint != curIndex + 1 : true;
            if (removeAndAdd) {
                this.removeEntry(entry);
                entry.setLexicalUnit(changedLexicalUnit);
                this.addEntry(entry);
            } else {
                entry.setLexicalUnit(changedLexicalUnit);
            }
        }
        entry.setDateModified(this.createXMLGregorianCalendar());
        this.setChanged(true);
        this.fireEntryChanged(entry, (Object)LexiconEvent.LexiconEventType.CHANGE);
    }

    public void changeSingleEntryField(EntryImpl entry, String fieldName, String fieldValue) throws LexiconStructureException {
        if (entry == null) {
            throw new LexiconStructureException("Cannot change the entry, it is null");
        }
        if (!this.entryList.contains(entry)) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning("The entry to change is not part of this lexicon");
            }
            throw new LexiconStructureException("Cannot change the entry, it is not part of this lexicon");
        }
        if (fieldName == null) {
            throw new LexiconStructureException("Cannot change the specified entry field, the field name is null");
        }
        if (fieldValue == null) {
            fieldValue = "";
        }
        boolean changed = false;
        if (LexiconFields.ENTRY_CITATION.getFieldName().equals(fieldName)) {
            if (!fieldValue.equals(entry.getCitation())) {
                entry.setCitation(fieldValue);
                changed = true;
            }
        } else if (LexiconFields.ENTRY_MORPH_TYPE.getFieldName().equals(fieldName)) {
            if (!fieldValue.equals(entry.getMorphType())) {
                entry.setMorphType(fieldValue);
                changed = true;
            }
        } else if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
            LexiconLogger.LEXLOG.info(String.format("The entry field to change is not supported by this method: %s", fieldName));
        }
        if (changed) {
            entry.setDateModified(this.createXMLGregorianCalendar());
            this.setChanged(true);
            this.fireEntryChanged(entry, (Object)LexiconEvent.LexiconEventType.CHANGE);
        }
    }

    public void removeEntry(Entry entryToRemove) throws LexiconStructureException {
        if (entryToRemove == null) {
            throw new LexiconStructureException("Cannot remove the entry, it is null");
        }
        boolean removed = this.entryList.remove(entryToRemove);
        if (removed) {
            for (Entry e : this.entryList) {
                if (e.getEntryRef() != entryToRemove) continue;
                e.setEntryRef(null);
            }
            List<EntryImpl> homonyms = this.getEntriesWithLexUnit(entryToRemove.getLexicalUnit());
            if (homonyms.size() == 1) {
                homonyms.get(0).setOrder(null);
            } else if (homonyms.size() > 1) {
                for (int i = 0; i < homonyms.size(); ++i) {
                    EntryImpl e = homonyms.get(i);
                    if (e.getOrder() != null && e.getOrder() == i + 1) continue;
                    e.setOrder(i + 1);
                }
            }
        } else {
            throw new LexiconStructureException("Cannot remove the entry, it is not part of this lexicon");
        }
        this.setChanged(true);
        this.fireEntryRemoved((EntryImpl)entryToRemove);
    }

    public synchronized void sortEntriesFromList(List<EntryImpl> orderedEntries) {
        if (orderedEntries == null) {
            return;
        }
        for (int i = 0; i < orderedEntries.size(); ++i) {
            EntryImpl entry = orderedEntries.get(i);
            EntryImpl moveEntry = this.getEntryWithId(entry.getId());
            if (moveEntry == null || !this.entryList.remove(moveEntry)) continue;
            if (i <= this.entryList.size()) {
                this.entryList.add(i, moveEntry);
                continue;
            }
            this.entryList.add(moveEntry);
        }
        this.setChanged(true);
        this.fireLexiconEdited();
    }

    public SenseImpl createSense(String gramCategory, String glossLabel) throws LexiconStructureException {
        if (gramCategory == null || gramCategory.isEmpty()) {
            throw new LexiconStructureException("Cannot create a Sense, the grammatical category is missing");
        }
        if (glossLabel == null) {
            throw new LexiconStructureException("Cannot create a Sense, a gloss label is missing");
        }
        SenseImpl sense = (SenseImpl)LexiconContext.getInstance().getLexiconFactory().createSense();
        sense.setGrammaticalCategory(gramCategory);
        sense.setId(SENSE_ID_PREFIX + UUID.randomUUID());
        Gloss gloss = LexiconContext.getInstance().getLexiconFactory().createGloss();
        gloss.setValue(glossLabel);
        sense.getGloss().add(gloss);
        return sense;
    }

    public void addSense(EntryImpl parentEntry, SenseImpl sense) throws LexiconStructureException {
        if (parentEntry == null) {
            throw new LexiconStructureException("Cannot add a Sense: the entry is null");
        }
        if (sense == null) {
            throw new LexiconStructureException("Cannot add a Sense, it is null");
        }
        sense.setEntry(parentEntry);
        int numSenses = parentEntry.getSense().size();
        sense.setOrder(numSenses + 1);
        parentEntry.getSense().add(sense);
        parentEntry.setDateModified(this.createXMLGregorianCalendar());
        this.setChanged(true);
        this.fireSenseAdded(sense);
    }

    public void removeSense(EntryImpl parentEntry, SenseImpl sense) throws LexiconStructureException {
        if (parentEntry == null) {
            throw new LexiconStructureException("Cannot remove the sense: the entry is null");
        }
        if (sense == null) {
            throw new LexiconStructureException("Cannot remove the sense, it is null");
        }
        if (!parentEntry.getSense().contains(sense)) {
            throw new LexiconStructureException("Cannot remove the sense, it is not part of the entry");
        }
        if (parentEntry.getSense().size() <= 1) {
            throw new LexiconStructureException("Cannot remove the sense, each entry is required to have at least one sense");
        }
        sense.setEntry(null);
        boolean removed = parentEntry.getSense().remove(sense);
        if (removed) {
            for (int i = 0; i < parentEntry.getSense().size(); ++i) {
                Sense curSense = parentEntry.getSense().get(i);
                if (curSense.getOrder() == i + 1) continue;
                curSense.setOrder(i + 1);
            }
        }
        parentEntry.setDateModified(this.createXMLGregorianCalendar());
        this.setChanged(true);
        this.fireSenseRemoved(sense);
    }

    public HeaderImpl createHeader() {
        HeaderImpl header = (HeaderImpl)LexiconContext.getInstance().getLexiconFactory().createHeader();
        return header;
    }

    public void addHeader(HeaderImpl header) throws LexiconStructureException {
        if (header == null) {
            throw new LexiconStructureException("Cannot add the header, it is null");
        }
        if (this.getHeader() != null) {
            throw new LexiconStructureException("Cannot add the header because there is already a header");
        }
        header.setLexicon(this);
        this.setHeader(header);
        this.setChanged(true);
        this.fireLexiconEdited();
    }

    public void changeHeader(Header header) throws LexiconStructureException {
        if (this.getHeader() != header) {
            throw new LexiconStructureException("The changed header is not part of this lexicon");
        }
        this.setChanged(true);
        this.fireLexiconEdited();
    }

    public void changeSortOrder(Header header, String newSortOrder) throws LexiconStructureException, ParseException {
        if (this.getHeader() != header) {
            throw new LexiconStructureException("The changed header is not part of this lexicon");
        }
        if (newSortOrder == null || newSortOrder.isEmpty()) {
            if (header.getSortOrder() != null && !header.getSortOrder().isEmpty()) {
                header.setSortOrder(null);
                this.lexUnitCollator = null;
                this.setChanged(true);
                this.fireLexiconEdited(new LexiconEvent<LexiconImpl>(this, this, LexiconEvent.LexiconEventType.SORT_ORDER_CHANGE));
            }
        } else if (header.getSortOrder() == null || header.getSortOrder().isEmpty() || !header.getSortOrder().equals(newSortOrder)) {
            CollatorUtil cu = new CollatorUtil();
            RuleBasedCollator rbc = cu.createCollator(newSortOrder);
            header.setSortOrder(newSortOrder);
            this.lexUnitCollator = rbc;
            this.setChanged(true);
            this.fireLexiconEdited(new LexiconEvent<LexiconImpl>(this, this, LexiconEvent.LexiconEventType.SORT_ORDER_CHANGE));
        }
    }

    public void addCustomFieldSpec(String name, String level) throws LexiconStructureException {
        if (name == null) {
            throw new LexiconStructureException("Cannot add an unnamed custom field to the lexicon");
        }
        CustomFieldSpecification cfSpecs = this.getHeader().getCustomFields();
        if (cfSpecs == null) {
            cfSpecs = LexiconContext.getInstance().getLexiconFactory().createCustomFieldSpecification();
            this.getHeader().setCustomFields(cfSpecs);
        } else {
            for (CustomFieldSpec cfs : cfSpecs.getFieldSpec()) {
                if (!cfs.getName().equals(name)) continue;
                throw new LexiconStructureException(String.format("Cannot add the custom field to the lexicon, the field name '%s' already exists", name));
            }
        }
        CustomFieldSpec nextFieldSpec = LexiconContext.getInstance().getLexiconFactory().createCustomFieldSpec();
        nextFieldSpec.setName(name);
        nextFieldSpec.setLevel(level);
        cfSpecs.getFieldSpec().add(nextFieldSpec);
        this.fieldIdsList = null;
        this.setChanged(true);
        this.fireLexiconEdited();
    }

    public void modifyCustomFieldSpec(CustomFieldSpec existCfs, String editName, String level) throws LexiconStructureException {
        if (existCfs == null) {
            throw new LexiconStructureException("Cannot modify the custom field, it is not present yet");
        }
        CustomFieldSpecification cfSpecs = this.getHeader().getCustomFields();
        if (cfSpecs == null) {
            throw new LexiconStructureException("Cannot modify the custom field, there are not custom fields defined yet");
        }
        if (!cfSpecs.getFieldSpec().contains(existCfs)) {
            throw new LexiconStructureException(String.format("Cannot modify the custom field '%s', it is not in the list of fields yet", existCfs.getName()));
        }
        if (!level.equals(existCfs.getLevel()) && !level.equals(LexiconFields.ALL.getFieldName())) {
            if (level.equals(LexiconFields.ENTRY.getFieldName())) {
                for (Entry entry : this.entryList) {
                    for (Sense sense : entry.getSense()) {
                        for (int i = sense.getField().size() - 1; i >= 0; --i) {
                            CustomField cf = sense.getField().get(i);
                            if (!cf.getName().equals(existCfs.getName())) continue;
                            sense.getField().remove(cf);
                        }
                    }
                }
            } else if (level.equals(LexiconFields.SENSE.getFieldName())) {
                for (Entry entry : this.entryList) {
                    for (int i = entry.getField().size() - 1; i >= 0; --i) {
                        CustomField cf = entry.getField().get(i);
                        if (!cf.getName().equals(existCfs.getName())) continue;
                        entry.getField().remove(cf);
                    }
                }
            }
        }
        if (!existCfs.getName().equals(editName)) {
            boolean eFlag = level.equals(LexiconFields.ALL.getFieldName()) || level.equals(LexiconFields.ENTRY.getFieldName());
            boolean sFlag = level.equals(LexiconFields.ALL.getFieldName()) || level.equals(LexiconFields.SENSE.getFieldName());
            for (Entry entry : this.entryList) {
                if (eFlag) {
                    for (CustomField cf : entry.getField()) {
                        if (!cf.getName().equals(existCfs.getName())) continue;
                        cf.setName(editName);
                    }
                }
                if (!sFlag) continue;
                for (Sense sense : entry.getSense()) {
                    for (CustomField cf : sense.getField()) {
                        if (!cf.getName().equals(existCfs.getName())) continue;
                        cf.setName(editName);
                    }
                }
            }
        }
        existCfs.setName(editName);
        existCfs.setLevel(level);
        this.fieldIdsList = null;
        this.setChanged(true);
        this.fireLexiconEdited();
    }

    public void removeAllCustomFieldSpecs() throws LexiconStructureException {
        if (this.getHeader().getCustomFields() != null) {
            LexiconStructureException lse = null;
            List<CustomFieldSpec> fieldSpecsList = this.getHeader().getCustomFields().getFieldSpec();
            for (int i = fieldSpecsList.size() - 1; i >= 0; --i) {
                CustomFieldSpec cfs = fieldSpecsList.get(i);
                try {
                    this.removeCustomFieldSpec(cfs);
                    continue;
                }
                catch (LexiconStructureException le) {
                    lse = le;
                }
            }
            if (lse != null) {
                throw lse;
            }
        }
    }

    public void removeCustomFieldSpec(CustomFieldSpec existCfs) throws LexiconStructureException {
        if (existCfs == null) {
            throw new LexiconStructureException("Cannot remove the custom field, it is null");
        }
        CustomFieldSpecification cfSpecs = this.getHeader().getCustomFields();
        if (cfSpecs == null) {
            throw new LexiconStructureException("Cannot remove the custom field, there are no custom fields in the lexicon");
        }
        if (!cfSpecs.getFieldSpec().contains(existCfs)) {
            throw new LexiconStructureException(String.format("Cannot remove the custom field '%s', it is not in the list of this lexicon", existCfs.getName()));
        }
        boolean eFlag = existCfs.getLevel().equals(LexiconFields.ALL.getFieldName()) || existCfs.getLevel().equals(LexiconFields.ENTRY.getFieldName());
        boolean sFlag = existCfs.getLevel().equals(LexiconFields.ALL.getFieldName()) || existCfs.getLevel().equals(LexiconFields.SENSE.getFieldName());
        for (Entry entry : this.entryList) {
            if (eFlag) {
                for (int i = entry.getField().size() - 1; i >= 0; --i) {
                    CustomField cf = entry.getField().get(i);
                    if (!cf.getName().equals(existCfs.getName())) continue;
                    entry.getField().remove(cf);
                }
            }
            if (!sFlag) continue;
            for (Sense sense : entry.getSense()) {
                for (int i = sense.getField().size() - 1; i >= 0; --i) {
                    CustomField cf = sense.getField().get(i);
                    if (!cf.getName().equals(existCfs.getName())) continue;
                    sense.getField().remove(cf);
                }
            }
        }
        this.getHeader().getCustomFields().getFieldSpec().remove(existCfs);
        this.fieldIdsList = null;
        this.setChanged(true);
        this.fireLexiconEdited();
    }

    public XMLGregorianCalendar createXMLGregorianCalendar(int year, int month, int day) {
        XMLGregorianCalendar xmlCalendar = this.createXMLGregorianCalendar();
        xmlCalendar.setYear(year);
        xmlCalendar.setMonth(month);
        xmlCalendar.setDay(day);
        xmlCalendar.setHour(0);
        xmlCalendar.setMinute(0);
        xmlCalendar.setSecond(0);
        xmlCalendar.setMillisecond(0);
        return xmlCalendar;
    }

    private XMLGregorianCalendar createXMLGregorianCalendar() {
        if (this.datatypeFact == null) {
            try {
                this.datatypeFact = DatatypeFactory.newInstance();
            }
            catch (Throwable t) {
                LexiconLogger.LEXLOG.warning("Could not create a DataTypeFactory");
            }
        }
        if (this.datatypeFact != null) {
            GregorianCalendar gCal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            XMLGregorianCalendar xmlCalendar = this.datatypeFact.newXMLGregorianCalendar(gCal);
            return xmlCalendar;
        }
        return null;
    }

    protected void fireLexiconEdited() {
        this.fireLexiconEdited(new LexiconEvent<LexiconImpl>(this, this));
    }

    protected void fireLexiconSaved() {
        this.fireLexiconEdited(new LexiconEvent<LexiconImpl>(this, this, LexiconEvent.LexiconEventType.SAVE));
    }

    protected void fireEntryAdded(EntryImpl addedEntry) {
        this.fireEntryEdited(new LexiconEvent<EntryImpl>(this, addedEntry, LexiconEvent.LexiconEventType.ADD));
    }

    protected void fireEntryRemoved(EntryImpl removedEntry) {
        this.fireEntryEdited(new LexiconEvent<EntryImpl>(this, removedEntry, LexiconEvent.LexiconEventType.REMOVE));
    }

    protected void fireEntryChanged(EntryImpl changedEntry, Object change) {
        this.fireEntryEdited(new LexiconEvent<EntryImpl>(this, changedEntry, LexiconEvent.LexiconEventType.CHANGE));
    }

    protected void fireSenseAdded(SenseImpl addedSense) {
        this.fireSenseEdited(new LexiconEvent<SenseImpl>(this, addedSense, LexiconEvent.LexiconEventType.ADD));
    }

    protected void fireSenseRemoved(SenseImpl removedSense) {
        this.fireSenseEdited(new LexiconEvent<SenseImpl>(this, removedSense, LexiconEvent.LexiconEventType.REMOVE));
    }

    protected void fireSenseChanged(SenseImpl changedSense, Object change) {
        this.fireSenseEdited(new LexiconEvent<SenseImpl>(this, changedSense, LexiconEvent.LexiconEventType.CHANGE));
    }

    protected void fireLexiconEdited(LexiconEvent<LexiconImpl> event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != LexiconEditListener.class) continue;
            ((LexiconEditListener)listeners[i + 1]).lexiconEdited(event);
        }
    }

    protected void fireEntryEdited(LexiconEvent<EntryImpl> event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != LexiconEditListener.class) continue;
            ((LexiconEditListener)listeners[i + 1]).lexiconEntryEdited(event);
        }
    }

    protected void fireSenseEdited(LexiconEvent<SenseImpl> event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != LexiconEditListener.class) continue;
            ((LexiconEditListener)listeners[i + 1]).lexiconSenseEdited(event);
        }
    }

    public void addLexiconEditListener(LexiconEditListener l) {
        this.listenerList.add(LexiconEditListener.class, l);
    }

    public void removeLexiconEditListener(LexiconEditListener l) {
        this.listenerList.remove(LexiconEditListener.class, l);
    }
}

