/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.mpi.lexiconcomponent.impl.EntryImpl;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.impl.SenseImpl;
import nl.mpi.lexiconcomponent.model.CustomField;
import nl.mpi.lexiconcomponent.model.Sense;
import nl.mpi.lexiconcomponent.model.TextLang;
import nl.mpi.lexiconcomponent.query.EntryFieldGetter;
import nl.mpi.lexiconcomponent.query.SenseFieldGetter;
import nl.mpi.lexiconcomponent.query.SenseFieldGetterFactory;

public class EntryFieldGetterFactory {
    public static final EmptyGetter EMPTY_GETTER = new EmptyGetter();

    private static EntryFieldGetter senseFieldGetter(String subQuery, boolean includeCustomFields) {
        String field;
        if (subQuery.isEmpty()) {
            return EMPTY_GETTER;
        }
        String[] parts = subQuery.split("/");
        String index = null;
        if (parts.length == 1) {
            field = parts[0];
        } else {
            try {
                Integer.parseInt(parts[0]);
                index = parts[0];
                field = subQuery.substring(parts[0].length() + 1);
            }
            catch (NumberFormatException nfe) {
                field = "*".equals(parts[0]) ? subQuery.substring(2) : subQuery;
            }
        }
        SenseFieldGetter getter = SenseFieldGetterFactory.createGetter(field, includeCustomFields, false);
        if (getter == SenseFieldGetterFactory.EMPTY_GETTER) {
            return EMPTY_GETTER;
        }
        if (index == null) {
            return new GetterFromAllSenses(getter);
        }
        SenseFieldGetterFactory.IGetterFromList<Sense> elementGetter = SenseFieldGetterFactory.getterFromList(index);
        return new GetterFromSomeSenses(getter, elementGetter);
    }

    public static EntryFieldGetter createGetter(String fieldName, boolean includeCustomFields) {
        if (fieldName == null || fieldName.isEmpty() || fieldName.equals("-")) {
            return EMPTY_GETTER;
        }
        try {
            if (fieldName.startsWith(LexiconFields.ENTRY_CITATION.getFieldName())) {
                return new CitationGetter();
            }
            if (fieldName.startsWith(LexiconFields.CUSTOM.getFieldName())) {
                return new GetterFromCustomFieldList(fieldName.substring(LexiconFields.CUSTOM.getFieldName().length() + 1));
            }
            if (fieldName.startsWith(LexiconFields.ENTRY_ID.getFieldName())) {
                return new IdGetter();
            }
            if (fieldName.startsWith(LexiconFields.ENTRY_LEX_UNIT.getFieldName())) {
                return new LexicalUnitGetter();
            }
            if (fieldName.startsWith(LexiconFields.ENTRY_MORPH_TYPE.getFieldName())) {
                return new MorphTypeGetter();
            }
            if (fieldName.startsWith(LexiconFields.ENTRY_NOTE.getFieldName())) {
                return new GetterFromStringListGetter(new NoteGetter(), SenseFieldGetterFactory.getterFromList(fieldName.substring(LexiconFields.ENTRY_NOTE.getFieldName().length())));
            }
            if (fieldName.startsWith(LexiconFields.ENTRY_ORDER.getFieldName())) {
                return new OrderGetter();
            }
            if (fieldName.startsWith(LexiconFields.ENTRY_VARIANT.getFieldName())) {
                return new GetterFromStringListGetter(new VariantGetter(), SenseFieldGetterFactory.getterFromList(fieldName.substring(LexiconFields.ENTRY_VARIANT.getFieldName().length())));
            }
            if (fieldName.startsWith(LexiconFields.ENTRY_PHONETIC.getFieldName())) {
                return new PhoneticGetter(fieldName.substring(LexiconFields.ENTRY_PHONETIC.getFieldName().length()));
            }
            if (!fieldName.startsWith(LexiconFields.SENSE_FIELD.getFieldName()) && fieldName.startsWith(LexiconFields.SENSE.getFieldName())) {
                return EntryFieldGetterFactory.senseFieldGetter(fieldName.substring(LexiconFields.SENSE.getFieldName().length() + 1), includeCustomFields);
            }
        }
        catch (Exception ex) {
            return EMPTY_GETTER;
        }
        if (includeCustomFields) {
            if (fieldName.startsWith(LexiconFields.ENTRY_FIELD.getFieldName())) {
                return new GetterFromCustomFieldList(fieldName.substring(LexiconFields.ENTRY_FIELD.getFieldName().length() + 1));
            }
            if (fieldName.startsWith(LexiconFields.SENSE_FIELD.getFieldName())) {
                SenseFieldGetter custSenseFieldGetter = SenseFieldGetterFactory.createGetter(fieldName, true, false);
                if (custSenseFieldGetter != null) {
                    return new GetterFromAllSenses(custSenseFieldGetter);
                }
            } else {
                return new GetterFromCustomFieldList(fieldName);
            }
        }
        return EMPTY_GETTER;
    }

    public static EntryFieldGetter createGetter(String fieldName) {
        return EntryFieldGetterFactory.createGetter(fieldName, true);
    }

    static class EmptyGetter
    implements EntryFieldGetter {
        EmptyGetter() {
        }

        @Override
        public List<String> getValues(EntryImpl entry) {
            return Collections.emptyList();
        }
    }

    static class GetterFromAllSenses
    implements EntryFieldGetter {
        SenseFieldGetter senseGetter;

        GetterFromAllSenses(SenseFieldGetter senseGetter) {
            this.senseGetter = senseGetter;
        }

        @Override
        public List<String> getValues(EntryImpl entry) {
            ArrayList<String> result = new ArrayList<String>();
            for (Sense s : entry.getSense()) {
                result.addAll(this.senseGetter.getValues((SenseImpl)s));
            }
            return result;
        }
    }

    static class GetterFromSomeSenses
    implements EntryFieldGetter {
        SenseFieldGetter senseGetter;
        SenseFieldGetterFactory.IGetterFromList<Sense> listGetter;

        GetterFromSomeSenses(SenseFieldGetter senseGetter, SenseFieldGetterFactory.IGetterFromList<Sense> listGetter) {
            this.senseGetter = senseGetter;
            this.listGetter = listGetter;
        }

        @Override
        public List<String> getValues(EntryImpl entry) {
            ArrayList<String> result = new ArrayList<String>();
            for (Sense s : this.listGetter.getValues(entry.getSense())) {
                result.addAll(this.senseGetter.getValues((SenseImpl)s));
            }
            return result;
        }
    }

    static class CitationGetter
    implements EntryFieldGetter {
        CitationGetter() {
        }

        @Override
        public List<String> getValues(EntryImpl entry) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(entry.getCitation());
            return list;
        }
    }

    static class GetterFromCustomFieldList
    extends SenseFieldGetterFactory.BGetterFromCustomFieldList
    implements EntryFieldGetter {
        GetterFromCustomFieldList(String subQuery) {
            this.parts = subQuery.split("/");
        }

        @Override
        public List<String> getValues(EntryImpl entry) {
            ArrayList<String> result = new ArrayList<String>(1);
            List<CustomField> fields = entry.getField();
            this.getValues(result, fields);
            return result;
        }
    }

    static class IdGetter
    implements EntryFieldGetter {
        IdGetter() {
        }

        @Override
        public List<String> getValues(EntryImpl entry) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(entry.getId());
            return list;
        }
    }

    static class LexicalUnitGetter
    implements EntryFieldGetter {
        LexicalUnitGetter() {
        }

        @Override
        public List<String> getValues(EntryImpl entry) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(entry.getLexicalUnit());
            return list;
        }
    }

    static class MorphTypeGetter
    implements EntryFieldGetter {
        MorphTypeGetter() {
        }

        @Override
        public List<String> getValues(EntryImpl entry) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(entry.getMorphType());
            return list;
        }
    }

    static class GetterFromStringListGetter
    implements EntryFieldGetter {
        StringListGetter fieldGetter;
        SenseFieldGetterFactory.IGetterFromList<String> nr;

        public GetterFromStringListGetter(StringListGetter fieldGetter, SenseFieldGetterFactory.IGetterFromList<String> subquery) {
            this.fieldGetter = fieldGetter;
            this.nr = subquery;
        }

        @Override
        public List<String> getValues(EntryImpl entry) {
            List<String> list = this.fieldGetter.getValues(entry);
            return this.nr.getValues(list);
        }
    }

    static class NoteGetter
    implements StringListGetter {
        NoteGetter() {
        }

        @Override
        public List<String> getValues(EntryImpl entry) {
            return entry.getNote();
        }
    }

    private static interface StringListGetter {
        public List<String> getValues(EntryImpl var1);
    }

    static class OrderGetter
    implements EntryFieldGetter {
        OrderGetter() {
        }

        @Override
        public List<String> getValues(EntryImpl entry) {
            ArrayList<String> list = new ArrayList<String>(1);
            if (entry.getOrder() != null) {
                list.add(String.valueOf(entry.getOrder()));
            }
            return list;
        }
    }

    static class VariantGetter
    implements StringListGetter {
        VariantGetter() {
        }

        @Override
        public List<String> getValues(EntryImpl entry) {
            return entry.getVariant();
        }
    }

    static class PhoneticGetter
    implements EntryFieldGetter {
        int nr = -1;
        String lang = null;

        public PhoneticGetter(String subQuery) {
            if (subQuery == null || subQuery.isEmpty()) {
                this.lang = "*";
            }
            if (subQuery.startsWith("/") && (subQuery = subQuery.substring(1)).isEmpty()) {
                this.lang = "*";
            }
            if (this.lang != null) {
                return;
            }
            String[] parts = subQuery.split("/");
            if (parts.length >= 1) {
                try {
                    this.nr = Integer.parseInt(parts[0]) - 1;
                }
                catch (NumberFormatException ex) {
                    this.lang = parts[0];
                }
            }
            if (parts.length == 2) {
                this.lang = parts[1];
            }
        }

        @Override
        public List<String> getValues(EntryImpl entry) {
            ArrayList<String> list;
            block5: {
                block3: {
                    TextLang ph;
                    block4: {
                        if (entry.getPhonetic().isEmpty()) {
                            return List.of();
                        }
                        list = new ArrayList<String>(entry.getPhonetic().size());
                        if (this.nr < 0 || this.nr >= entry.getPhonetic().size()) break block3;
                        ph = entry.getPhonetic().get(this.nr);
                        if (this.lang != null && !"*".equals(this.lang)) break block4;
                        list.add(ph.getValue());
                        break block5;
                    }
                    if (!this.lang.equals(ph.getLang())) break block5;
                    list.add(ph.getValue());
                    break block5;
                }
                for (TextLang textLang : entry.getPhonetic()) {
                    if (this.lang == null || "*".equals(this.lang)) {
                        list.add(textLang.getValue());
                        continue;
                    }
                    if (!this.lang.equals(textLang.getLang())) continue;
                    list.add(textLang.getValue());
                }
            }
            return list;
        }
    }
}

