/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.impl.SenseImpl;
import nl.mpi.lexiconcomponent.model.CustomField;
import nl.mpi.lexiconcomponent.model.Example;
import nl.mpi.lexiconcomponent.model.TextLang;
import nl.mpi.lexiconcomponent.query.EntryFieldGetter;
import nl.mpi.lexiconcomponent.query.EntryFieldGetterFactory;
import nl.mpi.lexiconcomponent.query.SenseFieldGetter;

public class SenseFieldGetterFactory {
    public static final EmptyGetter EMPTY_GETTER = new EmptyGetter();

    public static <T> IGetterFromList<T> getterFromList(String subquery) {
        if (subquery.startsWith("/")) {
            subquery = subquery.substring(1);
        }
        if (subquery.isEmpty() || subquery.equals("*")) {
            return new WholeList();
        }
        int nr = Integer.parseInt(subquery) - 1;
        return new GetNFromList(nr);
    }

    static SenseFieldGetter getterFromTextLangList(TextLangListGetter listGetter, String subQuery) {
        if (subQuery.startsWith("/")) {
            subQuery = subQuery.substring(1);
        }
        if (subQuery.isEmpty()) {
            subQuery = "*";
            return new GetterFromTextLangListGetter(listGetter, new LangGetterFromTextLangList(subQuery));
        }
        int num = -1;
        String lang = null;
        String[] parts = subQuery.split("/");
        if (parts.length >= 1) {
            try {
                num = Integer.parseInt(parts[0]) - 1;
            }
            catch (NumberFormatException ex) {
                lang = parts[0];
            }
        }
        if (parts.length == 2) {
            lang = parts[1];
        }
        if (num > -1) {
            if (lang != null) {
                return new GetterFromTextLangListGetter(listGetter, new IntLangGetterFromTextLangList(num, lang));
            }
            return new GetterFromTextLangListGetter(listGetter, new IntGetterFromTextLangList(num));
        }
        if (lang != null) {
            return new GetterFromTextLangListGetter(listGetter, new LangGetterFromTextLangList(lang));
        }
        return new GetterFromTextLangListGetter(listGetter, new LangGetterFromTextLangList(subQuery));
    }

    static SenseFieldGetter getterFromExamples(String subQuery) {
        String[] parts;
        if (subQuery.startsWith("/")) {
            subQuery = subQuery.substring(1);
        }
        if ((parts = subQuery.split("/")).length == 3) {
            int nr = parts[0].equals("*") ? -1 : Integer.parseInt(parts[0]) - 1;
            String field = parts[1];
            String lang = parts[2];
            if (field.equals("text")) {
                return new ExampleTextGetter(nr, lang);
            }
            if (field.equals("translation")) {
                return new ExampleTranslationGetter(nr, new LangGetterFromTextLangList(lang));
            }
        }
        return EMPTY_GETTER;
    }

    private static SenseFieldGetter parentFieldGetter(String fieldName, boolean includeCustomFields) {
        EntryFieldGetter getter = EntryFieldGetterFactory.createGetter(fieldName, includeCustomFields);
        if (getter == EntryFieldGetterFactory.EMPTY_GETTER) {
            return EMPTY_GETTER;
        }
        return new ParentFieldGetter(getter);
    }

    public static SenseFieldGetter createGetter(String fieldName, boolean includeCustomFields, boolean includeParentFields) {
        if (fieldName == null || fieldName.isEmpty() || fieldName.equals("-")) {
            return EMPTY_GETTER;
        }
        try {
            SenseFieldGetter parentGetter;
            if (fieldName.startsWith("comment")) {
                return new GetterFromStringListGetter(new CommentGetter(), SenseFieldGetterFactory.getterFromList(fieldName.substring(7)));
            }
            if (fieldName.startsWith("custom/")) {
                return new GetterFromCustomFieldList(fieldName.substring(7), includeParentFields);
            }
            if (fieldName.startsWith("definition")) {
                return SenseFieldGetterFactory.getterFromTextLangList(new DefinitionGetter(), fieldName.substring(10));
            }
            if (fieldName.startsWith("example")) {
                return SenseFieldGetterFactory.getterFromExamples(fieldName.substring(7));
            }
            if (fieldName.startsWith("gloss")) {
                return SenseFieldGetterFactory.getterFromTextLangList(new GlossGetter(), fieldName.substring(5));
            }
            if (fieldName.startsWith("grammatical-category")) {
                return new GrammaticalCategoryGetter();
            }
            if (fieldName.startsWith("id")) {
                return new IdGetter();
            }
            if (fieldName.startsWith("internal-note")) {
                return new GetterFromStringListGetter(new InternalNoteGetter(), SenseFieldGetterFactory.getterFromList(fieldName.substring(13)));
            }
            if (fieldName.startsWith("order")) {
                return new OrderGetter();
            }
            if (fieldName.startsWith("entry/")) {
                return SenseFieldGetterFactory.parentFieldGetter(fieldName.substring(6), includeCustomFields);
            }
            if (includeParentFields && (parentGetter = SenseFieldGetterFactory.parentFieldGetter(fieldName, false)) != EMPTY_GETTER) {
                return parentGetter;
            }
            if (includeCustomFields) {
                if (fieldName.startsWith(LexiconFields.SENSE_FIELD.getFieldName())) {
                    return new GetterFromCustomFieldList(fieldName.substring(LexiconFields.SENSE_FIELD.getFieldName().length() + 1), false);
                }
                return new GetterFromCustomFieldList(fieldName, includeParentFields);
            }
        }
        catch (Exception ex) {
            return EMPTY_GETTER;
        }
        return EMPTY_GETTER;
    }

    public static SenseFieldGetter createGetter(String fieldName) {
        return SenseFieldGetterFactory.createGetter(fieldName, true, false);
    }

    static class WholeList<T>
    implements IGetterFromList<T> {
        WholeList() {
        }

        @Override
        public List<T> getValues(List<T> list) {
            return list;
        }
    }

    static class GetNFromList<T>
    implements IGetterFromList<T> {
        int nr;

        public GetNFromList(int nr) {
            this.nr = nr;
        }

        @Override
        public List<T> getValues(List<T> list) {
            ArrayList<T> result = new ArrayList<T>(1);
            if (this.nr >= 0 && this.nr < list.size()) {
                result.add(list.get(this.nr));
            }
            return result;
        }
    }

    static class GetterFromTextLangListGetter
    implements SenseFieldGetter {
        TextLangListGetter listGetter;
        IGetterFromTextLangList nr;

        public GetterFromTextLangListGetter(TextLangListGetter listGetter, IGetterFromTextLangList nr) {
            this.listGetter = listGetter;
            this.nr = nr;
        }

        @Override
        public List<String> getValues(SenseImpl sense) {
            List<? extends TextLang> list = this.listGetter.getValues(sense);
            return this.nr.getValues(list);
        }
    }

    static class LangGetterFromTextLangList
    implements IGetterFromTextLangList {
        String lang;

        public LangGetterFromTextLangList(String lang) {
            this.lang = lang;
        }

        @Override
        public List<String> getValues(List<? extends TextLang> list) {
            ArrayList<String> result = new ArrayList<String>(1);
            boolean wildcard = this.lang.equals("*");
            for (TextLang textLang : list) {
                if (wildcard && textLang.getValue() != null && !textLang.getValue().isEmpty()) {
                    result.add(textLang.getValue());
                    continue;
                }
                if (!this.lang.equals(textLang.getLang()) || textLang.getValue() == null) continue;
                result.add(textLang.getValue());
            }
            return result;
        }
    }

    private static interface TextLangListGetter {
        public List<? extends TextLang> getValues(SenseImpl var1);
    }

    static interface IGetterFromTextLangList {
        public List<String> getValues(List<? extends TextLang> var1);
    }

    static class IntLangGetterFromTextLangList
    implements IGetterFromTextLangList {
        int nr;
        String lang;

        public IntLangGetterFromTextLangList(int nr, String lang) {
            this.nr = nr;
            this.lang = lang;
        }

        @Override
        public List<String> getValues(List<? extends TextLang> list) {
            TextLang tl;
            ArrayList<String> result = new ArrayList<String>(1);
            if (this.nr >= 0 && this.nr < list.size() && (tl = list.get(this.nr)).getValue() != null && !tl.getValue().isEmpty()) {
                if ("*".equals(this.lang)) {
                    result.add(tl.getValue());
                } else if (this.lang.equals(tl.getLang())) {
                    result.add(tl.getValue());
                }
            }
            return result;
        }
    }

    static class IntGetterFromTextLangList
    implements IGetterFromTextLangList {
        int nr;

        public IntGetterFromTextLangList(int nr) {
            this.nr = nr;
        }

        @Override
        public List<String> getValues(List<? extends TextLang> list) {
            ArrayList<String> result = new ArrayList<String>(1);
            if (this.nr >= 0 && this.nr < list.size()) {
                result.add(list.get(this.nr).getValue());
            }
            return result;
        }
    }

    static class ExampleTextGetter
    implements SenseFieldGetter {
        private int nr;
        String lang;

        ExampleTextGetter(int nr, String lang) {
            this.nr = nr;
            this.lang = lang;
        }

        @Override
        public List<String> getValues(SenseImpl sense) {
            List<Example> examples = sense.getExample();
            ArrayList<String> result = new ArrayList<String>(1);
            int nr = Math.min(this.nr, examples.size() - 1);
            int i = -1;
            for (Example e : examples) {
                String v;
                if (++i != nr && nr >= 0) continue;
                TextLang text = e.getText();
                if (!this.lang.equals("*") && !text.getLang().equals(this.lang) || (v = text.getValue()).isEmpty()) continue;
                result.add(v);
            }
            return result;
        }
    }

    static class ExampleTranslationGetter
    implements SenseFieldGetter {
        private int nr;
        IGetterFromTextLangList lang;

        ExampleTranslationGetter(int nr, IGetterFromTextLangList lang) {
            this.nr = nr;
            this.lang = lang;
        }

        @Override
        public List<String> getValues(SenseImpl sense) {
            List<Example> examples = sense.getExample();
            ArrayList<String> result = new ArrayList<String>(1);
            int nr = Math.min(this.nr, examples.size() - 1);
            int i = -1;
            for (Example e : examples) {
                if (++i != nr && nr >= 0) continue;
                List<TextLang> translations = e.getTranslation();
                result.addAll(this.lang.getValues(translations));
            }
            return result;
        }
    }

    static class EmptyGetter
    implements SenseFieldGetter {
        EmptyGetter() {
        }

        @Override
        public List<String> getValues(SenseImpl sense) {
            return Collections.emptyList();
        }
    }

    static class ParentFieldGetter
    implements SenseFieldGetter {
        EntryFieldGetter parentGetter;

        ParentFieldGetter(EntryFieldGetter parentGetter) {
            this.parentGetter = parentGetter;
        }

        @Override
        public List<String> getValues(SenseImpl sense) {
            return this.parentGetter.getValues(sense.getEntry());
        }
    }

    static class GetterFromStringListGetter
    implements SenseFieldGetter {
        StringListGetter fieldGetter;
        IGetterFromList<String> nr;

        public GetterFromStringListGetter(StringListGetter fieldGetter, IGetterFromList<String> subQuery) {
            this.fieldGetter = fieldGetter;
            this.nr = subQuery;
        }

        @Override
        public List<String> getValues(SenseImpl sense) {
            List<String> list = this.fieldGetter.getValues(sense);
            return this.nr.getValues(list);
        }
    }

    static class CommentGetter
    implements StringListGetter {
        CommentGetter() {
        }

        @Override
        public List<String> getValues(SenseImpl sense) {
            return sense.getComment();
        }
    }

    public static interface IGetterFromList<T> {
        public List<T> getValues(List<T> var1);
    }

    private static interface StringListGetter {
        public List<String> getValues(SenseImpl var1);
    }

    static class GetterFromCustomFieldList
    extends BGetterFromCustomFieldList
    implements SenseFieldGetter {
        private boolean includeParentFields;

        GetterFromCustomFieldList(String subQuery, boolean includeParentFields) {
            this.parts = subQuery.split("/");
            this.includeParentFields = includeParentFields;
        }

        @Override
        public List<String> getValues(SenseImpl sense) {
            ArrayList<String> result = new ArrayList<String>(1);
            List<CustomField> fields = sense.getField();
            this.getValues(result, fields);
            if (this.includeParentFields) {
                fields = sense.getEntry().getField();
                this.getValues(result, fields);
            }
            return result;
        }
    }

    static class DefinitionGetter
    implements TextLangListGetter {
        DefinitionGetter() {
        }

        @Override
        public List<? extends TextLang> getValues(SenseImpl sense) {
            return sense.getDefinition();
        }
    }

    static class GlossGetter
    implements TextLangListGetter {
        GlossGetter() {
        }

        @Override
        public List<? extends TextLang> getValues(SenseImpl sense) {
            return sense.getGloss();
        }
    }

    static class GrammaticalCategoryGetter
    implements SenseFieldGetter {
        GrammaticalCategoryGetter() {
        }

        @Override
        public List<String> getValues(SenseImpl sense) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(sense.getGrammaticalCategory());
            return list;
        }
    }

    static class IdGetter
    implements SenseFieldGetter {
        IdGetter() {
        }

        @Override
        public List<String> getValues(SenseImpl sense) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(sense.getId());
            return list;
        }
    }

    static class InternalNoteGetter
    implements StringListGetter {
        InternalNoteGetter() {
        }

        @Override
        public List<String> getValues(SenseImpl sense) {
            return sense.getInternalNote();
        }
    }

    static class OrderGetter
    implements SenseFieldGetter {
        OrderGetter() {
        }

        @Override
        public List<String> getValues(SenseImpl sense) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(String.valueOf(sense.getOrder()));
            return list;
        }
    }

    static class BGetterFromCustomFieldList {
        protected String[] parts;

        BGetterFromCustomFieldList() {
        }

        protected void getValues(Collection<String> result, List<CustomField> fields) {
            for (CustomField f : fields) {
                if (!this.parts[0].equals(f.getName()) || this.parts.length > 1 && !this.parts[1].equals(f.getLang())) continue;
                result.add(f.getValue());
            }
        }
    }

    static class CustomFieldListGetter {
        CustomFieldListGetter() {
        }

        public List<CustomField> getValues(SenseImpl sense) {
            return sense.getField();
        }
    }
}

