/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.util;

import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.mpi.lexiconcomponent.util.LexiconLogger;

public class CollatorUtil {
    private final Pattern punctPattern = Pattern.compile("[\\p{Punct}]");
    private char affixMarker = (char)45;
    private boolean ignoreAffixMarker = true;
    private boolean affixFollowsPrimary = false;

    public CollatorUtil() {
    }

    public CollatorUtil(char affixMarker, boolean ignoreAffixMarker) {
        this();
        this.affixMarker = affixMarker;
        this.ignoreAffixMarker = ignoreAffixMarker;
    }

    public CollatorUtil(char affixMarker, boolean ignoreAffixMarker, boolean affixFollowsPrimary) {
        this();
        this.affixMarker = affixMarker;
        this.ignoreAffixMarker = ignoreAffixMarker;
        this.affixFollowsPrimary = affixFollowsPrimary;
    }

    public RuleBasedCollator createCollator(String spaceSeparatedCharSequences) throws ParseException {
        if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
            LexiconLogger.LEXLOG.fine(String.format("Creating collator for sort order; %s", spaceSeparatedCharSequences));
        }
        if (spaceSeparatedCharSequences == null || spaceSeparatedCharSequences.isEmpty()) {
            return null;
        }
        String[] tokens = spaceSeparatedCharSequences.split("\\s");
        String affixString = String.valueOf(this.affixMarker);
        for (String s : tokens) {
            if (!s.startsWith(affixString) && !s.endsWith(affixString)) continue;
            this.ignoreAffixMarker = false;
        }
        StringBuilder ruleBuilder = new StringBuilder();
        if (this.ignoreAffixMarker) {
            ruleBuilder.append(',');
            if (this.punctPattern.matcher(String.valueOf(this.affixMarker)).find()) {
                ruleBuilder.append('\'');
                ruleBuilder.append(this.affixMarker);
                ruleBuilder.append('\'');
            } else {
                ruleBuilder.append(this.affixMarker);
            }
        }
        for (int i = 0; i < tokens.length; ++i) {
            if (i == 0) {
                ruleBuilder.append("<");
                ruleBuilder.append(this.escapeSpecials(tokens[i]));
                continue;
            }
            if (tokens[i - 1].equalsIgnoreCase(tokens[i])) {
                ruleBuilder.append(",");
            } else {
                ruleBuilder.append("<");
            }
            ruleBuilder.append(this.escapeSpecials(tokens[i]));
        }
        return new RuleBasedCollator(ruleBuilder.toString());
    }

    private String escapeSpecials(String input) {
        Matcher m = this.punctPattern.matcher(input);
        if (m.find()) {
            StringBuilder sb = new StringBuilder();
            m.reset();
            int lastEnd = 0;
            while (m.find()) {
                int start = m.start();
                int nextEnd = m.end();
                if (start > lastEnd) {
                    sb.append(input.substring(lastEnd, start));
                }
                for (int i = start; i < nextEnd; ++i) {
                    sb.append('\'');
                    sb.append(input.charAt(i));
                    sb.append('\'');
                }
                lastEnd = nextEnd;
            }
            if (lastEnd < input.length()) {
                sb.append(input.substring(lastEnd));
            }
            return sb.toString();
        }
        return input;
    }
}

