/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.util;

import java.text.RuleBasedCollator;
import java.util.Comparator;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.model.Entry;

public class EntryComparator<T extends Entry>
implements Comparator<T> {
    private LexiconFields fieldToCompare;
    private RuleBasedCollator customCollator = null;

    public EntryComparator() {
        this.fieldToCompare = LexiconFields.ENTRY_LEX_UNIT;
    }

    public EntryComparator(LexiconFields fieldToCompare) {
        this.fieldToCompare = fieldToCompare;
    }

    public EntryComparator(RuleBasedCollator customCollator) {
        this.fieldToCompare = LexiconFields.ENTRY_LEX_UNIT;
        this.customCollator = customCollator;
    }

    public EntryComparator(LexiconFields fieldToCompare, RuleBasedCollator customCollator) {
        this.fieldToCompare = fieldToCompare;
        this.customCollator = customCollator;
    }

    public LexiconFields getFieldToCompare() {
        return this.fieldToCompare;
    }

    public void setFieldToCompare(LexiconFields fieldToCompare) {
        this.fieldToCompare = fieldToCompare;
    }

    public void setCustomCollator(RuleBasedCollator customCollator) {
        this.customCollator = customCollator;
    }

    public RuleBasedCollator getCustomCollator() {
        return this.customCollator;
    }

    @Override
    public int compare(T o1, T o2) {
        String s1 = "";
        String s2 = "";
        switch (this.fieldToCompare) {
            case ENTRY_CITATION: {
                s1 = this.nonNull(((Entry)o1).getCitation());
                s2 = this.nonNull(((Entry)o2).getCitation());
                break;
            }
            case ENTRY_VARIANT: {
                if (((Entry)o1).getVariant().size() > 0) {
                    s1 = this.nonNull(((Entry)o1).getVariant().get(0));
                }
                if (((Entry)o2).getVariant().size() <= 0) break;
                s2 = this.nonNull(((Entry)o2).getVariant().get(0));
                break;
            }
            default: {
                s1 = ((Entry)o1).getLexicalUnit();
                s2 = ((Entry)o2).getLexicalUnit();
            }
        }
        int c = 0;
        c = this.customCollator != null ? this.customCollator.compare(s1, s2) : s1.compareTo(s2);
        if (c == 0) {
            if (((Entry)o1).getOrder() != null) {
                if (((Entry)o2).getOrder() != null) {
                    return ((Entry)o1).getOrder().compareTo(((Entry)o2).getOrder());
                }
                return -1;
            }
            if (((Entry)o2).getOrder() != null) {
                return 1;
            }
            return c;
        }
        return c;
    }

    private String nonNull(String s) {
        return s != null ? s : "";
    }
}

