/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nl.mpi.lexiconcomponent.util.LexiconLogger;

public class LexiconConverter {
    public void convertFromLiftToLexiconComponent(URL liftInputURL, URL lexCompOutputURL) throws TransformerException {
        URL xslFile;
        if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
            LexiconLogger.LEXLOG.info("Start url based transformation of a Lift lexicon to LexiconComponent format.");
        }
        if ((xslFile = this.getClass().getResource("/nl/mpi/lexiconcomponent/transform/lift_to_elanlexicon.xsl")) == null) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning("The XSL transform file 'lift_to_elanlexicon.xsl' could not be found.");
            }
            throw new TransformerException("The XSL transformation file ('lift_to_elanlexicon.xsl') could not be found");
        }
        this.transformLexicon(xslFile, liftInputURL, lexCompOutputURL);
        if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
            LexiconLogger.LEXLOG.info("The Lift file was successfully converted");
        }
    }

    public void convertFromLiftToLexiconComponent(File liftInputFile, File lexCompOutputFile) throws TransformerException {
        URL xslFile;
        if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
            LexiconLogger.LEXLOG.info("Start file based transformation of a Lift lexicon to LexiconComponent format.");
        }
        if ((xslFile = this.getClass().getResource("/nl/mpi/lexiconcomponent/transform/lift_to_elanlexicon.xsl")) == null) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning("The XSL transform file 'lift_to_elanlexicon.xsl' could not be found.");
            }
            throw new TransformerException("The XSL transformation file ('lift_to_elanlexicon.xsl') could not be found");
        }
        this.transformLexicon(xslFile, liftInputFile, lexCompOutputFile);
        if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
            LexiconLogger.LEXLOG.info("The Lift file was successfully converted");
        }
    }

    public void convertFromLexiconComponentToLift(URL lexCompInputURL, URL liftOutputURL) throws TransformerException {
        URL xslFile;
        if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
            LexiconLogger.LEXLOG.info("Start transformation of a LexiconComponent lexicon to Lift format.");
        }
        if ((xslFile = this.getClass().getResource("/nl/mpi/lexiconcomponent/transform/elanlexicon_to_lift.xsl")) == null) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning("The XSL transform file 'elanlexicon_to_lift.xsl' could not be found.");
            }
            new TransformerException("The XSL file 'elanlexicon_to_lift.xsl' could not be found.");
        }
        this.transformLexicon(xslFile, lexCompInputURL, liftOutputURL);
        if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
            LexiconLogger.LEXLOG.info("The LexiconComponent file was successfully converted to Lift");
        }
    }

    public void convertFromLexiconComponentToLift(File lexCompInputFile, File liftOutputFile) throws TransformerException {
        URL xslFile;
        if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
            LexiconLogger.LEXLOG.info("Start transformation of a LexiconComponent lexicon to Lift format.");
        }
        if ((xslFile = this.getClass().getResource("/nl/mpi/lexiconcomponent/transform/elanlexicon_to_lift.xsl")) == null) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning("The XSL transform file 'elanlexicon_to_lift.xsl' could not be found.");
            }
            new TransformerException("The XSL file 'elanlexicon_to_lift.xsl' could not be found.");
        }
        this.transformLexicon(xslFile, lexCompInputFile, liftOutputFile);
        if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
            LexiconLogger.LEXLOG.info("The LexiconComponent file was successfully converted to Lift");
        }
    }

    public void convertFromCorpafroasToLexiconComponent(URL corpaInputURL, URL lexCompOutputURL) throws TransformerException {
        URL xslFile;
        if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
            LexiconLogger.LEXLOG.info("Start transformation of a CorpAfroAs lexicon to LexiconComponent format.");
        }
        if ((xslFile = this.getClass().getResource("/nl/mpi/lexiconcomponent/transform/corpafroas_to_elanlexicon.xsl")) == null) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning("The XSL transform file 'corpafroas_to_elanlexicon.xsl' could not be found.");
            }
            new TransformerException("The XSL file 'corpafroas_to_elanlexicon.xsl' could not be found.");
        }
        this.transformLexicon(xslFile, corpaInputURL, lexCompOutputURL);
        if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
            LexiconLogger.LEXLOG.info("The CorpAfroAs file was successfully converted to LexiconComponent format");
        }
    }

    public void convertFromCorpafroasToLexiconComponent(File corpaInputFile, File lexCompOutputFile) throws TransformerException {
        URL xslFile;
        if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
            LexiconLogger.LEXLOG.info("Start transformation of a CorpAfroAs lexicon to LexiconComponent format.");
        }
        if ((xslFile = this.getClass().getResource("/nl/mpi/lexiconcomponent/transform/corpafroas_to_elanlexicon.xsl")) == null) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning("The XSL transform file 'corpafroas_to_elanlexicon.xsl' could not be found.");
            }
            new TransformerException("The XSL file 'corpafroas_to_elanlexicon.xsl' could not be found.");
        }
        this.transformLexicon(xslFile, corpaInputFile, lexCompOutputFile);
        if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
            LexiconLogger.LEXLOG.info("The CorpAfroAs file was successfully converted to LexiconComponent format");
        }
    }

    protected void transformLexicon(URL xslFile, URL inputLexiconURL, URL outputLexiconURL) throws TransformerException {
        if (inputLexiconURL == null) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning("The URL of the source lexicon file is null");
            }
            throw new TransformerException("The URL of the source lexicon file is null");
        }
        if (outputLexiconURL == null) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning("The URL for the result lexicon file is null");
            }
            throw new TransformerException("The URL for the result lexicon file is null");
        }
        try {
            StreamSource source = new StreamSource(inputLexiconURL.openStream());
            StreamResult result = new StreamResult(outputLexiconURL.toExternalForm());
            this.transformLexicon(xslFile, source, result);
        }
        catch (IOException ioe) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning(String.format("Could not transform the file. Stylesheet: %s, Input: %s, Output: %s. Error: %s", xslFile.getPath(), inputLexiconURL.getPath(), outputLexiconURL.getPath(), ioe.getMessage()));
            }
            throw new TransformerException(ioe);
        }
    }

    protected void transformLexicon(URL xslFile, File inputLexiconFile, File outputLexiconFile) throws TransformerException {
        if (inputLexiconFile == null) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning("The source lexicon file is null");
            }
            throw new TransformerException("The source lexicon file is null");
        }
        if (outputLexiconFile == null) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning("The file for the result lexicon is null");
            }
            throw new TransformerException("The file for the result lexicon is null");
        }
        try {
            StreamSource source = new StreamSource(new InputStreamReader((InputStream)new FileInputStream(inputLexiconFile), "UTF-8"));
            StreamResult result = new StreamResult(new OutputStreamWriter((OutputStream)new FileOutputStream(outputLexiconFile), "UTF-8"));
            this.transformLexicon(xslFile, source, result);
        }
        catch (FileNotFoundException fnfe) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning(String.format("Could not transform the file. Stylesheet: %s, Input: %s, Output: %s. Error: %s", xslFile.getPath(), inputLexiconFile.getPath(), outputLexiconFile.getPath(), fnfe.getMessage()));
            }
            throw new TransformerException(fnfe);
        }
        catch (UnsupportedEncodingException uee) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                LexiconLogger.LEXLOG.warning(String.format("Could not transform the file. Stylesheet: %s, Input: %s, Output: %s. Error: %s", xslFile.getPath(), inputLexiconFile.getPath(), outputLexiconFile.getPath(), uee.getMessage()));
            }
            throw new TransformerException(uee);
        }
    }

    protected void transformLexicon(URL xslFile, StreamSource inputLexiconSource, StreamResult outputLexiconResult) throws TransformerException {
        try {
            Transformer transformer = null;
            TransformerFactory factory = null;
            try {
                Class<?> saxfactClass = Class.forName("net.sf.saxon.TransformerFactoryImpl");
                factory = (TransformerFactory)saxfactClass.newInstance();
            }
            catch (Throwable t) {
                if (LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) {
                    LexiconLogger.LEXLOG.warning("Could not instantiate a Saxon TransformerFactory (supporting XSLT 2.0)");
                }
                factory = TransformerFactory.newInstance();
            }
            transformer = factory.newTransformer(new StreamSource(xslFile.openStream()));
            transformer.transform(inputLexiconSource, outputLexiconResult);
        }
        catch (TransformerConfigurationException tce) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.SEVERE)) {
                LexiconLogger.LEXLOG.severe(String.format("Could not transform the file. Stylesheet: %s, Input: %s, Output: %s. Error: %s", xslFile.getPath(), inputLexiconSource.toString(), outputLexiconResult.toString(), tce.getMessage()));
            }
            throw tce;
        }
        catch (TransformerException te) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.SEVERE)) {
                LexiconLogger.LEXLOG.severe(String.format("Could not transform the file. Stylesheet: %s, Input: %s, Output: %s. Error: %s", xslFile.getPath(), inputLexiconSource.toString(), outputLexiconResult.toString(), te.getMessage()));
            }
            throw te;
        }
        catch (IOException ioe) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.SEVERE)) {
                LexiconLogger.LEXLOG.severe(String.format("Could not transform the file. Stylesheet: %s, Input: %s, Output: %s. Error: %s", xslFile.getPath(), inputLexiconSource.toString(), outputLexiconResult.toString(), ioe.getMessage()));
            }
            throw new TransformerException(ioe);
        }
        catch (Throwable t) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.SEVERE)) {
                LexiconLogger.LEXLOG.severe("Lexicon transformation failed: " + t.getMessage());
            }
            throw new TransformerException(t);
        }
    }
}

