/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.util.toolbox;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nl.mpi.lexiconcomponent.gui.LexiconFieldsRenderer;
import nl.mpi.lexiconcomponent.gui.LexiconGuiResources;
import nl.mpi.lexiconcomponent.impl.LexiconFieldUtil;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.util.FieldMultiplicity;
import nl.mpi.lexiconcomponent.util.toolbox.ToolboxDictDecodeInfo;
import nl.mpi.lexiconcomponent.util.toolbox.ToolboxDictScanner;
import nl.mpi.lexiconcomponent.util.toolbox.ToolboxImportTableModel;

public class ImportToolboxDictDialog
extends JDialog {
    private JPanel filePanel;
    private JTextField toolboxFileTF;
    private JTextField lexiconTitleTF;
    private JButton selectFileButton;
    private JPanel optionsPanel;
    private JLabel infoLabel;
    private JTable fieldTable;
    private ToolboxImportTableModel fieldModel;
    private boolean tableInited = false;
    private boolean useRawFieldNames = false;
    private JCheckBox rawFieldNamesCB;
    private JCheckBox splitValuesCB;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private ActionListener buttonListener;
    private File tbDictFile;
    private String[] lexFieldNames;
    private String[] rawLexFieldNames;
    private ToolboxDictDecodeInfo decodeInfo;

    public ImportToolboxDictDialog(Frame owner) {
        super(owner);
        this.initComponents();
        this.postInit();
    }

    public ImportToolboxDictDialog(Window owner) {
        super(owner);
        this.initComponents();
        this.postInit();
    }

    public ImportToolboxDictDialog(Frame owner, File tbDictFile) {
        super(owner);
        this.tbDictFile = tbDictFile;
        this.initComponents();
        this.postInit();
    }

    public ImportToolboxDictDialog(Window owner, File tbDictFile) {
        super(owner);
        this.tbDictFile = tbDictFile;
        this.initComponents();
        this.postInit();
    }

    public ToolboxDictDecodeInfo getValue() {
        return this.decodeInfo;
    }

    private void postInit() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(2);
    }

    private void initComponents() {
        this.setTitle(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.ToolboxTitle", "Import Toolbox Dictionary"));
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.filePanel = new JPanel(new GridBagLayout());
        this.filePanel.setBorder(new TitledBorder(""));
        this.toolboxFileTF = new JTextField("", 20);
        this.toolboxFileTF.setEditable(false);
        this.lexiconTitleTF = new JTextField("", 20);
        this.selectFileButton = new JButton("...");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = insets;
        this.filePanel.add((Component)new JLabel(LexiconGuiResources.getLocalizedString("LexiconComponent.ToolboxDictFile", "Toolbox Dictionary File")), gbc);
        gbc.gridy = 1;
        this.filePanel.add((Component)new JLabel(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Name", "Lexicon Name")), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.filePanel.add((Component)this.toolboxFileTF, gbc);
        gbc.gridy = 1;
        this.filePanel.add((Component)this.lexiconTitleTF, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.filePanel.add((Component)this.selectFileButton, gbc);
        this.optionsPanel = new JPanel(new GridBagLayout());
        this.optionsPanel.setBorder(new TitledBorder(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.Options", "Import Options")));
        this.infoLabel = new JLabel(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.MarkerMapping", "Specify mappings from Toolbox markers to ELAN lexicon entry fields"));
        this.rawFieldNamesCB = new JCheckBox(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.ShowRawNames", "Show raw field names in table"), this.useRawFieldNames);
        this.fieldModel = new ToolboxImportTableModel();
        this.fieldTable = new JTable(this.fieldModel);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 6, 6, 6);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.optionsPanel.add((Component)this.infoLabel, gbc);
        gbc.gridy = 1;
        this.optionsPanel.add((Component)this.rawFieldNamesCB, gbc);
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JScrollPane scrollPane = new JScrollPane(this.fieldTable);
        scrollPane.setPreferredSize(new Dimension(400, 200));
        this.optionsPanel.add((Component)scrollPane, gbc);
        this.splitValuesCB = new JCheckBox(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.SplitMultipleValues", "Split semicolon separated fields into multiple fields"));
        gbc.gridy = 3;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(6, 6, 2, 6);
        this.optionsPanel.add((Component)this.splitValuesCB, gbc);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.okButton = new JButton(LexiconGuiResources.getLocalizedString("Button.OK", "OK"));
        this.cancelButton = new JButton(LexiconGuiResources.getLocalizedString("Button.Cancel", "Cancel"));
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.filePanel, gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.optionsPanel, gbc);
        gbc.gridy = 2;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        if (this.tbDictFile != null) {
            this.toolboxFileTF.setText(this.tbDictFile.getAbsolutePath());
            this.selectFileButton.setVisible(false);
        }
        this.okButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.buttonListener = new ButtonActionListener();
        this.okButton.addActionListener(this.buttonListener);
        this.cancelButton.addActionListener(this.buttonListener);
        this.rawFieldNamesCB.addChangeListener(new CheckBoxChangeListener());
    }

    private void initTable() {
        if (this.tableInited) {
            return;
        }
        this.lexFieldNames = new String[]{LexiconFields.ENTRY_LEX_UNIT.getDisplayLabel(), LexiconFields.ENTRY_MORPH_TYPE.getDisplayLabel(), LexiconFields.ENTRY_CITATION.getDisplayLabel(), LexiconFields.ENTRY_VARIANT.getDisplayLabel(), LexiconFields.ENTRY_PHONETIC.getDisplayLabel(), LexiconFields.ENTRY_NOTE.getDisplayLabel(), LexiconFields.ENTRY_FIELD.getDisplayLabel(), LexiconFields.SENSE_GRAM_CAT.getDisplayLabel(), LexiconFields.SENSE_GLOSS.getDisplayLabel(), LexiconFields.SENSE_DEFINITION.getDisplayLabel(), LexiconFields.SENSE_COMMENT.getDisplayLabel(), LexiconFields.SENSE_INT_NOTE.getDisplayLabel(), LexiconFields.SENSE_EXAMPLE.getDisplayLabel(), LexiconFields.SENSE_EXAM_TRANS.getDisplayLabel(), LexiconFields.SENSE_EXAM_SOURCE.getDisplayLabel(), LexiconFields.SENSE_FIELD.getDisplayLabel(), LexiconFields.ENTRY_DATE_CREATED.getDisplayLabel()};
        this.rawLexFieldNames = new String[]{LexiconFields.ENTRY_LEX_UNIT.getFieldName(), LexiconFields.ENTRY_MORPH_TYPE.getFieldName(), LexiconFields.ENTRY_CITATION.getFieldName(), LexiconFields.ENTRY_VARIANT.getFieldName(), LexiconFields.ENTRY_PHONETIC.getFieldName(), LexiconFields.ENTRY_NOTE.getFieldName(), LexiconFields.ENTRY_FIELD.getFieldName(), LexiconFields.SENSE_GRAM_CAT.getFieldName(), LexiconFields.SENSE_GLOSS.getFieldName(), LexiconFields.SENSE_DEFINITION.getFieldName(), LexiconFields.SENSE_COMMENT.getFieldName(), LexiconFields.SENSE_INT_NOTE.getFieldName(), LexiconFields.SENSE_EXAMPLE.getFieldName(), LexiconFields.SENSE_EXAM_TRANS.getFieldName(), LexiconFields.SENSE_EXAM_SOURCE.getFieldName(), LexiconFields.SENSE_FIELD.getFieldName(), LexiconFields.ENTRY_DATE_CREATED.getFieldName()};
        JComboBox<String> fieldComboBox = null;
        fieldComboBox = this.useRawFieldNames ? new JComboBox<String>(this.rawLexFieldNames) : new JComboBox<String>(this.lexFieldNames);
        fieldComboBox.setEditable(true);
        String fieldColumnName = this.fieldModel.getColumnName(1);
        this.fieldTable.getColumn(fieldColumnName).setCellEditor(new DefaultCellEditor(fieldComboBox));
        this.fieldTable.getColumn(this.fieldModel.getColumnName(2)).setCellRenderer(new LexiconFieldsRenderer());
        this.fieldTable.setRowMargin(4);
        int rowHeight = this.fieldTable.getRowHeight();
        this.fieldTable.setRowHeight((int)((float)rowHeight * 1.5f));
        this.tableInited = true;
    }

    private void updateFieldNameDisplay() {
        if (!this.tableInited) {
            return;
        }
        JComboBox<String> fieldComboBox = null;
        fieldComboBox = this.useRawFieldNames ? new JComboBox<String>(this.rawLexFieldNames) : new JComboBox<String>(this.lexFieldNames);
        fieldComboBox.setEditable(true);
        String fieldColumnName = this.fieldModel.getColumnName(1);
        this.fieldTable.getColumn(fieldColumnName).setCellEditor(new DefaultCellEditor(fieldComboBox));
        int fieldCol = 1;
        if (this.useRawFieldNames) {
            block0: for (int i = 0; i < this.fieldModel.getRowCount(); ++i) {
                String curFieldName = (String)this.fieldModel.getValueAt(i, fieldCol);
                if (curFieldName == null || curFieldName.isEmpty()) continue;
                for (int j = 0; j < this.lexFieldNames.length; ++j) {
                    if (!curFieldName.equals(this.lexFieldNames[j])) continue;
                    this.fieldModel.setValueAt(this.rawLexFieldNames[j], i, fieldCol);
                    continue block0;
                }
            }
        } else {
            block2: for (int i = 0; i < this.fieldModel.getRowCount(); ++i) {
                String curFieldName = (String)this.fieldModel.getValueAt(i, fieldCol);
                if (curFieldName == null || curFieldName.isEmpty()) continue;
                for (int j = 0; j < this.rawLexFieldNames.length; ++j) {
                    if (!curFieldName.equals(this.rawLexFieldNames[j])) continue;
                    this.fieldModel.setValueAt(this.lexFieldNames[j], i, fieldCol);
                    continue block2;
                }
            }
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b && this.tbDictFile != null) {
            this.loadMarkersAsync();
        }
        super.setVisible(b);
    }

    private void showMessage(int messageType, String message) {
        JOptionPane.showMessageDialog(this, message, "", messageType, null);
    }

    private boolean validateFields() {
        LexiconFields curField;
        String title = this.lexiconTitleTF.getText().trim();
        if (title == null || title.isEmpty()) {
            this.showMessage(2, LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.Warning.NoName", "A name is required for the imported lexicon"));
            return false;
        }
        int fieldCol = 1;
        int lexUnitCount = 0;
        HashMap<String, Integer> fieldsOccur = new HashMap<String, Integer>();
        for (int i = 0; i < this.fieldModel.getRowCount(); ++i) {
            String curFieldName = (String)this.fieldModel.getValueAt(i, fieldCol);
            if (curFieldName == null || (curFieldName = curFieldName.trim()).isEmpty()) continue;
            Integer curNum = (Integer)fieldsOccur.get(curFieldName);
            if (curNum != null) {
                fieldsOccur.put(curFieldName, curNum + 1);
            } else {
                fieldsOccur.put(curFieldName, 1);
            }
            if (!LexiconFields.ENTRY_LEX_UNIT.getDisplayLabel().equals(curFieldName) && !LexiconFields.ENTRY_LEX_UNIT.getFieldName().equals(curFieldName)) continue;
            ++lexUnitCount;
        }
        if (lexUnitCount != 1) {
            Object message = "Exactly one of the markers (the record marker) has to be set as " + (this.useRawFieldNames ? LexiconFields.ENTRY_LEX_UNIT.getFieldName() : LexiconFields.ENTRY_LEX_UNIT.getDisplayLabel());
            try {
                message = String.format(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.Warning.OneLexicalUnit", "Exactly one of the markers (the record marker) has to be set as %s"), this.useRawFieldNames ? LexiconFields.ENTRY_LEX_UNIT.getFieldName() : LexiconFields.ENTRY_LEX_UNIT.getDisplayLabel());
            }
            catch (IllegalFormatException curFieldName) {
                // empty catch block
            }
            this.showMessage(2, (String)message);
            return false;
        }
        if (this.useRawFieldNames) {
            for (String lfn : this.rawLexFieldNames) {
                if (fieldsOccur.containsKey(lfn) || (curField = LexiconFieldUtil.getLexiconFieldForFieldName(lfn)) == null || FieldMultiplicity.getMultiplicityForField(curField) == FieldMultiplicity.Multiplicity.ZERO_OR_MORE) continue;
                fieldsOccur.put(lfn, 0);
            }
        } else {
            for (String lfn : this.lexFieldNames) {
                if (fieldsOccur.containsKey(lfn) || (curField = LexiconFieldUtil.getLexiconFieldForDisplayLabel(lfn)) == null || FieldMultiplicity.getMultiplicityForField(curField) == FieldMultiplicity.Multiplicity.ZERO_OR_MORE) continue;
                fieldsOccur.put(lfn, 0);
            }
        }
        Iterator fieldIter = fieldsOccur.keySet().iterator();
        StringBuilder sb = new StringBuilder();
        while (fieldIter.hasNext()) {
            String curFieldName = (String)fieldIter.next();
            LexiconFields curField2 = null;
            curField2 = this.useRawFieldNames ? LexiconFieldUtil.getLexiconFieldForFieldName(curFieldName) : LexiconFieldUtil.getLexiconFieldForDisplayLabel(curFieldName);
            if (curField2 == null || curField2 == LexiconFields.ENTRY_LEX_UNIT) continue;
            int numOccur = (Integer)fieldsOccur.get(curFieldName);
            FieldMultiplicity.Multiplicity multi = FieldMultiplicity.getMultiplicityForField(curField2);
            String curMessageFName = curField2.getDisplayLabel();
            if (this.useRawFieldNames) {
                curMessageFName = curField2.getFieldName();
            }
            String m = "";
            switch (multi) {
                case ONE: {
                    if (numOccur == 1) break;
                    try {
                        m = String.format(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.Warning.FieldMulti", "Field \"%s\" selected %d times, should be %s"), curMessageFName, numOccur, String.valueOf(1));
                    }
                    catch (IllegalFormatException illegalFormatException) {
                        // empty catch block
                    }
                    sb.append(m);
                    sb.append("\n");
                    break;
                }
                case ONE_OR_MORE: {
                    if (numOccur != 0) break;
                    m = String.format("Field \"%s\" selected %d times, should be %s", curField2.getDisplayLabel(), numOccur, "1 or more");
                    try {
                        m = String.format(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.Warning.FieldMulti", "Field \"%s\" selected %d times, should be %s"), curMessageFName, numOccur, LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.Warning.FieldOneMore", "1 or more"));
                    }
                    catch (IllegalFormatException illegalFormatException) {
                        // empty catch block
                    }
                    sb.append(m);
                    sb.append("\n");
                    break;
                }
                case ZERO_OR_ONE: {
                    if (numOccur <= 1) break;
                    m = String.format("Field \"%s\" selected %d times, should be %s", curMessageFName, numOccur, "0 or 1");
                    try {
                        m = String.format(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.Warning.FieldMulti", "Field \"%s\" selected %d times, should be %s"), curMessageFName, numOccur, LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.Warning.FieldZeroOne", "0 or 1"));
                    }
                    catch (IllegalFormatException illegalFormatException) {
                        // empty catch block
                    }
                    sb.append(m);
                    sb.append("\n");
                    break;
                }
                case ZERO_OR_MORE: {
                    break;
                }
            }
        }
        if (sb.length() > 0) {
            sb.append("\n");
            sb.append(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.Warning.FieldWrongNumber", "Some fields have been selected too few or too many times."));
            sb.append("\n\n");
            sb.append(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.Warning.Continue", "Continue the import anyway?"));
            int option = JOptionPane.showConfirmDialog(this, sb.toString(), "", 0, 3, null);
            if (option != 0) {
                return false;
            }
        }
        return true;
    }

    private void createDecodeInfo() {
        this.decodeInfo = new ToolboxDictDecodeInfo();
        this.decodeInfo.setLexiconTitle(this.lexiconTitleTF.getText().trim());
        this.decodeInfo.setSplitMultipleValues(this.splitValuesCB.isSelected());
        HashMap<String, String> markToFieldMap = new HashMap<String, String>();
        HashMap<String, String> markToLangMap = new HashMap<String, String>();
        ArrayList<String> markersToImport = new ArrayList<String>();
        int markCol = 0;
        int fieldCol = 1;
        int langCol = 2;
        for (int i = 0; i < this.fieldModel.getRowCount(); ++i) {
            String curFieldName = (String)this.fieldModel.getValueAt(i, fieldCol);
            if (curFieldName == null || (curFieldName = curFieldName.trim()).isEmpty()) continue;
            String curMar = (String)this.fieldModel.getValueAt(i, markCol);
            markToFieldMap.put(curMar, curFieldName);
            if (LexiconFields.ENTRY_LEX_UNIT.getDisplayLabel().equals(curFieldName) || LexiconFields.ENTRY_LEX_UNIT.getFieldName().equals(curFieldName)) {
                markersToImport.add(0, curMar);
            } else {
                markersToImport.add(curMar);
            }
            String curLang = (String)this.fieldModel.getValueAt(i, langCol);
            if (curLang == null || curLang.isEmpty()) continue;
            markToLangMap.put(curMar, curLang);
        }
        this.decodeInfo.setMarkersToImport(markersToImport);
        this.decodeInfo.setMarkerToFieldMap(markToFieldMap);
        this.decodeInfo.setMarkerToLangMap(markToLangMap);
    }

    private void loadMarkersAsync() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    ToolboxDictScanner scanner = new ToolboxDictScanner(ImportToolboxDictDialog.this.tbDictFile);
                    List<String> markerList = scanner.extractFieldMarkersBR();
                    if (markerList.isEmpty()) {
                        ImportToolboxDictDialog.this.showMessage(2, LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.Warning.NoMarkers", "No markers detected, nothing to import."));
                        ImportToolboxDictDialog.this.cancelButton.setEnabled(true);
                        return;
                    }
                    ImportToolboxDictDialog.this.initTable();
                    ImportToolboxDictDialog.this.decodeInfo = null;
                    if (ImportToolboxDictDialog.this.fieldModel.getRowCount() > 0) {
                        ImportToolboxDictDialog.this.fieldModel.clearRowData();
                    }
                    for (int i = 0; i < markerList.size(); ++i) {
                        if (i == 0) {
                            ImportToolboxDictDialog.this.fieldModel.addRow(markerList.get(i), ImportToolboxDictDialog.this.useRawFieldNames ? ImportToolboxDictDialog.this.rawLexFieldNames[0] : ImportToolboxDictDialog.this.lexFieldNames[0], "");
                            continue;
                        }
                        ImportToolboxDictDialog.this.fieldModel.addRow(markerList.get(i), "", "");
                    }
                    ImportToolboxDictDialog.this.okButton.setEnabled(true);
                    ImportToolboxDictDialog.this.cancelButton.setEnabled(true);
                }
                catch (IOException ioe) {
                    ImportToolboxDictDialog.this.showMessage(2, LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.Warning.LoadMarkers", "Loading of markers failed:") + " " + ioe.getMessage());
                }
            }
        });
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ImportToolboxDictDialog.this.okButton) {
                boolean valid = ImportToolboxDictDialog.this.validateFields();
                if (!valid) {
                    ImportToolboxDictDialog.this.decodeInfo = null;
                    return;
                }
                ImportToolboxDictDialog.this.createDecodeInfo();
                ImportToolboxDictDialog.this.dispose();
            } else if (e.getSource() == ImportToolboxDictDialog.this.cancelButton) {
                ImportToolboxDictDialog.this.decodeInfo = null;
                ImportToolboxDictDialog.this.dispose();
            }
        }
    }

    private class CheckBoxChangeListener
    implements ChangeListener {
        private CheckBoxChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == ImportToolboxDictDialog.this.rawFieldNamesCB && ImportToolboxDictDialog.this.useRawFieldNames != ImportToolboxDictDialog.this.rawFieldNamesCB.isSelected()) {
                ImportToolboxDictDialog.this.useRawFieldNames = ImportToolboxDictDialog.this.rawFieldNamesCB.isSelected();
                ImportToolboxDictDialog.this.updateFieldNameDisplay();
            }
        }
    }
}

