/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.util.toolbox;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.xml.datatype.XMLGregorianCalendar;
import nl.mpi.lexiconcomponent.exceptions.LexiconStructureException;
import nl.mpi.lexiconcomponent.gui.LexiconGuiResources;
import nl.mpi.lexiconcomponent.impl.EntryImpl;
import nl.mpi.lexiconcomponent.impl.LexiconContext;
import nl.mpi.lexiconcomponent.impl.LexiconFactory;
import nl.mpi.lexiconcomponent.impl.LexiconFieldUtil;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.impl.LexiconImpl;
import nl.mpi.lexiconcomponent.impl.SenseImpl;
import nl.mpi.lexiconcomponent.model.CustomField;
import nl.mpi.lexiconcomponent.model.Definition;
import nl.mpi.lexiconcomponent.model.Example;
import nl.mpi.lexiconcomponent.model.Gloss;
import nl.mpi.lexiconcomponent.model.Phonetic;
import nl.mpi.lexiconcomponent.model.TextLang;
import nl.mpi.lexiconcomponent.util.LexiconLogger;
import nl.mpi.lexiconcomponent.util.NCNameCheck;
import nl.mpi.lexiconcomponent.util.toolbox.ToolboxDictDecodeInfo;
import nl.mpi.lexiconcomponent.util.toolbox.ToolboxDictScanner;

public class ToolboxConverter {
    private LexiconFactory lexFactory = LexiconContext.getInstance().getLexiconFactory();
    private final String PREF = "prefix";
    private final String SUFF = "suffix";
    private final String STEM = "stem";
    private final String HYPH = "-";

    /*
     * Unable to fully structure code
     */
    public LexiconImpl convertFromToolbox(File toolboxInputFile, ToolboxDictDecodeInfo decoderInfo) throws IOException, LexiconStructureException {
        if (toolboxInputFile == null) {
            throw new IOException(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.Warning.NoToolboxFile", "The Toolbox file is null (does not exist)"));
        }
        if (decoderInfo == null) {
            throw new IOException(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.Warning.NoDecoderFile", "TThe Toolbox decoder information is null (is not provided)"));
        }
        tbReader = new ToolboxDictScanner(toolboxInputFile);
        recordList = tbReader.getRecordsListForFieldsBR(decoderInfo.getMarkersToImport());
        if (recordList == null || recordList.isEmpty()) {
            throw new IOException(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.Warning.NoRecords", "No records could be read from the Toolbox dictionary (the list of records is empty)"));
        }
        lexImpl = (LexiconImpl)this.lexFactory.createLexicon();
        lexImpl.setProducer(LexiconContext.getInstance().PRODUCER);
        lexImpl.setSchemaVersion(LexiconContext.getInstance().SCHEMA_VERSION);
        header = lexImpl.createHeader();
        header.setName(decoderInfo.getLexiconTitle());
        header.setLanguage("und");
        lexImpl.addHeader(header);
        nameChecker = new NCNameCheck();
        markersToFields = decoderInfo.getMarkerToFieldMap();
        enteredFieldToActualField = new HashMap<String, String>(5);
        custEntryFields = new ArrayList<String>();
        custSenseFields = new ArrayList<String>();
        for (String fieldName : markersToFields.values()) {
            lf = this.getLexiconFieldConstant(fieldName);
            if (lf == LexiconFields.ENTRY_FIELD) {
                modName = fieldName;
                if (fieldName.startsWith(LexiconFields.ENTRY.getFieldName()) && (modName = fieldName.substring(LexiconFields.ENTRY.getFieldName().length())).length() > 0 && modName.charAt(0) == '/') {
                    modName = modName.substring(1);
                }
                if (modName.startsWith(LexiconFields.ENTRY_FIELD.getFieldName())) {
                    modName = modName.substring(LexiconFields.ENTRY_FIELD.getFieldName().length());
                }
                if (modName.length() <= 0) continue;
                if (modName.charAt(0) == '/') {
                    modName = modName.substring(1);
                }
                if (modName.isEmpty()) continue;
                modName = nameChecker.convertName(modName);
                existingCustField = custEntryFields.contains(modName);
                enteredFieldToActualField.put(fieldName, modName);
                if (existingCustField) continue;
                lexImpl.addCustomFieldSpec(modName, LexiconFields.ENTRY.getFieldName());
                custEntryFields.add(modName);
                continue;
            }
            if (lf == LexiconFields.SENSE_FIELD) {
                modName = fieldName;
                if (fieldName.startsWith(LexiconFields.SENSE_FIELD.getFieldName())) {
                    modName = fieldName.substring(LexiconFields.SENSE_FIELD.getFieldName().length());
                } else if (fieldName.startsWith(LexiconFields.SENSE.getFieldName())) {
                    modName = fieldName.substring(LexiconFields.SENSE.getFieldName().length());
                }
                if (modName.length() <= 0) continue;
                if (modName.charAt(0) == '/') {
                    modName = modName.substring(1);
                }
                if (modName.isEmpty()) continue;
                modName = nameChecker.convertName(modName);
                existingCustField = custSenseFields.contains(modName);
                enteredFieldToActualField.put(fieldName, modName);
                if (existingCustField) continue;
                lexImpl.addCustomFieldSpec(modName, LexiconFields.SENSE.getFieldName());
                custSenseFields.add(modName);
                continue;
            }
            if (lf != LexiconFields.CUSTOM || (modName = nameChecker.convertName(fieldName)).isEmpty()) continue;
            existingCustField = custEntryFields.contains(modName);
            enteredFieldToActualField.put(fieldName, modName);
            if (existingCustField) continue;
            lexImpl.addCustomFieldSpec(modName, LexiconFields.ENTRY.getFieldName());
            custEntryFields.add(modName);
        }
        for (List<String[]> record : recordList) {
            block57: {
                fieldRecord = new LexiconFields[record.size()];
                morphTypePresent = false;
                for (i = 0; i < record.size(); ++i) {
                    fieldRecord[i] = this.getLexiconFieldConstant(markersToFields.get(record.get(i)[0]));
                    if (fieldRecord[i] != LexiconFields.ENTRY_MORPH_TYPE) continue;
                    morphTypePresent = true;
                }
                nextEntry = null;
                for (i = 0; i < fieldRecord.length; ++i) {
                    if (fieldRecord[i] != LexiconFields.ENTRY_LEX_UNIT) continue;
                    try {
                        nextEntry = lexImpl.createEntry(record.get(i)[1]);
                        if (nextEntry == null || morphTypePresent) break;
                        lu = nextEntry.getLexicalUnit();
                        if (lu.startsWith("-")) {
                            nextEntry.setMorphType("suffix");
                            break;
                        }
                        if (lu.endsWith("-")) {
                            nextEntry.setMorphType("prefix");
                            break;
                        }
                        nextEntry.setMorphType("stem");
                    }
                    catch (LexiconStructureException lse) {
                        if (!LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) break;
                        LexiconLogger.LEXLOG.warning(String.format("Cannot create an entry for lexical-unit \"%s\", skipping record", new Object[]{record.get(i)[1]}));
                    }
                    break;
                }
                if (nextEntry == null) {
                    if (!LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) continue;
                    LexiconLogger.LEXLOG.warning(String.format("No lexical-unit found in record at index %d, skipping", new Object[]{recordList.indexOf(record)}));
                    continue;
                }
                lexImpl.addEntry((EntryImpl)nextEntry);
                for (i = 0; i < fieldRecord.length; ++i) {
                    if (fieldRecord[i] != LexiconFields.SENSE_GRAM_CAT) continue;
                    try {
                        nextSense = lexImpl.createSense(record.get(i)[1], "");
                        lexImpl.addSense((EntryImpl)nextEntry, nextSense);
                        continue;
                    }
                    catch (LexiconStructureException lse) {
                        if (!LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) continue;
                        LexiconLogger.LEXLOG.warning(String.format("Unable to create a Sense child object for %s", new Object[]{record.get(i)[1]}));
                    }
                }
                if (nextEntry.getSense().size() != 0) break block57;
                block28: for (i = 0; i < fieldRecord.length; ++i) {
                    switch (1.$SwitchMap$nl$mpi$lexiconcomponent$impl$LexiconFields[fieldRecord[i].ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            try {
                                nextSense = lexImpl.createSense("*", "");
                                lexImpl.addSense((EntryImpl)nextEntry, nextSense);
                                break block28;
                            }
                            catch (LexiconStructureException lse) {
                                if (!LexiconLogger.LEXLOG.isLoggable(Level.WARNING)) ** GOTO lbl124
                                LexiconLogger.LEXLOG.warning(String.format("Unable to create an empty Sense child object for field %s", new Object[]{fieldRecord[i].getFieldName()}));
                            }
                        }
lbl124:
                        // 3 sources

                        default: {
                            continue block28;
                        }
                    }
                }
            }
            curSense = 0;
            nextSense = null;
            curExam = -1;
            block29: for (i = 0; i < fieldRecord.length; ++i) {
                switch (1.$SwitchMap$nl$mpi$lexiconcomponent$impl$LexiconFields[fieldRecord[i].ordinal()]) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        this.addFieldToEntry((EntryImpl)nextEntry, fieldRecord[i], record.get(i)[1], decoderInfo.isSplitMultipleValues(), decoderInfo.getMarkerToLangMap().get(record.get(i)[0]));
                        continue block29;
                    }
                    case 15: 
                    case 16: {
                        this.setEntryDate(lexImpl, (EntryImpl)nextEntry, fieldRecord[i], record.get(i)[1]);
                        continue block29;
                    }
                    case 17: 
                    case 18: {
                        this.addCustomFieldToEntry((EntryImpl)nextEntry, (String)enteredFieldToActualField.get(markersToFields.get(record.get(i)[0])), record.get(i)[1], decoderInfo.isSplitMultipleValues(), decoderInfo.getMarkerToLangMap().get(record.get(i)[0]));
                        continue block29;
                    }
                    case 19: {
                        nextSense = (SenseImpl)nextEntry.getSense().get(curSense);
                        if (nextSense != null) {
                            this.addFieldToSense(nextSense, fieldRecord[i], record.get(i)[1], decoderInfo.isSplitMultipleValues(), decoderInfo.getMarkerToLangMap().get(record.get(i)[0]));
                        } else if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
                            LexiconLogger.LEXLOG.fine(String.format("The Sense at index %d could not be found", new Object[]{curSense}));
                        }
                        ++curSense;
                        curExam = -1;
                        continue block29;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        if (nextSense == null && nextEntry.getSense().size() == 1) {
                            nextSense = (SenseImpl)nextEntry.getSense().get(0);
                        }
                        if (nextSense != null) {
                            this.addFieldToSense(nextSense, fieldRecord[i], record.get(i)[1], decoderInfo.isSplitMultipleValues(), decoderInfo.getMarkerToLangMap().get(record.get(i)[0]));
                            continue block29;
                        }
                        if (!LexiconLogger.LEXLOG.isLoggable(Level.INFO)) continue block29;
                        LexiconLogger.LEXLOG.info(String.format("Could not add field to Sense, ignored (%s, %s)", new Object[]{fieldRecord[i].getFieldName(), record.get(i)[1]}));
                        continue block29;
                    }
                    case 5: 
                    case 6: {
                        try {
                            if (nextSense == null && nextEntry.getSense().size() == 1) {
                                nextSense = (SenseImpl)nextEntry.getSense().get(0);
                            }
                            if (nextSense != null) {
                                if (curExam >= 0 && (curEx = nextSense.getExample().get(curExam)) != null && curEx.getText() != null && (curEx.getText().getValue() == null || curEx.getText().getValue().isEmpty())) {
                                    curEx.getText().setValue(record.get(i)[1]);
                                    curEx.getText().setLang(decoderInfo.getMarkerToLangMap().get(record.get(i)[0]));
                                    continue block29;
                                }
                                this.addFieldToSense(nextSense, fieldRecord[i], record.get(i)[1], decoderInfo.isSplitMultipleValues(), decoderInfo.getMarkerToLangMap().get(record.get(i)[0]));
                                ++curExam;
                                continue block29;
                            }
                            if (!LexiconLogger.LEXLOG.isLoggable(Level.INFO)) continue block29;
                            LexiconLogger.LEXLOG.info(String.format("Could not add field to Sense, ignored (%s, %s)", new Object[]{fieldRecord[i].getFieldName(), record.get(i)[1]}));
                        }
                        catch (Throwable t) {
                            if (!LexiconLogger.LEXLOG.isLoggable(Level.INFO)) continue block29;
                            LexiconLogger.LEXLOG.info(String.format("Could not add field to Sense: \"%s\", ignored (%s, %s)", new Object[]{t.getMessage(), fieldRecord[i].getFieldName(), record.get(i)[1]}));
                        }
                        continue block29;
                    }
                    case 7: 
                    case 8: {
                        try {
                            if (nextSense == null && nextEntry.getSense().size() == 1) {
                                nextSense = (SenseImpl)nextEntry.getSense().get(0);
                            }
                            if (curExam >= 0 && nextSense != null) {
                                curEx = nextSense.getExample().get(curExam);
                                if (curEx == null) continue block29;
                                this.addFieldToExample(curEx, fieldRecord[i], record.get(i)[1], decoderInfo.isSplitMultipleValues(), decoderInfo.getMarkerToLangMap().get(record.get(i)[0]));
                                continue block29;
                            }
                            if (nextSense != null) {
                                this.addFieldToSense(nextSense, LexiconFields.SENSE_EXAMPLE, "", false, null);
                                curEx = nextSense.getExample().get(++curExam);
                                if (curEx == null) continue block29;
                                this.addFieldToExample(curEx, fieldRecord[i], record.get(i)[1], decoderInfo.isSplitMultipleValues(), decoderInfo.getMarkerToLangMap().get(record.get(i)[0]));
                                continue block29;
                            }
                            if (!LexiconLogger.LEXLOG.isLoggable(Level.INFO)) continue block29;
                            LexiconLogger.LEXLOG.info(String.format("Could not add field to Sense, ignored (%s, %s)", new Object[]{fieldRecord[i].getFieldName(), record.get(i)[1]}));
                        }
                        catch (Throwable t) {
                            if (!LexiconLogger.LEXLOG.isLoggable(Level.INFO)) continue block29;
                            LexiconLogger.LEXLOG.info(String.format("Could not add a field to Example: \"%s\", ignored (%s, %s)", new Object[]{t.getMessage(), fieldRecord[i].getFieldName(), record.get(i)[1]}));
                        }
                        continue block29;
                    }
                    case 9: {
                        if (nextSense == null && nextEntry.getSense().size() == 1) {
                            nextSense = (SenseImpl)nextEntry.getSense().get(0);
                        }
                        this.addCustomFieldToSense(nextSense, (String)enteredFieldToActualField.get(markersToFields.get(record.get(i)[0])), record.get(i)[1], decoderInfo.isSplitMultipleValues(), decoderInfo.getMarkerToLangMap().get(record.get(i)[0]));
                        continue block29;
                    }
                }
            }
        }
        return lexImpl;
    }

    private LexiconFields getLexiconFieldConstant(String fieldNameOrLabel) {
        LexiconFields lf = LexiconFieldUtil.getLexiconFieldForFieldName(fieldNameOrLabel);
        if (lf != null) {
            return lf;
        }
        lf = LexiconFieldUtil.getLexiconFieldForDisplayLabel(fieldNameOrLabel);
        if (lf != null) {
            return lf;
        }
        if (fieldNameOrLabel.startsWith(LexiconFields.ENTRY.getFieldName())) {
            return LexiconFields.ENTRY_FIELD;
        }
        if (fieldNameOrLabel.startsWith(LexiconFields.SENSE.getFieldName())) {
            return LexiconFields.SENSE_FIELD;
        }
        if (lf == null) {
            lf = LexiconFields.CUSTOM;
        }
        return lf;
    }

    private void addFieldToEntry(EntryImpl entry, LexiconFields field, String value, boolean split, String lang) {
        switch (field) {
            case ENTRY_CITATION: {
                entry.setCitation(value);
                break;
            }
            case ENTRY_MORPH_TYPE: {
                if (entry.getMorphType() != null) break;
                entry.setMorphType(value);
                break;
            }
            case ENTRY_NOTE: {
                if (split) {
                    for (String v : value.split(";")) {
                        entry.getNote().add(v);
                    }
                    break;
                }
                entry.getNote().add(value);
                break;
            }
            case ENTRY_VARIANT: {
                if (split) {
                    for (String v : value.split(";")) {
                        entry.getVariant().add(v);
                    }
                    break;
                }
                entry.getVariant().add(value);
                break;
            }
            case ENTRY_PHONETIC: {
                if (split) {
                    for (String v : value.split(";")) {
                        Phonetic ph = this.lexFactory.createPhonetic();
                        ph.setValue(v);
                        ph.setLang(lang);
                        entry.getPhonetic().add(ph);
                    }
                    break;
                }
                Phonetic ph = this.lexFactory.createPhonetic();
                ph.setValue(value);
                ph.setLang(lang);
                entry.getPhonetic().add(ph);
                break;
            }
        }
    }

    private void addCustomFieldToEntry(EntryImpl entry, String fieldName, String value, boolean split, String lang) {
        if (fieldName == null) {
            return;
        }
        if (split) {
            for (String v : value.split(";")) {
                CustomField cf = this.lexFactory.createCustomField();
                cf.setName(fieldName);
                cf.setValue(v);
                cf.setLang(lang);
                entry.getField().add(cf);
            }
        } else {
            CustomField cf = this.lexFactory.createCustomField();
            cf.setName(fieldName);
            cf.setValue(value);
            cf.setLang(lang);
            entry.getField().add(cf);
        }
    }

    private void addFieldToSense(SenseImpl sense, LexiconFields field, String value, boolean split, String lang) {
        switch (field) {
            case SENSE_GRAM_CAT: {
                sense.setGrammaticalCategory(value);
                break;
            }
            case SENSE_GLOSS: {
                Gloss gg = null;
                if (sense.getGloss().size() == 1 && ((gg = sense.getGloss().get(0)).getValue() != null && !gg.getValue().isEmpty() || gg.getLang() != null)) {
                    gg = null;
                }
                if (split) {
                    for (String v : value.split(";")) {
                        if (gg != null) {
                            gg.setValue(v);
                            gg.setLang(lang);
                            gg = null;
                            continue;
                        }
                        Gloss gl = this.lexFactory.createGloss();
                        gl.setValue(v);
                        gl.setLang(lang);
                        sense.getGloss().add(gl);
                    }
                    break;
                }
                if (gg != null) {
                    gg.setValue(value);
                    gg.setLang(lang);
                    break;
                }
                Gloss gl = this.lexFactory.createGloss();
                gl.setValue(value);
                gl.setLang(lang);
                sense.getGloss().add(gl);
                break;
            }
            case SENSE_COMMENT: {
                if (split) {
                    for (String v : value.split(";")) {
                        sense.getComment().add(v);
                    }
                    break;
                }
                sense.getComment().add(value);
                break;
            }
            case SENSE_DEFINITION: {
                if (split) {
                    for (String v : value.split(";")) {
                        Definition de = this.lexFactory.createDefinition();
                        de.setValue(v);
                        de.setLang(lang);
                        sense.getDefinition().add(de);
                    }
                    break;
                }
                Definition de = this.lexFactory.createDefinition();
                de.setValue(value);
                de.setLang(lang);
                sense.getDefinition().add(de);
                break;
            }
            case SENSE_EXAMPLE: 
            case SENSE_EXAM_TEXT: {
                Example ex = this.lexFactory.createExample();
                TextLang tl = this.lexFactory.createTextLang();
                tl.setValue(value);
                tl.setLang(lang);
                ex.setText(tl);
                sense.getExample().add(ex);
                break;
            }
            case SENSE_EXAM_TRANS: {
                break;
            }
            case SENSE_EXAM_SOURCE: {
                break;
            }
            case SENSE_INT_NOTE: {
                if (split) {
                    for (String v : value.split(";")) {
                        sense.getInternalNote().add(v);
                    }
                    break;
                }
                sense.getInternalNote().add(value);
                break;
            }
        }
    }

    private void addFieldToExample(Example exam, LexiconFields field, String value, boolean split, String lang) {
        if (exam != null) {
            switch (field) {
                case SENSE_EXAM_SOURCE: {
                    exam.setSourceRef(value);
                    break;
                }
                case SENSE_EXAM_TRANS: {
                    if (split) {
                        for (String v : value.split(";")) {
                            TextLang tl = this.lexFactory.createTextLang();
                            tl.setValue(v);
                            tl.setLang(lang);
                            exam.getTranslation().add(tl);
                        }
                        break;
                    }
                    TextLang tl = this.lexFactory.createTextLang();
                    tl.setValue(value);
                    tl.setLang(lang);
                    exam.getTranslation().add(tl);
                    break;
                }
            }
        }
    }

    private void addCustomFieldToSense(SenseImpl sense, String fieldName, String value, boolean split, String lang) {
        if (sense == null) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
                LexiconLogger.LEXLOG.info(String.format("Could not add field to Sense (Sense = null), ignored (%s, %s)", fieldName, value));
            }
            return;
        }
        if (fieldName == null) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.INFO)) {
                LexiconLogger.LEXLOG.info(String.format("Could not add field to Sense (Field = null), ignored (%s, %s)", fieldName, value));
            }
            return;
        }
        if (split) {
            for (String v : value.split(";")) {
                CustomField cf = this.lexFactory.createCustomField();
                cf.setName(fieldName);
                cf.setValue(v);
                cf.setLang(lang);
                sense.getField().add(cf);
            }
        } else {
            CustomField cf = this.lexFactory.createCustomField();
            cf.setName(fieldName);
            cf.setValue(value);
            cf.setLang(lang);
            sense.getField().add(cf);
        }
    }

    private void setEntryDate(LexiconImpl lexicon, EntryImpl entry, LexiconFields field, String value) {
        int day = 0;
        int month = 0;
        int year = 0;
        String[] bestSplit = null;
        String[] slashSplit = value.split("/");
        String[] spaceSplit = value.split(" ");
        String[] hyphSplit = value.split("-");
        if (slashSplit.length == 3) {
            bestSplit = slashSplit;
        } else if (spaceSplit.length == 3) {
            bestSplit = spaceSplit;
        } else if (hyphSplit.length == 3) {
            bestSplit = hyphSplit;
        }
        if (bestSplit == null) {
            if (slashSplit.length == 2) {
                bestSplit = slashSplit;
            } else if (spaceSplit.length == 2) {
                bestSplit = spaceSplit;
            } else if (hyphSplit.length == 2) {
                bestSplit = hyphSplit;
            }
            if (bestSplit != null) {
                String[] finalSplit = new String[]{"1", bestSplit[0], bestSplit[1]};
            }
        }
        if (bestSplit == null) {
            return;
        }
        if (bestSplit[0].length() == 1 || bestSplit[0].length() == 2) {
            try {
                day = Integer.parseInt(bestSplit[0]);
            }
            catch (NumberFormatException finalSplit) {
                // empty catch block
            }
        }
        if (day == 0 || day > 31) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
                LexiconLogger.LEXLOG.fine(String.format("Invalid day number \"%d\" extracted from \"%s\"", day, value));
            }
            return;
        }
        if (bestSplit[1].length() == 2) {
            try {
                month = Integer.parseInt(bestSplit[1]);
            }
            catch (NumberFormatException finalSplit) {}
        } else if (bestSplit[1].length() == 3) {
            month = this.extractMonth(bestSplit[1].toLowerCase());
        }
        if (month == 0 || month > 12) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
                LexiconLogger.LEXLOG.fine(String.format("Invalid month number \"%d\" extracted from \"%s\"", month, value));
            }
            return;
        }
        if (bestSplit[2].length() == 4) {
            try {
                year = Integer.parseInt(bestSplit[2]);
            }
            catch (NumberFormatException finalSplit) {}
        } else if (bestSplit[2].length() == 2) {
            try {
                int y2 = Integer.parseInt(bestSplit[2]);
                int cury2 = Calendar.getInstance().get(1);
                year = y2 > (cury2 %= 100) ? 1900 + y2 : 2000 + y2;
            }
            catch (NumberFormatException y2) {
                // empty catch block
            }
        }
        if (year == 0 || year <= 1900) {
            if (LexiconLogger.LEXLOG.isLoggable(Level.FINE)) {
                LexiconLogger.LEXLOG.fine(String.format("Invalid year \"%d\" extracted from \"%s\"", day, value));
            }
            return;
        }
        XMLGregorianCalendar xgc = lexicon.createXMLGregorianCalendar(year, month, day);
        if (xgc != null) {
            switch (field) {
                case ENTRY_DATE_CREATED: {
                    entry.setDateCreated(xgc);
                    break;
                }
                default: {
                    entry.setDateModified(xgc);
                }
            }
        }
    }

    private int extractMonth(String month) {
        if (month == null) {
            return 0;
        }
        if (month.startsWith("jan")) {
            return 1;
        }
        if (month.startsWith("feb")) {
            return 2;
        }
        if (month.startsWith("mar")) {
            return 3;
        }
        if (month.startsWith("apr")) {
            return 4;
        }
        if (month.startsWith("may")) {
            return 5;
        }
        if (month.startsWith("jun")) {
            return 6;
        }
        if (month.startsWith("jul")) {
            return 7;
        }
        if (month.startsWith("aug")) {
            return 8;
        }
        if (month.startsWith("sep")) {
            return 9;
        }
        if (month.startsWith("oct")) {
            return 10;
        }
        if (month.startsWith("nov")) {
            return 11;
        }
        if (month.startsWith("dec")) {
            return 12;
        }
        return 0;
    }
}

