/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.util.toolbox;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ToolboxDictScanner {
    private File tbFile;
    private final String tbFieldPattern = "\\\\[^_]{1}.*";
    private final String tbFieldPattern2 = "\\s*\\\\[^_]{1}\\S*(\\s|$)";
    private String charset = "UTF-8";

    public ToolboxDictScanner(String filePath) throws IOException {
        File f;
        try {
            f = new File(filePath);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        this.checkFile(f);
        this.tbFile = f;
    }

    public ToolboxDictScanner(File file) throws IOException {
        this.checkFile(file);
        this.tbFile = file;
    }

    public ToolboxDictScanner(File file, String charset) throws IOException {
        this.charset = charset;
        this.checkFile(file);
        this.tbFile = file;
    }

    private void checkFile(File file) throws IOException {
        if (file == null) {
            throw new IOException("No file was provided (null)");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(String.format("The file with path \"%s\" does not exist", file.getAbsolutePath()));
        }
        if (file.isDirectory()) {
            throw new IOException(String.format("The file with path \"%s\" is a directory", file.getAbsolutePath()));
        }
        if (!file.canRead()) {
            throw new IOException(String.format("The file with path \"%s\" cannot be read", file.getAbsolutePath()));
        }
    }

    public List<String> extractFieldMarkers() throws IOException {
        ArrayList<String> fieldList = new ArrayList<String>();
        Pattern fp = Pattern.compile("\\\\[^_]{1}.*");
        try {
            Scanner scanner = null;
            scanner = this.charset == null ? new Scanner(this.tbFile) : new Scanner(this.tbFile, this.charset);
            while (scanner.hasNextLine()) {
                try {
                    String field = scanner.next(fp);
                    if (field != null && !fieldList.contains(field)) {
                        fieldList.add(field);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                scanner.nextLine();
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae);
        }
        catch (Throwable tt) {
            throw new IOException(tt);
        }
        return fieldList;
    }

    public List<String> extractFieldMarkersBR() throws IOException {
        ArrayList<String> fieldList = new ArrayList<String>();
        BufferedReader br = null;
        Pattern fp2 = Pattern.compile("\\s*\\\\[^_]{1}\\S*(\\s|$)");
        try {
            br = this.charset != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.tbFile), this.charset)) : new BufferedReader(new InputStreamReader(new FileInputStream(this.tbFile)));
            String line = null;
            while ((line = br.readLine()) != null) {
                Matcher m = fp2.matcher(line);
                if (!m.find()) continue;
                String field = null;
                field = m.end() == line.length() ? line.trim() : line.substring(m.start(), m.end() - 1).trim();
                if (fieldList.contains(field)) continue;
                fieldList.add(field);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        finally {
            try {
                br.close();
            }
            catch (Throwable throwable) {}
        }
        return fieldList;
    }

    public List<Map<String, List<String>>> getRecordsForFields(List<String> fieldNames) {
        if (fieldNames == null || fieldNames.size() < 2) {
            return null;
        }
        String recordMarker = fieldNames.get(0);
        Pattern fp = Pattern.compile("\\\\[^_]{1}.*");
        ArrayList<Map<String, List<String>>> recordList = new ArrayList<Map<String, List<String>>>();
        try {
            Scanner scanner = null;
            scanner = this.charset == null ? new Scanner(this.tbFile) : new Scanner(this.tbFile, this.charset);
            StringBuilder sb = new StringBuilder();
            HashMap<String, List<String>> curRecord = new HashMap<String, List<String>>();
            String curField = null;
            while (scanner.hasNextLine()) {
                String remain;
                try {
                    String field = scanner.next(fp);
                    remain = scanner.nextLine().trim();
                    if (field != null) {
                        if (curField != null && sb.length() > 0) {
                            this.addToRecord(curRecord, curField, sb.toString());
                            sb = new StringBuilder();
                        }
                        if (field.equals(recordMarker) && !curRecord.isEmpty()) {
                            recordList.add(curRecord);
                            curRecord = new HashMap();
                        }
                        if (!fieldNames.contains(field)) continue;
                        curField = field;
                        sb.append(remain);
                        continue;
                    }
                    sb.append(remain);
                }
                catch (Throwable t) {
                    remain = scanner.nextLine();
                    if (curField == null) continue;
                    sb.append(" ");
                    sb.append(remain);
                }
            }
            if (curField != null && sb.length() > 0) {
                this.addToRecord(curRecord, curField, sb.toString());
            }
            if (!curRecord.isEmpty()) {
                recordList.add(curRecord);
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return recordList;
    }

    private void addToRecord(Map<String, List<String>> record, String field, String value) {
        List<String> fieldList = record.get(field);
        if (fieldList == null) {
            fieldList = new ArrayList<String>(5);
            record.put(field, fieldList);
        }
        fieldList.add(value);
    }

    private void addToRecord(List<String[]> record, String field, String value) {
        record.add(new String[]{field, value});
    }

    public List<Map<String, List<String>>> getRecordsForFieldsBR(List<String> fieldNames) throws IOException {
        if (fieldNames == null || fieldNames.size() < 2) {
            return null;
        }
        String recordMarker = fieldNames.get(0);
        BufferedReader br = null;
        Pattern fp2 = Pattern.compile("\\s*\\\\[^_]{1}\\S*(\\s|$)");
        ArrayList<Map<String, List<String>>> recordList = new ArrayList<Map<String, List<String>>>();
        try {
            br = this.charset != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.tbFile), this.charset)) : new BufferedReader(new InputStreamReader(new FileInputStream(this.tbFile)));
            StringBuilder sb = new StringBuilder();
            HashMap<String, List<String>> curRecord = new HashMap<String, List<String>>();
            String curField = null;
            String line = null;
            while ((line = br.readLine()) != null) {
                Matcher m = fp2.matcher(line);
                String field = null;
                String remain = null;
                if (m.find()) {
                    if (m.end() == line.length()) {
                        field = line.trim();
                    } else {
                        field = line.substring(m.start(), m.end() - 1).trim();
                        if (m.end() < line.length()) {
                            remain = line.substring(m.end()).trim();
                        }
                    }
                } else {
                    remain = line.trim();
                }
                if (field != null) {
                    if (curField != null && sb.length() > 0) {
                        this.addToRecord(curRecord, curField, sb.toString());
                        sb = new StringBuilder();
                    }
                    if (field.equals(recordMarker) && !curRecord.isEmpty()) {
                        recordList.add(curRecord);
                        curRecord = new HashMap();
                    }
                    if (fieldNames.contains(field)) {
                        curField = field;
                        if (remain == null) continue;
                        sb.append(remain);
                        continue;
                    }
                    curField = null;
                    continue;
                }
                if (curField == null) continue;
                sb.append(" ");
                sb.append(remain);
            }
            if (curField != null && sb.length() > 0) {
                this.addToRecord(curRecord, curField, sb.toString());
            }
            if (!curRecord.isEmpty()) {
                recordList.add(curRecord);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable tt) {
            throw new IOException(tt);
        }
        finally {
            try {
                br.close();
            }
            catch (Throwable throwable) {}
        }
        return recordList;
    }

    public List<List<String[]>> getRecordsListForFieldsBR(List<String> fieldNames) throws IOException {
        if (fieldNames == null || fieldNames.size() < 2) {
            return null;
        }
        String recordMarker = fieldNames.get(0);
        BufferedReader br = null;
        Pattern fp2 = Pattern.compile("\\s*\\\\[^_]{1}\\S*(\\s|$)");
        ArrayList<List<String[]>> recordList = new ArrayList<List<String[]>>();
        try {
            br = this.charset != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.tbFile), this.charset)) : new BufferedReader(new InputStreamReader(new FileInputStream(this.tbFile)));
            StringBuilder sb = new StringBuilder();
            ArrayList<Object> curRecord = new ArrayList<String[]>();
            String curField = null;
            String line = null;
            while ((line = br.readLine()) != null) {
                Matcher m = fp2.matcher(line);
                String field = null;
                String remain = null;
                if (m.find()) {
                    if (m.end() == line.length()) {
                        field = line.trim();
                    } else {
                        field = line.substring(m.start(), m.end() - 1).trim();
                        if (m.end() < line.length()) {
                            remain = line.substring(m.end()).trim();
                        }
                    }
                } else {
                    remain = line.trim();
                }
                if (field != null) {
                    if (curField != null && sb.length() > 0) {
                        this.addToRecord(curRecord, curField, sb.toString());
                        sb = new StringBuilder();
                    }
                    if (field.equals(recordMarker) && !curRecord.isEmpty()) {
                        recordList.add(curRecord);
                        curRecord = new ArrayList();
                    }
                    if (fieldNames.contains(field)) {
                        curField = field;
                        if (remain == null) continue;
                        sb.append(remain);
                        continue;
                    }
                    curField = null;
                    continue;
                }
                if (curField == null || remain == null || remain.isEmpty()) continue;
                sb.append(" ");
                sb.append(remain);
            }
            if (curField != null && sb.length() > 0) {
                this.addToRecord(curRecord, curField, sb.toString());
            }
            if (!curRecord.isEmpty()) {
                recordList.add(curRecord);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable tt) {
            throw new IOException(tt);
        }
        finally {
            try {
                br.close();
            }
            catch (Throwable throwable) {}
        }
        return recordList;
    }

    public static void main(String[] args) {
        if (args.length >= 1) {
            try {
                ToolboxDictScanner sc = new ToolboxDictScanner(args[0]);
                List<String> fields = sc.extractFieldMarkersBR();
                System.out.println(fields);
                if (fields != null && !fields.isEmpty()) {
                    List<Map<String, List<String>>> records = sc.getRecordsForFieldsBR(fields);
                    System.out.println("Number of entries: " + records.size());
                    for (Map<String, List<String>> record : records) {
                        System.out.println("## Entry #####");
                        for (String key : record.keySet()) {
                            List<String> vals = record.get(key);
                            Iterator<String> valIter = vals.iterator();
                            while (valIter.hasNext()) {
                                System.out.println(key + "\t" + valIter.next());
                            }
                        }
                        System.out.println();
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

