/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexiconcomponent.util.toolbox;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import nl.mpi.lexiconcomponent.gui.LexiconGuiResources;
import nl.mpi.lexiconcomponent.impl.LexiconFieldUtil;
import nl.mpi.lexiconcomponent.impl.LexiconFields;

public class ToolboxImportTableModel
extends AbstractTableModel {
    private List<String> columnIds = new ArrayList<String>(3);
    private List<List<Object>> rowDataList;

    public ToolboxImportTableModel() {
        this.columnIds.add(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Import.Marker", "Marker"));
        this.columnIds.add(LexiconGuiResources.getLocalizedString("LexiconComponent.Entry.Field.Name", "Field Name"));
        this.columnIds.add(LexiconGuiResources.getLocalizedString("LexiconComponent.Lexicon.Language", "Language"));
        this.rowDataList = new ArrayList<List<Object>>();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        switch (column) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                String field = (String)this.getValueAt(row, 1);
                return this.hasLangAttribute(field);
            }
        }
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.columnIds.size()) {
            return this.columnIds.get(columnIndex);
        }
        return "";
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.columnIds.size() && rowIndex < this.rowDataList.size()) {
            return this.rowDataList.get(rowIndex).get(columnIndex);
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (row < 0 || row >= this.rowDataList.size()) {
            return;
        }
        if (column < 0 || column >= this.columnIds.size()) {
            return;
        }
        if (!this.isCellEditable(row, column)) {
            return;
        }
        List<Object> rowData = this.rowDataList.get(row);
        rowData.set(column, aValue != null ? aValue : "");
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public int getRowCount() {
        return this.rowDataList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnIds.size();
    }

    public void addRow(String marker, String fieldName, String language) {
        ArrayList<String> rd = new ArrayList<String>(this.columnIds.size());
        rd.add(marker);
        rd.add(fieldName);
        rd.add(language);
        int row = this.rowDataList.size();
        this.rowDataList.add(rd);
        this.fireTableRowsInserted(row, row);
    }

    public void clearRowData() {
        int numRows = this.rowDataList.size();
        for (int i = numRows - 1; i >= 0; --i) {
            this.rowDataList.remove(i);
        }
        this.fireTableDataChanged();
    }

    private boolean hasLangAttribute(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            return false;
        }
        LexiconFields field = LexiconFieldUtil.getLexiconFieldForDisplayLabel(fieldName);
        if (field == null) {
            field = LexiconFieldUtil.getLexiconFieldForFieldName(fieldName);
        }
        if (field != null) {
            return LexiconFieldUtil.hasLanguageAttribute(field);
        }
        return true;
    }
}

