/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.whitespaceanalyzer;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import nl.mpi.lexan.analyzers.TextAnalyzer;
import nl.mpi.lexan.analyzers.TextAnalyzerContext;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChangeListener;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChanger;
import nl.mpi.lexan.analyzers.helpers.Information;
import nl.mpi.lexan.analyzers.helpers.Position;
import nl.mpi.lexan.analyzers.helpers.SourceTargetConfiguration;
import nl.mpi.lexan.analyzers.helpers.Suggestion;
import nl.mpi.lexan.analyzers.helpers.settings.SettingsException;
import nl.mpi.lexan.analyzers.whitespaceanalyzer.PunctAction;
import nl.mpi.lexan.analyzers.whitespaceanalyzer.WhitespaceAnalyzerInformation;
import nl.mpi.lexan.analyzers.whitespaceanalyzer.WhitespaceConfigurationPanel;
import nl.mpi.lexan.analyzers.whitespaceanalyzer.WhitespaceConfigurator;

public class WhitespaceAnalyzer
implements TextAnalyzer,
ConfigurationChangeListener {
    public static final Logger LOG = Logger.getLogger(WhitespaceAnalyzer.class.getName());
    private Information info = new WhitespaceAnalyzerInformation();
    private List<SourceTargetConfiguration> configs = null;
    private TextAnalyzerContext analyzerContext;
    private File cacheFolder;
    private String loadedSettings = null;
    private static final Pattern whitespace = Pattern.compile("\\s+");
    private Pattern allPunctMarks = null;
    private Map<Integer, PunctAction> perCodePointMap;
    private List<Integer> removalCodePoints = null;
    private boolean paused = true;
    private List<Position> pauseList = null;

    public void setAnalyzerContext(TextAnalyzerContext analyzerContext) {
        this.analyzerContext = analyzerContext;
    }

    public Information getInformation() {
        return this.info;
    }

    public Component getConfigurationComponent(String configKey) {
        if (this.cacheFolder != null) {
            WhitespaceConfigurationPanel configPanel = new WhitespaceConfigurationPanel(this.cacheFolder, WhitespaceAnalyzer.class.getSimpleName(), configKey, this.loadedSettings);
            configPanel.addConfigurationChangeListener(this);
            return configPanel;
        }
        return null;
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean load(List<SourceTargetConfiguration> configurations) {
        if (configurations == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot initialize, no source-target configurations specified.");
            }
            return false;
        }
        if (this.configs != null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The analyzer is already initialized, cannot initialize again.");
            }
            return false;
        }
        this.configs = new ArrayList<SourceTargetConfiguration>();
        this.paused = false;
        this.pauseList = new LinkedList<Position>();
        for (SourceTargetConfiguration conf : configurations) {
            if (!this.checkConfigurationRequirements(conf)) continue;
            this.configs.add(conf);
        }
        if (this.configs.isEmpty()) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "No valid source-target configurations, initialization failed.");
            }
            this.unload();
            return false;
        }
        return true;
    }

    public boolean partLoad(List<SourceTargetConfiguration> configurations) {
        if (configurations == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot partially load, no configurations specified.");
            }
            return false;
        }
        if (this.configs == null) {
            return this.load(configurations);
        }
        int curSize = this.configs.size();
        for (SourceTargetConfiguration conf : configurations) {
            if (!this.checkConfigurationRequirements(conf)) continue;
            if (this.indexOfConfiguration(conf) == -1) {
                this.configs.add(conf);
                continue;
            }
            if (!LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning(String.format("This configuration already exists (Source: %s - Target: %s)", conf.getSource().getTierId(), ((Position)conf.getTargetList().get(0)).getTierId()));
        }
        return curSize < this.configs.size();
    }

    public boolean unload() {
        this.configs = null;
        this.paused = true;
        this.pauseList = null;
        return true;
    }

    public int partUnload(List<SourceTargetConfiguration> configurations) {
        if (configurations == null || configurations.isEmpty()) {
            return this.configs.size();
        }
        for (SourceTargetConfiguration conf : configurations) {
            int index = this.indexOfConfiguration(conf);
            if (index <= -1) continue;
            for (Position l : this.pauseList) {
                if (!l.getTierId().equals(conf.getSource().getTierId())) continue;
                this.pauseList.remove(l);
            }
            this.configs.remove(index);
        }
        return this.configs.size();
    }

    private boolean checkConfigurationRequirements(SourceTargetConfiguration stc) {
        if (stc == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The tested configuration is null, removing.");
            }
            return false;
        }
        if (stc.getSource() == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("No source tier specified in a configuration, removing.");
            }
            return false;
        }
        if (stc.getTargetList().isEmpty()) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("No target tier specified in a configuration, removing.");
            }
            return false;
        }
        if (stc.getSource().equals(stc.getTargetList().get(0))) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The source tier and target tier are the same, removing.");
            }
            return false;
        }
        return true;
    }

    private int indexOfConfiguration(SourceTargetConfiguration config) {
        if (config != null) {
            for (int i = 0; i < this.configs.size(); ++i) {
                SourceTargetConfiguration conf = this.configs.get(i);
                if (!conf.getSource().equals((Object)config.getSource()) || config.getTargetList().isEmpty() || !((Position)conf.getTargetList().get(0)).equals(config.getTargetList().get(0))) continue;
                return i;
            }
        }
        return -1;
    }

    public void analyze(Position pos) {
        if (this.paused) {
            this.pauseList.add(pos);
            return;
        }
        for (SourceTargetConfiguration conf : this.configs) {
            if (!conf.getSource().getTierId().equals(pos.getTierId())) continue;
            this.analyze(pos, (Position)conf.getTargetList().get(0));
        }
    }

    private void analyze(Position source, Position target) {
        List input = this.analyzerContext.readAnnotation(source);
        for (Suggestion s : input) {
            List<String> split = this.split(s.getContent());
            LinkedList<Suggestion> suggestions = new LinkedList<Suggestion>();
            Position targetPos = new Position(target.getTierId(), s.getPosition());
            for (String c : split) {
                Suggestion toadd = new Suggestion(c, targetPos);
                suggestions.add(toadd);
            }
            this.analyzerContext.newAnnotation(targetPos, suggestions);
        }
    }

    public void pause() {
        this.paused = true;
    }

    public void unPause() {
        this.paused = false;
        for (Position p : this.pauseList) {
            this.analyze(p);
        }
    }

    public void saveState() {
    }

    public void loadState() {
    }

    public void setCacheFolder(File f) {
        if (!(f != null && f.isDirectory() && f.canRead() && f.canWrite())) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning(String.format("The provided cache folder cannot be used: %s", f));
            }
            return;
        }
        this.cacheFolder = f;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected List<String> split(String tosplit) {
        LinkedList<String> output = new LinkedList<String>();
        String[] stringArray = whitespace.split(tosplit, 0);
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            block20: {
                int[] codePointArray;
                boolean startedState;
                int start;
                block23: {
                    String part;
                    block21: {
                        block22: {
                            if (n2 >= n) {
                                return output;
                            }
                            part = stringArray[n2];
                            if (part.isEmpty()) break block20;
                            if (this.allPunctMarks == null) break block21;
                            Matcher m = this.allPunctMarks.matcher(part);
                            if (!m.find()) break block22;
                            part = this.removeRemovals(part);
                            start = 0;
                            startedState = false;
                            codePointArray = part.codePoints().toArray();
                            break block23;
                        }
                        output.add(part);
                        break block20;
                    }
                    output.add(part);
                    break block20;
                }
                block12: for (int i = 0; i < codePointArray.length; ++i) {
                    int cp = codePointArray[i];
                    PunctAction pa = this.perCodePointMap.get(cp);
                    if (!startedState) {
                        if (pa == null) {
                            start = i;
                            startedState = true;
                        } else {
                            switch (pa) {
                                case AS_SPACE: {
                                    break;
                                }
                                case SEPARATE: {
                                    output.add(String.valueOf(Character.toChars(cp)));
                                    break;
                                }
                                case WITH_NEXT: {
                                    start = i;
                                    startedState = true;
                                    break;
                                }
                            }
                        }
                    } else if (pa != null) {
                        switch (pa) {
                            case AS_SPACE: {
                                output.add(new String(codePointArray, start, i - start));
                                startedState = false;
                                break;
                            }
                            case SEPARATE: {
                                output.add(new String(codePointArray, start, i - start));
                                output.add(String.valueOf(Character.toChars(cp)));
                                startedState = false;
                                break;
                            }
                            case WITH_NEXT: {
                                break;
                            }
                            case WITH_PREV: {
                                PunctAction pa2;
                                if (i < codePointArray.length - 1 && (pa2 = this.perCodePointMap.get(codePointArray[i + 1])) == PunctAction.WITH_PREV) continue block12;
                                output.add(new String(codePointArray, start, i + 1 - start));
                                startedState = false;
                            }
                        }
                    }
                    if (i != codePointArray.length - 1 || !startedState) continue;
                    output.add(new String(codePointArray, start, i + 1 - start));
                }
            }
            ++n2;
        }
    }

    private String removeRemovals(String token) {
        StringBuilder sb = new StringBuilder(token.length());
        int[] tokencp = token.codePoints().toArray();
        for (int i = 0; i < tokencp.length; ++i) {
            PunctAction pa;
            int cp = tokencp[i];
            if (this.removalCodePoints.contains(cp) || i == 0 && (pa = this.perCodePointMap.get(cp)) == PunctAction.WITH_PREV || i == tokencp.length - 1 && (pa = this.perCodePointMap.get(cp)) == PunctAction.WITH_NEXT) continue;
            sb.appendCodePoint(cp);
        }
        if (sb.length() < token.length()) {
            return sb.toString();
        }
        return token;
    }

    public void configurationChanged(ConfigurationChanger panel) {
        if (panel instanceof WhitespaceConfigurationPanel) {
            Map<String, PunctAction> punctSettings = ((WhitespaceConfigurationPanel)panel).getPunctuationSettings();
            this.applySettings(punctSettings);
            this.loadedSettings = ((WhitespaceConfigurationPanel)panel).getCurrentSettingsKey();
        }
    }

    private void applySettings(Map<String, PunctAction> punctSettings) {
        if (punctSettings != null) {
            ArrayList<Integer> removalCodePointsTmp;
            HashMap<Integer, PunctAction> perCPMapTmp;
            block8: {
                perCPMapTmp = new HashMap<Integer, PunctAction>();
                removalCodePointsTmp = new ArrayList<Integer>();
                StringBuilder sb = new StringBuilder("[");
                for (String key : punctSettings.keySet()) {
                    int[] cps = key.codePoints().toArray();
                    PunctAction pa = punctSettings.get(key);
                    for (int cp : cps) {
                        if (!perCPMapTmp.containsKey(cp)) {
                            perCPMapTmp.put(cp, pa);
                        }
                        if (".$|()[]{}^?*+\\".indexOf(Character.toString(cp)) != -1) {
                            sb.append("\\");
                        }
                        sb.appendCodePoint(cp);
                        if (pa != PunctAction.REMOVE) continue;
                        removalCodePointsTmp.add(cp);
                    }
                }
                sb.append(']');
                try {
                    this.allPunctMarks = Pattern.compile(sb.toString());
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.log(Level.INFO, "Splitter Additional Pattern: " + this.allPunctMarks.pattern());
                    }
                }
                catch (PatternSyntaxException pse) {
                    if (!LOG.isLoggable(Level.WARNING)) break block8;
                    LOG.warning(String.format("Could not turn the string \"%s\" into a regular expression: %s", sb.toString(), pse.getMessage()));
                }
            }
            this.perCodePointMap = perCPMapTmp;
            this.removalCodePoints = removalCodePointsTmp;
        }
    }

    public void loadSettingsFor(String configId) {
        block3: {
            WhitespaceConfigurator cfHandler = new WhitespaceConfigurator(this.cacheFolder, WhitespaceAnalyzer.class.getSimpleName(), configId);
            this.loadedSettings = configId;
            try {
                Map<String, PunctAction> punctSettings = cfHandler.loadPunctuationSettings();
                if (cfHandler.getCurrentSettings() != null) {
                    this.loadedSettings = cfHandler.getCurrentSettings().getKey();
                }
                this.applySettings(punctSettings);
            }
            catch (SettingsException se) {
                if (!LOG.isLoggable(Level.WARNING)) break block3;
                LOG.warning("Unable to apply settings: " + se.getMessage());
            }
        }
    }
}

