/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.whitespaceanalyzer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChangeListener;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChanger;
import nl.mpi.lexan.analyzers.helpers.settings.SettingsException;
import nl.mpi.lexan.analyzers.whitespaceanalyzer.PunctAction;
import nl.mpi.lexan.analyzers.whitespaceanalyzer.WhitespaceConfigurator;

public class WhitespaceConfigurationPanel
extends JPanel
implements ConfigurationChanger,
ActionListener {
    public static final Logger LOG = Logger.getLogger("WhitespaceAnalyzer");
    private File dataDirectory;
    private String analyzerName;
    private String curSettingsKey = null;
    private String settingsToRemove = null;
    private WhitespaceConfigurator configHandler;
    private List<ConfigurationChangeListener> listeners;
    private Map<String, PunctAction> currentActionSettings;
    private JButton saveButton;
    private JButton addButton;
    private JButton removeButton;
    private JLabel infoLabel;
    private JTable punctTable;
    private DefaultTableModel punctModel;
    private PunctAction[] optionsArray = new PunctAction[]{PunctAction.AS_SPACE, PunctAction.SEPARATE, PunctAction.WITH_PREV, PunctAction.WITH_NEXT, PunctAction.REMOVE};

    public WhitespaceConfigurationPanel(File dataDirectory, String analyzerName, String curSettingsKey, String settingsToRemove) {
        this.dataDirectory = dataDirectory;
        this.analyzerName = analyzerName;
        this.curSettingsKey = curSettingsKey;
        this.settingsToRemove = settingsToRemove;
        this.configHandler = new WhitespaceConfigurator(dataDirectory, analyzerName, curSettingsKey);
        this.initComponents();
        this.loadSettings();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.infoLabel = new JLabel("Specify how to treat punctuation marks");
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.infoLabel, gbc);
        this.punctModel = new DefaultTableModel(new String[]{"Marks", "Action"}, 0);
        this.punctTable = new JTable(this.punctModel);
        this.punctTable.getSelectionModel().setSelectionMode(0);
        this.punctTable.getTableHeader().setReorderingAllowed(false);
        this.punctTable.getColumnModel().getColumn(0).setMinWidth(30);
        this.punctTable.getColumnModel().getColumn(1).setPreferredWidth(90);
        JComboBox<PunctAction> actionCBox = new JComboBox<PunctAction>(this.optionsArray);
        DefaultCellEditor actionEditor = new DefaultCellEditor(actionCBox);
        this.punctTable.getColumnModel().getColumn(1).setCellEditor(actionEditor);
        this.punctTable.setRowHeight(actionCBox.getPreferredSize().height);
        JScrollPane scrollPane = new JScrollPane(this.punctTable);
        scrollPane.setPreferredSize(new Dimension(80, 40));
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 0.1;
        this.add((Component)scrollPane, gbc);
        this.saveButton = new JButton("Apply");
        this.saveButton.addActionListener(this);
        this.addButton = new JButton("+");
        this.addButton.addActionListener(this);
        this.removeButton = new JButton("-");
        this.removeButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.setBorder(new EmptyBorder(2, 0, 4, 0));
        buttonPanel.add(this.addButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        buttonPanel.add(this.removeButton);
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this.saveButton);
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.add((Component)buttonPanel, gbc);
    }

    public void addConfigurationChangeListener(ConfigurationChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ConfigurationChangeListener>(2);
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeConfigurationChangeListener(ConfigurationChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void removeAllListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
    }

    public void notifyListeners() {
        if (this.listeners != null) {
            for (ConfigurationChangeListener l : this.listeners) {
                l.configurationChanged((ConfigurationChanger)this);
            }
        }
    }

    public Map<String, PunctAction> getPunctuationSettings() {
        return this.currentActionSettings;
    }

    public String getCurrentSettingsKey() {
        return this.curSettingsKey;
    }

    private void applySettings() {
        this.currentActionSettings = new LinkedHashMap<String, PunctAction>();
        for (int i = 0; i < this.punctTable.getRowCount(); ++i) {
            String keyCol = (String)this.punctTable.getValueAt(i, 0);
            Object valCol = this.punctTable.getValueAt(i, 1);
            if (keyCol != null && !keyCol.isEmpty()) {
                if (valCol instanceof PunctAction) {
                    this.currentActionSettings.put(keyCol, (PunctAction)((Object)valCol));
                    continue;
                }
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine(String.format("There is no action selected for a punctuation column %s", keyCol));
                continue;
            }
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.fine(String.format("There are no punctuation marks entered in row %d", i));
        }
        this.configHandler.setPunctuationSettings(this.currentActionSettings);
    }

    private void saveSettings() {
        block3: {
            try {
                this.configHandler.saveCurrentSettings();
                if (this.settingsToRemove != null && !this.settingsToRemove.equals(this.curSettingsKey)) {
                    this.configHandler.removeSettings(this.settingsToRemove);
                }
            }
            catch (SettingsException se) {
                if (!LOG.isLoggable(Level.WARNING)) break block3;
                LOG.warning(this.analyzerName + ": " + se.getMessage());
            }
        }
    }

    private void loadSettings() {
        block6: {
            try {
                this.currentActionSettings = this.configHandler.loadPunctuationSettings();
                if (this.punctTable.getRowCount() > 0) {
                    for (int i = this.punctTable.getRowCount() - 1; i >= 0; --i) {
                        this.punctTable.remove(i);
                    }
                }
                if (this.currentActionSettings == null) {
                    this.currentActionSettings = new LinkedHashMap<String, PunctAction>();
                }
                for (String key : this.currentActionSettings.keySet()) {
                    this.punctModel.addRow(new Object[]{key, this.currentActionSettings.get(key)});
                }
            }
            catch (SettingsException se) {
                if (!LOG.isLoggable(Level.WARNING)) break block6;
                LOG.warning(this.analyzerName + ": " + se.getMessage());
            }
        }
    }

    public void loadSettingsForKey(String settingsKey) {
        if (this.curSettingsKey == null && settingsKey == null) {
            return;
        }
        if (this.curSettingsKey != null && this.curSettingsKey.equals(settingsKey)) {
            return;
        }
        this.curSettingsKey = settingsKey;
        this.configHandler = new WhitespaceConfigurator(this.dataDirectory, this.analyzerName, this.curSettingsKey);
        this.loadSettings();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int row;
        if (e.getSource() == this.saveButton) {
            if (this.punctTable.isEditing()) {
                this.punctTable.getCellEditor().stopCellEditing();
            }
            this.applySettings();
            this.notifyListeners();
            this.saveSettings();
        } else if (e.getSource() == this.addButton) {
            this.punctModel.addRow(new String[]{"", "<Select...>"});
        } else if (e.getSource() == this.removeButton && (row = this.punctTable.getSelectedRow()) > -1) {
            this.punctModel.removeRow(row);
            int rowCount = this.punctTable.getRowCount();
            if (rowCount > 0) {
                if (rowCount < row) {
                    this.punctTable.setRowSelectionInterval(row, row);
                } else {
                    this.punctTable.setRowSelectionInterval(rowCount - 1, rowCount - 1);
                }
            }
        }
    }
}

