/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.whitespaceanalyzer;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import nl.mpi.lexan.analyzers.helpers.ConfigurationHandler;
import nl.mpi.lexan.analyzers.helpers.settings.AnalyzerSet;
import nl.mpi.lexan.analyzers.helpers.settings.Setting;
import nl.mpi.lexan.analyzers.helpers.settings.SettingsException;
import nl.mpi.lexan.analyzers.helpers.settings.SettingsIO;
import nl.mpi.lexan.analyzers.whitespaceanalyzer.PunctAction;

public class WhitespaceConfigurator
extends ConfigurationHandler {
    private Map<String, PunctAction> currentActionSettings;

    public WhitespaceConfigurator(File dataDirectory, String analyzerName, String settingsKey) {
        super(dataDirectory, analyzerName, settingsKey);
    }

    public Map<String, PunctAction> loadPunctuationSettings() throws SettingsException {
        this.loadCurrentSettings();
        this.setCurrentSettings(this.currentSettings);
        return this.currentActionSettings;
    }

    public Map<String, PunctAction> getPunctuationSettings() {
        return this.currentActionSettings;
    }

    public void setPunctuationSettings(Map<String, PunctAction> nextSettings) {
        this.currentActionSettings = nextSettings;
        if (this.currentActionSettings != null) {
            AnalyzerSet anSet = SettingsIO.getInstance().createEmptySettings(this.analyzerName);
            for (String key : this.currentActionSettings.keySet()) {
                PunctAction pa = this.currentActionSettings.get(key);
                anSet.getSettingList().add(new Setting(key, pa.getActionName()));
            }
            this.currentSettings = anSet;
        }
    }

    public void setCurrentSettings(AnalyzerSet settings) {
        super.setCurrentSettings(settings);
        if (this.currentSettings != null) {
            this.currentActionSettings = new LinkedHashMap<String, PunctAction>();
            for (Setting s : this.currentSettings.getSettingList()) {
                String key = s.getKey();
                String val = s.getValue();
                PunctAction actionVal = null;
                for (PunctAction pa : PunctAction.values()) {
                    if (!pa.getActionName().equals(val)) continue;
                    actionVal = pa;
                    break;
                }
                if (key == null || actionVal == null) continue;
                this.currentActionSettings.put(key, actionVal);
            }
        }
    }
}

