/*
 * Decompiled with CFR 0.152.
 */
package nl.ru.signbank;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mpi.eudico.client.annotator.CacheSettingsChangeListener;
import mpi.eudico.client.annotator.CachedDataManager;
import mpi.eudico.client.annotator.mediadisplayer.MediaDisplayerFactory;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.lexicon.EntryElement;
import mpi.eudico.server.corpora.lexicon.Lexicon;
import mpi.eudico.server.corpora.lexicon.LexiconEntry;
import mpi.eudico.server.corpora.lexicon.LexiconIdentification;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClientException;
import mpi.eudico.util.Pair;
import nl.ru.signbank.SignbankWebServiceClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SignbankDataManager
implements CacheSettingsChangeListener {
    private static final int BUFFER_SIZE = 4096;
    SignbankWebServiceClient signbankClient;
    String url;
    String packageUrlPath = "/dictionary/package/";
    File signbankStoreDirectory;
    private JSONObject glossesDB;
    private String lexiconName;

    public SignbankDataManager(String url, SignbankWebServiceClient signbankClient, LexiconIdentification lexID) {
        this.url = url;
        this.signbankClient = signbankClient;
        this.lexiconName = lexID.getName();
        CachedDataManager.getInstance().addCacheSettingsListener((CacheSettingsChangeListener)this);
    }

    private File urlToDirectory() {
        try {
            String name = URLEncoder.encode(this.url + this.lexiconName, "UTF-8");
            name = name.replaceAll("%", "~");
            String cacheDirectory = CachedDataManager.getInstance().getCacheLocation();
            return new File(cacheDirectory + File.separator + "lexica" + File.separator + "signbank" + File.separator + name);
        }
        catch (UnsupportedEncodingException e) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("Unsupported encoding in " + this.url + " (" + e.getMessage() + ")");
            }
            return null;
        }
    }

    public Boolean checkSignbankDataStore() {
        File newSignbankStoreDirectory = this.urlToDirectory();
        if (!newSignbankStoreDirectory.exists()) {
            newSignbankStoreDirectory.mkdirs();
            new File(newSignbankStoreDirectory.getAbsolutePath() + File.separator + MediaDisplayerFactory.MEDIA_TYPE.VIDEO).mkdir();
            new File(newSignbankStoreDirectory.getAbsolutePath() + File.separator + MediaDisplayerFactory.MEDIA_TYPE.IMAGE).mkdir();
        }
        if (newSignbankStoreDirectory.isDirectory()) {
            this.signbankStoreDirectory = newSignbankStoreDirectory;
            String glossesDBFile = this.signbankStoreDirectory.getAbsolutePath() + File.separator + "glosses.json";
            this.readGlossesDatabase(glossesDBFile);
            return true;
        }
        ClientLogger.LOG.severe("WARNING: createSignbankDataStore, " + this.signbankStoreDirectory.getAbsolutePath() + " exists and is NOT a directory");
        return false;
    }

    public void downloadPackage() throws LexiconServiceClientException {
        this.downloadPatch("0");
    }

    public void downloadPatch(String lastUpdate) throws LexiconServiceClientException {
        Object since_timestamp_var = "";
        if (lastUpdate != null && !lastUpdate.equals("") && !lastUpdate.equals("0")) {
            since_timestamp_var = "since_timestamp=" + lastUpdate;
        }
        try {
            String dataset_var = "dataset_name=" + URLEncoder.encode(this.lexiconName, "UTF-8");
            String patchUrl = this.url + this.packageUrlPath + "?" + (String)since_timestamp_var + "&" + dataset_var;
            String zipFile = this.signbankClient.downloadFile(patchUrl, this.signbankStoreDirectory.getAbsolutePath());
            this.unpack(zipFile);
            this.storeTimestamp(zipFile);
            new File(zipFile).delete();
        }
        catch (Exception e) {
            ClientLogger.LOG.info("IOException: " + e.getMessage());
            e.printStackTrace();
            this.readGlossesDatabase(this.signbankStoreDirectory.getAbsolutePath() + File.separator + "glosses.json");
        }
    }

    private void storeTimestamp(String filepath) {
        block3: {
            File f = new File(filepath);
            String timestamp = f.getName().split("\\.", 0)[1];
            if (timestamp.indexOf("-") != -1) {
                timestamp = timestamp.split("\\-")[1];
            }
            try {
                FileWriter fw = new FileWriter(this.signbankStoreDirectory.getAbsolutePath() + File.separator + "lastupdated.txt");
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(timestamp);
                bw.close();
            }
            catch (IOException e) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block3;
                ClientLogger.LOG.warning("The timestamp file could not be saved properly (" + e.getMessage() + ")");
            }
        }
    }

    public String readTimeStamp() {
        String timestamp;
        block3: {
            File lastupdatedFile = new File(this.signbankStoreDirectory.getAbsolutePath() + File.separator + "lastupdated.txt");
            if (!lastupdatedFile.exists() || !lastupdatedFile.canRead()) {
                return "0";
            }
            timestamp = "";
            try {
                FileReader fr = new FileReader(this.signbankStoreDirectory.getAbsolutePath() + File.separator + "lastupdated.txt");
                BufferedReader br = new BufferedReader(fr);
                timestamp = br.readLine();
                br.close();
            }
            catch (IOException e) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block3;
                ClientLogger.LOG.warning("The timestamp file could not be read properly (" + e.getMessage() + ")");
            }
        }
        return timestamp;
    }

    public void unpack(String zipFilePath) throws IOException, LexiconServiceClientException {
        System.out.println("ZipFilePath: " + zipFilePath);
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            if (!entry.isDirectory()) {
                String fileContents = this.zipInputStreamToString(zipIn);
                if (entry.getName().equals("video_urls.json")) {
                    this.downloadMedia(this.extractUrls(fileContents), MediaDisplayerFactory.MEDIA_TYPE.VIDEO);
                } else if (entry.getName().equals("image_urls.json")) {
                    this.downloadMedia(this.extractUrls(fileContents), MediaDisplayerFactory.MEDIA_TYPE.IMAGE);
                } else if (entry.getName().equals("glosses.json")) {
                    this.updateGlossDatabase(fileContents);
                } else if (entry.getName().equals("deleted_glosses.json")) {
                    this.deleteGlossesFromDatabase(fileContents);
                } else if (entry.getName().equals("deleted_videos.json")) {
                    this.deleteMediaFromDatabase(fileContents, MediaDisplayerFactory.MEDIA_TYPE.VIDEO);
                } else if (entry.getName().equals("deleted_images.json")) {
                    this.deleteMediaFromDatabase(fileContents, MediaDisplayerFactory.MEDIA_TYPE.IMAGE);
                }
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private ArrayList<Pair<String, String>> extractUrls(String fileContents) throws IOException {
        ArrayList<Pair<String, String>> urls = new ArrayList<Pair<String, String>>();
        JSONObject jsonObject = new JSONObject(fileContents);
        Set glossIDs = jsonObject.keySet();
        for (String glossID : glossIDs) {
            Object media_url = jsonObject.get(glossID).toString();
            if (((String)media_url).startsWith("/")) {
                URL url = new URL(this.url);
                media_url = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + (String)media_url;
            }
            urls.add((Pair<String, String>)new Pair(media_url, (Object)glossID));
        }
        return urls;
    }

    private void downloadMedia(ArrayList<Pair<String, String>> urls, MediaDisplayerFactory.MEDIA_TYPE type) throws IOException, LexiconServiceClientException {
        String media_url = "";
        for (Pair<String, String> url : urls) {
            try {
                String extension = "";
                media_url = (String)url.getFirst();
                int i = media_url.lastIndexOf(".");
                if (i > 0) {
                    extension = media_url.substring(i);
                }
                this.signbankClient.downloadFile(media_url, this.signbankStoreDirectory.getAbsolutePath() + File.separator + type, (String)url.getSecond() + extension);
            }
            catch (Exception e) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) continue;
                ClientLogger.LOG.warning("Something went wrong when dowloading " + media_url + " (" + e.getMessage() + ")");
            }
        }
    }

    private void updateGlossDatabase(String fileContents) {
        block4: {
            String glossesDBFile = this.signbankStoreDirectory.getAbsolutePath() + File.separator + "glosses.json";
            try {
                if (this.glossesDB == null) {
                    this.readGlossesDatabase(glossesDBFile);
                }
                JSONObject jsonObject = new JSONObject(fileContents);
                Set glossIDs = jsonObject.keySet();
                for (String glossID : glossIDs) {
                    JSONObject glossObject = jsonObject.getJSONObject(glossID);
                    this.glossesDB.put(glossID, (Object)glossObject);
                }
                this.writeGlossesDatabase(glossesDBFile);
            }
            catch (Exception e) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block4;
                ClientLogger.LOG.warning("The glosses database file could not be updated properly (" + e.getMessage() + ")");
            }
        }
    }

    private void deleteGlossesFromDatabase(String fileContents) {
        block7: {
            String glossesDBFile = this.signbankStoreDirectory.getAbsolutePath() + File.separator + "glosses.json";
            try {
                if (this.glossesDB == null) {
                    this.readGlossesDatabase(glossesDBFile);
                }
                JSONArray jsonArray = new JSONArray(fileContents);
                for (Object jsonArrayObj : jsonArray) {
                    String glossID = null;
                    if (jsonArrayObj instanceof String) {
                        glossID = (String)jsonArrayObj;
                    } else if (jsonArrayObj instanceof JSONArray) {
                        glossID = ((JSONArray)jsonArrayObj).get(0).toString();
                    }
                    if (glossID == null) continue;
                    this.glossesDB.remove(glossID);
                    this.deleteMediaFiles(glossID, this.signbankStoreDirectory.getAbsolutePath() + File.separator + MediaDisplayerFactory.MEDIA_TYPE.VIDEO);
                    this.deleteMediaFiles(glossID, this.signbankStoreDirectory.getAbsolutePath() + File.separator + MediaDisplayerFactory.MEDIA_TYPE.IMAGE);
                }
                this.writeGlossesDatabase(glossesDBFile);
            }
            catch (JSONException e) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block7;
                ClientLogger.LOG.warning("The JSON data of the glosses database could not be processed properly (" + e.getMessage() + ")");
            }
        }
    }

    private void deleteMediaFromDatabase(String fileContents, MediaDisplayerFactory.MEDIA_TYPE mediaType) {
        JSONArray jsonArray = new JSONArray(fileContents);
        for (Object jsonArrayObj : jsonArray) {
            if (!(jsonArrayObj instanceof String)) continue;
            String glossID = (String)jsonArrayObj;
            this.deleteMediaFiles(glossID, this.signbankStoreDirectory.getAbsolutePath() + File.separator + mediaType);
        }
    }

    private void deleteMediaFiles(final String glossID, String directory) {
        File[] files;
        File dir = new File(directory);
        for (File f : files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(glossID + ".");
            }
        })) {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGlossesDatabase(String filename) {
        BufferedWriter bufferedWriter = null;
        try {
            File glossesDBFile = new File(filename);
            if (glossesDBFile.exists() && glossesDBFile.isFile() && glossesDBFile.canWrite() || !glossesDBFile.exists()) {
                bufferedWriter = new BufferedWriter(new FileWriter(glossesDBFile));
                bufferedWriter.write(this.glossesDB.toString());
            } else {
                ClientLogger.LOG.severe("Could not write to " + filename);
            }
        }
        catch (IOException ioe) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("The glosses database file could not be written to properly (" + ioe.getMessage() + ")");
            }
        }
        finally {
            block16: {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException e) {
                    if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block16;
                    ClientLogger.LOG.warning("The glosses database file could not be written to properly (" + e.getMessage() + ")");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readGlossesDatabase(String filename) {
        BufferedReader bufRead = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            File glossesDBFile = new File(filename);
            if (glossesDBFile.exists() && glossesDBFile.isFile() && glossesDBFile.canRead()) {
                bufRead = new BufferedReader(new FileReader(glossesDBFile));
                String line = null;
                while ((line = bufRead.readLine()) != null) {
                    stringBuilder.append(line);
                }
            }
        }
        catch (Exception ioe) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("The glosses database file could not be read from properly (" + ioe.getMessage() + ")");
            }
        }
        finally {
            block16: {
                try {
                    if (bufRead != null) {
                        bufRead.close();
                    }
                }
                catch (IOException e) {
                    if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block16;
                    ClientLogger.LOG.warning("The glosses database  could notfile be read from properly (" + e.getMessage() + ")");
                }
            }
        }
        this.glossesDB = stringBuilder.length() > 0 ? new JSONObject(stringBuilder.toString()) : new JSONObject();
    }

    private String zipInputStreamToString(ZipInputStream zipIn) throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            boas.write(bytesIn, 0, read);
        }
        boas.close();
        return boas.toString("UTF-8");
    }

    public ArrayList<String> getFieldnames() {
        if (this.glossesDB == null) {
            this.readGlossesDatabase(this.signbankStoreDirectory.getAbsolutePath() + File.separator + "glosses.json");
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        Iterator it = this.glossesDB.keys();
        if (it.hasNext()) {
            JSONObject entry = (JSONObject)this.glossesDB.get((String)it.next());
            fieldNames.addAll(entry.keySet());
        }
        return fieldNames;
    }

    public Lexicon search(String fieldID, String searchString, String constraint) {
        Lexicon lexicon = new Lexicon();
        Iterator it = this.glossesDB.keys();
        while (it.hasNext()) {
            JSONObject DBentry = (JSONObject)this.glossesDB.get((String)it.next());
            Boolean isMatch = false;
            try {
                if (constraint.equals("is")) {
                    if (DBentry.get(fieldID).toString().equals(searchString)) {
                        isMatch = true;
                    }
                } else if (constraint.equals("contains")) {
                    if (DBentry.get(fieldID).toString().contains(searchString)) {
                        isMatch = true;
                    }
                } else if (constraint.equals("beginswith")) {
                    if (DBentry.get(fieldID).toString().startsWith(searchString)) {
                        isMatch = true;
                    }
                } else if (constraint.equals("endswith") && DBentry.get(fieldID).toString().endsWith(searchString)) {
                    isMatch = true;
                }
            }
            catch (JSONException e) {
                ClientLogger.LOG.info("JSON object " + DBentry.toString() + " does not have key " + fieldID);
            }
            if (!isMatch.booleanValue()) continue;
            String name = DBentry.get(fieldID).toString();
            LexiconEntry entry = new LexiconEntry(name);
            entry.setFieldOfFocus(fieldID);
            entry.setValue(name);
            entry.addFocusFieldValue(name);
            this.addEntryElement(DBentry, (EntryElement)entry);
            lexicon.addEntry(entry);
        }
        return lexicon;
    }

    private void addEntryElement(JSONObject jsonObject, EntryElement parent) {
        Object[] keys = jsonObject.keySet().toArray();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Object key : keys) {
            if (!(key instanceof String)) continue;
            fieldNames.add((String)key);
        }
        Collections.sort(fieldNames);
        for (String field : fieldNames) {
            Object obj = jsonObject.get(field);
            if (obj instanceof String) {
                Object fieldValue;
                block6: {
                    fieldValue = (String)obj;
                    if (field.equals("Link") && ((String)fieldValue).startsWith("/")) {
                        try {
                            URL url = new URL(this.url);
                            fieldValue = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + (String)fieldValue;
                        }
                        catch (MalformedURLException e) {
                            if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block6;
                            ClientLogger.LOG.warning("The string " + this.url + " is not a proper url (" + e.getMessage() + ")");
                        }
                    }
                }
                EntryElement entryElem = new EntryElement(field, parent);
                entryElem.setValue((String)fieldValue);
                parent.addElement(entryElem);
                continue;
            }
            if (!(obj instanceof JSONObject)) continue;
            EntryElement element = new EntryElement(field, parent);
            parent.addElement(element);
            this.addEntryElement((JSONObject)obj, element);
        }
    }

    public String getPath(String id, MediaDisplayerFactory.MEDIA_TYPE type) {
        File[] files;
        String tmpId = id;
        if (id.startsWith("gloss")) {
            tmpId = id.substring(5);
        }
        final String entryId = tmpId;
        File directory = new File(this.signbankStoreDirectory.getAbsolutePath() + File.separator + type);
        if (directory.exists() && directory.isDirectory() && (files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("(.+\\-|)" + entryId + "\\..*");
            }
        })).length > 0) {
            return files[0].getAbsolutePath();
        }
        return "";
    }

    public void cacheSettingsChanged() {
        this.checkSignbankDataStore();
    }
}

