/*
 * Decompiled with CFR 0.152.
 */
package nl.ru.signbank;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingWorker;
import javax.swing.tree.TreeModel;
import mpi.eudico.client.annotator.mediadisplayer.MediaBundle;
import mpi.eudico.client.annotator.mediadisplayer.MediaDisplayerFactory;
import mpi.eudico.client.annotator.mediadisplayer.MediaProvider;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.lexicon.InitializableLexiconServiceClient;
import mpi.eudico.server.corpora.lexicon.LexicalEntryFieldIdentification;
import mpi.eudico.server.corpora.lexicon.Lexicon;
import mpi.eudico.server.corpora.lexicon.LexiconIdentification;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClientException;
import nl.ru.signbank.SignbankDataManager;
import nl.ru.signbank.SignbankWebServiceClientFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class SignbankWebServiceClient
implements InitializableLexiconServiceClient,
MediaProvider {
    private String description;
    private boolean isLoggedIn;
    private String url;
    private String username;
    private String password;
    private HttpClient httpClient;
    private HttpContext httpContext;
    String loginUrlPath = "/accounts/login/?api=yes";
    String infoUrlPath = "/dictionary/info/";
    private SignbankWebServiceClientFactory factory;
    private SignbankDataManager dataManager = null;
    private Set<MediaDisplayerFactory.MEDIA_TYPE> providedMediaTypes = new HashSet<MediaDisplayerFactory.MEDIA_TYPE>(Arrays.asList(MediaDisplayerFactory.MEDIA_TYPE.IMAGE, MediaDisplayerFactory.MEDIA_TYPE.VIDEO));
    private MediaDisplayerFactory.MEDIA_TYPE preferredMediaType = MediaDisplayerFactory.MEDIA_TYPE.VIDEO;

    public SignbankWebServiceClient(SignbankWebServiceClientFactory factory) {
        this.factory = factory;
        this.isLoggedIn = false;
    }

    public String getDescription() {
        return this.description;
    }

    public ArrayList<LexicalEntryFieldIdentification> getLexicalEntryFieldIdentifications(LexiconIdentification lexiconID) throws LexiconServiceClientException {
        ArrayList<LexicalEntryFieldIdentification> lexEntryFldIDs = new ArrayList<LexicalEntryFieldIdentification>();
        if (this.dataManager == null) {
            this.dataManager = new SignbankDataManager(this.url, this, lexiconID);
            if (!this.dataManager.checkSignbankDataStore().booleanValue()) {
                throw new LexiconServiceClientException("Client malfunction");
            }
        }
        for (String fieldName : this.dataManager.getFieldnames()) {
            lexEntryFldIDs.add(new LexicalEntryFieldIdentification(fieldName, fieldName));
        }
        return lexEntryFldIDs;
    }

    public TreeModel getLexicalEntryStructure(LexiconIdentification arg0) throws LexiconServiceClientException {
        return null;
    }

    public Lexicon getLexicon(LexiconIdentification lexId) throws LexiconServiceClientException {
        return null;
    }

    public ArrayList<LexiconIdentification> getLexiconIdentifications() throws LexiconServiceClientException {
        ArrayList<LexiconIdentification> list;
        block4: {
            list = new ArrayList<LexiconIdentification>();
            if (!this.isLoggedIn) {
                this.login();
            }
            try {
                HttpGet httpget = new HttpGet(this.url + this.infoUrlPath);
                HttpResponse response = this.httpClient.execute((HttpUriRequest)httpget, this.httpContext);
                String json = EntityUtils.toString((HttpEntity)response.getEntity());
                ClientLogger.LOG.info("getLexiconIdentifications - JSON: " + json);
                JSONArray jsonArray = new JSONArray(json);
                for (Object jsonArrayObj : jsonArray) {
                    if (!(jsonArrayObj instanceof String)) continue;
                    String datasetName = (String)jsonArrayObj;
                    LexiconIdentification lexID = new LexiconIdentification();
                    lexID.setId(datasetName);
                    lexID.setName(datasetName);
                    lexID.setDescription(datasetName);
                    list.add(lexID);
                }
            }
            catch (IOException e) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block4;
                ClientLogger.LOG.warning("The lexicon identifications could not be received from " + this.url + this.infoUrlPath + "(" + e.getMessage() + ")");
            }
        }
        return list;
    }

    public String getPassword() {
        return this.password;
    }

    public ArrayList<String> getSearchConstraints() {
        return this.factory.getSearchConstraints();
    }

    public String getType() {
        return this.factory.getType();
    }

    public String getUrl() {
        if (this.url == null || this.url.equals("")) {
            return this.factory.getDefaultUrl();
        }
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public Lexicon search(LexiconIdentification lexID, LexicalEntryFieldIdentification fieldID, String constraint, String searchString) throws LexiconServiceClientException {
        if (!this.isLoggedIn) {
            this.login();
        }
        if (this.dataManager == null) {
            this.initialize(false, lexID);
        }
        return this.dataManager.search(fieldID.getId(), searchString, constraint);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String lexiconWebserviceUrl) {
        this.url = lexiconWebserviceUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public static void main(String[] args) {
    }

    public void initialize(Boolean doInBackground, LexiconIdentification lexID) throws LexiconServiceClientException {
        this.dataManager = new SignbankDataManager(this.url, this, lexID);
        if (this.dataManager.checkSignbankDataStore().booleanValue()) {
            if (doInBackground.booleanValue()) {
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        SignbankWebServiceClient.this.dataManager.downloadPatch(SignbankWebServiceClient.this.dataManager.readTimeStamp());
                        return null;
                    }
                };
                worker.execute();
            } else {
                try {
                    this.dataManager.downloadPatch(this.dataManager.readTimeStamp());
                }
                catch (Exception e) {
                    if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                        ClientLogger.LOG.warning("Something went wrong when downloading a Signbank patch (" + e.getMessage() + ")");
                    }
                    throw new LexiconServiceClientException((Throwable)e);
                }
            }
        }
    }

    public void login() throws LexiconServiceClientException {
        try {
            this.httpClient = HttpClients.custom().disableRedirectHandling().build();
            BasicCookieStore cookieStore = new BasicCookieStore();
            this.httpContext = new BasicHttpContext();
            this.httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
            HttpGet httpGet = new HttpGet(this.url + this.loginUrlPath);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet, this.httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new LexiconServiceClientException("CONNECTION_MALFUNCTION");
            }
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            String csrfToken = (String)new JSONObject(json).get("csrfmiddlewaretoken");
            ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
            postParameters.add(new BasicNameValuePair("email", this.username));
            postParameters.add(new BasicNameValuePair("password", this.password));
            postParameters.add(new BasicNameValuePair("csrfmiddlewaretoken", csrfToken));
            HttpPost httpPost = new HttpPost(this.url + this.loginUrlPath);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters));
            httpPost.addHeader("Referer", this.url + this.loginUrlPath);
            response = this.httpClient.execute((HttpUriRequest)httpPost, this.httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new LexiconServiceClientException("CONNECTION_MALFUNCTION");
            }
            String loginResultJson = EntityUtils.toString((HttpEntity)response.getEntity());
            String success = (String)new JSONObject(loginResultJson).get("success");
            if (success.equals("false")) {
                throw new LexiconServiceClientException("Incorrect username or password", (Throwable)new Exception("Incorrect username or password"));
            }
            this.isLoggedIn = true;
        }
        catch (ClientProtocolException e) {
            throw new LexiconServiceClientException("CONNECTION_MALFUNCTION", (Throwable)e);
        }
        catch (IOException e) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("Logging into " + this.url + this.loginUrlPath + " failed due to problems in communicating with the website (" + e.getMessage() + ")");
            }
            throw new LexiconServiceClientException("CONNECTION_MALFUNCTION", (Throwable)e);
        }
    }

    public String downloadFile(String fileURL, String saveDir) throws IOException, LexiconServiceClientException {
        return this.downloadFile(fileURL, saveDir, null);
    }

    public String downloadFile(String fileURL, String saveDir, String saveFile) throws IOException, LexiconServiceClientException {
        System.out.println("fileUrl: " + fileURL);
        try {
            HttpGet packageHttpGet = new HttpGet(fileURL);
            if (!this.isLoggedIn) {
                this.login();
            }
            HttpResponse packageResponse = this.httpClient.execute((HttpUriRequest)packageHttpGet, this.httpContext);
            HttpEntity entity = packageResponse.getEntity();
            if (packageResponse.getStatusLine().getStatusCode() == 200) {
                String fileName = "";
                if (saveFile == null) {
                    Header disposition = packageResponse.getFirstHeader("Content-Disposition");
                    if (disposition != null) {
                        String dispositionValue = disposition.getValue();
                        int index = dispositionValue.indexOf("filename=");
                        if (index > 0) {
                            fileName = dispositionValue.substring(index + 9);
                        }
                    } else {
                        fileName = fileURL.substring(fileURL.lastIndexOf("/") + 1);
                    }
                } else {
                    fileName = saveFile;
                }
                fileName = fileName.replaceAll("[^a-zA-Z0-9.-]", "_");
                String saveFilePath = saveDir + File.separator + fileName;
                if (entity != null) {
                    int inByte;
                    BufferedInputStream bis = new BufferedInputStream(entity.getContent());
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(saveFilePath)));
                    while ((inByte = bis.read()) != -1) {
                        bos.write(inByte);
                    }
                    bis.close();
                    bos.close();
                    return saveFilePath;
                }
            } else {
                this.login();
            }
        }
        catch (Exception e) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("Something went wrong when dowloading " + fileURL + " (" + e.getMessage() + ")");
            }
            return null;
        }
        return null;
    }

    public MediaBundle getMedia(MediaDisplayerFactory.MEDIA_TYPE type, Object[] args) {
        MediaBundle mediaBundle = null;
        String id = null;
        if (args[0] instanceof String) {
            id = (String)args[0];
        } else if (args[0] instanceof Annotation) {
            Annotation annotation = (Annotation)args[0];
            id = annotation.getCVEntryId();
        }
        if (id != null && !id.equals("")) {
            if (this.dataManager == null) {
                LexiconIdentification lexID = null;
                if (args[1] instanceof LexiconIdentification) {
                    lexID = (LexiconIdentification)args[1];
                    this.dataManager = new SignbankDataManager(this.url, this, lexID);
                    this.dataManager.checkSignbankDataStore();
                }
            }
            if (this.dataManager != null) {
                mediaBundle = new MediaBundle();
                mediaBundle.setMediaUrl(this.dataManager.getPath(id, type));
            }
        }
        return mediaBundle;
    }

    public Boolean providesType(MediaDisplayerFactory.MEDIA_TYPE mediaType) {
        if (this.providedMediaTypes.contains(mediaType)) {
            return true;
        }
        return false;
    }

    public MediaDisplayerFactory.MEDIA_TYPE getPreferredMediaType() {
        return this.preferredMediaType;
    }
}

